/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.can;

import org.openlcb.NodeID;

public class NIDa {
    NodeID nid;
    int nida = 0;
    long lfsr1 = 0L;
    long lfsr2 = 0L;

    public NIDa(NodeID nid) {
        this.loadSeed(nid);
        this.nextAlias();
    }

    public int getNIDa() {
        return this.nida;
    }

    public void nextAlias() {
        this.stepGenerator();
        this.nida = this.computeAliasFromGenerator();
    }

    protected void forceSeedValue(long seed1, long seed2) {
        this.lfsr1 = seed1;
        this.lfsr2 = seed2;
        this.nida = this.computeAliasFromGenerator();
    }

    protected void forceAliasValue(int alias) {
        this.nida = alias;
    }

    protected void loadSeed(NodeID nid) {
        this.nid = nid;
        byte[] val = this.nid.getContents();
        this.lfsr1 = (long)val[0] << 16 | (long)val[1] << 8 | (long)val[2];
        this.lfsr2 = (long)val[3] << 16 | (long)val[4] << 8 | (long)val[5];
    }

    protected void stepGenerator() {
        long temp1 = (this.lfsr1 << 9 | this.lfsr2 >> 15 & 0x1FFL) & 0xFFFFFFL;
        long temp2 = this.lfsr2 << 9 & 0xFFFFFFL;
        this.lfsr2 = this.lfsr2 + temp2 + 8014761L;
        this.lfsr1 = this.lfsr1 + temp1 + 1772707L;
        this.lfsr1 = (this.lfsr1 & 0xFFFFFFL) + ((this.lfsr2 & 0xFFFFFFFFFF000000L) >> 24);
        this.lfsr2 &= 0xFFFFFFL;
    }

    protected int computeAliasFromGenerator() {
        return (int)(this.lfsr1 ^ this.lfsr2 ^ this.lfsr1 >> 12 ^ this.lfsr2 >> 12) & 0xFFF;
    }
}

