/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.can;

import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import org.openlcb.NodeID;
import org.openlcb.can.CanFrame;
import org.openlcb.can.CanFrameListener;
import org.openlcb.can.NIDa;
import org.openlcb.can.OpenLcbCanFrame;

public class NIDaAlgorithm
implements CanFrameListener {
    private Runnable done;
    private CanFrameListener sendInterface;
    private static Timer timer;
    private TimerTask task;
    private static final Logger logger;
    int index = 0;
    NodeID nid;
    NIDa nida;
    boolean complete = false;

    private synchronized void scheduleTimer(long delay) {
        this.task = new TimerTask(){

            @Override
            public void run() {
                NIDaAlgorithm.this.timerExpired();
            }
        };
        try {
            timer.schedule(this.task, delay);
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
    }

    public NIDaAlgorithm(NodeID n) {
        this.nid = n;
        this.nida = new NIDa(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NIDaAlgorithm(NodeID n, CanFrameListener sendInterface) {
        this(n);
        this.sendInterface = sendInterface;
        Class<NIDaAlgorithm> clazz = NIDaAlgorithm.class;
        synchronized (NIDaAlgorithm.class) {
            if (timer == null) {
                timer = new Timer("OpenLCB NIDaAlgorithm Timer");
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void start(Runnable done) {
        this.done = done;
        this.scheduleTimer(100L);
    }

    public OpenLcbCanFrame nextFrame() {
        OpenLcbCanFrame f;
        if (this.index < 4) {
            f = new OpenLcbCanFrame(this.nida.getNIDa());
            long id = this.nid.toLong();
            int varfield = (int)(id >> (3 - this.index) * 12 & 0xFFFL);
            logger.fine(String.format("Sending CID frame, id %x, varfield %x", id, varfield));
            f.setCIM(this.index, varfield, this.nida.getNIDa());
        } else if (this.index == 4) {
            f = new OpenLcbCanFrame(this.nida.getNIDa());
            f.setRIM(this.nida.getNIDa());
        } else if (this.index == 5) {
            f = new OpenLcbCanFrame(this.nida.getNIDa());
            f.setAMD(this.nida.getNIDa(), this.nid);
            this.complete = true;
        } else {
            f = null;
        }
        ++this.index;
        return f;
    }

    public int getNIDa() {
        return this.nida.getNIDa();
    }

    boolean compareDataAndNodeID(OpenLcbCanFrame f) {
        return new NodeID(f.getData()).equals(this.nid);
    }

    public void processFrame(OpenLcbCanFrame f) {
        if (f == null) {
            return;
        }
        if (f.isAliasMapEnquiry() && this.complete && (f.data.length == 0 || this.compareDataAndNodeID(f))) {
            OpenLcbCanFrame frame = new OpenLcbCanFrame(this.nida.getNIDa());
            frame.setAMD(this.nida.getNIDa(), this.nid);
            this.sendInterface.send(frame);
            return;
        }
        if (f.isAliasMapDefinition() && this.complete && (this.compareDataAndNodeID(f) || f.getSourceAlias() == this.nida.getNIDa())) {
            OpenLcbCanFrame frame = new OpenLcbCanFrame(this.nida.getNIDa());
            frame.setAMR(this.nida.getNIDa(), this.nid);
            this.sendInterface.send(frame);
            this.index = 0;
            this.complete = false;
            this.nida.nextAlias();
            this.cancelTimer();
            this.timerExpired();
            return;
        }
        if (f.getSourceAlias() != this.nida.getNIDa()) {
            return;
        }
        if (f.isCIM() && this.complete) {
            OpenLcbCanFrame frame = new OpenLcbCanFrame(this.nida.getNIDa());
            frame.setRIM(this.nida.getNIDa());
            this.sendInterface.send(frame);
            return;
        }
        this.index = 0;
        this.complete = false;
        this.nida.nextAlias();
        this.cancelTimer();
    }

    public boolean isComplete() {
        return this.complete;
    }

    protected void cancelTimer() {
        if (timer == null) {
            return;
        }
        if (this.task == null || this.task.cancel()) {
            this.scheduleTimer(0L);
        }
    }

    protected void timerExpired() {
        if (this.index == 0) {
            while (this.index < 4) {
                this.sendInterface.send(this.nextFrame());
            }
            this.scheduleTimer(400L);
        } else if (this.index == 4) {
            this.sendInterface.send(this.nextFrame());
            this.sendInterface.send(this.nextFrame());
            if (this.done != null) {
                this.done.run();
                this.done = null;
            }
        }
    }

    @Override
    public void send(CanFrame frame) {
        this.processFrame(new OpenLcbCanFrame(frame));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.cancelTimer();
        Class<NIDaAlgorithm> clazz = NIDaAlgorithm.class;
        synchronized (NIDaAlgorithm.class) {
            timer.cancel();
            timer = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.done = null;
            this.complete = true;
            return;
        }
    }

    static {
        logger = Logger.getLogger(NIDaAlgorithm.class.getName());
    }
}

