/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.can;

import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.openlcb.EventID;
import org.openlcb.MessageTypeIdentifier;
import org.openlcb.NodeID;
import org.openlcb.can.CanFrame;
import org.openlcb.implementations.DatagramUtils;

public class OpenLcbCanFrame
implements CanFrame {
    int id;
    int length;
    byte[] data = new byte[8];
    int nodeAlias;
    static final int MASK_FRAME_TYPE = 0x8000000;
    static final int MASK_SRC_ALIAS = 4095;
    static final int MASK_VARIABLE_FIELD = 0x7FFF000;
    static final int SHIFT_VARIABLE_FIELD = 12;
    static final int MASK_OPENLCB_FORMAT = 28672;
    static final int SHIFT_OPENLCB_FORMAT = 12;
    static final int RIM_VAR_FIELD = 1792;
    static final int AMD_VAR_FIELD = 1793;
    static final int AME_VAR_FIELD = 1794;
    static final int AMR_VAR_FIELD = 1795;
    static final int FRAME_FORMAT_MTI = 1;
    static final int FRAME_FORMAT_ADDRESSED_DATAGRAM_ALL = 2;
    static final int FRAME_FORMAT_ADDRESSED_DATAGRAM_FIRST = 3;
    static final int FRAME_FORMAT_ADDRESSED_DATAGRAM_MID = 4;
    static final int FRAME_FORMAT_ADDRESSED_DATAGRAM_LAST = 5;
    static final int FRAME_FORMAT_ADDRESSED_NON_DATAGRAM = 6;
    static final int FRAME_FORMAT_STREAM_CODE = 7;
    static final byte CONTINUATION_BITS_MASK = -49;
    static final byte CONTINUATION_BITS_NOT_FIRST_FRAME = 32;
    static final byte CONTINUATION_BITS_NOT_LAST_FRAME = 16;

    public OpenLcbCanFrame(int nodeAlias) {
        this.nodeAlias = nodeAlias;
        this.init(nodeAlias);
    }

    public OpenLcbCanFrame(CanFrame frame) {
        this.id = frame.getHeader();
        this.nodeAlias = this.getSourceAlias();
        this.setData(frame.getData());
    }

    @Override
    public int getHeader() {
        return this.id;
    }

    public void setHeader(int id) {
        this.id = id;
    }

    @Override
    public byte[] getData() {
        byte[] copy = new byte[this.length];
        System.arraycopy(this.data, 0, copy, 0, this.length);
        return copy;
    }

    public void setData(byte[] b) {
        this.data = b;
        this.length = b.length;
    }

    @Override
    public long bodyAsLong() {
        long retval = 0L;
        for (int i = 0; i < this.data.length; ++i) {
            retval = retval << 8 | (long)(this.data[i] & 0xFF);
        }
        return retval;
    }

    @Override
    public long dataAsLong() {
        long retval = 0L;
        for (int i = 2; i < this.data.length; ++i) {
            retval = retval << 8 | (long)(this.data[i] & 0xFF);
        }
        return retval;
    }

    @Override
    public boolean isExtended() {
        return true;
    }

    @Override
    public boolean isRtr() {
        return false;
    }

    @Override
    public int getNumDataElements() {
        return this.length;
    }

    @Override
    public int getElement(int n) {
        return DatagramUtils.byteToInt(this.data[n]);
    }

    void init(int alias) {
        this.id = 0x1FFFF000 | alias & 0xFFF;
    }

    void setSourceAlias(int a) {
        this.id &= 0xFFFFF000;
        this.id |= a & 0xFFF;
    }

    int getSourceAlias() {
        return this.id & 0xFFF;
    }

    void setDestAlias(int a) {
        this.data[0] = (byte)(a >> 8 & 0xF);
        this.data[1] = (byte)(a & 0xFF);
        this.length = this.length < 2 ? 2 : this.length;
    }

    void setContinuation(boolean first, boolean last) {
        this.data[0] = (byte)(this.data[0] & 0xFFFFFFCF);
        if (!first) {
            this.data[0] = (byte)(this.data[0] | 0x20);
        }
        if (!last) {
            this.data[0] = (byte)(this.data[0] | 0x10);
        }
    }

    void setFrameTypeCAN() {
        this.id &= 0xF7FFFFFF;
    }

    boolean isFrameTypeCAN() {
        return (long)(this.id & 0x8000000) == 0L;
    }

    void setFrameTypeOpenLcb() {
        this.id |= 0x8000000;
    }

    boolean isFrameTypeOpenLcb() {
        return (this.id & 0x8000000) == 0x8000000;
    }

    void setVariableField(int f) {
        this.id &= 0xF8000FFF;
        this.id |= f << 12 & 0x7FFF000;
    }

    int getVariableField() {
        return (this.id & 0x7FFF000) >> 12;
    }

    void setCIM(int i, int testval, int alias) {
        this.init(alias);
        this.setFrameTypeCAN();
        int var = (7 - i & 7) << 12 | testval & 0xFFF;
        this.setVariableField(var);
        this.length = 0;
    }

    boolean isCIM() {
        return this.isFrameTypeCAN() && (this.getVariableField() & 0x7000) >= 16384;
    }

    void setRIM(int alias) {
        this.init(alias);
        this.setFrameTypeCAN();
        this.setVariableField(1792);
        this.length = 0;
    }

    boolean isRIM() {
        return this.isFrameTypeCAN() && this.getVariableField() == 1792;
    }

    boolean isAliasMapDefinition() {
        return this.isFrameTypeCAN() && this.getVariableField() == 1793;
    }

    boolean isAliasMapEnquiry() {
        return this.isFrameTypeCAN() && this.getVariableField() == 1794;
    }

    boolean isAliasMapReset() {
        return this.isFrameTypeCAN() && this.getVariableField() == 1795;
    }

    void setAMR(int alias, NodeID nid) {
        this.init(alias);
        this.setFrameTypeCAN();
        this.setVariableField(1795);
        this.length = 6;
        byte[] val = nid.getContents();
        this.data[0] = val[0];
        this.data[1] = val[1];
        this.data[2] = val[2];
        this.data[3] = val[3];
        this.data[4] = val[4];
        this.data[5] = val[5];
    }

    void setAMD(int alias, NodeID nid) {
        this.init(alias);
        this.setFrameTypeCAN();
        this.setVariableField(1793);
        this.length = 6;
        byte[] val = nid.getContents();
        this.data[0] = val[0];
        this.data[1] = val[1];
        this.data[2] = val[2];
        this.data[3] = val[3];
        this.data[4] = val[4];
        this.data[5] = val[5];
    }

    void setAME(int alias, @Nullable NodeID nid) {
        this.init(alias);
        this.setFrameTypeCAN();
        this.setVariableField(1794);
        if (nid == null) {
            this.length = 0;
        } else {
            this.length = 6;
            byte[] val = nid.getContents();
            this.data[0] = val[0];
            this.data[1] = val[1];
            this.data[2] = val[2];
            this.data[3] = val[3];
            this.data[4] = val[4];
            this.data[5] = val[5];
        }
    }

    int getOpenLcbFormat() {
        return (this.getVariableField() & 0x7000) >> 12;
    }

    void setOpenLcbFormat(int i) {
        int now = this.getVariableField() & 0xFFFF8FFF;
        this.setVariableField(i << 12 & 0x7000 | now);
    }

    void setOpenLcbMTI(int mti) {
        this.setFrameTypeOpenLcb();
        this.setVariableField(mti | 0x1000);
    }

    boolean isOpenLcbMTI(int mti) {
        return this.isFrameTypeOpenLcb() && this.getOpenLcbFormat() == 1 && (this.getVariableField() & 0xFFFF8FFF) == mti;
    }

    void setPCEventReport(EventID eid) {
        this.setPCEventReport(eid, MessageTypeIdentifier.ProducerConsumerEventReport);
    }

    void setPCEventReport(EventID eid, MessageTypeIdentifier mti) {
        this.init(this.nodeAlias);
        this.setOpenLcbMTI(mti.mti());
        this.length = 8;
        this.loadFromEid(eid);
    }

    void setPCEventReport(MessageTypeIdentifier mti, byte[] data) {
        this.init(this.nodeAlias);
        this.setOpenLcbMTI(mti.mti());
        this.length = data.length;
        this.setData(data);
    }

    boolean isPCEventReport() {
        return this.isOpenLcbMTI(MessageTypeIdentifier.ProducerConsumerEventReport.mti()) || this.isOpenLcbMTI(MessageTypeIdentifier.PCERfirst.mti());
    }

    void setLearnEvent(EventID eid) {
        this.init(this.nodeAlias);
        this.setOpenLcbMTI(MessageTypeIdentifier.LearnEvent.mti());
        this.length = 8;
        this.loadFromEid(eid);
    }

    boolean isLearnEvent() {
        return this.isOpenLcbMTI(MessageTypeIdentifier.LearnEvent.mti());
    }

    void setInitializationComplete(int alias, NodeID nid, boolean simple) {
        this.nodeAlias = alias;
        this.init(this.nodeAlias);
        if (simple) {
            this.setOpenLcbMTI(MessageTypeIdentifier.InitializationCompleteSimple.mti());
        } else {
            this.setOpenLcbMTI(MessageTypeIdentifier.InitializationComplete.mti());
        }
        this.length = 6;
        byte[] val = nid.getContents();
        this.data[0] = val[0];
        this.data[1] = val[1];
        this.data[2] = val[2];
        this.data[3] = val[3];
        this.data[4] = val[4];
        this.data[5] = val[5];
    }

    boolean isInitializationComplete() {
        return this.isOpenLcbMTI(MessageTypeIdentifier.InitializationComplete.mti());
    }

    EventID getEventID() {
        return new EventID(this.data);
    }

    NodeID getNodeID() {
        return new NodeID(this.data);
    }

    boolean isVerifyNID() {
        return this.isOpenLcbMTI(MessageTypeIdentifier.VerifyNodeIdGlobal.mti());
    }

    void setVerifyNID(NodeID nid) {
        this.init(this.nodeAlias);
        this.setOpenLcbMTI(MessageTypeIdentifier.VerifyNodeIdGlobal.mti());
        this.length = 0;
    }

    boolean isVerifiedNID() {
        return this.isOpenLcbMTI(MessageTypeIdentifier.VerifiedNodeId.mti());
    }

    void setVerifiedNID(NodeID nid, boolean simple) {
        this.init(this.nodeAlias);
        if (simple) {
            this.setOpenLcbMTI(MessageTypeIdentifier.VerifiedNodeIdSimple.mti());
        } else {
            this.setOpenLcbMTI(MessageTypeIdentifier.VerifiedNodeId.mti());
        }
        this.length = 6;
        byte[] val = nid.getContents();
        this.data[0] = val[0];
        this.data[1] = val[1];
        this.data[2] = val[2];
        this.data[3] = val[3];
        this.data[4] = val[4];
        this.data[5] = val[5];
    }

    boolean isIdentifyConsumers() {
        return this.isOpenLcbMTI(MessageTypeIdentifier.IdentifyConsumer.mti());
    }

    void setConsumerIdentified(EventID eid) {
        this.init(this.nodeAlias);
        this.setOpenLcbMTI(MessageTypeIdentifier.IdentifyConsumer.mti());
        this.length = 8;
        this.loadFromEid(eid);
    }

    boolean isIdentifyProducers() {
        return this.isOpenLcbMTI(MessageTypeIdentifier.IdentifyProducer.mti());
    }

    void setProducerIdentified(EventID eid) {
        this.init(this.nodeAlias);
        this.setOpenLcbMTI(MessageTypeIdentifier.ProducerIdentifiedUnknown.mti());
        this.length = 8;
        this.loadFromEid(eid);
    }

    boolean isIdentifyEventsGlobal() {
        return this.isOpenLcbMTI(MessageTypeIdentifier.IdentifyEventsGlobal.mti());
    }

    void loadFromEid(EventID eid) {
        this.length = 8;
        byte[] val = eid.getContents();
        this.data[0] = val[0];
        this.data[1] = val[1];
        this.data[2] = val[2];
        this.data[3] = val[3];
        this.data[4] = val[4];
        this.data[5] = val[5];
        this.data[6] = val[6];
        this.data[7] = val[7];
    }

    boolean isDatagram() {
        return this.isFrameTypeOpenLcb() && (this.getOpenLcbFormat() == 2 || this.getOpenLcbFormat() == 3 || this.getOpenLcbFormat() == 4 || this.getOpenLcbFormat() == 5) && this.nodeAlias == this.getVariableField();
    }

    boolean isLastDatagram() {
        return this.getOpenLcbFormat() == 5;
    }

    void setDatagram(int[] content, int destAlias, boolean first, boolean last) {
        this.init(this.nodeAlias);
        if (last) {
            if (first) {
                this.setVariableField(0x2000 | destAlias);
            } else {
                this.setVariableField(0x5000 | destAlias);
            }
        } else if (first) {
            this.setVariableField(0x3000 | destAlias);
        } else {
            this.setVariableField(0x4000 | destAlias);
        }
        this.length = content.length;
        for (int i = 0; i < content.length; ++i) {
            this.data[i] = (byte)(content[i] & 0xFF);
        }
    }

    void setStream(byte[] content, int destAlias) {
        this.init(this.nodeAlias);
        this.setVariableField(0x7000 | destAlias);
        this.length = content.length;
        System.arraycopy(content, 0, this.data, 0, content.length);
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_MIGHT_BE_INFEASIBLE"}, justification="Because of the returns, data cannot be null when checking length.")
    public boolean equals(Object other) {
        try {
            OpenLcbCanFrame c = (OpenLcbCanFrame)other;
            if (this.id != c.id) {
                return false;
            }
            if (this.data == null && c.data == null) {
                return true;
            }
            if (this.data == null && c.data != null) {
                return false;
            }
            if (this.data != null && c.data == null) {
                return false;
            }
            if (this.data.length != c.data.length) {
                return false;
            }
            for (int i = 0; i < this.data.length; ++i) {
                if (this.data[i] == c.data[i]) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public int hashCode() {
        return 42;
    }

    public String toString() {
        String retval = "[0x" + Integer.toHexString(this.id) + "]";
        for (int i = 0; i < this.length; ++i) {
            retval = retval + " " + this.data[i];
        }
        return retval;
    }
}

