/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.can.impl;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.openlcb.can.CanFrame;
import org.openlcb.can.CanFrameListener;

public class GridConnectOutput
implements CanFrameListener {
    private static final Logger logger = Logger.getLogger(GridConnectOutput.class.getName());
    private BufferedOutputStream output;
    private final Runnable onError;

    public GridConnectOutput(OutputStream output, Runnable onError) {
        this.output = new BufferedOutputStream(output);
        this.onError = onError;
    }

    public static String format(CanFrame frame) {
        StringBuilder b = new StringBuilder();
        if (frame.isExtended()) {
            b.append(String.format(":X%08X", frame.getHeader()));
        } else {
            b.append(String.format(":S%03X", frame.getHeader()));
        }
        if (frame.isRtr()) {
            b.append('R');
        } else {
            b.append('N');
        }
        if (frame.getNumDataElements() > 8) {
            logger.warning("Output frame with too many data elements: " + Integer.toString(frame.getNumDataElements()));
        }
        for (int i = 0; i < frame.getNumDataElements(); ++i) {
            b.append(String.format("%02X", frame.getElement(i) & 0xFF));
        }
        b.append(';');
        return b.toString();
    }

    @Override
    public synchronized void send(CanFrame frame) {
        block4: {
            try {
                this.output.write(GridConnectOutput.format(frame).getBytes("ISO-8859-1"));
                this.output.write(10);
                this.output.flush();
            }
            catch (IOException e) {
                logger.warning("Error writing to gridconnect output: " + e.toString());
                try {
                    this.output.close();
                }
                catch (IOException e1) {
                    logger.fine("Error closing gridconnect output: " + e1.toString());
                }
                if (this.onError == null) break block4;
                this.onError.run();
            }
        }
    }
}

