/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.can.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.openlcb.Connection;
import org.openlcb.NodeID;
import org.openlcb.OlcbInterface;
import org.openlcb.can.CanFrame;
import org.openlcb.can.CanFrameListener;
import org.openlcb.can.CanInterface;
import org.openlcb.can.impl.GridConnectInput;
import org.openlcb.can.impl.GridConnectOutput;
import org.openlcb.cdi.impl.ConfigRepresentation;

public class OlcbConnection {
    public static OlcbConnection lastConnection = null;
    private final NodeID nodeId;
    private final ListenerProxy listenerProxy;
    private String hostName;
    private int portNumber;
    private GridConnectInput input;
    private GridConnectOutput output;
    private CanFrameHub inputHub;
    private CanFrameHub outputHub;
    private CanInterface canInterface;
    private Socket socket;
    private Runnable mOnError = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            OlcbConnection olcbConnection = OlcbConnection.this;
            synchronized (olcbConnection) {
                if (OlcbConnection.this.outputHub != null) {
                    OlcbConnection.this.outputHub.removeEntry(OlcbConnection.this.output);
                }
                OlcbConnection.this.listenerProxy.onDisconnect();
                OlcbConnection.this.shutdown();
            }
        }
    };

    public OlcbConnection(NodeID nodeId, String hostName, int portNumber, ConnectionListener connectionListener) {
        this.hostName = hostName;
        this.portNumber = portNumber;
        this.listenerProxy = new ListenerProxy();
        this.listenerProxy.add(connectionListener);
        this.nodeId = nodeId;
    }

    public void startConnect() {
        new Thread("openlcb-connect"){

            @Override
            public void run() {
                OlcbConnection.this.connect();
            }
        }.start();
    }

    private synchronized void connect() {
        OutputStream outputStream;
        BufferedReader reader;
        this.inputHub = new CanFrameHub();
        this.outputHub = new CanFrameHub();
        this.listenerProxy.onConnectionPending();
        this.listenerProxy.onStatusChange("Connecting...");
        try {
            this.socket = new Socket(this.hostName, this.portNumber);
            this.socket.setTcpNoDelay(true);
            reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "ISO-8859-1"));
            outputStream = this.socket.getOutputStream();
        }
        catch (IOException e) {
            this.listenerProxy.onStatusChange("Connection failed: " + e.toString());
            this.listenerProxy.onDisconnect();
            return;
        }
        this.input = new GridConnectInput(reader, this.inputHub, this.mOnError);
        this.output = new GridConnectOutput(outputStream, this.mOnError);
        this.outputHub.addEntry(this.output);
        this.canInterface = new CanInterface(this.nodeId, this.outputHub);
        this.inputHub.addEntry(this.canInterface.frameInput());
        this.canInterface.addStartListener(new Connection.ConnectionListener(){

            @Override
            public void connectionActive(Connection c) {
                OlcbConnection.this.listenerProxy.onConnect();
            }
        });
        lastConnection = this;
    }

    public synchronized void shutdown() {
        if (this.inputHub != null) {
            this.inputHub.clear();
            this.inputHub = null;
        }
        if (this.outputHub != null) {
            this.outputHub.clear();
            this.outputHub = null;
        }
        this.input = null;
        this.output = null;
        if (this.socket == null) {
            return;
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.socket = null;
    }

    public void addConnectionListener(ConnectionListener l) {
        this.listenerProxy.add(l);
    }

    public void removeConnectionListener(ConnectionListener l) {
        this.listenerProxy.remove(l);
    }

    public ConfigRepresentation getConfigForNode(NodeID remoteNode) {
        return this.getInterface().getConfigForNode(remoteNode);
    }

    public CanFrameHub getInputHub() {
        return this.inputHub;
    }

    public CanFrameHub getOutputHub() {
        return this.outputHub;
    }

    public OlcbInterface getInterface() {
        return this.canInterface.getInterface();
    }

    public void dispose() {
        this.canInterface.dispose();
    }

    private class ListenerProxy
    implements ConnectionListener {
        private List<ConnectionListener> entries = new ArrayList<ConnectionListener>(3);

        private ListenerProxy() {
        }

        public synchronized void add(ConnectionListener l) {
            this.entries.add(l);
        }

        public synchronized void remove(ConnectionListener l) {
            this.entries.remove(l);
        }

        private synchronized ConnectionListener[] getEntries() {
            ConnectionListener[] ar = new ConnectionListener[this.entries.size()];
            return this.entries.toArray(ar);
        }

        @Override
        public void onConnect() {
            ConnectionListener[] ar;
            for (ConnectionListener l : ar = this.getEntries()) {
                l.onConnect();
            }
        }

        @Override
        public void onDisconnect() {
            ConnectionListener[] ar;
            for (ConnectionListener l : ar = this.getEntries()) {
                l.onDisconnect();
            }
        }

        @Override
        public void onStatusChange(String status) {
            ConnectionListener[] ar;
            for (ConnectionListener l : ar = this.getEntries()) {
                l.onStatusChange(status);
            }
        }

        @Override
        public void onConnectionPending() {
            ConnectionListener[] ar;
            for (ConnectionListener l : ar = this.getEntries()) {
                l.onConnectionPending();
            }
        }
    }

    public class CanFrameHub
    implements CanFrameListener {
        private List<CanFrameListener> entries = new ArrayList<CanFrameListener>();

        public void addEntry(CanFrameListener l) {
            this.addEntry(l, false);
        }

        public void addEntry(CanFrameListener l, boolean atFront) {
            if (atFront) {
                this.entries.add(0, l);
            } else {
                this.entries.add(l);
            }
        }

        public void removeEntry(CanFrameListener l) {
            this.entries.remove(l);
        }

        public void clear() {
            this.entries.clear();
        }

        @Override
        public void send(CanFrame frame) {
            for (CanFrameListener l : this.entries) {
                l.send(frame);
            }
        }
    }

    public static interface ConnectionListener {
        public void onConnect();

        public void onDisconnect();

        public void onStatusChange(String var1);

        public void onConnectionPending();
    }
}

