/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.cdi.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Queue;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.openlcb.NodeID;
import org.openlcb.OlcbInterface;
import org.openlcb.cdi.impl.ConfigRepresentation;
import org.openlcb.cdi.impl.RangeCacheUtil;
import org.openlcb.cdi.impl.ReadWriteAccess;
import org.openlcb.implementations.MemoryConfigurationService;

public class MemorySpaceCache {
    public static final String UPDATE_LOADING_COMPLETE = "UPDATE_LOADING_COMPLETE";
    public static final String UPDATE_DATA = "UPDATE_DATA";
    private static final Logger logger = Logger.getLogger(MemorySpaceCache.class.getName());
    private final int space;
    private final RangeCacheUtil ranges = new RangeCacheUtil();
    private final NavigableMap<RangeCacheUtil.Range, byte[]> dataCache = new TreeMap<RangeCacheUtil.Range, byte[]>();
    private final NavigableMap<RangeCacheUtil.Range, ChangeEntry> dataChangeListeners = new TreeMap<RangeCacheUtil.Range, ChangeEntry>();
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private RangeCacheUtil.Range nextRangeToLoad = null;
    private long currentRangeNextOffset;
    private byte[] currentRangeData;
    private Queue<RangeCacheUtil.Range> rangesToLoad = new LinkedList<RangeCacheUtil.Range>();
    private final ReadWriteAccess access;
    private final String remoteNodeString;

    public MemorySpaceCache(OlcbInterface connection, final NodeID remoteNode, int space) {
        final MemoryConfigurationService mcs = connection.getMemoryConfigurationService();
        this.remoteNodeString = remoteNode.toString();
        this.access = new ReadWriteAccess(){

            @Override
            public void doWrite(long address, int space, byte[] data, MemoryConfigurationService.McsWriteHandler handler) {
                mcs.requestWrite(remoteNode, space, address, data, handler);
            }

            @Override
            public void doRead(long address, int space, int length, MemoryConfigurationService.McsReadHandler handler) {
                mcs.requestRead(remoteNode, space, address, length, handler);
            }
        };
        this.space = space;
    }

    public MemorySpaceCache(ReadWriteAccess access, int space) {
        this.access = access;
        this.space = space;
        this.remoteNodeString = "(mock)";
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    protected void firePropertyChange(String p, Object old, Object n) {
        this.pcs.firePropertyChange(p, old, n);
    }

    public void addRangeToCache(long start, long end, boolean nullTerminated) {
        this.ranges.addRange(start, end, nullTerminated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRangeListener(long start, long end, boolean nullTerminated, PropertyChangeListener listener) {
        MemorySpaceCache memorySpaceCache = this;
        synchronized (memorySpaceCache) {
            RangeCacheUtil.Range r = new RangeCacheUtil.Range(start, end, nullTerminated);
            ChangeEntry lt = (ChangeEntry)this.dataChangeListeners.get(r);
            if (lt == null) {
                lt = new ChangeEntry();
                this.dataChangeListeners.put(r, lt);
            }
            lt.listeners.add(listener);
        }
    }

    private void notifyPartialRead(long start, long end, boolean hasZero) {
        PropertyChangeEvent ev = null;
        for (Map.Entry e : this.dataChangeListeners.entrySet()) {
            if (((RangeCacheUtil.Range)e.getKey()).start >= end || ((RangeCacheUtil.Range)e.getKey()).end <= start) continue;
            boolean needNotify = false;
            if (((RangeCacheUtil.Range)e.getKey()).end <= end) {
                needNotify = true;
            }
            if (start >= ((RangeCacheUtil.Range)e.getKey()).start && ((RangeCacheUtil.Range)e.getKey()).nullTerminated && hasZero) {
                needNotify = true;
            }
            if (!needNotify) continue;
            if (ev == null) {
                ev = new PropertyChangeEvent(this, UPDATE_DATA, null, null);
            }
            for (PropertyChangeListener l : ((ChangeEntry)e.getValue()).listeners) {
                l.propertyChange(ev);
            }
        }
    }

    private void notifyAfterWrite(long start, long end) {
        PropertyChangeEvent ev = null;
        for (Map.Entry e : this.dataChangeListeners.entrySet()) {
            if (((RangeCacheUtil.Range)e.getKey()).start >= end || ((RangeCacheUtil.Range)e.getKey()).end <= start) continue;
            if (ev == null) {
                ev = new PropertyChangeEvent(this, UPDATE_DATA, null, null);
            }
            for (PropertyChangeListener l : ((ChangeEntry)e.getValue()).listeners) {
                l.propertyChange(ev);
            }
        }
    }

    public void fillCache() {
        if (!this.dataCache.isEmpty()) {
            throw new UnsupportedOperationException("The data cache can be filled only once.");
        }
        List<RangeCacheUtil.Range> rlist = this.ranges.getRanges();
        if (rlist.isEmpty()) {
            return;
        }
        for (RangeCacheUtil.Range r : rlist) {
            this.dataCache.put(r, null);
            this.rangesToLoad.add(r);
        }
        this.continueLoading();
    }

    private void continueLoading() {
        if (this.dataCache.isEmpty() && this.rangesToLoad.isEmpty()) {
            return;
        }
        this.nextRangeToLoad = this.rangesToLoad.poll();
        if (this.nextRangeToLoad == null) {
            this.firePropertyChange(UPDATE_LOADING_COMPLETE, null, null);
            return;
        }
        this.currentRangeNextOffset = -1L;
        this.loadRange();
    }

    private void loadRange() {
        int count;
        if (this.currentRangeNextOffset < 0L) {
            int len = (int)(this.nextRangeToLoad.end - this.nextRangeToLoad.start);
            Map.Entry<RangeCacheUtil.Range, byte[]> cachedRange = this.getCacheForRange(this.nextRangeToLoad.start, len);
            if (cachedRange == null) {
                this.currentRangeData = new byte[len];
                this.dataCache.put(this.nextRangeToLoad, this.currentRangeData);
                this.currentRangeNextOffset = this.nextRangeToLoad.start;
            } else {
                this.currentRangeData = cachedRange.getValue();
                this.currentRangeNextOffset = this.nextRangeToLoad.start;
                if (!this.nextRangeToLoad.equals(cachedRange.getKey())) {
                    this.nextRangeToLoad = new RangeCacheUtil.Range(cachedRange.getKey().start, this.nextRangeToLoad.end, false);
                }
            }
        }
        if ((count = (int)(this.nextRangeToLoad.end - this.currentRangeNextOffset)) <= 0) {
            this.continueLoading();
            return;
        }
        if (count > 64) {
            count = 64;
        }
        final int fcount = count;
        this.access.doRead(this.currentRangeNextOffset, this.space, count, new MemoryConfigurationService.McsReadHandler(){

            @Override
            public void handleFailure(int code) {
                logger.warning("Error reading memory space cache: dest " + MemorySpaceCache.this.remoteNodeString + "space" + MemorySpaceCache.this.space + " offset " + MemorySpaceCache.this.currentRangeNextOffset + " error 0x" + Integer.toHexString(code));
                MemorySpaceCache.this.currentRangeNextOffset += fcount;
                MemorySpaceCache.this.loadRange();
            }

            @Override
            public void handleReadData(NodeID dest, int space, long address, byte[] data) {
                if (MemorySpaceCache.this.currentRangeNextOffset != address) {
                    throw new RuntimeException("spurious return data for address=" + address + " length " + data.length);
                }
                if ((long)data.length + MemorySpaceCache.this.currentRangeNextOffset - ((MemorySpaceCache)MemorySpaceCache.this).nextRangeToLoad.start > (long)MemorySpaceCache.this.currentRangeData.length) {
                    throw new RuntimeException("return data won't fit, space=" + space + " address= " + address + " length=" + data.length + " expected address=" + MemorySpaceCache.this.currentRangeNextOffset + " expectedspace=" + MemorySpaceCache.this.space + " expectedcount=" + fcount);
                }
                boolean hasZero = false;
                if (data.length == 0) {
                    logger.warning(String.format("Datagram read returned 0 bytes. Remote node %s, space %d, address 0x%x", dest.toString(), space, address));
                    MemorySpaceCache.this.currentRangeNextOffset += fcount;
                } else {
                    System.arraycopy(data, 0, MemorySpaceCache.this.currentRangeData, (int)(MemorySpaceCache.this.currentRangeNextOffset - ((MemorySpaceCache)MemorySpaceCache.this).nextRangeToLoad.start), data.length);
                    for (int i = 0; i < data.length; ++i) {
                        if (data[i] != 0) continue;
                        hasZero = true;
                        break;
                    }
                    MemorySpaceCache.this.notifyPartialRead(MemorySpaceCache.this.currentRangeNextOffset, MemorySpaceCache.this.currentRangeNextOffset + (long)data.length, hasZero);
                    MemorySpaceCache.this.currentRangeNextOffset += data.length;
                }
                if (hasZero && ((MemorySpaceCache)MemorySpaceCache.this).nextRangeToLoad.nullTerminated) {
                    MemorySpaceCache.this.continueLoading();
                } else {
                    MemorySpaceCache.this.loadRange();
                }
            }
        });
    }

    private Map.Entry<RangeCacheUtil.Range, byte[]> getCacheForRange(long offset, int len) {
        RangeCacheUtil.Range r = new RangeCacheUtil.Range(offset, Integer.MAX_VALUE, true);
        Map.Entry<RangeCacheUtil.Range, byte[]> entry = this.dataCache.floorEntry(r);
        if (entry == null) {
            return null;
        }
        if (entry.getKey().end < offset + (long)len) {
            return null;
        }
        if (entry.getValue() == null) {
            return null;
        }
        return entry;
    }

    public byte[] read(long offset, int len) {
        Map.Entry<RangeCacheUtil.Range, byte[]> entry = this.getCacheForRange(offset, len);
        if (entry == null) {
            return null;
        }
        byte[] ret = new byte[len];
        System.arraycopy(entry.getValue(), (int)(offset - entry.getKey().start), ret, 0, len);
        return ret;
    }

    public void write(final long offset, final byte[] data, final ConfigRepresentation.CdiEntry cdiEntry) {
        int len = data.length;
        Map.Entry<RangeCacheUtil.Range, byte[]> entry = this.getCacheForRange(offset, len);
        if (entry != null && entry.getValue() != null) {
            System.arraycopy(data, 0, entry.getValue(), (int)(offset - entry.getKey().start), data.length);
        }
        logger.finer("Writing to space " + this.space + " offset 0x" + Long.toHexString(offset) + " payload length " + data.length);
        class RepeatedWrite
        implements MemoryConfigurationService.McsWriteHandler {
            int dataOffset = 0;

            RepeatedWrite() {
            }

            public void next() {
                byte[] p;
                int len = Math.min(data.length - this.dataOffset, 64);
                if (len == data.length) {
                    p = data;
                } else {
                    p = new byte[len];
                    System.arraycopy(data, this.dataOffset, p, 0, len);
                }
                long writeAddress = offset + (long)this.dataOffset;
                this.dataOffset += len;
                MemorySpaceCache.this.access.doWrite(writeAddress, MemorySpaceCache.this.space, p, this);
            }

            @Override
            public void handleFailure(int errorCode) {
                logger.warning(String.format("Write failed (space %d address %d): 0x%04x", MemorySpaceCache.this.space, offset, errorCode));
                cdiEntry.fireWriteComplete();
            }

            @Override
            public void handleSuccess() {
                logger.finer(String.format("Write complete (space %d address %d).", MemorySpaceCache.this.space, offset));
                if (this.dataOffset >= data.length) {
                    cdiEntry.fireWriteComplete();
                } else {
                    this.next();
                }
            }
        }
        new RepeatedWrite().next();
        this.notifyAfterWrite(offset, offset + (long)data.length);
    }

    public void reload(long origin, int size, boolean nullTerminated) {
        this.rangesToLoad.add(new RangeCacheUtil.Range(origin, origin + (long)size, nullTerminated));
        this.continueLoading();
    }

    private class ChangeEntry {
        List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();
        int previousMax;

        private ChangeEntry() {
        }
    }
}

