/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.cdi.impl;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RangeCacheUtil {
    private static final int RANGE_MERGE_THRESHOLD = 8;
    private ArrayList<Range> addedRanges = new ArrayList();
    private boolean isSimplified = true;

    @Nullable
    private static Range mergeRange(Range current, Range next) {
        if (next.start > current.end + 8L || current.nullTerminated || next.nullTerminated) {
            return null;
        }
        return new Range(Math.min(current.start, next.start), Math.max(current.end, next.end), false);
    }

    public synchronized void addRange(long start, long end, boolean nullTerminated) {
        this.addedRanges.add(new Range(start, end, nullTerminated));
        this.isSimplified = false;
    }

    public synchronized void addRange(long start, long end) {
        this.addRange(start, end, false);
    }

    private void simplifyRanges() {
        if (this.addedRanges.isEmpty()) {
            return;
        }
        Collections.sort(this.addedRanges);
        ArrayList<Range> newRanges = new ArrayList<Range>(this.addedRanges.size());
        Range current = this.addedRanges.get(0);
        for (int i = 1; i < this.addedRanges.size(); ++i) {
            Range mergedRange = RangeCacheUtil.mergeRange(current, this.addedRanges.get(i));
            if (mergedRange == null) {
                newRanges.add(current);
                current = this.addedRanges.get(i);
                continue;
            }
            current = mergedRange;
        }
        newRanges.add(current);
        this.addedRanges = newRanges;
        this.isSimplified = true;
    }

    public synchronized List<Range> getRanges() {
        if (!this.isSimplified) {
            this.simplifyRanges();
        }
        return this.addedRanges;
    }

    public static class Range
    implements Comparable<Range> {
        public final long start;
        public final long end;
        public boolean nullTerminated;

        public Range(long s, long e, boolean nullTerminated) {
            this.start = s;
            this.end = e;
            this.nullTerminated = nullTerminated;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Range)) {
                return false;
            }
            Range orng = (Range)o;
            return this.start == orng.start && this.end == orng.end && this.nullTerminated == orng.nullTerminated;
        }

        public int hashCode() {
            return (int)(this.start * 941083987L ^ this.end * 920419813L ^ (long)(this.nullTerminated ? 858599509 : 0));
        }

        public String toString() {
            return (this.nullTerminated ? "NRange[" : "Range[") + this.start + "," + this.end + ")";
        }

        @Override
        public int compareTo(Range another) {
            if (this.start < another.start) {
                return -1;
            }
            if (this.start > another.start) {
                return 1;
            }
            if (this.end < another.end) {
                return -1;
            }
            if (this.end > another.end) {
                return 1;
            }
            if (!this.nullTerminated && another.nullTerminated) {
                return -1;
            }
            if (this.nullTerminated && !another.nullTerminated) {
                return 1;
            }
            return 0;
        }
    }
}

