/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.cdi.jdom;

import java.io.IOException;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xerces.parsers.SAXParser;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.openlcb.cdi.CdiRep;
import org.openlcb.cdi.jdom.JdomCdiRep;

public class JdomCdiReader {
    private static final Logger logger = Logger.getLogger(JdomCdiReader.class.getName());

    public static Element getHeadFromReader(Reader rdr) throws Exception {
        SAXBuilder builder;
        String parserName = SAXParser.class.getName();
        try {
            builder = new SAXBuilder(parserName, false);
        }
        catch (Exception e) {
            builder = new SAXBuilder(false);
        }
        try {
            builder.setFeature("http://apache.org/xml/features/xinclude", true);
            builder.setFeature("http://apache.org/xml/features/xinclude/fixup-base-uris", false);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Could not set xinclude feature: {0}", e);
        }
        try {
            builder.setFeature("http://xml.org/sax/features/namespaces", true);
            builder.setFeature("http://apache.org/xml/features/validation/schema", false);
            builder.setFeature("http://apache.org/xml/features/validation/schema-full-checking", false);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Could not set schema validation feature: {0}", e);
        }
        try {
            Document doc = builder.build(rdr);
            return doc.getRootElement();
        }
        catch (JDOMException e) {
            logger.log(Level.SEVERE, "Could not create Document: {0}", e);
            throw e;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Could not create Document: {0}", e);
            throw new Exception(e);
        }
    }

    public CdiRep getRep(Element root) {
        return new JdomCdiRep(root);
    }
}

