/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.cdi.jdom;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.openlcb.cdi.CdiRep;

public class JdomCdiRep
implements CdiRep {
    private static final Logger logger = Logger.getLogger(JdomCdiRep.class.getName());
    Element root;

    public JdomCdiRep(Element root) {
        this.root = root;
    }

    @Override
    public Identification getIdentification() {
        Element id = this.root.getChild("identification");
        if (id == null) {
            return null;
        }
        return new Identification(id);
    }

    @Override
    public List<CdiRep.Segment> getSegments() {
        List list = this.root.getChildren("segment");
        ArrayList<CdiRep.Segment> result = new ArrayList<CdiRep.Segment>();
        for (int i = 0; i < list.size(); ++i) {
            result.add(new Segment((Element)list.get(i)));
        }
        return result;
    }

    public static class Identification
    implements CdiRep.Identification {
        Element id;

        @Override
        public String getManufacturer() {
            Element c = this.id.getChild("manufacturer");
            if (c == null) {
                return null;
            }
            return c.getText();
        }

        @Override
        public String getModel() {
            Element c = this.id.getChild("model");
            if (c == null) {
                return null;
            }
            return c.getText();
        }

        @Override
        public String getHardwareVersion() {
            Element c = this.id.getChild("hardwareVersion");
            if (c == null) {
                return null;
            }
            return c.getText();
        }

        @Override
        public String getSoftwareVersion() {
            Element c = this.id.getChild("softwareVersion");
            if (c == null) {
                return null;
            }
            return c.getText();
        }

        @Override
        public String getLinkText() {
            Element c = this.id.getChild("link");
            if (c == null) {
                return null;
            }
            return c.getText();
        }

        @Override
        public String getLinkURL() {
            Element c = this.id.getChild("link");
            if (c == null) {
                return null;
            }
            Attribute a = c.getAttribute("ref");
            if (a == null) {
                return null;
            }
            return a.getValue();
        }

        @Override
        public Map getMap() {
            return new Map(this.id.getChild("map"));
        }

        Identification(Element id) {
            this.id = id;
        }
    }

    public static class Segment
    extends Nested
    implements CdiRep.Segment {
        Segment(Element segment) {
            super(segment);
        }

        @Override
        public int getSpace() {
            Attribute a = this.e.getAttribute("space");
            try {
                if (a == null) {
                    return 0;
                }
                return a.getIntValue();
            }
            catch (DataConversionException e1) {
                return 0;
            }
        }

        @Override
        public int getOrigin() {
            Attribute a = this.e.getAttribute("origin");
            try {
                if (a == null) {
                    return 0;
                }
                return a.getIntValue();
            }
            catch (DataConversionException e1) {
                return 0;
            }
        }

        @Override
        public String getLinkText() {
            Element c = this.e.getChild("link");
            if (c == null) {
                return null;
            }
            return c.getText();
        }

        @Override
        public String getLinkURL() {
            Element c = this.e.getChild("link");
            if (c == null) {
                return null;
            }
            Attribute a = c.getAttribute("ref");
            if (a == null) {
                return null;
            }
            return a.getValue();
        }
    }

    public static class ActionButtonRep
    extends Item
    implements CdiRep.ActionButtonRep {
        ActionButtonRep(Element e) {
            super(e);
        }

        @Override
        public int getSize() {
            Attribute a = this.e.getAttribute("size");
            try {
                if (a == null) {
                    return 1;
                }
                return a.getIntValue();
            }
            catch (DataConversionException e1) {
                return 0;
            }
        }

        @Override
        public long getValue() {
            Element target = this.e.getChild("value");
            if (target != null) {
                String text = target.getTextNormalize();
                try {
                    return Integer.valueOf(text).intValue();
                }
                catch (NumberFormatException ex) {
                    logger.severe("Invalid content for value element: " + text);
                }
            }
            return 0L;
        }

        @Override
        public String getButtonText() {
            Element target = this.e.getChild("buttonText");
            if (target != null) {
                return target.getTextNormalize();
            }
            return "";
        }

        @Override
        public String getDialogText() {
            Element target = this.e.getChild("dialogText");
            if (target != null) {
                return target.getTextNormalize();
            }
            return "";
        }
    }

    public static class StringRep
    extends Item
    implements CdiRep.StringRep {
        StringRep(Element e) {
            super(e);
        }

        @Override
        public int getSize() {
            Attribute a = this.e.getAttribute("size");
            try {
                if (a == null) {
                    return 1;
                }
                return a.getIntValue();
            }
            catch (DataConversionException e1) {
                return 0;
            }
        }
    }

    public static class BitRep
    extends Item
    implements CdiRep.BitRep {
        BitRep(Element e) {
            super(e);
        }

        @Override
        public boolean getDefault() {
            return false;
        }

        @Override
        public int getSize() {
            Attribute a = this.e.getAttribute("size");
            try {
                if (a == null) {
                    return 1;
                }
                return a.getIntValue();
            }
            catch (DataConversionException e1) {
                return 0;
            }
        }
    }

    public static class UnknownRep
    extends Item
    implements CdiRep.UnknownRep {
        UnknownRep(Element e) {
            super(e);
        }

        @Override
        public boolean getDefault() {
            return false;
        }

        @Override
        public int getSize() {
            Attribute a = this.e.getAttribute("size");
            try {
                if (a == null) {
                    return 0;
                }
                return a.getIntValue();
            }
            catch (DataConversionException e1) {
                return 0;
            }
        }
    }

    public static class FloatRep
    extends Item
    implements CdiRep.FloatRep {
        FloatRep(Element e) {
            super(e);
        }

        @Override
        public double getDefault() {
            Element target = this.e.getChild("default");
            if (target != null) {
                String text = target.getTextNormalize();
                try {
                    return Double.valueOf(text);
                }
                catch (NumberFormatException ex) {
                    logger.severe("Invalid content for default element: " + text);
                }
            }
            return 0.0;
        }

        @Override
        public double getMin() {
            Element target = this.e.getChild("min");
            if (target != null) {
                String text = target.getTextNormalize();
                try {
                    return Double.valueOf(text);
                }
                catch (NumberFormatException ex) {
                    logger.severe("Invalid content for min element: " + text);
                }
            }
            return 0.0;
        }

        @Override
        public double getMax() {
            Element target = this.e.getChild("max");
            if (target != null) {
                String text = target.getTextNormalize();
                try {
                    return Integer.valueOf(text).intValue();
                }
                catch (NumberFormatException ex) {
                    logger.severe("Invalid content for max element: " + text);
                }
            }
            switch (this.getSize()) {
                case 8: {
                    return Double.MAX_VALUE;
                }
                case 4: {
                    return 3.4028234663852886E38;
                }
                case 2: {
                    return 65503.0;
                }
            }
            logger.severe("Invalid size when finding default max: " + this.getSize());
            return 1.0;
        }

        @Override
        public int getSize() {
            Attribute a = this.e.getAttribute("size");
            try {
                if (a == null) {
                    return 1;
                }
                return a.getIntValue();
            }
            catch (DataConversionException e1) {
                return 0;
            }
        }
    }

    public static class IntRep
    extends Item
    implements CdiRep.IntegerRep {
        IntRep(Element e) {
            super(e);
        }

        @Override
        public int getDefault() {
            Element target = this.e.getChild("default");
            if (target != null) {
                String text = target.getTextNormalize();
                try {
                    return Integer.valueOf(text);
                }
                catch (NumberFormatException ex) {
                    logger.severe("Invalid content for default element: " + text);
                }
            }
            return 0;
        }

        @Override
        public long getMin() {
            Element target = this.e.getChild("min");
            if (target != null) {
                String text = target.getTextNormalize();
                try {
                    return Integer.valueOf(text).intValue();
                }
                catch (NumberFormatException ex) {
                    logger.severe("Invalid content for min element: " + text);
                }
            }
            return 0L;
        }

        @Override
        public long getMax() {
            int size;
            Element target = this.e.getChild("max");
            if (target != null) {
                String text = target.getTextNormalize();
                try {
                    return Integer.valueOf(text).intValue();
                }
                catch (NumberFormatException ex) {
                    logger.severe("Invalid content for max element: " + text);
                }
            }
            if ((size = this.getSize()) == 8) {
                size = 4;
            }
            long retVal = 1L << (int)((long)size * 8L);
            return --retVal;
        }

        @Override
        public int getSize() {
            Attribute a = this.e.getAttribute("size");
            try {
                if (a == null) {
                    return 1;
                }
                return a.getIntValue();
            }
            catch (DataConversionException e1) {
                return 0;
            }
        }

        @Override
        public boolean isSliderHint() {
            Element hints = this.e.getChild("hints");
            if (hints == null) {
                return false;
            }
            Element slider = hints.getChild("slider");
            return slider != null;
        }

        @Override
        public boolean isSliderImmediate() {
            Element hints = this.e.getChild("hints");
            if (hints == null) {
                return false;
            }
            Element slider = hints.getChild("slider");
            if (slider == null) {
                return false;
            }
            Attribute immediate = slider.getAttribute("immediate");
            if (immediate == null) {
                return false;
            }
            try {
                boolean value = immediate.getBooleanValue();
                return value;
            }
            catch (DataConversionException ex) {
                return false;
            }
        }

        @Override
        public int getSliderTickSpacing() {
            Element hints = this.e.getChild("hints");
            if (hints == null) {
                return 0;
            }
            Element slider = hints.getChild("slider");
            if (slider == null) {
                return 0;
            }
            Attribute tickSpacing = slider.getAttribute("tickSpacing");
            if (tickSpacing == null) {
                return 0;
            }
            try {
                return tickSpacing.getIntValue();
            }
            catch (DataConversionException e) {
                return 0;
            }
        }

        @Override
        public boolean isSliderShowValue() {
            Element hints = this.e.getChild("hints");
            if (hints == null) {
                return false;
            }
            Element slider = hints.getChild("slider");
            if (slider == null) {
                return false;
            }
            Attribute showValue = slider.getAttribute("showValue");
            if (showValue == null) {
                return false;
            }
            try {
                boolean value = showValue.getBooleanValue();
                return value;
            }
            catch (DataConversionException ex) {
                return false;
            }
        }

        @Override
        public boolean isRadioButtonHint() {
            Element hints = this.e.getChild("hints");
            if (hints == null) {
                return false;
            }
            Element radiobutton = hints.getChild("radiobutton");
            return radiobutton != null;
        }
    }

    public static class EventID
    extends Item
    implements CdiRep.EventID {
        EventID(Element e) {
            super(e);
        }
    }

    public static class Group
    extends Nested
    implements CdiRep.Group {
        private static final String DEFAULT_REP_PREFIX = "Group";

        Group(Element e) {
            super(e);
        }

        @Override
        public int getReplication() {
            Attribute a = this.e.getAttribute("replication");
            try {
                if (a == null) {
                    return 0;
                }
                return a.getIntValue();
            }
            catch (DataConversionException e1) {
                return 0;
            }
        }

        @Override
        public int getOffset() {
            Attribute a = this.e.getAttribute("offset");
            try {
                if (a == null) {
                    return 0;
                }
                return a.getIntValue();
            }
            catch (DataConversionException e1) {
                return 0;
            }
        }

        @Override
        public String getLinkText() {
            Element c = this.e.getChild("link");
            if (c == null) {
                return null;
            }
            return c.getText();
        }

        @Override
        public String getLinkURL() {
            Element c = this.e.getChild("link");
            if (c == null) {
                return null;
            }
            Attribute a = c.getAttribute("ref");
            if (a == null) {
                return null;
            }
            return a.getValue();
        }

        @Override
        public boolean isHideable() {
            Element hints = this.e.getChild("hints");
            if (hints == null) {
                return false;
            }
            Element visibility = hints.getChild("visibility");
            if (visibility == null) {
                return false;
            }
            Attribute a = visibility.getAttribute("hideable");
            if (a == null) {
                return false;
            }
            try {
                boolean value = a.getBooleanValue();
                return value;
            }
            catch (DataConversionException ex) {
                return false;
            }
        }

        @Override
        public boolean isHidden() {
            Element hints = this.e.getChild("hints");
            if (hints == null) {
                return false;
            }
            Element visibility = hints.getChild("visibility");
            if (visibility == null) {
                return false;
            }
            Attribute a = visibility.getAttribute("hidden");
            if (a == null) {
                return false;
            }
            try {
                boolean value = a.getBooleanValue();
                return value;
            }
            catch (DataConversionException ex) {
                return false;
            }
        }

        @Override
        public boolean isReadOnly() {
            Element hints = this.e.getChild("hints");
            if (hints == null) {
                return false;
            }
            Element readOnly = hints.getChild("readOnly");
            return readOnly != null;
        }

        @Override
        @NonNull
        public String getRepName(int index, int replications) {
            if (index < 1) {
                throw new IllegalArgumentException("index " + index + " must be >= 1");
            }
            List repnames = this.e.getChildren("repname");
            if (repnames == null || repnames.size() == 0) {
                return DEFAULT_REP_PREFIX;
            }
            if (index < repnames.size()) {
                Element d = (Element)repnames.get(index - 1);
                return d.getText();
            }
            if (index == repnames.size() && index == replications) {
                Element d = (Element)repnames.get(index - 1);
                return d.getText();
            }
            Element d = (Element)repnames.get(repnames.size() - 1);
            String name = d.getText();
            int firstTrailingDigit = this.indexOfFirstTrailingDigit(name);
            if (firstTrailingDigit == -1) {
                int trailingNumber = index - (repnames.size() - 1);
                return name + trailingNumber;
            }
            String digits = name.substring(firstTrailingDigit);
            int initialValue = Integer.parseInt(digits);
            int trailingNumber = initialValue + (index - 1 - (repnames.size() - 1));
            return name.substring(0, firstTrailingDigit) + trailingNumber;
        }

        int indexOfFirstTrailingDigit(String input) {
            if (input.isEmpty()) {
                return -1;
            }
            if (!Character.isDigit(input.charAt(input.length() - 1))) {
                return -1;
            }
            for (int first = input.length() - 1; first >= 0; --first) {
                if (Character.isDigit(input.charAt(first))) continue;
                return first + 1;
            }
            return 0;
        }
    }

    public static class Item
    implements CdiRep.Item {
        Element e;

        Item(Element e) {
            this.e = e;
        }

        @Override
        public String getName() {
            Element d = this.e.getChild("name");
            if (d == null) {
                return null;
            }
            return d.getText();
        }

        @Override
        public String getDescription() {
            Element d = this.e.getChild("description");
            if (d == null) {
                return null;
            }
            return d.getText();
        }

        @Override
        public Map getMap() {
            return new Map(this.e.getChild("map"));
        }

        @Override
        public int getOffset() {
            Attribute a = this.e.getAttribute("offset");
            try {
                if (a == null) {
                    return 0;
                }
                return a.getIntValue();
            }
            catch (DataConversionException e) {
                return 0;
            }
        }

        @Override
        public int getIndexInParent() {
            return this.e.getParent().indexOf((Content)this.e);
        }
    }

    public static class Map
    implements CdiRep.Map {
        Element map;

        Map(Element map) {
            this.map = map;
        }

        @Override
        public String getEntry(String key) {
            List relations = this.map.getChildren("relation");
            for (int i = 0; i < relations.size(); ++i) {
                if (!key.equals(((Element)relations.get(i)).getChild("property").getText())) continue;
                return ((Element)relations.get(i)).getChild("value").getText();
            }
            return null;
        }

        @Override
        public String getKey(String entry) {
            List relations = this.map.getChildren("relation");
            for (int i = 0; i < relations.size(); ++i) {
                if (!entry.equals(((Element)relations.get(i)).getChild("value").getText())) continue;
                return ((Element)relations.get(i)).getChild("property").getText();
            }
            return null;
        }

        @Override
        public List<String> getKeys() {
            ArrayList<String> list = new ArrayList<String>();
            if (this.map == null) {
                return list;
            }
            List relations = this.map.getChildren("relation");
            if (relations == null) {
                return list;
            }
            for (int i = 0; i < relations.size(); ++i) {
                list.add(((Element)relations.get(i)).getChild("property").getText());
            }
            return list;
        }

        @Override
        public List<String> getValues() {
            ArrayList<String> list = new ArrayList<String>();
            if (this.map == null) {
                return list;
            }
            List relations = this.map.getChildren("relation");
            if (relations == null) {
                return list;
            }
            for (int i = 0; i < relations.size(); ++i) {
                list.add(((Element)relations.get(i)).getChild("value").getText());
            }
            return list;
        }

        @Override
        public void addItemToMap(String key, String entry) {
            Element relation = new Element("relation");
            Element property = new Element("property");
            Element value = new Element("value");
            property.addContent(key);
            value.addContent(entry);
            relation.addContent((Content)property);
            relation.addContent((Content)value);
            this.map.addContent((Content)relation);
        }
    }

    static class Nested {
        Element e;

        public String getName() {
            Element d = this.e.getChild("name");
            if (d == null) {
                return null;
            }
            return d.getText();
        }

        public String getDescription() {
            Element d = this.e.getChild("description");
            if (d == null) {
                return null;
            }
            return d.getText();
        }

        public Map getMap() {
            return new Map(this.e.getChild("map"));
        }

        public List<CdiRep.Item> getItems() {
            ArrayList<CdiRep.Item> list = new ArrayList<CdiRep.Item>();
            if (this.e == null) {
                return list;
            }
            List elements = this.e.getChildren();
            block24: for (int i = 0; i < elements.size(); ++i) {
                Element element = (Element)elements.get(i);
                switch (element.getName()) {
                    case "group": {
                        list.add(new Group(element));
                        continue block24;
                    }
                    case "bit": {
                        list.add(new BitRep(element));
                        continue block24;
                    }
                    case "int": {
                        list.add(new IntRep(element));
                        continue block24;
                    }
                    case "float": {
                        list.add(new FloatRep(element));
                        continue block24;
                    }
                    case "eventid": {
                        list.add(new EventID(element));
                        continue block24;
                    }
                    case "string": {
                        list.add(new StringRep(element));
                        continue block24;
                    }
                    case "action": {
                        list.add(new ActionButtonRep(element));
                        continue block24;
                    }
                    case "repname": 
                    case "name": 
                    case "description": 
                    case "link": 
                    case "hints": {
                        continue block24;
                    }
                    default: {
                        list.add(new UnknownRep(element));
                    }
                }
            }
            return list;
        }

        public int getIndexInParent() {
            return this.e.getParent().indexOf((Content)this.e);
        }

        Nested(Element e) {
            this.e = e;
        }
    }
}

