/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.cdi.jdom;

import java.io.IOException;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class XmlHelper {
    private static final Logger logger = Logger.getLogger(XmlHelper.class.getName());

    public static Element parseXmlFromReader(Reader r) throws Exception {
        SAXBuilder builder = new SAXBuilder(false);
        builder.setFeature("http://xml.org/sax/features/namespaces", true);
        try {
            Document doc = builder.build(r);
            return doc.getRootElement();
        }
        catch (IOException | JDOMException e) {
            logger.log(Level.SEVERE, "Could not create Document: {0}", e);
            throw e;
        }
    }
}

