/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.cdi.swing;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.openlcb.EventID;
import org.openlcb.NodeID;
import org.openlcb.ProducerConsumerEventReportMessage;
import org.openlcb.Utilities;
import org.openlcb.cdi.CdiRep;
import org.openlcb.cdi.cmd.BackupConfig;
import org.openlcb.cdi.cmd.RestoreConfig;
import org.openlcb.cdi.impl.ConfigRepresentation;
import org.openlcb.implementations.BitProducerConsumer;
import org.openlcb.implementations.EventTable;
import org.openlcb.swing.EventIdTextField;
import util.CollapsiblePanel;
import util.WrapLayout;
import util.javaworld.GridLayout2;

public class CdiPanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(CdiPanel.class.getName());
    private static final Color COLOR_EDITED = new Color(16765568);
    private static final Color COLOR_UNFILLED = new Color(0xFFFF00);
    private static final Color COLOR_WRITTEN = new Color(0xFFFFFF);
    private static final Color COLOR_ERROR = new Color(0xFF0000);
    private static final Color COLOR_INVALID = new Color(0xC0C0FF);
    private static final Pattern segmentPrefixRe = Pattern.compile("^seg[0-9]*[.]");
    private static final Pattern entrySuffixRe = Pattern.compile("[.]child[0-9]*$");
    private static final Color COLOR_COPIED = COLOR_EDITED;
    static JFileChooser fci = new JFileChooser();
    private ConfigRepresentation rep;
    private EventTable eventTable;
    private String nodeName;
    private boolean _changeMade;
    private boolean _unsavedRestore;
    private boolean _panelChange;
    private boolean _windowCloseCheckAlreadyHandled;
    private JButton _saveButton;
    private Color COLOR_DEFAULT;
    private List<CollapsiblePanel> segmentPanels;
    private List<CollapsiblePanel> navPanels;
    private final Color COLOR_BACKGROUND;
    private CollapsiblePanel sensorHelperPanel;
    private JComponent bottomPanelHead;
    private static Font tabFont;
    public static FileNameGenerator fileNameGenerator;
    GuiItemFactory factory;
    JPanel loadingPanel;
    JLabel loadingText;
    PropertyChangeListener loadingListener;
    private JButton reloadButton;
    private final List<EntryPane> allEntries;
    private final Map<String, EntryPane> entriesByKey;
    private final Map<String, JTabbedPane> tabsByKey;
    private final ArrayList<Runnable> cleanupTasks;
    private final ArrayList<Runnable> startupTasks;
    private boolean renderingInProgress;
    boolean loadingIsPacked;
    JScrollPane scrollPane;
    JPanel contentPanel;
    JPanel bottomPanel;
    JPopupMenu moreMenu;
    JButton moreButton;
    SearchPane searchPane;
    private java.util.Timer tabColorTimer;
    private boolean tabColorTimerStopped;
    long lastColorRefreshNeeded;
    long lastColorRefreshDone;
    Font countAreaFont;
    Font textAreaFont;
    static final int MAX_SINGLE_LINE_ENTRY = 64;

    public CdiPanel() {
        fci.setSelectedFile(new File(".txt"));
        this.eventTable = null;
        this.nodeName = "";
        this._changeMade = false;
        this._unsavedRestore = false;
        this._panelChange = false;
        this._windowCloseCheckAlreadyHandled = false;
        this.segmentPanels = new ArrayList<CollapsiblePanel>();
        this.navPanels = new ArrayList<CollapsiblePanel>();
        this.allEntries = new ArrayList<EntryPane>();
        this.entriesByKey = new HashMap<String, EntryPane>();
        this.tabsByKey = new HashMap<String, JTabbedPane>();
        this.cleanupTasks = new ArrayList();
        this.startupTasks = new ArrayList();
        this.renderingInProgress = true;
        this.loadingIsPacked = false;
        this.moreMenu = new JPopupMenu();
        this.searchPane = new SearchPane();
        this.tabColorTimerStopped = false;
        this.lastColorRefreshNeeded = 0L;
        this.lastColorRefreshDone = Long.MAX_VALUE;
        Font existingFont = UIManager.getFont("TextArea.font");
        int size = existingFont.getSize() * 3 / 4;
        this.countAreaFont = new Font("Monospaced", 0, size);
        existingFont = UIManager.getFont("TextArea.font");
        size = existingFont.getSize();
        this.textAreaFont = new Font("Monospaced", 0, size);
        this.tabColorTimer = new java.util.Timer("OpenLCB CDI Reader Tab Color Timer");
        this.COLOR_BACKGROUND = this.getBackground().darker();
        this.setForeground(this.COLOR_BACKGROUND);
    }

    public CdiPanel(File dir) {
        this();
        fci.setCurrentDirectory(dir);
    }

    public void release() {
        logger.log(Level.FINE, "Cleanup of CDI window for {0}", this.nodeName);
        for (Runnable task : this.cleanupTasks) {
            task.run();
        }
        this.cleanupTasks.clear();
        this.tabColorTimerStopped = true;
        this.tabColorTimer.cancel();
    }

    public void setEventTable(String nodeName, EventTable t) {
        this.eventTable = t;
        this.nodeName = nodeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initComponents(ConfigRepresentation rep, GuiItemFactory factory) {
        this.setLayout(new BoxLayout(this, 1));
        this.setAlignmentX(0.0f);
        this.rep = rep;
        this.factory = factory;
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
        this.contentPanel.setAlignmentX(0.0f);
        this.contentPanel.setBackground(this.COLOR_BACKGROUND);
        this.scrollPane = new JScrollPane(this.contentPanel);
        Dimension minScrollerDim = new Dimension(800, 12);
        this.scrollPane.setMinimumSize(minScrollerDim);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(30);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.add(this.scrollPane);
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new WrapLayout());
        JButton bb = new JButton("Refresh All");
        bb.setToolTipText("Discards all changes and loads the freshest value from the hardware for all entries.");
        bb.addActionListener(actionEvent -> this.reloadAll());
        this.bottomPanelHead = bb;
        this.bottomPanel.add(bb);
        this.addNavigationHelper(null, this.bottomPanel, bb);
        this._saveButton = new JButton("Save Changes");
        this.COLOR_DEFAULT = this._saveButton.getBackground();
        this._saveButton.setToolTipText("Writes every changed value to the hardware.");
        this._saveButton.addActionListener(actionEvent -> this.saveChanged());
        this.bottomPanel.add(this._saveButton);
        bb = new JButton("Backup...");
        bb.setToolTipText("Creates a file on your computer with all saved settings from this node. Use the \"Save Changes\" button first.");
        bb.addActionListener(actionEvent -> this.runBackup());
        this.bottomPanel.add(bb);
        bb = new JButton("Restore...");
        bb.setToolTipText("Loads a file with backed-up settings. Does not change the hardware settings, so use \"Save Changes\" afterwards.");
        bb.addActionListener(actionEvent -> this.runRestore());
        this.bottomPanel.add(bb);
        if (rep.getConnection() != null && rep.getRemoteNodeID() != null) {
            bb = new JButton("Restart");
            bb.setToolTipText("Requests the configured node to restart.");
            bb.addActionListener(actionEvent -> this.runRestart());
            this.addButtonToMoreFunctions(bb);
            bb = new JButton("Update Complete");
            bb.setToolTipText("Tells the configured node that the you are done with changing the settings and they should be taking effect now. Might restart the node.");
            bb.addActionListener(actionEvent -> this.runUpdateComplete());
            this.addButtonToMoreFunctions(bb);
            bb = new JButton("Factory Reset");
            bb.setToolTipText("Resets the node to its factory default content");
            bb.addActionListener(actionEvent -> this.runFactoryReset());
            this.addButtonToMoreFunctions(bb);
        }
        this.createSensorCreateHelper();
        Dimension size = this.bottomPanel.getMaximumSize();
        size.height = this.bottomPanel.getPreferredSize().height;
        this.bottomPanel.setMaximumSize(size);
        this.add(this.bottomPanel);
        this._changeMade = false;
        this.setSaveClean();
        ConfigRepresentation configRepresentation = rep;
        synchronized (configRepresentation) {
            if (rep.getRoot() != null) {
                this.displayCdi();
            } else {
                this.displayLoadingProgress();
            }
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                CdiPanel.this.updateWidth();
                super.componentResized(componentEvent);
            }
        });
    }

    private void createSensorCreateHelper() {
        JPanel createHelper = new JPanel();
        this.factory.handleGroupPaneStart(createHelper);
        createHelper.setAlignmentX(0.0f);
        createHelper.setLayout(new BoxLayout(createHelper, 1));
        JPanel lineHelper = new JPanel();
        lineHelper.setAlignmentX(0.0f);
        lineHelper.setLayout(new BoxLayout(lineHelper, 0));
        lineHelper.setBorder(BorderFactory.createTitledBorder("User name"));
        JTextField textField = new JTextField(32){

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        this.factory.handleStringValue(textField);
        lineHelper.add(textField);
        lineHelper.add(Box.createHorizontalGlue());
        createHelper.add(lineHelper);
        lineHelper = new JPanel();
        lineHelper.setAlignmentX(0.0f);
        lineHelper.setLayout(new BoxLayout(lineHelper, 0));
        lineHelper.setBorder(BorderFactory.createTitledBorder("Event Id for Active / Thrown"));
        JTextComponent activeTextField = this.factory.handleEventIdTextField(EventIdTextField.getEventIdTextField());
        activeTextField.setMaximumSize(activeTextField.getPreferredSize());
        lineHelper.add(activeTextField);
        this.addCopyPasteButtons(lineHelper, activeTextField);
        lineHelper.add(Box.createHorizontalGlue());
        createHelper.add(lineHelper);
        lineHelper = new JPanel();
        lineHelper.setAlignmentX(0.0f);
        lineHelper.setLayout(new BoxLayout(lineHelper, 0));
        lineHelper.setBorder(BorderFactory.createTitledBorder("Event Id for Inactive / Closed"));
        JTextComponent inactiveTextField = this.factory.handleEventIdTextField(EventIdTextField.getEventIdTextField());
        inactiveTextField.setMaximumSize(inactiveTextField.getPreferredSize());
        lineHelper.add(inactiveTextField);
        this.addCopyPasteButtons(lineHelper, inactiveTextField);
        lineHelper.add(Box.createHorizontalGlue());
        createHelper.add(lineHelper);
        this.factory.handleGroupPaneEnd(createHelper);
        this.sensorHelperPanel = new CollapsiblePanel("Sensor/Turnout creation", createHelper);
        this.sensorHelperPanel.setBackground(this.getForeground());
        this.sensorHelperPanel.setExpanded(false);
        this.sensorHelperPanel.setBorder(BorderFactory.createMatteBorder(10, 0, 10, 0, this.getForeground()));
        this.add(this.sensorHelperPanel);
    }

    public void initComponents(ConfigRepresentation rep) {
        this.initComponents(rep, new GuiItemFactory());
    }

    public void addButtonToFooter(JComponent c) {
        if (c instanceof JButton) {
            this.addButtonToMoreFunctions((JButton)c);
        } else {
            this.bottomPanel.add(c);
        }
    }

    private void addButtonToMoreFunctions(final JButton b) {
        if (this.moreButton == null) {
            this.moreButton = new JButton("More...");
            this.moreButton.setToolTipText("Shows additional operations you can do here.");
            this.moreButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CdiPanel.this.showMoreFunctionsMenu();
                }
            });
            this.bottomPanel.add(this.moreButton);
        }
        AbstractAction a = new AbstractAction(b.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                b.doClick();
            }
        };
        this.moreMenu.add(a);
    }

    private void showMoreFunctionsMenu() {
        this.moreMenu.show(this.moreButton, 0, this.moreButton.getHeight());
    }

    public void reloadAll() {
        this.rep.reloadAll();
    }

    private void saveChanged() {
        for (EntryPane entry : this.allEntries) {
            if (!entry.isDirty()) continue;
            entry.writeDisplayTextToNode();
        }
        this.checkForSave();
        logger.info("Save changes done.");
    }

    private void checkForSave() {
        for (EntryPane entry : this.allEntries) {
            if (!entry.isDataInvalid()) continue;
            this.setSaveInvalid();
            return;
        }
        for (EntryPane entry : this.allEntries) {
            if (!entry.isDirty()) continue;
            this.setSaveDirty();
            return;
        }
        this._unsavedRestore = false;
        this.setSaveClean();
    }

    public void madeSensor(String uName) {
        this._panelChange = true;
    }

    public void madeTurnout(String uName) {
        this._panelChange = true;
    }

    public void runBackup() {
        int confirm;
        fci.setDialogTitle("Save configuration backup file");
        fci.rescanCurrentDirectory();
        fci.setSelectedFile(new File(this.generateFileName()));
        int retVal = fci.showSaveDialog(null);
        if (retVal != 0 || fci.getSelectedFile() == null) {
            return;
        }
        if (fci.getSelectedFile().exists() && (confirm = JOptionPane.showConfirmDialog(this, "Do you want to overwrite the existing file?", "File already exists", 0, 2)) != 0) {
            return;
        }
        try {
            BackupConfig.writeConfigToFile(fci.getSelectedFile().getPath(), this.rep);
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.severe("Failed to write variables to file " + fci.getSelectedFile().getPath() + ": " + e.toString());
        }
        logger.info("Config backup done.");
    }

    private String generateFileName() {
        return fileNameGenerator.generateFileName(this.rep, this.nodeName);
    }

    public void runRestore() {
        fci.setDialogTitle("Open configuration restore file");
        fci.rescanCurrentDirectory();
        int retVal = fci.showOpenDialog(null);
        if (retVal != 0) {
            return;
        }
        RestoreConfig.parseConfigFromFile(fci.getSelectedFile().getPath(), new RestoreConfig.ConfigCallback(){
            boolean hasError = false;

            @Override
            public void onConfigEntry(String key, String value) {
                String mapvalue;
                EntryPane pp = (EntryPane)CdiPanel.this.entriesByKey.get(key);
                if (pp == null) {
                    this.onError("Could not find variable for key " + key);
                    return;
                }
                CdiRep.Map map = pp.entry.getCdiItem().getMap();
                if (map != null && map.getKeys().size() > 0 && (mapvalue = map.getEntry(value)) != null) {
                    value = mapvalue;
                }
                pp.updateDisplayText(value);
                pp.updateColor();
            }

            @Override
            public void onError(String error) {
                if (!this.hasError) {
                    logger.severe("Error(s) encountered during loading configuration backup.");
                    this.hasError = true;
                }
                logger.severe(error);
            }
        });
        logger.info("Config load done.");
        this._unsavedRestore = true;
    }

    private void runRestart() {
        this.rep.getConnection().getDatagramService().sendData(this.rep.getRemoteNodeID(), new int[]{32, 169});
    }

    private void runFactoryReset() {
        int reply = JOptionPane.showConfirmDialog(this, "Do you want to make a backup first?", "Factory Reset", 0);
        if (reply != 1) {
            this.runBackup();
        }
        if ((reply = JOptionPane.showConfirmDialog(this, "This resets node contents. Proceed?", "Factory Reset", 0)) != 0) {
            return;
        }
        int[] contentArray = new int[8];
        contentArray[0] = 32;
        contentArray[1] = 170;
        byte[] nodeID = this.rep.getRemoteNodeID().getContents();
        for (int i = 0; i < 6; ++i) {
            contentArray[i + 2] = nodeID[i];
        }
        this.rep.getConnection().getDatagramService().sendData(this.rep.getRemoteNodeID(), contentArray);
    }

    private void runUpdateComplete() {
        try {
            this.rep.getConnection().getDatagramService().sendData(this.rep.getRemoteNodeID(), new int[]{32, 168});
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTabColorRefresh() {
        long currentTick;
        java.util.Timer timer = this.tabColorTimer;
        synchronized (timer) {
            currentTick = ++this.lastColorRefreshNeeded;
        }
        final long actualRequest = currentTick;
        if (!this.tabColorTimerStopped) {
            this.tabColorTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    EventQueue.invokeLater(() -> CdiPanel.this.performTabColorRefresh(actualRequest));
                }
            }, 500L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLoadingListener() {
        ConfigRepresentation configRepresentation = this.rep;
        synchronized (configRepresentation) {
            if (this.loadingListener != null) {
                this.rep.removePropertyChangeListener(this.loadingListener);
            }
            this.loadingListener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLoadingListener() {
        ConfigRepresentation configRepresentation = this.rep;
        synchronized (configRepresentation) {
            if (this.loadingListener != null) {
                return;
            }
            this.loadingListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getPropertyName().equals("UPDATE_REP")) {
                        CdiPanel.this.displayCdi();
                    } else if (event.getPropertyName().equals("UPDATE_STATE")) {
                        CdiPanel.this.loadingText.setText(CdiPanel.this.rep.getStatus());
                        Window win = SwingUtilities.getWindowAncestor(CdiPanel.this);
                        if (!CdiPanel.this.loadingIsPacked && win != null) {
                            win.pack();
                            CdiPanel.this.loadingIsPacked = true;
                        }
                    }
                }
            };
            this.rep.addPropertyChangeListener(this.loadingListener);
        }
    }

    private void hideLoadingProgress() {
        if (this.loadingPanel == null) {
            return;
        }
        this.removeLoadingListener();
        this.loadingPanel.setVisible(false);
    }

    private void displayLoadingProgress() {
        if (this.loadingPanel == null) {
            this.createLoadingPane();
            this.contentPanel.add(this.loadingPanel);
        }
        this.addLoadingListener();
        this.loadingPanel.setVisible(true);
    }

    private void displayCdi() {
        this.displayLoadingProgress();
        this.loadingText.setText("Creating display...");
        if (this.rep.getCdiRep().getIdentification() != null) {
            this.contentPanel.add(this.createIdentificationPane(this.rep.getCdiRep()));
        }
        this.repack();
        new Thread(new Runnable(){

            @Override
            public void run() {
                CdiPanel.this.rep.visit(new RendererVisitor());
                CdiPanel.this.addNavigationActions(CdiPanel.this.sensorHelperPanel);
                EventQueue.invokeLater(() -> CdiPanel.this.displayComplete());
            }
        }, "openlcb-cdi-render").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayComplete() {
        Object object = this.startupTasks;
        synchronized (object) {
            this.renderingInProgress = false;
        }
        this.startupTasks.forEach(r -> r.run());
        this.hideLoadingProgress();
        this.contentPanel.add(Box.createVerticalGlue());
        this.repack();
        object = this.tabColorTimer;
        synchronized (object) {
            this.lastColorRefreshDone = 0L;
        }
        this.setSaveClean();
        this.notifyTabColorRefresh();
        SwingUtilities.invokeLater(() -> {
            JFrame f = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this);
            if (f == null) {
                logger.log(Level.FINE, "Could not add close window listener");
                return;
            }
            f.setDefaultCloseOperation(0);
            f.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    CdiPanel.this.targetWindowClosingEvent(e);
                }
            });
        });
        this.segmentPanels.forEach(p -> p.setExpanded(false));
    }

    protected void targetWindowClosingEvent(WindowEvent evt) {
        boolean closeWindow = true;
        if (!this._windowCloseCheckAlreadyHandled) {
            closeWindow = this.checkOnWindowClosing();
        }
        if (closeWindow) {
            this.release();
            JFrame f = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this);
            f.dispose();
        }
    }

    public void setWindowCloseCheckAlreadyHandled() {
        this._windowCloseCheckAlreadyHandled = true;
    }

    public boolean checkOnWindowClosing() {
        StringBuilder sb = new StringBuilder();
        if (this._unsavedRestore) {
            sb.append("The configuration was restored but not saved.");
            sb.append("\n");
        }
        boolean save = this._unsavedRestore;
        int num_dirty = 0;
        int MAX_DIRTY_TO_SHOW = 10;
        for (EntryPane entry : this.allEntries) {
            GetEntryNameVisitor nameGetter;
            if (entry.isDataInvalid()) {
                if (++num_dirty <= 10) {
                    nameGetter = new GetEntryNameVisitor(entry);
                    this.rep.visit(nameGetter);
                    sb.append(nameGetter.getName());
                    sb.append(" has an invalid value.");
                    sb.append("\n");
                }
                save = true;
                continue;
            }
            if (!entry.isDirty()) continue;
            if (++num_dirty <= 10) {
                nameGetter = new GetEntryNameVisitor(entry);
                this.rep.visit(nameGetter);
                sb.append(nameGetter.getName());
                sb.append(" has not been saved.");
                sb.append("\n");
            }
            save = true;
        }
        if (num_dirty > 10) {
            sb.append(num_dirty - 10);
            sb.append(" additional entries have not been saved.");
            sb.append("\n");
        }
        if (this._panelChange) {
            sb.append("The panel tables have been changed. To keep these changes, save the panel file.");
            sb.append("\n");
        }
        if (num_dirty > 0) {
            sb.append("\nPress Cancel to go back and save these changes.");
            Object[] options = new Object[]{"Discard changes", "Cancel"};
            int confirm = JOptionPane.showOptionDialog(this, sb.toString(), "Unsaved changes", -1, 2, null, options, options[1]);
            if (confirm != 0) {
                return false;
            }
        } else if (this._panelChange) {
            JOptionPane.showMessageDialog(this, sb.toString(), "Tables are changed", 1);
        }
        if (this._changeMade) {
            this.runUpdateComplete();
        }
        return true;
    }

    private void setSaveDirty() {
        SwingUtilities.invokeLater(() -> {
            this._saveButton.setBackground(COLOR_EDITED);
            this._saveButton.setEnabled(true);
        });
    }

    private void setSaveClean() {
        SwingUtilities.invokeLater(() -> {
            this._saveButton.setBackground(this.COLOR_DEFAULT);
            this._saveButton.setEnabled(false);
        });
    }

    private void setSaveInvalid() {
        SwingUtilities.invokeLater(() -> this._saveButton.setBackground(COLOR_INVALID));
    }

    private void repack() {
        Window win = SwingUtilities.getWindowAncestor(this);
        if (win != null) {
            win.pack();
        }
    }

    private void updateWidth() {
        int w = this.getSize().width - 4;
        this.runNowOrLater(() -> this.segmentPanels.forEach(p -> p.setMaximumWidth(w)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performTabColorRefresh(long requestTick) {
        java.util.Timer timer = this.tabColorTimer;
        synchronized (timer) {
            if (this.lastColorRefreshDone >= requestTick) {
                return;
            }
            this.lastColorRefreshDone = this.lastColorRefreshNeeded;
        }
        this.rep.visit(new ConfigRepresentation.Visitor(){
            boolean isDirty = false;
            boolean isInvalid = false;

            @Override
            public void visitGroupRep(ConfigRepresentation.GroupRep e) {
                boolean oldDirty = this.isDirty;
                boolean oldInvalid = this.isInvalid;
                this.isDirty = false;
                this.isInvalid = false;
                super.visitGroupRep(e);
                JTabbedPane tabs = (JTabbedPane)CdiPanel.this.tabsByKey.get(e.key);
                if (tabs != null && tabs.getTabCount() >= e.index) {
                    if (this.isInvalid) {
                        tabs.setBackgroundAt(e.index - 1, COLOR_INVALID);
                    } else if (this.isDirty) {
                        tabs.setBackgroundAt(e.index - 1, COLOR_EDITED);
                    } else {
                        tabs.setBackgroundAt(e.index - 1, null);
                    }
                }
                this.isDirty |= oldDirty;
                this.isInvalid |= oldInvalid;
            }

            @Override
            public void visitLeaf(ConfigRepresentation.CdiEntry e) {
                EntryPane v = (EntryPane)CdiPanel.this.entriesByKey.get(e.key);
                this.isDirty |= v.isDirty();
                this.isInvalid |= v.isDataInvalid();
            }
        });
        this.checkForSave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runNowOrLater(Runnable r) {
        ArrayList<Runnable> arrayList = this.startupTasks;
        synchronized (arrayList) {
            if (this.renderingInProgress) {
                this.startupTasks.add(r);
                return;
            }
        }
        r.run();
    }

    private void navigateUp(CollapsiblePanel current) {
        int index = this.navPanels.indexOf(current);
        if (index < 0) {
            index = this.navPanels.size();
        }
        while (--index >= 0) {
            if (!this.navPanels.get(index).isShowing()) continue;
            this.navPanels.get(index).getHeader().requestFocusInWindow();
            return;
        }
        this.bottomPanelHead.requestFocusInWindow();
    }

    private void navigateDown(CollapsiblePanel current) {
        int index = this.navPanels.indexOf(current);
        if (index < 0) {
            index = -1;
        }
        while (++index < this.navPanels.size()) {
            if (!this.navPanels.get(index).isShowing()) continue;
            this.navPanels.get(index).getHeader().requestFocusInWindow();
            return;
        }
        this.bottomPanelHead.requestFocusInWindow();
    }

    private void addNavigationActions(CollapsiblePanel cPanel) {
        this.navPanels.add(cPanel);
        this.addNavigationHelper(cPanel, cPanel, cPanel.getHeader());
    }

    private void addNavigationHelper(final CollapsiblePanel navigationKey, JPanel panel, final JComponent header) {
        panel.getInputMap(1).put(KeyStroke.getKeyStroke("shift F6"), "focusCurrentSegment");
        panel.getActionMap().put("focusCurrentSegment", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                header.requestFocusInWindow();
            }
        });
        header.getInputMap(0).put(KeyStroke.getKeyStroke("shift F6"), "focusPreviousSegment");
        header.getActionMap().put("focusPreviousSegment", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CdiPanel.this.navigateUp(navigationKey);
            }
        });
        panel.getInputMap(1).put(KeyStroke.getKeyStroke("F6"), "focusNextSegment");
        panel.getActionMap().put("focusNextSegment", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CdiPanel.this.navigateDown(navigationKey);
            }
        });
    }

    void createLoadingPane() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setAlignmentX(0.0f);
        p.setAlignmentY(0.0f);
        p.setBorder(BorderFactory.createTitledBorder("Loading"));
        this.loadingText = new JLabel(this.rep.getStatus());
        this.loadingText.setPreferredSize(new Dimension(400, 20));
        this.loadingText.setMinimumSize(new Dimension(400, 20));
        this.loadingText.setAlignmentX(0.0f);
        p.add(this.loadingText);
        this.reloadButton = new JButton("Re-try");
        this.reloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CdiPanel.this.rep.restartIfNeeded();
            }
        });
        this.reloadButton.setAlignmentX(0.0f);
        this.reloadButton.setAlignmentY(0.0f);
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout());
        p1.add(this.reloadButton);
        p.add(p1);
        this.loadingPanel = p;
    }

    JPanel createIdentificationPane(CdiRep c) {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setAlignmentX(0.0f);
        p.setAlignmentY(0.0f);
        CdiRep.Identification id = c.getIdentification();
        JPanel p1 = new JPanel();
        p.add(p1);
        p1.setLayout(new GridLayout2(5, 2));
        p1.setAlignmentX(0.0f);
        p1.add(new JLabel("Manufacturer: "));
        p1.add(new JLabel(id.getManufacturer()));
        p1.add(new JLabel("Model: "));
        p1.add(new JLabel(id.getModel()));
        p1.add(new JLabel("Hardware Version: "));
        p1.add(new JLabel(id.getHardwareVersion()));
        p1.add(new JLabel("Software Version: "));
        p1.add(new JLabel(id.getSoftwareVersion()));
        if (id.getLinkText() != null && id.getLinkURL() != null) {
            p1.add(new HtmlLabel(id.getLinkText(), id.getLinkURL()));
        }
        p1.setMaximumSize(p1.getPreferredSize());
        JPanel p2 = this.createPropertyPane(id.getMap());
        if (p2 != null) {
            p2.setAlignmentX(0.0f);
            p.add(p2);
        }
        CollapsiblePanel ret = new CollapsiblePanel("Identification", p);
        this.segmentPanels.add(ret);
        this.addNavigationActions(ret);
        ret.setAlignmentY(0.0f);
        ret.setAlignmentX(0.0f);
        return ret;
    }

    JPanel createPropertyPane(CdiRep.Map map) {
        if (map != null) {
            JPanel p2 = new JPanel();
            p2.setAlignmentX(0.0f);
            p2.setBorder(BorderFactory.createTitledBorder("Properties"));
            List<String> keys = map.getKeys();
            if (keys.isEmpty()) {
                return null;
            }
            p2.setLayout(new GridLayout2(keys.size(), 2));
            for (int i = 0; i < keys.size(); ++i) {
                String key = keys.get(i);
                p2.add(new JLabel(key + ": "));
                p2.add(new JLabel(map.getEntry(key)));
            }
            p2.setMaximumSize(p2.getPreferredSize());
            return p2;
        }
        return null;
    }

    void createDescriptionPane(JPanel parent, String d) {
        if (d == null) {
            return;
        }
        if (d.trim().length() == 0) {
            return;
        }
        JTextArea area = new JTextArea(d){

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(Integer.MAX_VALUE, this.getPreferredSize().height);
            }
        };
        area.setAlignmentX(0.0f);
        area.setFont(UIManager.getFont("TextArea.font"));
        area.setEditable(false);
        area.setOpaque(false);
        area.setWrapStyleWord(true);
        area.setLineWrap(true);
        parent.add(area);
    }

    void createLinkPane(JPanel parent, String text, String ref) {
        if (text == null || ref == null) {
            return;
        }
        parent.add(new HtmlLabel(text, ref));
    }

    private void addCopyPasteButtons(JPanel linePanel, final JTextComponent textField) {
        final JButton b = new JButton("Copy");
        final Color defaultColor = b.getBackground();
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String s = textField.getText();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        textField.selectAll();
                    }
                });
                StringSelection eventToCopy = new StringSelection(s);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(eventToCopy, new ClipboardOwner(){

                    @Override
                    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
                        b.setBackground(defaultColor);
                        b.setText("Copy");
                    }
                });
                b.setBackground(COLOR_COPIED);
                b.setText("Copied");
            }
        });
        linePanel.add(b);
        JButton bb = new JButton("Paste");
        bb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                DataFlavor dataFlavor = DataFlavor.stringFlavor;
                Object text = null;
                try {
                    text = systemClipboard.getData(dataFlavor);
                }
                catch (UnsupportedFlavorException | IOException e1) {
                    return;
                }
                String pasteValue = (String)text;
                if (pasteValue != null) {
                    textField.setText(pasteValue);
                }
            }
        });
        linePanel.add(bb);
    }

    static {
        int size = 12;
        Font defaultTabbedFont = UIManager.getFont("TabbedPane.font");
        if (defaultTabbedFont != null) {
            size = defaultTabbedFont.getSize();
        } else {
            logger.log(Level.WARNING, "Did not find default TabbedPane font, please report this.");
        }
        tabFont = new Font("Dialog", 0, size);
        fileNameGenerator = new FileNameGenerator();
    }

    private class SearchPane
    extends JPanel {
        JPanel parent = null;
        JTextField textField;
        JTextComponent outputField;
        JPopupMenu suggestMenu = null;

        SearchPane() {
            this.setLayout(new BoxLayout(this, 0));
            this.setAlignmentX(0.0f);
            this.textField = new JTextField(32);
            this.textField.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.textField.getPreferredSize().height));
            this.textField.setToolTipText("Enter the description of an event here to help pasting the event ID.");
            this.textField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    SearchPane.this.textUpdated();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    SearchPane.this.textUpdated();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    SearchPane.this.textUpdated();
                }
            });
            this.textField.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                }

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 27) {
                        SearchPane.this.cancelSearch();
                    } else if (keyEvent.getKeyCode() == 40 && SearchPane.this.suggestMenu != null && SearchPane.this.suggestMenu.isVisible()) {
                        SearchPane.this.suggestMenu.setVisible(false);
                        SearchPane.this.suggestMenu.setFocusable(true);
                        SearchPane.this.suggestMenu.getSelectionModel().setSelectedIndex(0);
                        SearchPane.this.suggestMenu.show(SearchPane.this.textField, 0, SearchPane.this.textField.getHeight());
                        Timer t = new Timer(100, new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                try {
                                    Robot r = new Robot();
                                    r.keyPress(40);
                                    r.keyRelease(40);
                                }
                                catch (AWTException aWTException) {
                                    // empty catch block
                                }
                            }
                        });
                        t.setRepeats(false);
                        t.start();
                        keyEvent.consume();
                    }
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                }
            });
        }

        private void textUpdated() {
            if (this.parent == null) {
                return;
            }
            String searchQuery = this.textField.getText();
            logger.log(Level.FINE, String.format("Search for: %s", searchQuery));
            boolean fresh = false;
            if (this.suggestMenu == null) {
                this.suggestMenu = new JPopupMenu();
                fresh = true;
            }
            long startTime = System.nanoTime();
            List<EventTable.EventTableEntry> results = CdiPanel.this.eventTable.searchForEvent(searchQuery, 8);
            long timelen = System.nanoTime() - startTime;
            logger.log(Level.FINE, String.format("Search took %.2f msec", (double)timelen * 1.0 / 1000000.0));
            this.suggestMenu.removeAll();
            for (final EventTable.EventTableEntry result : results) {
                AbstractAction a = new AbstractAction(result.getDescription()){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        String r = Utilities.toHexDotsString(result.getEvent().getContents());
                        SearchPane.this.outputField.setText(r);
                        SearchPane.this.cancelSearch();
                    }
                };
                this.suggestMenu.add(a);
            }
            if (results.isEmpty()) {
                this.suggestMenu.add("No matches.");
            }
            this.suggestMenu.setFocusable(false);
            if (!fresh) {
                this.suggestMenu.revalidate();
                this.suggestMenu.pack();
                this.suggestMenu.repaint();
            }
            this.suggestMenu.show(this.textField, 0, this.textField.getHeight());
        }

        private void cancelSearch() {
            logger.log(Level.FINE, "Removing search box");
            if (this.suggestMenu != null) {
                this.suggestMenu.setVisible(false);
            }
            if (this.parent != null) {
                this.parent.remove(this.textField);
                this.parent.revalidate();
                this.parent.repaint();
                this.parent = null;
            }
        }

        void attachParent(JPanel parentPane, JTextComponent output) {
            if (this.parent != null) {
                this.cancelSearch();
            }
            this.textField.setText("");
            parentPane.add(this.textField);
            this.parent = parentPane;
            this.outputField = output;
            parentPane.revalidate();
            this.textField.requestFocusInWindow();
        }
    }

    public static class GuiItemFactory {
        public JButton handleReadButton(JButton button) {
            return button;
        }

        public JButton handleWriteButton(JButton button) {
            return button;
        }

        public JButton handleEventidMoreButton(JButton button) {
            return button;
        }

        public JButton handleProduceButton(JButton button) {
            return button;
        }

        public void makeSensor(String ev, String mdesc) {
        }

        public void handleGroupPaneStart(JPanel pane) {
        }

        public void handleGroupPaneEnd(JPanel pane) {
        }

        public JTextComponent handleEventIdTextField(EventIdTextField field) {
            return field;
        }

        public JTextField handleStringValue(JTextField value) {
            return value;
        }

        public JTextArea handleEditorValue(JTextArea value) {
            return value;
        }
    }

    private abstract class EntryPane
    extends JPanel {
        protected final CdiRep.Item item;
        protected JComponent textComponent;
        private ConfigRepresentation.CdiEntry entry;
        PropertyChangeListener entryListener = null;
        JButton writeButton;
        boolean dirty = false;
        JPanel p3;

        EntryPane(ConfigRepresentation.CdiEntry e, String defaultName) {
            this.item = e.getCdiItem();
            this.entry = e;
            this.setLayout(new BoxLayout(this, 1));
            this.setAlignmentX(0.0f);
            String name = this.item.getName() != null ? this.item.getName() : defaultName;
            this.setBorder(BorderFactory.createTitledBorder(name));
            CdiPanel.this.createDescriptionPane(this, this.item.getDescription());
            this.p3 = new JPanel();
            this.p3.setAlignmentX(0.0f);
            this.p3.setLayout(new BoxLayout(this.p3, 0));
            this.add(this.p3);
        }

        void release() {
            if (this.entryListener != null) {
                this.entry.removePropertyChangeListener(this.entryListener);
            }
        }

        protected void additionalButtons() {
        }

        protected void init() {
            JPanel subpanel = null;
            if (this.textComponent instanceof JTextArea) {
                subpanel = new JPanel();
                subpanel.setLayout(new FlowLayout());
                JLabel lengthLabel = new JLabel("Remaining characters: ");
                subpanel.add(lengthLabel);
                final JTextField countField = new JTextField(6);
                countField.setText("" + (this.entry.size - 1));
                subpanel.add(countField);
                lengthLabel.setFont(CdiPanel.this.countAreaFont);
                countField.setFont(CdiPanel.this.countAreaFont);
                JPanel combinedPanel = new JPanel();
                combinedPanel.setLayout(new BoxLayout(combinedPanel, 1));
                JScrollPane spane = new JScrollPane(this.textComponent){

                    @Override
                    public Dimension getMinimumSize() {
                        Dimension superSize = super.getMinimumSize();
                        int width = superSize.width;
                        int height = Math.max(superSize.height, 50);
                        return new Dimension(width, height);
                    }

                    @Override
                    public Dimension getPreferredSize() {
                        Dimension superMin = super.getMinimumSize();
                        Dimension superPref = super.getPreferredSize();
                        int width = Math.max(superMin.width, superPref.width);
                        int height = Math.max(superMin.height, superPref.height);
                        return new Dimension(width, height);
                    }

                    @Override
                    public Dimension getMaximumSize() {
                        Dimension superMax = super.getMaximumSize();
                        Dimension superPref = super.getPreferredSize();
                        int width = Math.max(superMax.width, superPref.width);
                        int height = Math.max(superMax.height, superPref.height);
                        return new Dimension(width, height);
                    }
                };
                spane.setVerticalScrollBarPolicy(22);
                combinedPanel.add(spane);
                combinedPanel.add(subpanel);
                this.p3.add(combinedPanel);
                ((JTextArea)this.textComponent).getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void insertUpdate(DocumentEvent documentEvent) {
                        this.updateLength();
                    }

                    @Override
                    public void removeUpdate(DocumentEvent documentEvent) {
                        this.updateLength();
                    }

                    @Override
                    public void changedUpdate(DocumentEvent documentEvent) {
                        this.updateLength();
                    }

                    private void updateLength() {
                        countField.setText("" + (((EntryPane)EntryPane.this).entry.size - 1 - ((JTextArea)EntryPane.this.textComponent).getText().length()));
                    }
                });
            } else {
                this.p3.add(this.textComponent);
            }
            this.textComponent.setMaximumSize(this.textComponent.getPreferredSize());
            if (this.textComponent instanceof JTextComponent) {
                ((JTextComponent)this.textComponent).getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void insertUpdate(DocumentEvent documentEvent) {
                        this.drawRed();
                    }

                    @Override
                    public void removeUpdate(DocumentEvent documentEvent) {
                        this.drawRed();
                    }

                    @Override
                    public void changedUpdate(DocumentEvent documentEvent) {
                        this.drawRed();
                    }

                    private void drawRed() {
                        EntryPane.this.updateColor();
                    }
                });
            }
            this.entryListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("UPDATE_ENTRY_DATA")) {
                        String v = ((EntryPane)EntryPane.this).entry.lastVisibleValue;
                        if (v == null) {
                            v = "";
                        }
                        EntryPane.this.updateDisplayText(v);
                        EntryPane.this.updateColor();
                    } else if (propertyChangeEvent.getPropertyName().equals("PENDING_WRITE_COMPLETE")) {
                        EntryPane.this.updateColor();
                    }
                }
            };
            this.entry.addPropertyChangeListener(this.entryListener);
            CdiPanel.this.cleanupTasks.add(new Runnable(){

                @Override
                public void run() {
                    EntryPane.this.entry.removePropertyChangeListener(EntryPane.this.entryListener);
                }
            });
            this.entry.fireUpdate();
            if (!(this.textComponent instanceof JButton) && !(this.textComponent instanceof JLabel)) {
                JButton b = CdiPanel.this.factory.handleReadButton(new JButton("Refresh"));
                b.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        EntryPane.this.entry.reload();
                    }
                });
                if (subpanel != null) {
                    subpanel.add(b);
                } else {
                    this.p3.add(b);
                }
                if (!this.entry.isFlaggedReadOnly()) {
                    this.writeButton = CdiPanel.this.factory.handleWriteButton(new JButton("Write"));
                    this.writeButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            EntryPane.this.writeDisplayTextToNode();
                        }
                    });
                    if (subpanel != null) {
                        subpanel.add(this.writeButton);
                    } else {
                        this.p3.add(this.writeButton);
                    }
                }
            }
            this.additionalButtons();
            this.p3.add(Box.createHorizontalGlue());
        }

        void updateColor() {
            if (this.entry.lastVisibleValue == null) {
                this.textComponent.setBackground(COLOR_UNFILLED);
                return;
            }
            String v = this.getDisplayText();
            boolean oldDirty = this.dirty;
            if (this.isDataInvalid()) {
                this.textComponent.setBackground(COLOR_INVALID);
                this.dirty = true;
                CdiPanel.this.setSaveInvalid();
            } else if (v.equals(this.entry.lastVisibleValue)) {
                this.textComponent.setBackground(COLOR_WRITTEN);
                this.dirty = false;
            } else {
                this.textComponent.setBackground(COLOR_EDITED);
                this.dirty = true;
                CdiPanel.this.setSaveDirty();
            }
            CdiPanel.this.notifyTabColorRefresh();
            this.updateWriteButton();
        }

        void updateWriteButton() {
        }

        boolean isDataInvalid() {
            return false;
        }

        boolean isDirty() {
            return this.dirty;
        }

        protected abstract void writeDisplayTextToNode();

        protected abstract void updateDisplayText(@NonNull String var1);

        @NonNull
        protected abstract String getDisplayText();

        @NonNull
        protected String getCurrentValue() {
            return this.getDisplayText();
        }
    }

    public static class FileNameGenerator {
        public String generateFileName(ConfigRepresentation rep, String nodeName) {
            String fileName = rep.getRemoteNodeAsString();
            if (!nodeName.isEmpty()) {
                fileName = fileName + "-" + nodeName;
            }
            if (rep.getCdiRep() != null && rep.getCdiRep().getIdentification() != null) {
                fileName = fileName + "-" + rep.getCdiRep().getIdentification().getSoftwareVersion();
            }
            fileName = fileName + "-" + LocalDate.now();
            fileName = fileName + "-" + LocalTime.now().format(DateTimeFormatter.ofPattern("HH-mm-ss"));
            fileName = fileName.replace(" ", "_");
            return "config." + fileName + ".txt";
        }
    }

    private class GetEntryNameVisitor
    extends ConfigRepresentation.Visitor {
        CdiRep.Item item;
        int segNum = 1;
        String segName = null;
        String groupName = null;
        String groupRepName = null;
        String entryName = null;
        String fullName = null;
        boolean done = false;

        GetEntryNameVisitor(EntryPane ep) {
            this.item = ep.item;
        }

        @Override
        public void visitSegment(ConfigRepresentation.SegmentEntry e) {
            if (!this.done) {
                this.groupName = null;
                this.groupRepName = null;
                this.segName = e.segment.getName();
                ++this.segNum;
                this.visitContainer(e);
            }
        }

        @Override
        public void visitGroupRep(ConfigRepresentation.GroupRep e) {
            if (!this.done) {
                this.groupRepName = e.group.getName() + e.index;
                this.visitContainer(e);
            }
        }

        @Override
        public void visitGroup(ConfigRepresentation.GroupEntry e) {
            if (!this.done) {
                this.groupName = e.group.getName();
                this.visitContainer(e);
            }
        }

        @Override
        public void visitLeaf(ConfigRepresentation.CdiEntry e) {
            if (!this.done && this.item.equals(e.getCdiItem())) {
                this.entryName = e.getCdiItem().getName();
                StringBuilder sb = new StringBuilder();
                sb.append("Item \"");
                sb.append(this.entryName);
                sb.append("\"");
                if (this.groupRepName == null) {
                    this.groupRepName = this.groupName;
                } else if (this.groupName != null) {
                    sb.append(" in ");
                    sb.append(this.groupName);
                }
                if (this.groupRepName != null) {
                    sb.append(" of group \"");
                    sb.append(this.groupRepName);
                    sb.append("\"");
                }
                sb.append(" in segment ");
                if (this.segName == null || this.segName.isEmpty()) {
                    sb.append("#");
                    sb.append(this.segNum);
                } else {
                    sb.append(this.segName);
                }
                this.fullName = sb.toString();
                this.done = true;
            }
        }

        String getName() {
            if (this.fullName == null) {
                return "NotFound";
            }
            return this.fullName;
        }
    }

    class HtmlLabel
    extends JTextPane {
        public HtmlLabel(String text, String ref) {
            this.setContentType("text/html");
            String content = "<html><a href=\"" + ref + "\">" + text + "</a></html>";
            this.setText(content);
            this.setAlignmentX(0.0f);
            this.setFont(UIManager.getFont("TextArea.font"));
            this.setEditable(false);
            this.setOpaque(false);
            this.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    try {
                        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && Desktop.isDesktopSupported()) {
                            Desktop.getDesktop().browse(e.getURL().toURI());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    private class ActionButtonPane
    extends EntryPane {
        JButton actionButton;
        private final ConfigRepresentation.ActionButtonEntry entry;

        ActionButtonPane(ConfigRepresentation.ActionButtonEntry e) {
            super(e, "Action");
            this.entry = e;
            this.actionButton = new JButton(e.rep.getButtonText());
            this.textComponent = this.actionButton;
            this.textComponent.setToolTipText("Writes to node when pressed.");
            this.actionButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActionButtonPane.this.writeDisplayTextToNode();
                }
            });
            this.init();
        }

        @Override
        protected void writeDisplayTextToNode() {
            if (this.entry.rep.getDialogText() == null || this.entry.rep.getDialogText().isEmpty()) {
                this.entry.setValue(this.entry.rep.getValue());
                CdiPanel.this._changeMade = true;
                CdiPanel.this.notifyTabColorRefresh();
            } else {
                int result = JOptionPane.showConfirmDialog(null, this.entry.rep.getDialogText(), "", 2);
                if (result == 0) {
                    this.entry.setValue(this.entry.rep.getValue());
                    CdiPanel.this._changeMade = true;
                    CdiPanel.this.notifyTabColorRefresh();
                }
            }
        }

        @Override
        protected void updateDisplayText(@NonNull String value) {
        }

        @Override
        @NonNull
        protected String getDisplayText() {
            return this.entry.rep.getButtonText();
        }
    }

    private class UnknownPane
    extends EntryPane {
        private final ConfigRepresentation.UnknownEntry entry;

        UnknownPane(ConfigRepresentation.UnknownEntry e) {
            super(e, "Unknown");
            this.entry = e;
            this.textComponent = new JLabel("Unknown Entry in the CDI Information");
            this.textComponent.setToolTipText("Unknown element, perhaps from a later version of the CDI format?");
            this.init();
        }

        @Override
        protected void writeDisplayTextToNode() {
        }

        @Override
        protected void updateDisplayText(@NonNull String value) {
        }

        @Override
        @NonNull
        protected String getDisplayText() {
            return "Unknown Element";
        }
    }

    private class StringPane
    extends EntryPane {
        JTextComponent textField;
        private final ConfigRepresentation.StringEntry entry;

        StringPane(ConfigRepresentation.StringEntry e) {
            super(e, "String");
            this.entry = e;
            PlainDocument doc = new PlainDocument(){

                @Override
                public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
                    if (this.getLength() + str.length() > ((StringPane)StringPane.this).entry.size - 1) {
                        Toolkit.getDefaultToolkit().beep();
                    } else {
                        super.insertString(offset, str, a);
                    }
                }
            };
            if (this.entry.size <= 64) {
                JTextField jtf = new JTextField(doc, "", this.entry.size - 1){

                    @Override
                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }
                };
                jtf.setFont(CdiPanel.this.textAreaFont);
                jtf = CdiPanel.this.factory.handleStringValue(jtf);
                jtf.getDocument().putProperty("filterNewlines", Boolean.FALSE);
                this.textField = jtf;
            } else {
                JTextArea jta = new JTextArea(doc, "", Math.min(40, this.entry.size / 32), 80);
                jta.setEditable(true);
                jta.setLineWrap(true);
                jta.setWrapStyleWord(true);
                jta.setFont(CdiPanel.this.textAreaFont);
                jta = CdiPanel.this.factory.handleEditorValue(jta);
                this.textField = jta;
            }
            this.textComponent = this.textField;
            this.textComponent.setToolTipText("String of up to " + (this.entry.size - 1) + " characters");
            this.init();
            if (e.isFlaggedReadOnly()) {
                this.textComponent.setEnabled(false);
            }
        }

        @Override
        protected void writeDisplayTextToNode() {
            this.entry.setValue(this.textField.getText());
            CdiPanel.this._changeMade = true;
            CdiPanel.this.notifyTabColorRefresh();
        }

        @Override
        protected void updateDisplayText(@NonNull String value) {
            this.textField.setText(value);
        }

        @Override
        @NonNull
        protected String getDisplayText() {
            String s = this.textField.getText();
            return s == null ? "" : s;
        }
    }

    private class FloatPane
    extends EntryPane {
        JTextField textField;
        private final ConfigRepresentation.FloatEntry entry;

        FloatPane(ConfigRepresentation.FloatEntry e) {
            super(e, "Float");
            this.textField = null;
            this.entry = e;
            this.textField = new JTextField(24){

                @Override
                public Dimension getMaximumSize() {
                    return this.getPreferredSize();
                }
            };
            this.textComponent = this.textField;
            this.textField.setToolTipText("Float from " + this.entry.rep.getMin() + " to " + this.entry.rep.getMax() + " (" + this.entry.size + " bytes)");
            this.init();
            if (e.isFlaggedReadOnly()) {
                this.textComponent.setEnabled(false);
            }
        }

        @Override
        protected void writeDisplayTextToNode() {
            double value = Double.parseDouble(this.textField.getText());
            this.entry.setValue(value);
            CdiPanel.this._changeMade = true;
            CdiPanel.this.notifyTabColorRefresh();
        }

        @Override
        protected void updateDisplayText(@NonNull String value) {
            this.textField.setText(value);
        }

        @Override
        @NonNull
        protected String getDisplayText() {
            String s = this.textField.getText();
            return s == null ? "" : s;
        }

        @Override
        @NonNull
        protected String getCurrentValue() {
            String s = this.textField.getText();
            return s == null ? "" : s;
        }

        @Override
        boolean isDataInvalid() {
            try {
                double value = Double.valueOf(this.getCurrentValue());
                return !(value >= this.entry.rep.getMin()) || !(value <= this.entry.rep.getMax());
            }
            catch (NumberFormatException ex) {
                return true;
            }
        }

        @Override
        void updateWriteButton() {
            if (this.writeButton == null) {
                return;
            }
            this.writeButton.setEnabled(!this.isDataInvalid());
        }
    }

    private class IntPane
    extends EntryPane {
        JTextField textField;
        JComboBox<String> box;
        SliderWithView sliderView;
        RadioButtonPane radiobuttons;
        CdiRep.Map map;
        private final ConfigRepresentation.IntegerEntry entry;
        boolean suppressExternal;
        boolean suppressInternal;

        IntPane(ConfigRepresentation.IntegerEntry e) {
            super(e, "Integer");
            this.textField = null;
            this.box = null;
            this.sliderView = null;
            this.radiobuttons = null;
            this.map = null;
            this.suppressExternal = false;
            this.suppressInternal = false;
            this.entry = e;
            this.map = this.item.getMap();
            if (this.map != null && this.map.getKeys().size() > 0) {
                if (this.entry.rep.isRadioButtonHint()) {
                    ActionListener action = new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            IntPane.this.updateColor();
                        }
                    };
                    this.radiobuttons = new RadioButtonPane(this.map, action);
                    this.textComponent = this.radiobuttons;
                } else {
                    this.box = new JComboBox(this.map.getValues().toArray(new String[]{""})){

                        @Override
                        public Dimension getMaximumSize() {
                            return this.getPreferredSize();
                        }
                    };
                    this.box.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            IntPane.this.updateColor();
                        }
                    });
                    this.textComponent = this.box;
                }
            } else if (this.entry.rep.isSliderHint()) {
                this.sliderView = new SliderWithView((int)this.entry.rep.getMin(), (int)this.entry.rep.getMax(), this.entry.rep.isSliderShowValue(), this.entry.size);
                if (this.entry.rep.getSliderTickSpacing() > 0) {
                    this.sliderView.slider.setMajorTickSpacing(this.entry.rep.getSliderTickSpacing());
                    this.sliderView.slider.setLabelTable(this.sliderView.slider.createStandardLabels(this.entry.rep.getSliderTickSpacing()));
                    this.sliderView.slider.setPaintTicks(true);
                    this.sliderView.slider.setPaintLabels(true);
                }
                if (this.entry.rep.isSliderImmediate()) {
                    this.sliderView.slider.addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent e) {
                            if (!(IntPane.this.sliderView.slider.getValueIsAdjusting() || IntPane.this.suppressInternal || IntPane.this.suppressExternal)) {
                                IntPane.this.writeDisplayTextToNode();
                            }
                            IntPane.this.suppressExternal = false;
                            IntPane.this.suppressInternal = false;
                        }
                    });
                }
                this.sliderView.slider.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        IntPane.this.updateColor();
                    }
                });
                this.textComponent = this.sliderView;
                if (this.entry.rep.getMin() < 0L) {
                    this.sliderView.setToolTipText("Signed integer from " + this.entry.rep.getMin() + " to " + this.entry.rep.getMax() + " (" + this.entry.size + " bytes)");
                } else {
                    this.sliderView.setToolTipText("Unsigned integer from " + this.entry.rep.getMin() + " to " + this.entry.rep.getMax() + " (" + this.entry.size + " bytes)");
                }
            } else {
                this.textField = new JTextField(24){

                    @Override
                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }
                };
                this.textComponent = this.textField;
                if (this.entry.rep.getMin() < 0L) {
                    this.textField.setToolTipText("Signed integer from " + this.entry.rep.getMin() + " to " + this.entry.rep.getMax() + " (" + this.entry.size + " bytes)");
                } else {
                    this.textField.setToolTipText("Unsigned integer from " + this.entry.rep.getMin() + " to " + this.entry.rep.getMax() + " (" + this.entry.size + " bytes)");
                }
            }
            this.init();
            if (e.isFlaggedReadOnly()) {
                this.textComponent.setEnabled(false);
            }
        }

        @Override
        protected void writeDisplayTextToNode() {
            long value;
            if (this.textField != null) {
                value = Long.parseLong(this.textField.getText());
            } else if (this.sliderView != null) {
                this.suppressInternal = true;
                value = this.sliderView.slider.getValue();
            } else if (this.radiobuttons != null) {
                value = this.radiobuttons.getCurrentValue();
            } else {
                String entry = (String)this.box.getSelectedItem();
                String key = this.map.getKey(entry);
                value = Long.parseLong(key);
            }
            this.suppressExternal = true;
            this.entry.setValue(value);
            CdiPanel.this._changeMade = true;
            CdiPanel.this.notifyTabColorRefresh();
        }

        @Override
        protected void updateDisplayText(@NonNull String value) {
            if (this.textField != null) {
                this.textField.setText(value);
            }
            if (this.sliderView != null) {
                this.suppressInternal = true;
                this.sliderView.slider.setValue(Integer.parseInt(value));
            } else if (this.radiobuttons != null) {
                this.radiobuttons.setCurrentValue(value);
            }
            if (this.box != null) {
                this.box.setSelectedItem(value);
                if (!this.box.getSelectedItem().equals(value)) {
                    String newValue = "Reserved value: " + value;
                    ComboBoxModel<String> model = this.box.getModel();
                    int size = model.getSize();
                    boolean absent = true;
                    for (int i = 0; i < size; ++i) {
                        String element = (String)model.getElementAt(i);
                        if (newValue != element) continue;
                        absent = false;
                    }
                    if (absent) {
                        this.box.addItem(newValue);
                        this.map.addItemToMap(value, newValue);
                    }
                    this.box.setSelectedItem(newValue);
                }
            }
        }

        @Override
        @NonNull
        protected String getDisplayText() {
            if (this.sliderView != null) {
                return "" + this.sliderView.slider.getValue();
            }
            if (this.radiobuttons != null) {
                return this.radiobuttons.getDisplayText();
            }
            String s = this.box == null ? this.textField.getText() : (String)this.box.getSelectedItem();
            return s == null ? "" : s;
        }

        @Override
        @NonNull
        protected String getCurrentValue() {
            String s;
            if (this.sliderView != null) {
                return "" + this.sliderView.slider.getValue();
            }
            if (this.radiobuttons != null) {
                return this.radiobuttons.getCurrentValueString();
            }
            if (this.box == null) {
                s = this.textField.getText();
            } else {
                String entry = (String)this.box.getSelectedItem();
                s = this.map.getKey(entry);
            }
            return s == null ? "" : s;
        }

        @Override
        boolean isDataInvalid() {
            try {
                int value = Integer.valueOf(this.getCurrentValue());
                return (long)value < this.entry.rep.getMin() || (long)value > this.entry.rep.getMax();
            }
            catch (NumberFormatException ex) {
                return true;
            }
        }

        @Override
        void updateWriteButton() {
            if (this.writeButton == null) {
                return;
            }
            this.writeButton.setEnabled(!this.isDataInvalid());
        }
    }

    private class RadioButtonPane
    extends JPanel {
        CdiRep.Map map;
        ButtonGroup group = new ButtonGroup();

        RadioButtonPane(CdiRep.Map map, ActionListener action) {
            this.map = map;
            this.setLayout(new BoxLayout(this, 1));
            for (String v : map.getValues()) {
                JRadioButton button = new JRadioButton(v);
                button.setActionCommand(v);
                this.add(button);
                button.addActionListener(action);
                this.group.add(button);
            }
        }

        long getCurrentValue() {
            return Long.parseLong(this.getCurrentValueString());
        }

        void setCurrentValue(String value) {
            String key = this.map.getKey(value);
            Enumeration<AbstractButton> e = this.group.getElements();
            while (e.hasMoreElements()) {
                AbstractButton b = e.nextElement();
                if (!b.getActionCommand().equals(value)) continue;
                b.setSelected(true);
                return;
            }
            logger.log(Level.WARNING, "Value \"" + value + "\" does not match a button value, taking 1st button");
            this.group.clearSelection();
        }

        String getCurrentValueString() {
            String value = this.getDisplayText();
            if (this.map.getKey(value) != null) {
                return this.map.getKey(value);
            }
            logger.severe("Value \"" + value + "\" does not match a button name");
            return this.map.getKeys().get(0);
        }

        String getDisplayText() {
            if (this.group.getSelection() == null) {
                return this.map.getValues().get(0);
            }
            return this.group.getSelection().getActionCommand();
        }
    }

    private class SliderWithView
    extends JPanel {
        JSlider slider = null;
        JTextField textField = null;

        SliderWithView(int min, int max, boolean showValue, int size) {
            this.setLayout(new FlowLayout());
            this.slider = new JSlider(min, max);
            this.slider.setOpaque(true);
            if (min < 0) {
                this.slider.setToolTipText("Signed integer from " + min + " to " + max + " (" + size + " bytes)");
            } else {
                this.slider.setToolTipText("Unsigned integer from " + min + " to " + max + " (" + size + " bytes)");
            }
            this.add(this.slider);
            if (showValue) {
                this.textField = new JTextField(2 + (int)Math.log10(Math.max(1.0, (double)Math.abs(max)))){

                    @Override
                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }
                };
                this.textField.setOpaque(true);
                if (min < 0) {
                    this.textField.setToolTipText("Signed integer from " + min + " to " + max + " (" + size + " bytes)");
                } else {
                    this.textField.setToolTipText("Unsigned integer from " + min + " to " + max + " (" + size + " bytes)");
                }
                this.slider.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        SliderWithView.this.textField.setText("" + SliderWithView.this.slider.getValue());
                    }
                });
                this.textField.addFocusListener(new FocusListener(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        SliderWithView.this.textToSlider();
                    }

                    @Override
                    public void focusGained(FocusEvent e) {
                    }
                });
                this.textField.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyReleased(KeyEvent ke) {
                        if (ke.getKeyCode() == 10) {
                            SliderWithView.this.textToSlider();
                        }
                    }
                });
                this.add(this.textField);
            }
        }

        @Override
        public void setBackground(Color color) {
            if (this.slider != null) {
                this.slider.setBackground(color);
            }
            if (this.textField != null) {
                this.textField.setBackground(color);
            }
        }

        @Override
        public void setEnabled(boolean state) {
            super.setEnabled(state);
            if (this.slider != null) {
                this.slider.setEnabled(state);
            }
            if (this.textField != null) {
                this.textField.setEnabled(state);
            }
        }

        void textToSlider() {
            try {
                int current = (int)Double.parseDouble(this.textField.getText().trim());
                this.slider.setValue(current);
            }
            catch (NumberFormatException e) {
                this.textField.setText("" + this.slider.getValue());
            }
        }
    }

    private class EventIdPane
    extends EntryPane {
        private final ConfigRepresentation.EventEntry entry;
        JTextComponent textField;
        JLabel eventNamesLabel;
        EventTable.EventTableEntryHolder eventTableEntryHolder;
        String lastEventText;
        PropertyChangeListener eventListUpdateListener;
        Map<String, String> parentVisibleKeys;
        JPopupMenu eventidMoreMenu;
        JButton eventidMoreButton;

        EventIdPane(ConfigRepresentation.EventEntry e) {
            super(e, "EventID");
            this.eventNamesLabel = null;
            this.eventTableEntryHolder = null;
            this.parentVisibleKeys = new TreeMap(Collections.reverseOrder());
            this.eventidMoreMenu = new JPopupMenu();
            this.entry = e;
            this.textField = CdiPanel.this.factory.handleEventIdTextField(EventIdTextField.getEventIdTextField());
            this.textComponent = this.textField;
            if (CdiPanel.this.eventTable != null) {
                this.eventNamesLabel = new JLabel();
                this.eventNamesLabel.setFont(UIManager.getFont("TextArea.font"));
                this.eventNamesLabel.setVisible(false);
                this.eventListUpdateListener = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if (propertyChangeEvent.getPropertyName().equals("UPDATED_EVENT_LIST")) {
                            EventIdPane.this.updateEventDescriptionField((EventTable.EventInfo)propertyChangeEvent.getNewValue());
                        }
                    }
                };
                CdiPanel.this.cleanupTasks.add(() -> this.releaseListener());
            }
            this.init();
            if (CdiPanel.this.eventTable != null) {
                this.add(this.eventNamesLabel);
            }
            if (e.isFlaggedReadOnly()) {
                this.textComponent.setEnabled(false);
            }
        }

        private void updateEventDescriptionField(EventTable.EventInfo eventInfo) {
            EventTable.EventTableEntry[] elist = eventInfo.getAllEntries();
            StringBuilder b = new StringBuilder();
            b.append("<html><body>");
            boolean first = true;
            for (EventTable.EventTableEntry ee : elist) {
                if (ee.isOwnedBy(this.eventTableEntryHolder)) continue;
                if (first) {
                    b.append("Other uses of this Event ID:<br>");
                    first = false;
                } else {
                    b.append("<br>");
                }
                b.append(ee.getDescription());
            }
            b.append("</body></html>");
            if (first) {
                this.eventNamesLabel.setVisible(false);
            } else {
                this.eventNamesLabel.setText(b.toString());
                this.eventNamesLabel.setVisible(true);
            }
        }

        void updateOwnEventName() {
            if (this.eventTableEntryHolder == null) {
                return;
            }
            this.eventTableEntryHolder.getEntry().updateDescription(this.getEventName());
        }

        private String getEventName() {
            StringBuilder b = new StringBuilder(this.entry.key);
            this.parentVisibleKeys.forEach((k, v) -> {
                if (v.trim().length() > 0) {
                    b.insert(k.length() - 1, "," + v);
                }
            });
            Matcher m = segmentPrefixRe.matcher(b);
            if (m.find()) {
                b.delete(m.start(), m.end());
            }
            if ((m = entrySuffixRe.matcher(b)).find()) {
                b.delete(m.start(), m.end());
            }
            if (CdiPanel.this.nodeName.length() > 0) {
                b.insert(0, CdiPanel.this.nodeName);
                b.insert(CdiPanel.this.nodeName.length(), ".");
            }
            for (int i = b.length() - 1; i >= 0; --i) {
                int j;
                if (b.charAt(i) != '(') continue;
                for (j = i + 1; j < b.length() && Character.isDigit(b.charAt(j)); ++j) {
                }
                if (j <= i + 1) continue;
                int val = Integer.parseInt(b.substring(i + 1, j));
                b.replace(i + 1, j, Integer.toString(++val));
            }
            return b.toString();
        }

        @Override
        protected void additionalButtons() {
            final JTextComponent tf = this.textField;
            JButton bb = CdiPanel.this.factory.handleProduceButton(new JButton("Trigger"));
            bb.setToolTipText("Click to fire this event.");
            bb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NodeID node = CdiPanel.this.rep.getConnection().getNodeId();
                    EventID ev = ((CdiPanel)CdiPanel.this).rep.eventNameStore.getEventID(EventIdPane.this.textField.getText());
                    CdiPanel.this.rep.getConnection().getOutputConnection().put(new ProducerConsumerEventReportMessage(node, ev), CdiPanel.this.rep.getConnection().getOutputConnection());
                }
            });
            this.addButtonToEventidMoreFunctions(bb);
            JButton bAS = CdiPanel.this.factory.handleProduceButton(new JButton("Make Sensor"));
            bAS.setToolTipText("Add a JMRI sensor with the Event ID.");
            bAS.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CdiPanel.this.factory.makeSensor(EventIdPane.this.textField.getText(), EventIdPane.this.getEventName());
                }
            });
            this.addButtonToEventidMoreFunctions(bAS);
            this.eventidMoreMenu.add(EventIdTextField.makeWellKnownEventMenu(this.textField));
            this.eventidMoreMenu.add(EventIdTextField.makeClockEventMenuItem(this.textField));
            this.eventidMoreMenu.add(EventIdTextField.makeDccAccessoryEventMenuItem(this.textField));
            this.p3.add(Box.createHorizontalStrut(5));
            CdiPanel.this.addCopyPasteButtons(this.p3, this.textField);
            this.p3.add(Box.createHorizontalStrut(5));
            JButton b = new JButton("Search");
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CdiPanel.this.searchPane.attachParent(EventIdPane.this.p3, tf);
                }
            });
            this.p3.add(b);
            this.p3.add(Box.createHorizontalStrut(5));
        }

        private void addButtonToEventidMoreFunctions(final JButton b) {
            if (this.eventidMoreButton == null) {
                this.eventidMoreButton = new JButton("More...");
                this.eventidMoreButton.setToolTipText("Additional actions you can do with this Event ID");
                this.eventidMoreButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        EventIdPane.this.showEventidMoreFunctionsMenu();
                    }
                });
                this.p3.add(this.eventidMoreButton);
            }
            AbstractAction a = new AbstractAction(b.getText()){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    b.doClick();
                }
            };
            this.eventidMoreMenu.add(a);
        }

        private void showEventidMoreFunctionsMenu() {
            this.eventidMoreMenu.show(this.eventidMoreButton, 0, this.eventidMoreButton.getHeight());
        }

        @Override
        protected void writeDisplayTextToNode() {
            this.entry.setValue(((CdiPanel)CdiPanel.this).rep.eventNameStore.getEventID(this.textField.getText()));
            CdiPanel.this._changeMade = true;
            CdiPanel.this.notifyTabColorRefresh();
        }

        @Override
        protected void updateDisplayText(@NonNull String value) {
            String retval = "";
            if (!value.isEmpty()) {
                EventID eid = ((CdiPanel)CdiPanel.this).rep.eventNameStore.getEventID(value);
                retval = ((CdiPanel)CdiPanel.this).rep.eventNameStore.getEventName(eid);
            }
            this.textField.setText(retval);
        }

        @Override
        @NonNull
        protected String getDisplayText() {
            String s = this.textField.getText();
            return s == null ? "" : s;
        }

        @Override
        void updateColor() {
            EventID id;
            super.updateColor();
            if (CdiPanel.this.eventTable == null) {
                return;
            }
            String s = this.textField.getText();
            if (s.equals(this.lastEventText)) {
                return;
            }
            this.lastEventText = s;
            try {
                id = ((CdiPanel)CdiPanel.this).rep.eventNameStore.getEventID(s);
            }
            catch (RuntimeException e) {
                return;
            }
            if (this.eventTableEntryHolder != null) {
                if (this.eventTableEntryHolder.getEntry().getEvent().equals(id)) {
                    return;
                }
                this.releaseListener();
            }
            if (id == null || id.equals(BitProducerConsumer.nullEvent)) {
                this.eventNamesLabel.setVisible(false);
                return;
            }
            this.eventTableEntryHolder = CdiPanel.this.eventTable.addEvent(id, this.getEventName());
            this.eventTableEntryHolder.getList().addPropertyChangeListener(this.eventListUpdateListener);
            this.updateEventDescriptionField(this.eventTableEntryHolder.getList());
        }

        private void releaseListener() {
            if (this.eventTableEntryHolder == null) {
                return;
            }
            this.eventTableEntryHolder.getList().removePropertyChangeListener(this.eventListUpdateListener);
            this.eventTableEntryHolder.release();
            this.eventTableEntryHolder = null;
        }
    }

    public class GroupPane
    extends JPanel {
        private final ConfigRepresentation.GroupEntry entry;
        private final CdiRep.Item item;

        GroupPane(ConfigRepresentation.GroupEntry e) {
            this.entry = e;
            this.item = e.getCdiItem();
            this.setLayout(new BoxLayout(this, 1));
            this.setAlignmentX(0.0f);
            String name = this.item.getName() != null ? this.item.getName() : "Group";
            this.setBorder(BorderFactory.createTitledBorder(name));
            this.setName(name);
            CdiPanel.this.createDescriptionPane(this, this.item.getDescription());
            CdiPanel.this.createLinkPane(this, this.entry.group.getLinkText(), this.entry.group.getLinkURL());
            JPanel p2 = CdiPanel.this.createPropertyPane(this.item.getMap());
            if (p2 != null) {
                this.add(p2);
            }
        }
    }

    public class SegmentPane
    extends JPanel {
        SegmentPane(ConfigRepresentation.SegmentEntry item) {
            SegmentPane p = this;
            p.setLayout(new BoxLayout(p, 1));
            p.setAlignmentX(0.0f);
            p.setAlignmentY(0.0f);
            CdiPanel.this.createDescriptionPane(this, item.getDescription());
            CdiPanel.this.createLinkPane(this, item.segment.getLinkText(), item.segment.getLinkURL());
            JPanel p2 = CdiPanel.this.createPropertyPane(item.getMap());
            if (p2 != null) {
                p.add(p2);
            }
        }
    }

    private class RendererVisitor
    extends ConfigRepresentation.Visitor {
        private JPanel currentPane;
        private EntryPane currentLeaf;
        private JTabbedPane currentTabbedPane;

        private RendererVisitor() {
        }

        @Override
        public void visitSegment(ConfigRepresentation.SegmentEntry e) {
            this.currentPane = new SegmentPane(e);
            String name = "Segment" + (e.getName() != null ? ": " + e.getName() : "");
            CollapsiblePanel cPanel = new CollapsiblePanel(name, this.currentPane);
            CdiPanel.this.segmentPanels.add(cPanel);
            CdiPanel.this.addNavigationActions(cPanel);
            cPanel.setAlignmentY(0.0f);
            cPanel.setAlignmentX(0.0f);
            cPanel.setBorder(BorderFactory.createMatteBorder(10, 0, 0, 0, CdiPanel.this.getForeground()));
            super.visitSegment(e);
            CdiPanel.this.contentPanel.add(cPanel);
        }

        @Override
        public void visitGroup(ConfigRepresentation.GroupEntry e) {
            JPanel oldPane = this.currentPane;
            JTabbedPane oldTabbed = this.currentTabbedPane;
            GroupPane groupPane = new GroupPane(e);
            this.currentPane = groupPane;
            if (e.group.getReplication() > 1) {
                this.currentTabbedPane = new JTabbedPane();
                this.currentTabbedPane.setAlignmentX(0.0f);
                this.currentPane.add(this.currentTabbedPane);
            }
            CdiPanel.this.factory.handleGroupPaneStart(groupPane);
            if (e.isReadOnlyConfigured()) {
                for (ConfigRepresentation.CdiEntry entry : e.getEntries()) {
                    if (entry instanceof ConfigRepresentation.GroupEntry) continue;
                    entry.setFlaggedReadOnly(true);
                    if (!(entry instanceof ConfigRepresentation.GroupRep)) continue;
                    for (ConfigRepresentation.CdiEntry subentry : ((ConfigRepresentation.GroupRep)entry).getEntries()) {
                        subentry.setFlaggedReadOnly(true);
                    }
                }
            }
            super.visitGroup(e);
            CdiPanel.this.factory.handleGroupPaneEnd(groupPane);
            if (groupPane.getComponentCount() > 0) {
                if (oldPane instanceof SegmentPane || e.isHideable()) {
                    groupPane.setBorder(null);
                    CollapsiblePanel cPanel = new CollapsiblePanel(groupPane.getName(), groupPane);
                    cPanel.setAlignmentY(0.0f);
                    cPanel.setAlignmentX(0.0f);
                    cPanel.setExpanded(!e.isHidden());
                    oldPane.add(cPanel);
                    CdiPanel.this.addNavigationActions(cPanel);
                } else {
                    oldPane.add(groupPane);
                }
            }
            this.currentPane = oldPane;
            this.currentTabbedPane = oldTabbed;
        }

        @Override
        public void visitGroupRep(final ConfigRepresentation.GroupRep e) {
            this.currentPane = new JPanel();
            this.currentPane.setLayout(new BoxLayout(this.currentPane, 1));
            this.currentPane.setAlignmentX(0.0f);
            CdiRep.Group item = e.group;
            final String name = item.getRepName(e.index, item.getReplication());
            this.currentPane.setName(name);
            FindDescriptorVisitor vv = new FindDescriptorVisitor();
            vv.visitContainer(e);
            if (vv.foundEntry != null) {
                final JPanel tabPanel = this.currentPane;
                final ConfigRepresentation.StringEntry source = vv.foundEntry;
                final JTabbedPane parentTabs = this.currentTabbedPane;
                PropertyChangeListener l = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent event) {
                        if (event.getPropertyName().equals("UPDATE_ENTRY_DATA")) {
                            CdiPanel.this.runNowOrLater(() -> {
                                String downstreamName = "";
                                if (source2.lastVisibleValue != null && !source2.lastVisibleValue.isEmpty()) {
                                    String newName = name + " (" + source2.lastVisibleValue + ")";
                                    tabPanel.setName(newName);
                                    if (parentTabs.getTabCount() >= e2.index) {
                                        JComponent tabLabel = RendererVisitor.this.getTabLabel(parentTabs, e2.index - 1, newName, e);
                                        parentTabs.setTabComponentAt(e2.index - 1, tabLabel);
                                    }
                                    downstreamName = source2.lastVisibleValue;
                                } else if (parentTabs.getTabCount() >= e2.index) {
                                    JComponent tabLabel = RendererVisitor.this.getTabLabel(parentTabs, e2.index - 1, name, e);
                                    parentTabs.setTabComponentAt(e2.index - 1, tabLabel);
                                }
                                new UpdateGroupNameVisitor(e2.key, downstreamName).visitContainer(e);
                            });
                        }
                    }
                };
                source.addPropertyChangeListener(l);
                CdiPanel.this.cleanupTasks.add(() -> source.removePropertyChangeListener(l));
            }
            CdiPanel.this.factory.handleGroupPaneStart(this.currentPane);
            super.visitGroupRep(e);
            CdiPanel.this.factory.handleGroupPaneEnd(this.currentPane);
            this.currentPane.add(Box.createVerticalGlue());
            this.currentTabbedPane.add(this.currentPane);
            CdiPanel.this.tabsByKey.put(e.key, this.currentTabbedPane);
            int index = this.currentTabbedPane.indexOfComponent(this.currentPane);
            JComponent tabLabel = this.getTabLabel(this.currentTabbedPane, index, name, e);
            this.currentTabbedPane.setTabComponentAt(index, tabLabel);
        }

        protected JComponent getTabLabel(final JTabbedPane parentTabbedPane, final int index, String name, final ConfigRepresentation.GroupRep rep) {
            final JLabel tabLabel = new JLabel(name);
            tabLabel.setFont(tabFont);
            tabLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    boolean isPopup;
                    boolean bl = isPopup = (event.getModifiersEx() & 0x80) != 0 || event.isPopupTrigger();
                    if (!isPopup) {
                        parentTabbedPane.setSelectedIndex(index);
                    } else {
                        parentTabbedPane.setSelectedIndex(index);
                        JPopupMenu popupMenu = new JPopupMenu();
                        JMenuItem menuItem = new JMenuItem("Copy");
                        popupMenu.add(menuItem);
                        menuItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                RendererVisitor.this.performGroupReplCopy(index, rep);
                            }
                        });
                        menuItem = new JMenuItem("Paste");
                        popupMenu.add(menuItem);
                        menuItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                RendererVisitor.this.performGroupReplPaste(index, rep);
                            }
                        });
                        popupMenu.show(tabLabel, event.getX(), event.getY());
                    }
                }
            });
            return tabLabel;
        }

        protected void performGroupReplCopy(int index, ConfigRepresentation.GroupRep rep) {
            String result = this.groupReplToString(rep);
            StringSelection selection = new StringSelection(result);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(selection, selection);
        }

        protected String groupReplToString(ConfigRepresentation.GroupRep rep) {
            final StringBuilder result = new StringBuilder();
            ConfigRepresentation.Visitor visitor = new ConfigRepresentation.Visitor(){

                @Override
                public void visitString(ConfigRepresentation.StringEntry e) {
                    this.writeEntry(e.key, e.getValue());
                }

                @Override
                public void visitInt(ConfigRepresentation.IntegerEntry e) {
                    this.writeEntry(e.key, Long.toString(e.getValue()));
                }

                @Override
                public void visitFloat(ConfigRepresentation.FloatEntry e) {
                    this.writeEntry(e.key, Double.toString(e.getValue()));
                }

                @Override
                public void visitEvent(ConfigRepresentation.EventEntry e) {
                    this.writeEntry(e.key, e.getValue());
                }

                protected void writeEntry(String key, String entry) {
                    result.append(key);
                    result.append("=");
                    result.append(((EntryPane)CdiPanel.this.entriesByKey.get(key)).getCurrentValue());
                    result.append("\n");
                }
            };
            visitor.visitGroupRep(rep);
            return new String(result);
        }

        protected void performGroupReplPaste(int index, ConfigRepresentation.GroupRep rep) {
            Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable t = c.getContents(null);
            String newContentString = "";
            if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    newContentString = (String)t.getTransferData(DataFlavor.stringFlavor);
                }
                catch (UnsupportedFlavorException | IOException e) {
                    return;
                }
            }
            String previousContentString = this.groupReplToString(rep);
            String[] newContentLines = newContentString.split("\n");
            String[] previousContentLines = previousContentString.split("\n");
            if (previousContentLines.length != newContentLines.length) {
                logger.log(Level.WARNING, "Cannot paste into a mis-matching entry type");
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            List<String> list = Arrays.asList(newContentLines);
            String prefix = Utilities.longestLeadingSubstring(list);
            StringBuilder processedContentSB = new StringBuilder();
            for (int i = 0; i < newContentLines.length; ++i) {
                newContentLines[i] = rep.key + "." + newContentLines[i].substring(prefix.length()) + "\n";
                processedContentSB.append(newContentLines[i]);
            }
            String processedContent = new String(processedContentSB);
            BufferedReader reader = new BufferedReader(new StringReader(processedContent));
            RestoreConfig.parseConfigFromReader(reader, new RestoreConfig.ConfigCallback(){
                boolean hasError = false;

                @Override
                public void onConfigEntry(String key, String value) {
                    String mapvalue;
                    EntryPane pp = (EntryPane)CdiPanel.this.entriesByKey.get(key);
                    if (pp == null) {
                        this.onError("Could not find variable for key " + key);
                        return;
                    }
                    CdiRep.Map map = pp.entry.getCdiItem().getMap();
                    if (map != null && map.getKeys().size() > 0 && (mapvalue = map.getEntry(value)) != null) {
                        value = mapvalue;
                    }
                    pp.updateDisplayText(value);
                    pp.updateColor();
                }

                @Override
                public void onError(String error) {
                    if (!this.hasError) {
                        logger.severe("Error(s) encountered during loading configuration backup.");
                        this.hasError = true;
                    }
                    logger.severe(error);
                }
            });
            CdiPanel.this._unsavedRestore = true;
        }

        @Override
        public void visitString(ConfigRepresentation.StringEntry e) {
            this.currentLeaf = new StringPane(e);
            super.visitString(e);
        }

        @Override
        public void visitUnknown(ConfigRepresentation.UnknownEntry e) {
            this.currentLeaf = new UnknownPane(e);
            super.visitUnknown(e);
        }

        @Override
        public void visitInt(ConfigRepresentation.IntegerEntry e) {
            this.currentLeaf = new IntPane(e);
            super.visitInt(e);
        }

        @Override
        public void visitFloat(ConfigRepresentation.FloatEntry e) {
            this.currentLeaf = new FloatPane(e);
            super.visitFloat(e);
        }

        @Override
        public void visitEvent(ConfigRepresentation.EventEntry e) {
            this.currentLeaf = new EventIdPane(e);
            super.visitEvent(e);
        }

        @Override
        public void visitActionButton(ConfigRepresentation.ActionButtonEntry e) {
            this.currentLeaf = new ActionButtonPane(e);
            super.visitActionButton(e);
        }

        @Override
        public void visitLeaf(ConfigRepresentation.CdiEntry e) {
            CdiPanel.this.allEntries.add(this.currentLeaf);
            CdiPanel.this.entriesByKey.put(((EntryPane)this.currentLeaf).entry.key, this.currentLeaf);
            this.currentLeaf.setAlignmentX(0.0f);
            this.currentPane.add(this.currentLeaf);
            this.currentLeaf = null;
        }
    }

    private class UpdateGroupNameVisitor
    extends ConfigRepresentation.Visitor {
        String baseGroupKey;
        String labelValue;

        UpdateGroupNameVisitor(String baseGroupKey, String labelValue) {
            this.baseGroupKey = baseGroupKey;
            this.labelValue = labelValue;
        }

        @Override
        public void visitEvent(ConfigRepresentation.EventEntry e) {
            EventIdPane pane = (EventIdPane)CdiPanel.this.entriesByKey.get(e.key);
            if (pane == null) {
                return;
            }
            pane.parentVisibleKeys.put(this.baseGroupKey, this.labelValue);
            pane.updateOwnEventName();
        }
    }

    private class FindDescriptorVisitor
    extends ConfigRepresentation.Visitor {
        public boolean foundUnique = false;
        public ConfigRepresentation.StringEntry foundEntry = null;

        private FindDescriptorVisitor() {
        }

        @Override
        public void visitString(ConfigRepresentation.StringEntry e) {
            if (this.foundEntry != null) {
                this.foundUnique = false;
            } else {
                this.foundUnique = true;
                this.foundEntry = e;
            }
        }

        @Override
        public void visitGroupRep(ConfigRepresentation.GroupRep e) {
        }
    }
}

