/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.hub;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Hub {
    private static final Logger logger = Logger.getLogger(Hub.class.getName());
    public static final int DEFAULT_PORT = 12021;
    static final int CAPACITY = 20;
    private final boolean sendLineEndings;
    private final boolean requireIncomingLineEndings;
    private boolean disposed = false;
    BlockingQueue<Memo> queue = new LinkedBlockingQueue<Memo>();
    final List<Forwarding> threads = Collections.synchronizedList(new ArrayList());
    final int port;
    private ServerSocket service = null;

    public Hub() {
        this(12021);
    }

    public Hub(int port) {
        this(port, true, false);
    }

    public Hub(int port, boolean sendLineEndings, boolean requireIncomingLineEndings) {
        this.port = port;
        this.sendLineEndings = sendLineEndings;
        this.requireIncomingLineEndings = requireIncomingLineEndings;
        this.createServerThread();
    }

    private void createServerThread() {
        Thread t = new Thread("openlcb-hub-output"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!Hub.this.disposed) {
                    try {
                        ArrayList<Forwarding> threadList;
                        Memo m = Hub.this.queue.take();
                        List<Forwarding> list = Hub.this.threads;
                        synchronized (list) {
                            threadList = new ArrayList<Forwarding>(Hub.this.threads);
                        }
                        for (Forwarding e : threadList) {
                            e.forward(m);
                        }
                    }
                    catch (InterruptedException e) {
                        logger.severe("Hub: Interrupted in queue handling loop - exiting");
                        logger.log(Level.SEVERE, "", e);
                        Hub.this.dispose();
                        return;
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Hub: Continuing from unexpected Exception in openlcb-hub-output thread", e);
                    }
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    public void start() {
        try {
            this.service = new ServerSocket(this.port);
            while (!this.disposed) {
                Socket clientSocket = this.service.accept();
                ReaderThread r = new ReaderThread(clientSocket);
                this.addForwarder(r);
                r.start();
                this.notifyOwner("Connection started with " + this.getRemoteSocketAddress(clientSocket));
            }
        }
        catch (IOException e) {
            logger.severe("Hub: Exception in main loop");
            logger.log(Level.SEVERE, "", e);
            this.notifyOwner(e.getLocalizedMessage());
            this.dispose();
        }
        finally {
            if (this.service != null) {
                try {
                    this.service.close();
                    this.service = null;
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "Exception closing Service", e);
                }
            }
        }
    }

    public int getPort() {
        return this.port;
    }

    public void addForwarder(Forwarding f) {
        this.threads.add(f);
    }

    public void notifyOwner(String line) {
        logger.info(line);
    }

    String getRemoteSocketAddress(Socket socket) {
        try {
            return socket.getRemoteSocketAddress().toString();
        }
        catch (Throwable e) {
            return "<unknown>";
        }
    }

    public void putLine(String line) {
        try {
            this.queue.put(new Memo(line, null));
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, "ERROR storing input", e);
        }
    }

    public void dispose() {
        this.notifyOwner("Hub Shutting Down");
        this.disposed = true;
        try {
            if (this.service != null) {
                new Socket(this.service.getInetAddress(), this.service.getLocalPort()).close();
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "dispose exception", e);
        }
    }

    public static void main(String[] args) {
        Hub h = new Hub();
        h.start();
    }

    class ReaderThread
    extends Thread
    implements Forwarding {
        Socket clientSocket;
        PrintStream output;
        static final int MAX_STREAM_FRAME_BYTE_LENGTH = 30;
        private byte char1;
        private final byte[] rcvBuffer = new byte[1];

        ReaderThread(Socket clientSocket) {
            this.clientSocket = clientSocket;
        }

        @Override
        public void run() {
            try (DataInputStream input = new DataInputStream(this.clientSocket.getInputStream());
                 BufferedReader bfr = new BufferedReader(new InputStreamReader(input));){
                this.output = new PrintStream(this.clientSocket.getOutputStream(), true, "ISO-8859-1");
                while (!Hub.this.disposed) {
                    String line = Hub.this.requireIncomingLineEndings ? bfr.readLine() : this.loadChars(input);
                    if (line == null) {
                        break;
                    }
                    Hub.this.queue.put(new Memo(line, this));
                }
            }
            catch (SocketException e) {
                logger.log(Level.WARNING, "Hub: {0} while handling input from " + Hub.this.getRemoteSocketAddress(this.clientSocket), e.getMessage());
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Hub: Error while handling input from {0}", Hub.this.getRemoteSocketAddress(this.clientSocket));
                logger.log(Level.SEVERE, "", e);
            }
            catch (InterruptedException e) {
                logger.log(Level.SEVERE, "Hub: Interrupted while handling input from {0}", Hub.this.getRemoteSocketAddress(this.clientSocket));
                logger.log(Level.SEVERE, "", e);
            }
            this.output = null;
            Hub.this.threads.remove(this);
            Hub.this.notifyOwner("Connection ended with " + Hub.this.getRemoteSocketAddress(this.clientSocket));
            try {
                this.clientSocket.close();
            }
            catch (IOException e) {
                logger.severe("Hub: Error while closing socket at end of connection");
                logger.log(Level.SEVERE, "", e);
            }
        }

        private String loadChars(DataInputStream istream) throws IOException {
            StringBuilder sb = new StringBuilder(30);
            for (int i = 0; i < 30; ++i) {
                this.char1 = this.readByteProtected(istream);
                if (i == 0) {
                    while (this.char1 != 58 && this.char1 != 124 && !Hub.this.disposed) {
                        this.char1 = this.readByteProtected(istream);
                    }
                }
                sb.append((char)this.char1);
                if (this.char1 == 59 || this.char1 == 33) break;
            }
            return sb.toString();
        }

        private byte readByteProtected(DataInputStream istream) throws IOException {
            while (!Hub.this.disposed) {
                try {
                    int nchars = istream.read(this.rcvBuffer, 0, 1);
                    if (nchars == -1) {
                        throw new IOException("Connection not terminated normally");
                    }
                    if (nchars <= 0) continue;
                    return this.rcvBuffer[0];
                }
                catch (SocketTimeoutException ex) {
                }
            }
            return 0;
        }

        @Override
        public void forward(Memo m) {
            if (!this.equals(m.source) && this.output != null) {
                if (Hub.this.sendLineEndings) {
                    this.output.println(m.line);
                } else {
                    this.output.print(m.line);
                }
            }
        }
    }

    public static interface Forwarding {
        public void forward(Memo var1);
    }

    public static class Memo {
        public String line;
        public Forwarding source;

        Memo(String line, Forwarding source) {
            this.line = line;
            this.source = source;
        }
    }
}

