/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.implementations;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openlcb.Connection;
import org.openlcb.EventID;
import org.openlcb.LearnEventMessage;
import org.openlcb.NodeID;
import org.openlcb.implementations.BlueGoldEngine;
import org.openlcb.implementations.ScatterGather;
import org.openlcb.implementations.SingleConsumer;
import org.openlcb.implementations.SingleProducer;

public class BlueGoldExtendedEngine
extends BlueGoldEngine {
    boolean[] isSelectedPC;
    private static final Logger logger = Logger.getLogger(BlueGoldExtendedEngine.class.getName());

    @Override
    public void goldClick() {
        if (this.getGoldLightOn() && this.getBlueLightOn()) {
            if (this.selectedPC >= 0) {
                this.sendLearnEventMessage(this.getEventID(this.selectedPC));
                this.setGoldLightOn(false);
                this.setBlueLightOn(false);
                this.selectedPC = -1;
                return;
            }
        } else if (!this.getGoldLightOn() && this.getBlueLightOn()) {
            if (this.selectedPC >= 0) {
                this.isSelectedPC[this.selectedPC] = true;
                this.selectedPC = -1;
                this.setBlueLightOn(false);
            }
        } else if (!this.getGoldLightOn() && !this.getBlueLightOn()) {
            this.setGoldLightOn(true);
        } else {
            this.setGoldLightOn(false);
            this.setBlueLightOn(false);
            this.selectedPC = -1;
            for (boolean p : this.isSelectedPC) {
                p = false;
            }
        }
    }

    @Override
    public void blueClick() {
        ++this.selectedPC;
        if (this.selectedPC >= this.producers.size() + this.consumers.size()) {
            this.selectedPC = -1;
            this.setBlueLightOn(false);
        } else {
            this.setBlueLightOn(true);
        }
    }

    @Override
    public void longBluePress() {
        for (int i = 0; i < this.isSelectedPC.length; ++i) {
            this.isSelectedPC[i] = false;
        }
        this.selectedPC = -1;
        this.setBlueLightOn(false);
    }

    @Override
    public void handleLearnEvent(LearnEventMessage msg, Connection sender) {
        for (int i = 0; i < this.isSelectedPC.length; ++i) {
            if (this.isSelectedPC[i]) {
                EventID eid = msg.getEventID();
                logger.log(Level.INFO, "Set {0} to {1}", new Object[]{i, eid});
                this.setEventID(i, eid);
            }
            this.isSelectedPC[i] = false;
        }
        this.setBlueLightOn(false);
        this.setGoldLightOn(false);
        this.selectedPC = -1;
    }

    public BlueGoldExtendedEngine(NodeID nid, ScatterGather sg, List<SingleProducer> producers, List<SingleConsumer> consumers) {
        super(nid, sg, producers, consumers);
        for (boolean p : this.isSelectedPC = new boolean[producers.size() + consumers.size()]) {
            p = false;
        }
    }
}

