/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.implementations;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.openlcb.Connection;
import org.openlcb.DatagramAcknowledgedMessage;
import org.openlcb.DatagramMessage;
import org.openlcb.DatagramRejectedMessage;
import org.openlcb.MessageDecoder;
import org.openlcb.NodeID;
import org.openlcb.Utilities;

public class DatagramService
extends MessageDecoder {
    private static final Logger logger = Logger.getLogger(DatagramService.class.getName());
    public static final int FLAG_REPLY_PENDING = 128;
    public static final int DEFAULT_ERROR_CODE = 4096;
    public static final int ERROR_TOO_SHORT = 4225;
    public static final int ERROR_UNSUPPORTED_DATAGRAM_TYPE = 4162;
    public static final int ACCEPT_REPLY_PENDING = 0x800000;
    NodeID here;
    Connection downstream;
    final Map<Integer, DatagramServiceReceiveMemo> receivers = new HashMap<Integer, DatagramServiceReceiveMemo>();
    DatagramServiceTransmitMemo xmtMemo;

    public DatagramService(NodeID here, Connection downstream) {
        this.here = here;
        this.downstream = downstream;
    }

    public void sendData(DatagramServiceTransmitMemo memo) {
        if (this.xmtMemo != null) {
            logger.log(Level.SEVERE, "Overriding datagram transmit memo. old {0} new {1}", new Object[]{this.xmtMemo, memo});
        }
        this.xmtMemo = memo;
        DatagramMessage m = new DatagramMessage(this.here, memo.dest, memo.data);
        this.downstream.put(m, this);
    }

    public void sendData(NodeID dest, int[] data) {
        DatagramServiceTransmitMemo memo;
        this.xmtMemo = memo = new DatagramServiceTransmitMemo(dest, data){

            @Override
            public void handleSuccess(int flags) {
            }

            @Override
            public void handleFailure(int errorCode) {
            }
        };
        DatagramMessage m = new DatagramMessage(this.here, memo.dest, memo.data);
        this.downstream.put(m, this);
    }

    @Override
    public void handleDatagram(DatagramMessage msg, Connection sender) {
        if (!msg.getDestNodeID().equals(this.here)) {
            return;
        }
        ReplyMemo replyMemo = new ReplyMemo(msg, this.downstream, this.here, this);
        if (msg.getData() == null) {
            new Exception("Unexpected null content of datagram").printStackTrace();
            replyMemo.acceptData(4096);
            return;
        }
        if (msg.getData().length == 0) {
            new Exception("Unexpected zero length content of datagram").printStackTrace();
            replyMemo.acceptData(4225);
            return;
        }
        int t = msg.getData()[0] & 0xFF;
        DatagramServiceReceiveMemo receiveMemo = this.receivers.get(t);
        if (receiveMemo == null) {
            replyMemo.acceptData(4162);
            return;
        }
        receiveMemo.handleData(msg.getSourceNodeID(), msg.getData(), replyMemo);
        if (!replyMemo.hasReplied()) {
            logger.log(Level.SEVERE, "No internal reply received to datagram with contents {0}", Utilities.toHexDotsString(msg.getData()));
        }
    }

    @Override
    public void handleDatagramRejected(DatagramRejectedMessage msg, Connection sender) {
        if (this.xmtMemo != null && msg.getDestNodeID().equals(this.here) && this.xmtMemo.dest.equals(msg.getSourceNodeID())) {
            if (msg.canResend()) {
                return;
            }
            DatagramServiceTransmitMemo temp = this.xmtMemo;
            this.xmtMemo = null;
            temp.handleFailure(msg.getCode());
        }
    }

    @Override
    public void handleDatagramAcknowledged(DatagramAcknowledgedMessage msg, Connection sender) {
        if (this.xmtMemo != null && msg.getDestNodeID().equals(this.here) && this.xmtMemo.dest.equals(msg.getSourceNodeID())) {
            DatagramServiceTransmitMemo temp = this.xmtMemo;
            this.xmtMemo = null;
            temp.handleSuccess(msg.getFlags());
        }
    }

    public synchronized void registerForReceive(DatagramServiceReceiveMemo memo) {
        this.receivers.put(memo.type, memo);
    }

    public synchronized void unRegisterForReceive(DatagramServiceReceiveMemo memo) {
        DatagramServiceReceiveMemo old = this.receivers.get(memo.type);
        if (old == memo) {
            this.receivers.remove(memo.type);
        } else {
            logger.log(Level.SEVERE, "Unregistering a datagram listener that is not registered for type {0}", Integer.toString(memo.type));
            new Exception("Unexpected unregister for datagram listener").printStackTrace();
        }
    }

    @Immutable
    @ThreadSafe
    public static abstract class DatagramServiceTransmitMemo {
        protected int[] data;
        final NodeID dest;

        public DatagramServiceTransmitMemo(NodeID dest, int[] data) {
            this.data = data;
            this.dest = dest;
        }

        protected DatagramServiceTransmitMemo(NodeID dest) {
            this.data = null;
            this.dest = dest;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof DatagramServiceTransmitMemo)) {
                return false;
            }
            DatagramServiceTransmitMemo m = (DatagramServiceTransmitMemo)o;
            if (this.data.length != m.data.length) {
                return false;
            }
            if (this.dest != m.dest) {
                return false;
            }
            for (int i = 0; i < this.data.length; ++i) {
                if (this.data[i] == m.data[i]) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "DatagramServiceTransmitMemo to " + this.dest.toString() + ": " + Utilities.toHexDotsString(this.data);
        }

        public int hashCode() {
            return this.data.length + this.data[0] + this.dest.hashCode();
        }

        public abstract void handleSuccess(int var1);

        public abstract void handleFailure(int var1);
    }

    @Immutable
    public static class ReplyMemo {
        DatagramMessage msg;
        Connection downstream;
        NodeID here;
        DatagramService service;
        boolean replied = false;

        protected ReplyMemo(DatagramMessage msg, Connection downstream, NodeID here, DatagramService service) {
            this.msg = msg;
            this.downstream = downstream;
            this.here = here;
            this.service = service;
        }

        public void acceptData(int resultCode) {
            this.replied = true;
            if ((resultCode & 0xFFFF) == 0) {
                int flags = resultCode >> 16 & 0xFF;
                DatagramAcknowledgedMessage m = new DatagramAcknowledgedMessage(this.here, this.msg.getSourceNodeID(), flags);
                this.downstream.put(m, this.service);
            } else {
                DatagramRejectedMessage m = new DatagramRejectedMessage(this.here, this.msg.getSourceNodeID(), resultCode & 0xFFFF);
                this.downstream.put(m, this.service);
            }
        }

        boolean hasReplied() {
            return this.replied;
        }
    }

    @Immutable
    @ThreadSafe
    public static class DatagramServiceReceiveMemo {
        final int type;

        public DatagramServiceReceiveMemo(int type) {
            this.type = type;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof DatagramServiceReceiveMemo)) {
                return false;
            }
            return this.type == ((DatagramServiceReceiveMemo)o).type;
        }

        public String toString() {
            return "DatagramServiceReceiveMemo: " + this.type;
        }

        public int hashCode() {
            return this.type;
        }

        public void acceptData(int resultCode) {
        }

        public void handleData(NodeID n, int[] data, ReplyMemo service) {
            service.acceptData(4096);
        }
    }
}

