/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.implementations;

public class DatagramUtils {
    static Long parseLong(int[] payload, int offset) {
        long retval = 0L;
        retval |= (long)(payload[offset++] & 0xFF);
        retval <<= 8;
        retval |= (long)(payload[offset++] & 0xFF);
        retval <<= 8;
        retval |= (long)(payload[offset++] & 0xFF);
        retval <<= 8;
        return retval |= (long)(payload[offset++] & 0xFF);
    }

    static void renderLong(int[] payload, int offset, long value) {
        payload[offset++] = (int)(value >> 24 & 0xFFL);
        payload[offset++] = (int)(value >> 16 & 0xFFL);
        payload[offset++] = (int)(value >> 8 & 0xFFL);
        payload[offset++] = (int)(value & 0xFFL);
    }

    static int parseErrorCode(int[] payload, int offset) {
        int retval = payload[offset++];
        retval <<= 8;
        return retval |= payload[offset] & 0xFF;
    }

    static void renderErrorCode(int[] payload, int offset, int errorCode) {
        payload[offset++] = errorCode >> 8 & 0xFF;
        payload[offset++] = errorCode & 0xFF;
    }

    public static int byteToInt(byte b) {
        return b < 0 ? b + 256 : b;
    }

    static void byteToIntArray(int[] dst, int iDst, byte[] src, int iSrc, int len) {
        for (int i = 0; i < len; ++i) {
            dst[i + iDst] = DatagramUtils.byteToInt(src[i + iSrc]);
        }
    }

    static byte intToByte(int b) {
        return (byte)b;
    }

    static void intToByteArray(byte[] dst, int iDst, int[] src, int iSrc, int len) {
        for (int i = 0; i < len; ++i) {
            dst[i + iDst] = DatagramUtils.intToByte(src[i + iSrc]);
        }
    }
}

