/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.implementations;

import java.util.HashSet;
import org.openlcb.Connection;
import org.openlcb.ConsumerIdentifiedMessage;
import org.openlcb.EventID;
import org.openlcb.Gateway;
import org.openlcb.Message;
import org.openlcb.MessageDecoder;
import org.openlcb.ProducerConsumerEventReportMessage;

public class EventFilterGateway
extends Gateway {
    HashSet<EventID> idsGoingWest = new HashSet();
    HashSet<EventID> idsGoingEast = new HashSet();

    @Override
    public Connection getEastConnection() {
        this.eastInputConnection = new EastConnection();
        return this.eastInputConnection;
    }

    @Override
    public Connection getWestConnection() {
        this.westInputConnection = new WestConnection();
        return this.westInputConnection;
    }

    class EastConnection
    extends MessageDecoder
    implements Connection {
        boolean forward;

        EastConnection() {
        }

        @Override
        public void put(Message msg, Connection sender) {
            this.forward = true;
            msg.applyTo(this, sender);
            if (this.forward) {
                EventFilterGateway.this.sendMessageToWest(msg, sender);
            }
        }

        @Override
        public void handleProducerConsumerEventReport(ProducerConsumerEventReportMessage msg, Connection sender) {
            if (!EventFilterGateway.this.idsGoingWest.contains(msg.getEventID())) {
                this.forward = false;
            }
        }

        @Override
        public void handleConsumerIdentified(ConsumerIdentifiedMessage msg, Connection sender) {
            EventFilterGateway.this.idsGoingEast.add(msg.getEventID());
        }
    }

    class WestConnection
    extends MessageDecoder
    implements Connection {
        boolean forward;

        WestConnection() {
        }

        @Override
        public void put(Message msg, Connection sender) {
            this.forward = true;
            msg.applyTo(this, sender);
            if (this.forward) {
                EventFilterGateway.this.sendMessageToEast(msg, sender);
            }
        }

        @Override
        public void handleProducerConsumerEventReport(ProducerConsumerEventReportMessage msg, Connection sender) {
            if (!EventFilterGateway.this.idsGoingEast.contains(msg.getEventID())) {
                this.forward = false;
            }
        }

        @Override
        public void handleConsumerIdentified(ConsumerIdentifiedMessage msg, Connection sender) {
            EventFilterGateway.this.idsGoingWest.add(msg.getEventID());
        }
    }
}

