/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.implementations;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import net.jcip.annotations.ThreadSafe;
import org.openlcb.DefaultPropertyListenerSupport;
import org.openlcb.EventID;

@ThreadSafe
public class EventTable {
    private final HashMap<Long, EventInfo> entries = new HashMap();
    public static final String UPDATED_EVENT_LIST = "UPDATED_EVENT_LIST";
    private static float SUBSTRING_SCORE = 10.0f;
    private static float SUBSTRINGIC_SCORE = 5.0f;
    private static float WORDPREF_SCORE = 20.0f;
    private static float WORDPREFIC_SCORE = 17.0f;
    private static float HASPAREN_SCORE = -1.0f;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public EventInfo getEventInfo(EventID event) {
        HashMap<Long, EventInfo> hashMap = this.entries;
        synchronized (hashMap) {
            long key = event.toLong();
            EventInfo entry = this.entries.get(key);
            if (entry == null) {
                entry = new EventInfo(event);
                this.entries.put(key, entry);
            }
            return entry;
        }
    }

    public EventTableEntryHolder addEvent(EventID event, String description) {
        return this.getEventInfo(event).add(description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EventTableEntry> searchForEvent(String query, int maxResults) {
        class SearchEntryHelper
        implements Comparable<SearchEntryHelper> {
            final EventTableEntry entry;
            final float score;

            SearchEntryHelper(EventTableEntry e, float s) {
                this.entry = e;
                this.score = s;
            }

            @Override
            public int compareTo(@NonNull SearchEntryHelper o) {
                int scc = Float.compare(this.score, o.score);
                if (scc != 0) {
                    return scc;
                }
                return -this.entry.description.compareTo(o.entry.description);
            }
        }
        PriorityQueue<SearchEntryHelper> heap = new PriorityQueue<SearchEntryHelper>(maxResults + 1);
        HashMap<Long, EventInfo> hashMap = this.entries;
        synchronized (hashMap) {
            for (EventInfo ev : this.entries.values()) {
                for (EventTableEntry entry : ev.entries) {
                    float sc = EventTable.match(entry.description, query);
                    if (sc <= 0.0f) continue;
                    heap.add(new SearchEntryHelper(entry, sc));
                    if (heap.size() <= maxResults) continue;
                    heap.poll();
                }
            }
        }
        LinkedList<EventTableEntry> results = new LinkedList<EventTableEntry>();
        while (!heap.isEmpty()) {
            results.addFirst(((SearchEntryHelper)heap.poll()).entry);
        }
        return results;
    }

    static boolean substringMatch(String description, String query) {
        if (description.isEmpty()) {
            return query.isEmpty();
        }
        int di = 0;
        int qi = 0;
        while (qi < query.length() && di < description.length()) {
            if (description.charAt(di) == query.charAt(qi)) {
                ++di;
                ++qi;
                continue;
            }
            ++di;
        }
        return qi >= query.length();
    }

    static boolean wordPrefixMatch(String description, String query) {
        int di = 0;
        int qi = 0;
        while (true) {
            int qqi;
            if (qi < query.length() && (!Character.isLetterOrDigit(query.charAt(qi)) || qi > 0 && Character.isLetterOrDigit(query.charAt(qi - 1)))) {
                ++qi;
                continue;
            }
            if (qi >= query.length()) {
                return true;
            }
            while (di < description.length() && (query.charAt(qi) != description.charAt(di) || di > 0 && Character.isLetterOrDigit(description.charAt(di - 1)))) {
                ++di;
            }
            if (di >= description.length()) {
                return false;
            }
            int ddi = di;
            for (qqi = qi; ddi < description.length() && qqi < query.length() && Character.isLetterOrDigit(query.charAt(qqi)) && query.charAt(qqi) == description.charAt(ddi); ++ddi, ++qqi) {
            }
            if (qqi >= query.length() || !Character.isLetterOrDigit(query.charAt(qqi))) {
                di = ddi;
                qi = qqi;
                continue;
            }
            if (ddi <= ++di) continue;
            di = ddi;
        }
    }

    public static float match(String description, String query) {
        boolean isSubStringICase = EventTable.substringMatch(description.toLowerCase(), query.toLowerCase());
        boolean isSubString = isSubStringICase && EventTable.substringMatch(description, query);
        boolean isWordPrefixICase = EventTable.wordPrefixMatch(description.toLowerCase(), query.toLowerCase());
        boolean isWordPrefix = isWordPrefixICase && EventTable.wordPrefixMatch(description, query);
        boolean hasParen = description.indexOf(40) >= 0;
        float score = 0.0f;
        if (isSubString) {
            score += SUBSTRING_SCORE;
        }
        if (isSubStringICase) {
            score += SUBSTRINGIC_SCORE;
        }
        if (isWordPrefix) {
            score += WORDPREF_SCORE;
        }
        if (isWordPrefixICase) {
            score += WORDPREFIC_SCORE;
        }
        if (hasParen) {
            score += HASPAREN_SCORE;
        }
        return score;
    }

    @ThreadSafe
    public class EventInfo
    extends DefaultPropertyListenerSupport {
        private final EventID eventId;
        private final List<EventTableEntry> entries = new ArrayList<EventTableEntry>();

        EventInfo(EventID id) {
            this.eventId = id;
        }

        public EventID getEventId() {
            return this.eventId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EventTableEntryHolder add(String description) {
            EventTableEntryHolder h;
            EventTableEntry newEntry = new EventTableEntry(description);
            newEntry.h = h = new EventTableEntryHolder(this, newEntry);
            List<EventTableEntry> list = this.entries;
            synchronized (list) {
                this.entries.add(newEntry);
            }
            this.notifyUpdated();
            return h;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(EventTableEntryHolder h) {
            List<EventTableEntry> list = this.entries;
            synchronized (list) {
                for (int i = 0; i < this.entries.size(); ++i) {
                    if (this.entries.get((int)i).h != h) continue;
                    this.entries.remove(i);
                    --i;
                }
            }
            this.notifyUpdated();
        }

        void notifyUpdated() {
            this.firePropertyChange(EventTable.UPDATED_EVENT_LIST, null, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EventTableEntry[] getAllEntries() {
            List<EventTableEntry> list = this.entries;
            synchronized (list) {
                EventTableEntry[] ar = new EventTableEntry[this.entries.size()];
                this.entries.toArray(ar);
                return ar;
            }
        }
    }

    public class EventTableEntryHolder {
        final EventTableEntry entry;
        final EventInfo event;

        EventTableEntryHolder(EventInfo event, EventTableEntry e) {
            this.event = event;
            this.entry = e;
        }

        public void release() {
            this.event.remove(this);
        }

        public EventTableEntry getEntry() {
            return this.entry;
        }

        public EventInfo getList() {
            return this.event;
        }
    }

    public class EventTableEntry {
        String description;
        EventTableEntryHolder h;

        EventTableEntry(String d) {
            this.description = d;
        }

        public String getDescription() {
            return this.description;
        }

        public EventID getEvent() {
            return this.h.event.getEventId();
        }

        public boolean isOwnedBy(EventTableEntryHolder holder) {
            return holder == this.h;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateDescription(String newDescription) {
            List list = this.h.event.entries;
            synchronized (list) {
                if (this.description.equals(newDescription)) {
                    return;
                }
                this.description = newDescription;
            }
            this.h.event.notifyUpdated();
        }
    }
}

