/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.implementations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.openlcb.NodeID;
import org.openlcb.OlcbInterface;
import org.openlcb.implementations.MemoryConfigurationService;

public class FakeMemoryConfigurationService
extends MemoryConfigurationService {
    private Map<SpaceKey, SpaceData> knownSpaces = new HashMap<SpaceKey, SpaceData>();
    public List<ActualWrite> actualWriteList = new ArrayList<ActualWrite>();
    public List<ActualRead> actualReadList = new ArrayList<ActualRead>();
    private static final Logger logger = Logger.getLogger(FakeMemoryConfigurationService.class.getName());

    public FakeMemoryConfigurationService(OlcbInterface iface) {
        super(iface.getNodeId(), iface.getDatagramService());
        iface.injectMemoryConfigurationService(this);
    }

    public void addSpace(NodeID remoteNode, int space, byte[] payload, boolean writeEnabled) {
        SpaceKey k = new SpaceKey();
        k.remoteNode = remoteNode;
        k.space = space;
        SpaceData d = new SpaceData();
        d.payload = payload;
        d.writeEnabled = writeEnabled;
        this.knownSpaces.put(k, d);
    }

    private SpaceData findSpace(NodeID dest, int space) {
        return this.knownSpaces.get(new SpaceKey(dest, space));
    }

    @Override
    public void requestWrite(NodeID dest, int space, long address, byte[] data, MemoryConfigurationService.McsWriteHandler cb) {
        ActualWrite aw = new ActualWrite();
        aw.space = space;
        aw.address = address;
        aw.data = data;
        this.actualWriteList.add(aw);
        SpaceData d = this.findSpace(dest, space);
        if (d == null || d.payload == null) {
            cb.handleFailure(4096);
            return;
        }
        if ((long)d.payload.length < address) {
            cb.handleFailure(4097);
            return;
        }
        if (!d.writeEnabled) {
            cb.handleFailure(4098);
            return;
        }
        if ((long)d.payload.length < address + (long)data.length) {
            cb.handleFailure(4099);
            return;
        }
        System.arraycopy(data, 0, d.payload, (int)address, data.length);
        cb.handleSuccess();
    }

    @Override
    public void requestRead(NodeID dest, int space, long address, int len, MemoryConfigurationService.McsReadHandler cb) {
        ActualRead ar = new ActualRead();
        ar.space = space;
        ar.address = address;
        ar.size = len;
        this.actualReadList.add(ar);
        SpaceData d = this.findSpace(dest, space);
        if (d == null || d.payload == null) {
            cb.handleFailure(4096);
            return;
        }
        if (address >= (long)d.payload.length) {
            logger.warning("Reading from space " + space + " address " + address + " but payload max is " + d.payload.length);
            cb.handleFailure(4097);
            return;
        }
        int count = len;
        if (address + (long)count > (long)d.payload.length) {
            count = d.payload.length - (int)address;
        }
        byte[] ret = new byte[count];
        System.arraycopy(d.payload, (int)address, ret, 0, count);
        cb.handleReadData(dest, space, address, ret);
    }

    class SpaceKey {
        NodeID remoteNode;
        int space;

        SpaceKey() {
        }

        SpaceKey(NodeID nid, int sp) {
            this.remoteNode = nid;
            this.space = sp;
        }

        public boolean equals(Object o) {
            if (!(o instanceof SpaceKey)) {
                return false;
            }
            SpaceKey p = (SpaceKey)o;
            return this.remoteNode.equals(p.remoteNode) && this.space == p.space;
        }

        public int hashCode() {
            return this.remoteNode.hashCode() | this.space;
        }
    }

    class SpaceData {
        byte[] payload;
        boolean writeEnabled;

        SpaceData() {
        }
    }

    public class ActualWrite {
        public int space;
        public long address;
        public byte[] data;
    }

    public class ActualRead {
        public int space;
        public long address;
        public int size;
    }
}

