/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.implementations;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;
import org.openlcb.Message;
import org.openlcb.NodeID;
import org.openlcb.ProducerConsumerEventReportMessage;
import org.openlcb.implementations.throttle.Float16;

public class LocationServiceUtils {
    public static Content parse(Message inputMessage) {
        if (!(inputMessage instanceof ProducerConsumerEventReportMessage)) {
            return null;
        }
        ProducerConsumerEventReportMessage msg = (ProducerConsumerEventReportMessage)inputMessage;
        byte[] payload = msg.getPayloadArray();
        if (payload.length < 8) {
            return null;
        }
        byte[] eid = msg.getEventID().getContents();
        if (eid[0] != 1 || eid[1] != 2) {
            return null;
        }
        int overallFlags = payload[0] << 8 + payload[1];
        NodeID scannerReporting = new NodeID(new byte[]{eid[2], eid[3], eid[4], eid[5], eid[6], eid[7]});
        NodeID scannedDevice = new NodeID(new byte[]{payload[2], payload[3], payload[4], payload[5], payload[6], payload[7]});
        List<Block> blocks = LocationServiceUtils.parseBlock(payload, 8, new ArrayList<Block>());
        Content retval = new Content(scannerReporting, scannedDevice, overallFlags, blocks);
        return retval;
    }

    private static List<Block> parseBlock(byte[] payload, int offset, ArrayList<Block> list) {
        if (offset >= payload.length) {
            return list;
        }
        byte length = payload[offset];
        if (length == 0) {
            list.add(new Block(Block.Type.RESERVED, new byte[0]));
        } else {
            Block.Type type = Block.Type.get(Integer.valueOf(payload[offset + 1]));
            byte[] content = Arrays.copyOfRange(payload, offset + 1, offset + 1 + length);
            switch (type) {
                case ANALOG: {
                    list.add(new AnalogBlock(content));
                    break;
                }
                default: {
                    list.add(new Block(type, content));
                }
            }
        }
        return LocationServiceUtils.parseBlock(payload, offset + length + 1, list);
    }

    @Immutable
    public static class Content {
        NodeID scannerReporting;
        NodeID scannedDevice;
        int overallFlags;
        List<Block> blocks;

        public NodeID getScannerReporting() {
            return this.scannerReporting;
        }

        public NodeID getScannedDevice() {
            return this.scannedDevice;
        }

        public int getOverallFlags() {
            return this.overallFlags;
        }

        public List<Block> getBlocks() {
            return this.blocks;
        }

        public Content(NodeID scannerReporting, NodeID scannedDevice, int overallFlags, List<Block> blocks) {
            this.scannerReporting = scannerReporting;
            this.scannedDevice = scannedDevice;
            this.overallFlags = overallFlags;
            this.blocks = blocks;
        }
    }

    @Immutable
    public static class Block {
        int length;
        Type type;
        byte[] content;

        Block(Type type, byte[] content) {
            this.length = content.length;
            this.type = type;
            this.content = content;
        }

        public int getLength() {
            return this.length;
        }

        public Type getType() {
            return this.type;
        }

        public byte[] getContent() {
            return this.content;
        }

        public static enum Type {
            RESERVED(0, "Reserved"),
            READABLE(1, "Readable"),
            RFID(2, "RFID"),
            QR(3, "QR"),
            RAILCOM(4, "RailCom"),
            TRANSPONDING(5, "Transponding"),
            POSITION(6, "Position"),
            DCCADDRESS(7, "DccAddress"),
            SETSPEED(8, "Set Speed"),
            COMMANDEDSPEED(9, "Commanded Speed"),
            ACTUALSPEED(10, "Actual Speed"),
            ANALOG(11, "Analog");

            int code;
            String name;
            private static Map<Integer, Type> mapping;

            private Type(int code, String name) {
                this.code = code;
                this.name = name;
                Type.getMap().put(code, this);
            }

            public String toString() {
                return this.name;
            }

            public static Type get(Integer type) {
                return mapping.get(type);
            }

            private static Map<Integer, Type> getMap() {
                if (mapping == null) {
                    mapping = new HashMap<Integer, Type>();
                }
                return mapping;
            }
        }
    }

    @Immutable
    public static class AnalogBlock
    extends Block {
        Unit unit;
        double value;
        String text;

        AnalogBlock(byte[] content) {
            super(Block.Type.ANALOG, content);
            this.value = new Float16(content[1], content[2]).getFloat();
            this.unit = Unit.get(Integer.valueOf(content[3]));
            try {
                this.text = new String(Arrays.copyOfRange(content, 4, content.length), "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                this.text = "<UTF8 Error>";
            }
        }

        public Unit getUnit() {
            return this.unit;
        }

        public double getValue() {
            return this.value;
        }

        public String getText() {
            return this.text;
        }

        public static enum Unit {
            UNKNOWN(0, "Unknown"),
            VOLTS(1, "Volts"),
            AMPERES(2, "Amperes"),
            WATTS(3, "Watts"),
            OHMS(4, "OHMS"),
            DEGREESC(5, "Degrees C"),
            SECONDS(6, "Seconds"),
            METERS(7, "Meters"),
            METERS2(8, "Meters^2"),
            METERS3(9, "Meters^3"),
            METERSPERSECOND(10, "Meters/Second"),
            METERSPERSECOND2(11, "Meters/Second^2"),
            KILOGRAMS(12, "Kilograms"),
            NEWTONS(13, "Newtons");

            int code;
            String name;
            private static Map<Integer, Unit> mapping;

            private Unit(int code, String name) {
                this.code = code;
                this.name = name;
                Unit.getMap().put(code, this);
            }

            public String toString() {
                return this.name;
            }

            public static Unit get(Integer unit) {
                return mapping.get(unit);
            }

            private static Map<Integer, Unit> getMap() {
                if (mapping == null) {
                    mapping = new HashMap<Integer, Unit>();
                }
                return mapping;
            }
        }
    }

    @Immutable
    public static class ReadableBlock
    extends Block {
        String text;

        ReadableBlock(byte[] content) {
            super(Block.Type.READABLE, content);
            try {
                this.text = new String(Arrays.copyOfRange(content, 1, content.length), "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                this.text = "<UTF8 Error>";
            }
        }

        public String getText() {
            return this.text;
        }
    }
}

