/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.implementations;

import org.openlcb.NodeID;
import org.openlcb.OlcbInterface;
import org.openlcb.implementations.MemoryConfigurationService;

public class MemoryConfigSpaceRetriever {
    static final int LENGTH = 64;
    final NodeID node;
    final MemoryConfigurationService service;
    final int space;
    final Callback cb;
    long nextAddress = 0L;
    StringBuffer buf;

    public MemoryConfigSpaceRetriever(NodeID node, OlcbInterface iface, int space, Callback cb) {
        this.node = node;
        this.service = iface.getMemoryConfigurationService();
        this.space = space;
        this.cb = cb;
        this.nextAddress = 0L;
        this.buf = new StringBuffer();
        this.nextRequest();
    }

    void nextRequest() {
        MemoryConfigurationService.McsReadHandler memo = new MemoryConfigurationService.McsReadHandler(){

            @Override
            public void handleFailure(int code) {
                MemoryConfigSpaceRetriever.this.cb.onFailure(code);
            }

            @Override
            public void handleReadData(NodeID dest, int space, long address, byte[] data) {
                if (data.length == 0) {
                    MemoryConfigSpaceRetriever.this.done();
                    return;
                }
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] == 0) {
                        MemoryConfigSpaceRetriever.this.done();
                        return;
                    }
                    MemoryConfigSpaceRetriever.this.buf.append((char)data[i]);
                }
                MemoryConfigSpaceRetriever.this.nextAddress += 64L;
                MemoryConfigSpaceRetriever.this.nextRequest();
            }
        };
        this.service.requestRead(this.node, this.space, this.nextAddress, 64, memo);
    }

    private void done() {
        this.cb.onSuccess(this.buf.toString());
    }

    public static interface Callback {
        public void onSuccess(String var1);

        public void onFailure(int var1);
    }
}

