/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.implementations;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.openlcb.implementations.VersionedValue;

public abstract class VersionedValueListener<T>
implements PropertyChangeListener {
    int ownerVersion;
    protected VersionedValue<T> parent;

    public VersionedValueListener(VersionedValue<T> parent) {
        this.parent = parent;
        parent.addPropertyChangeListener(this);
        this.ownerVersion = parent.getVersion();
    }

    public void release() {
        this.parent.removePropertyChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        int pVersion = this.parent.getVersion();
        boolean isUpdated = false;
        VersionedValueListener versionedValueListener = this;
        synchronized (versionedValueListener) {
            if (pVersion > this.ownerVersion) {
                this.ownerVersion = pVersion;
                isUpdated = true;
            }
        }
        if (isUpdated) {
            this.update(this.parent.getLatestData());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFromOwner(T t) {
        int newVersion;
        VersionedValueListener versionedValueListener = this;
        synchronized (versionedValueListener) {
            this.ownerVersion = newVersion = this.parent.getNewVersion();
        }
        this.parent.set(newVersion, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFromOwnerWithForceNotify(T t) {
        int newVersion;
        VersionedValueListener versionedValueListener = this;
        synchronized (versionedValueListener) {
            this.ownerVersion = newVersion = this.parent.getNewVersion();
        }
        this.parent.setWithForceNotify(newVersion, t);
    }

    public void pingUpdater() {
        this.update(this.parent.getLatestData());
    }

    public abstract void update(T var1);
}

