/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.implementations.throttle;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openlcb.Connection;
import org.openlcb.EventID;
import org.openlcb.MessageDecoder;
import org.openlcb.NodeID;
import org.openlcb.ProducerConsumerEventReportMessage;
import org.openlcb.ProducerIdentifiedMessage;

public abstract class AbstractNodeCache<T>
extends MessageDecoder {
    public static final String UPDATE_PROP_CACHE = "cache";
    HashMap<NodeID, Integer> index = new HashMap();
    ArrayList<T> list = new ArrayList();
    EventID indicator;
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public AbstractNodeCache(EventID indicator) {
        this.indicator = indicator;
    }

    public T[] getCache() {
        return this.list.toArray();
    }

    public T getCache(int index) throws ArrayIndexOutOfBoundsException {
        return this.list.get(index);
    }

    public List<T> getList() {
        return this.list;
    }

    @Override
    public void handleProducerConsumerEventReport(ProducerConsumerEventReportMessage msg, Connection sender) {
        EventID evt = msg.getEventID();
        this.processEvent(msg.getSourceNodeID(), evt);
    }

    private synchronized void processEvent(NodeID src, EventID evt) {
        if (!evt.equals(this.indicator)) {
            return;
        }
        if (this.index.containsKey(src)) {
            return;
        }
        T node = this.newObject(src);
        this.list.add(node);
        int last = this.list.size() - 1;
        this.index.put(src, last);
        this.firePropertyChange(UPDATE_PROP_CACHE, null, node);
    }

    @Override
    public void handleProducerIdentified(ProducerIdentifiedMessage msg, Connection sender) {
        EventID evt = msg.getEventID();
        this.processEvent(msg.getSourceNodeID(), evt);
    }

    protected abstract T newObject(NodeID var1);

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    protected void firePropertyChange(String p, Object old, Object n) {
        this.pcs.firePropertyChange(p, old, n);
    }
}

