/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.implementations.throttle;

import org.openlcb.MimicNodeStore;
import org.openlcb.NodeID;
import org.openlcb.implementations.DatagramService;
import org.openlcb.implementations.throttle.ThrottleFunctionDatagram;
import org.openlcb.implementations.throttle.ThrottleSpeedDatagram;

public class ThrottleImplementation {
    MimicNodeStore store;
    DatagramService service;
    NodeID dest;

    public ThrottleImplementation(NodeID node, MimicNodeStore store, DatagramService service) {
        this.dest = node;
        this.store = store;
        this.service = service;
    }

    public ThrottleImplementation(int dccAddress, boolean dccLongAddress, MimicNodeStore store, DatagramService service) {
        this(ThrottleImplementation.createNodeIdFromDcc(dccAddress, dccLongAddress), store, service);
    }

    static NodeID createNodeIdFromDcc(int dccAddress, boolean dccLongAddress) {
        if (dccLongAddress) {
            return new NodeID(new byte[]{6, 1, 0, 0, (byte)(dccAddress >> 8 & 0xFF | 0xC0), (byte)(dccAddress & 0xFF)});
        }
        return new NodeID(new byte[]{6, 1, 0, 0, 0, (byte)(dccAddress & 0xFF)});
    }

    public void start() {
        this.store.findNode(this.dest);
    }

    public void setSpeed(double speed, boolean forward) {
        ThrottleSpeedDatagram tsd = new ThrottleSpeedDatagram(speed, forward);
        this.service.sendData(this.dest, tsd.getData());
    }

    public void doEmergencyStop() {
        ThrottleSpeedDatagram tsd = new ThrottleSpeedDatagram();
        this.service.sendData(this.dest, tsd.getData());
    }

    public void setFunction(int number, int value) {
        ThrottleFunctionDatagram tsd = new ThrottleFunctionDatagram(number, value);
        this.service.sendData(this.dest, tsd.getData());
    }
}

