/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.implementations.throttle;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.openlcb.Connection;
import org.openlcb.MessageDecoder;
import org.openlcb.NodeID;
import org.openlcb.OlcbInterface;
import org.openlcb.implementations.VersionedValue;
import org.openlcb.implementations.VersionedValueListener;
import org.openlcb.implementations.throttle.RemoteTrainNode;
import org.openlcb.messages.TractionControlReplyMessage;
import org.openlcb.messages.TractionControlRequestMessage;

public class TractionThrottle
extends MessageDecoder {
    public static final int CONSIST_FLAG_REVERSE = 2;
    public static final int CONSIST_FLAG_FN0 = 4;
    public static final int CONSIST_FLAG_FNN = 8;
    public static final String UPDATE_PROP_ENABLED = "updateEnabled";
    public static final String UPDATE_PROP_STATUS = "updateStatus";
    public static final String UPDATE_PROP_CONSISTLIST = "updateConsistList";
    private static final Logger logger = Logger.getLogger(TractionThrottle.class.getName());
    private final OlcbInterface iface;
    RemoteTrainNode trainNode;
    boolean assigned = false;
    boolean enabled = false;
    String status;
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private VersionedValue<Float> speed = new VersionedValue<Float>(Float.valueOf(0.0f));
    private VersionedValueListener<Float> speedUpdater = new VersionedValueListener<Float>(this.speed){

        @Override
        public void update(Float t) {
            if (!TractionThrottle.this.enabled) {
                return;
            }
            TractionControlRequestMessage m = Float.isNaN(t.floatValue()) ? TractionControlRequestMessage.createSetEstop(TractionThrottle.this.iface.getNodeId(), TractionThrottle.this.trainNode.getNodeId()) : TractionControlRequestMessage.createSetSpeed(TractionThrottle.this.iface.getNodeId(), TractionThrottle.this.trainNode.getNodeId(), Math.copySign(1.0, (double)t.floatValue()) >= 0.0, t.floatValue());
            TractionThrottle.this.iface.getOutputConnection().put(m, TractionThrottle.this);
        }
    };
    private Map<Integer, FunctionInfo> functions = new HashMap<Integer, FunctionInfo>();
    private boolean pendingAssign = false;
    private List<ConsistEntry> consistList = new ArrayList<ConsistEntry>();
    private boolean needFetchConsist = false;

    public TractionThrottle(OlcbInterface iface) {
        this.iface = iface;
    }

    public void start(RemoteTrainNode trainNode) {
        if (this.assigned && !this.trainNode.getNodeId().equals(trainNode.getNodeId())) {
            this.release();
        }
        this.trainNode = trainNode;
        this.assign();
    }

    @Nullable
    public NodeID getNodeId() {
        if (this.trainNode == null) {
            return null;
        }
        return this.trainNode.getNodeId();
    }

    public void refresh() {
        if (!this.getEnabled()) {
            return;
        }
        this.querySpeed();
        this.queryConsist();
        for (FunctionInfo f : this.functions.values()) {
            this.queryFunction(f.fn);
        }
    }

    public void release() {
        if (!this.assigned) {
            return;
        }
        TractionControlRequestMessage m = TractionControlRequestMessage.createConsistDetach(this.iface.getNodeId(), this.trainNode.getNodeId(), this.iface.getNodeId());
        this.iface.getOutputConnection().put(m, this);
        m = TractionControlRequestMessage.createReleaseController(this.iface.getNodeId(), this.trainNode.getNodeId());
        this.iface.getOutputConnection().put(m, this);
        this.assigned = false;
        this.setEnabled(false);
        this.iface.unRegisterMessageListener(this);
        this.setStatus("Released node.");
    }

    public List<ConsistEntry> getConsistList() {
        return this.consistList;
    }

    private void assign() {
        this.setStatus("Assigning node...");
        this.iface.registerMessageListener(this);
        this.pendingAssign = true;
        TractionControlRequestMessage m = TractionControlRequestMessage.createAssignController(this.iface.getNodeId(), this.trainNode.getNodeId());
        this.iface.getOutputConnection().put(m, this);
    }

    private void assignComplete() {
        this.assigned = true;
        this.setStatus("Enabled.");
        this.setEnabled(true);
        this.refresh();
        TractionControlRequestMessage m = TractionControlRequestMessage.createConsistAttach(this.iface.getNodeId(), this.trainNode.getNodeId(), this.iface.getNodeId(), 140);
        this.iface.getOutputConnection().put(m, this);
    }

    private void handleHeartbeatMessage(TractionControlReplyMessage msg) {
        TractionControlRequestMessage m = TractionControlRequestMessage.createNoop(this.iface.getNodeId(), this.trainNode.getNodeId());
        this.iface.getOutputConnection().put(m, this);
    }

    public void querySpeed() {
        TractionControlRequestMessage m = TractionControlRequestMessage.createGetSpeed(this.iface.getNodeId(), this.trainNode.getNodeId());
        this.iface.getOutputConnection().put(m, this);
    }

    public void queryConsist() {
        this.consistList.clear();
        this.needFetchConsist = true;
        TractionControlRequestMessage m = TractionControlRequestMessage.createConsistLengthQuery(this.iface.getNodeId(), this.trainNode.getNodeId());
        this.iface.getOutputConnection().put(m, this);
    }

    public void queryConsistMember(int index) {
        TractionControlRequestMessage m = TractionControlRequestMessage.createConsistIndexQuery(this.iface.getNodeId(), this.trainNode.getNodeId(), index);
        this.iface.getOutputConnection().put(m, this);
    }

    public void addToConsist(NodeID newMember, int flags) {
        TractionControlRequestMessage m = TractionControlRequestMessage.createConsistAttach(this.iface.getNodeId(), this.trainNode.getNodeId(), newMember, flags);
        this.iface.getOutputConnection().put(m, this);
        m = TractionControlRequestMessage.createConsistAttach(this.iface.getNodeId(), newMember, this.trainNode.getNodeId(), flags);
        this.iface.getOutputConnection().put(m, this);
    }

    public void removeFromConsist(NodeID member) {
        TractionControlRequestMessage m = TractionControlRequestMessage.createConsistDetach(this.iface.getNodeId(), this.trainNode.getNodeId(), member);
        this.iface.getOutputConnection().put(m, this);
        m = TractionControlRequestMessage.createConsistDetach(this.iface.getNodeId(), member, this.trainNode.getNodeId());
        this.iface.getOutputConnection().put(m, this);
    }

    public void queryFunction(int fn) {
        TractionControlRequestMessage m = TractionControlRequestMessage.createGetFn(this.iface.getNodeId(), this.trainNode.getNodeId(), fn);
        this.iface.getOutputConnection().put(m, this);
    }

    public VersionedValue<Boolean> getFunction(int fn) {
        return this.getFunctionInfo((int)fn).shared;
    }

    private synchronized FunctionInfo getFunctionInfo(int fn) {
        FunctionInfo v = this.functions.get(fn);
        if (v == null) {
            logger.fine("Creating function " + fn);
            v = new FunctionInfo(fn);
            this.functions.put(fn, v);
            if (!this.pendingAssign) {
                this.queryFunction(fn);
            }
        }
        return v;
    }

    public VersionedValue<Float> getSpeed() {
        return this.speed;
    }

    @Override
    public void handleTractionControlReply(TractionControlReplyMessage msg, Connection sender) {
        if (this.trainNode == null) {
            return;
        }
        if (!msg.getSourceNodeID().equals(this.trainNode.getNodeId())) {
            return;
        }
        if (!msg.getDestNodeID().equals(this.iface.getNodeId())) {
            return;
        }
        try {
            if (msg.getCmd() == 32 && msg.getSubCmd() == 1) {
                byte result = msg.getAssignControllerReply();
                this.pendingAssign = false;
                if (result == 0) {
                    this.assignComplete();
                } else if ((result & 1) != 0) {
                    this.setStatus("Assigning controller failed: controller refused.");
                } else if ((result & 2) != 0) {
                    this.setStatus("Assigning controller failed: train node refused.");
                }
                return;
            }
            if (msg.getCmd() == 16) {
                this.speedUpdater.setFromOwner(Float.valueOf(msg.getSetSpeed().getFloat()));
                return;
            }
            if (msg.getCmd() == 17) {
                int fn = msg.getFnNumber();
                int val = msg.getFnVal();
                logger.fine("Function response: train function " + fn + " value " + val);
                this.getFunctionInfo((int)fn).fnUpdater.setFromOwner(val != 0);
                return;
            }
            if (msg.getCmd() == 48 && msg.getSubCmd() == 3) {
                int index;
                int length = msg.getConsistLength();
                boolean fireChange = false;
                if (length != this.consistList.size() || this.needFetchConsist) {
                    this.consistList.clear();
                    fireChange = true;
                    for (int i = 0; i < length; ++i) {
                        this.consistList.add(null);
                        this.queryConsistMember(i);
                    }
                    this.needFetchConsist = false;
                }
                if ((index = msg.getConsistIndex()) >= 0) {
                    NodeID n = msg.getConsistQueryNodeID();
                    int flags = msg.getConsistQueryFlags();
                    this.consistList.set(index, new ConsistEntry(n, flags));
                    fireChange = true;
                }
                if (fireChange) {
                    this.firePropertyChange(UPDATE_PROP_CONSISTLIST, null, this.consistList);
                }
                return;
            }
            if (msg.getCmd() == 48 && msg.getSubCmd() == 1) {
                this.queryConsist();
                return;
            }
            if (msg.getCmd() == 48 && msg.getSubCmd() == 2) {
                this.queryConsist();
                return;
            }
            if (msg.getCmd() == 64 && msg.getSubCmd() == 3) {
                this.handleHeartbeatMessage(msg);
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            logger.warning("Invalid traction message " + msg.toString());
            return;
        }
        logger.info("Unhandled traction response message " + msg.toString());
    }

    @Override
    public void handleTractionControlRequest(TractionControlRequestMessage msg, Connection sender) {
        if (this.trainNode == null) {
            return;
        }
        if (!msg.getSourceNodeID().equals(this.trainNode.getNodeId())) {
            return;
        }
        if (!msg.getDestNodeID().equals(this.iface.getNodeId())) {
            return;
        }
        try {
            if (msg.getCmd() == 0) {
                this.speedUpdater.setFromOwner(Float.valueOf(msg.getSpeed().getFloat()));
                return;
            }
            if (msg.getCmd() == 2) {
                this.speedUpdater.setFromOwner(Float.valueOf(Float.NaN));
                return;
            }
            if (msg.getCmd() == 1) {
                int fn = msg.getFnNumber();
                int val = msg.getFnVal();
                logger.fine("Function request: train function " + fn + " value " + val);
                this.getFunctionInfo((int)fn).fnUpdater.setFromOwner(val != 0);
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            logger.warning("Invalid traction message " + msg.toString());
            return;
        }
        logger.info("Unhandled traction request message (to listener) " + msg.toString());
    }

    public String getStatus() {
        return this.status;
    }

    private void setStatus(String status) {
        logger.fine("Throttle status: " + status);
        String oldStatus = this.status;
        this.status = status;
        this.firePropertyChange(UPDATE_PROP_STATUS, oldStatus, this.status);
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    private void setEnabled(boolean enabled_) {
        boolean old = this.enabled;
        this.enabled = enabled_;
        this.firePropertyChange(UPDATE_PROP_ENABLED, old, this.enabled);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    protected void firePropertyChange(String p, Object old, Object n) {
        this.pcs.firePropertyChange(p, old, n);
    }

    private class FunctionInfo {
        int fn;
        VersionedValue<Boolean> shared = new VersionedValue<Boolean>(false);
        VersionedValueListener<Boolean> fnUpdater = new VersionedValueListener<Boolean>(this.shared){

            @Override
            public void update(Boolean aBoolean) {
                if (!TractionThrottle.this.enabled) {
                    return;
                }
                TractionControlRequestMessage m = TractionControlRequestMessage.createSetFn(TractionThrottle.this.iface.getNodeId(), TractionThrottle.this.trainNode.getNodeId(), FunctionInfo.this.fn, aBoolean != false ? 1 : 0);
                TractionThrottle.this.iface.getOutputConnection().put(m, TractionThrottle.this);
            }
        };

        public FunctionInfo(int num) {
            this.fn = num;
        }
    }

    public class ConsistEntry {
        public NodeID node;
        public int flags;

        ConsistEntry(NodeID n, int f) {
            this.node = n;
            this.flags = f;
        }
    }
}

