/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.messages;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.logging.Logger;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.openlcb.AddressedPayloadMessage;
import org.openlcb.Connection;
import org.openlcb.MessageDecoder;
import org.openlcb.MessageTypeIdentifier;
import org.openlcb.NodeID;
import org.openlcb.Utilities;
import org.openlcb.implementations.throttle.Float16;
import org.openlcb.messages.TractionControlRequestMessage;

@Immutable
@ThreadSafe
public class TractionControlReplyMessage
extends AddressedPayloadMessage {
    private static final Logger logger = Logger.getLogger(TractionControlReplyMessage.class.getName());
    public static final byte CMD_GET_SPEED = 16;
    public static final int GET_SPEED_FLAG_ESTOP = 1;
    public static final byte CMD_GET_FN = 17;
    public static final byte CMD_CONTROLLER = 32;
    public static final byte SUBCMD_CONTROLLER_ASSIGN = 1;
    public static final byte SUBCMD_CONTROLLER_QUERY = 3;
    public static final byte SUBCMD_CONTROLLER_CHANGE = 4;
    public static final byte CMD_MGMT = 64;
    public static final byte SUBCMD_MGMT_RESERVE = 1;
    public static final byte SUBCMD_MGMT_HEARTBEAT = 3;
    public static final byte CMD_CONSIST = 48;
    public static final byte SUBCMD_CONSIST_ATTACH = 1;
    public static final byte SUBCMD_CONSIST_DETACH = 2;
    public static final byte SUBCMD_CONSIST_QUERY = 3;

    public TractionControlReplyMessage(NodeID source, NodeID dest, byte[] payload) {
        super(source, dest, payload);
    }

    public byte getCmd() throws ArrayIndexOutOfBoundsException {
        return this.payload[0];
    }

    public byte getSubCmd() throws ArrayIndexOutOfBoundsException {
        return this.payload[1];
    }

    public byte getAssignControllerReply() throws ArrayIndexOutOfBoundsException {
        return this.payload[2];
    }

    public NodeID getCurrentControllerReply() throws ArrayIndexOutOfBoundsException {
        if (this.payload.length < 8) {
            throw new ArrayIndexOutOfBoundsException();
        }
        byte[] nid = new byte[6];
        System.arraycopy(this.payload, 3, nid, 0, 6);
        return new NodeID(nid);
    }

    public byte getReserveReply() throws ArrayIndexOutOfBoundsException {
        return this.payload[2];
    }

    public Float16 getSetSpeed() throws ArrayIndexOutOfBoundsException {
        Float16 f = new Float16(this.payload[1], this.payload[2]);
        logger.finest("Incoming float16 " + this.payload[1] + "." + this.payload[2] + "= " + f.getFloat());
        return f;
    }

    public Float16 getCommandedSpeed() throws ArrayIndexOutOfBoundsException {
        return new Float16(this.payload[4], this.payload[5]);
    }

    public Float16 getActualSpeed() throws ArrayIndexOutOfBoundsException {
        return new Float16(this.payload[6], this.payload[7]);
    }

    public int getFnNumber() {
        int retval = 0;
        retval = this.payload[1] & 0xFF;
        retval <<= 8;
        retval |= this.payload[2] & 0xFF;
        retval <<= 8;
        return retval |= this.payload[3] & 0xFF;
    }

    public int getFnVal() {
        int retval = 0;
        retval = this.payload[4] & 0xFF;
        retval <<= 8;
        return retval |= this.payload[5] & 0xFF;
    }

    @Nullable
    public NodeID getConsistAttachNodeID() {
        if (this.payload.length < 8) {
            return null;
        }
        byte[] id = new byte[6];
        System.arraycopy(this.payload, 2, id, 0, 6);
        return new NodeID(id);
    }

    public int getConsistAttachCode() {
        return Utilities.NetworkToHostUint16(this.payload, 8);
    }

    public int getConsistLength() {
        int uintval = this.payload[2];
        int retval = uintval < 0 ? uintval + 256 : uintval;
        return retval;
    }

    public int getConsistIndex() {
        if (this.payload.length < 4) {
            return -1;
        }
        int uintval = this.payload[3];
        int retval = uintval < 0 ? uintval + 256 : uintval;
        return retval;
    }

    @Nullable
    public NodeID getConsistQueryNodeID() {
        if (this.payload.length < 11) {
            return null;
        }
        byte[] id = new byte[6];
        System.arraycopy(this.payload, 5, id, 0, 6);
        return new NodeID(id);
    }

    public int getConsistQueryFlags() {
        if (this.payload.length < 11) {
            return 0;
        }
        return this.payload[4];
    }

    @Override
    public void applyTo(MessageDecoder decoder, Connection sender) {
        decoder.handleTractionControlReply(this, sender);
    }

    @Override
    public MessageTypeIdentifier getEMTI() {
        return MessageTypeIdentifier.TractionControlReply;
    }

    @Override
    public String toString() {
        StringBuilder p;
        block34: {
            p = new StringBuilder(this.getSourceNodeID().toString());
            p.append(" - ");
            p.append(this.getDestNodeID());
            p.append(" ");
            p.append(this.getEMTI().toString());
            p.append(" ");
            try {
                block1 : switch (this.getCmd()) {
                    case 16: {
                        p.append("speed reply ");
                        p.append(TractionControlRequestMessage.speedToDebugString(this.getSetSpeed()));
                        if (this.payload.length >= 4 && (this.payload[3] & 1) != 0) {
                            p.append(" estop");
                        }
                        if (this.payload.length >= 6) {
                            p.append(" commanded speed ");
                            p.append(TractionControlRequestMessage.speedToDebugString(this.getCommandedSpeed()));
                        }
                        if (this.payload.length >= 8) {
                            p.append(" actual speed ");
                            p.append(TractionControlRequestMessage.speedToDebugString(this.getActualSpeed()));
                        }
                        break;
                    }
                    case 17: {
                        int fn = Utilities.NetworkToHostUint24(this.payload, 1);
                        int val = Utilities.NetworkToHostUint16(this.payload, 4);
                        p.append(String.format("fn %d is %d", fn, val));
                        break;
                    }
                    case 32: {
                        switch (this.getSubCmd()) {
                            case 1: {
                                p.append("controller assign");
                                int flags = Utilities.NetworkToHostUint8(this.payload, 2);
                                if (flags == 0) {
                                    p.append(" OK");
                                    break block1;
                                }
                                p.append(String.format(" fail 0x%02x", flags));
                                break block1;
                            }
                            case 3: {
                                long nid = Utilities.NetworkToHostUint48(this.payload, 3);
                                p.append("controller is ");
                                p.append(new NodeID(nid).toString());
                                int flags = Utilities.NetworkToHostUint8(this.payload, 2);
                                if (flags != 0) {
                                    p.append(String.format(" flags 0x%02x", flags));
                                    break block1;
                                }
                                break block34;
                            }
                            case 4: {
                                p.append("change controller reply");
                                int flags = Utilities.NetworkToHostUint8(this.payload, 2);
                                if (flags == 0) {
                                    p.append(" OK");
                                    break block1;
                                }
                                p.append(String.format(" reject 0x%02x", flags));
                                break block1;
                            }
                            default: {
                                return super.toString();
                            }
                        }
                    }
                    case 48: {
                        switch (this.getSubCmd()) {
                            case 1: {
                                long nid = Utilities.NetworkToHostUint48(this.payload, 2);
                                p.append("listener attach ");
                                p.append(new NodeID(nid).toString());
                                int code = Utilities.NetworkToHostUint16(this.payload, 8);
                                p.append(String.format(" result 0x%04x", code));
                                break block1;
                            }
                            case 2: {
                                long nid = Utilities.NetworkToHostUint48(this.payload, 2);
                                p.append("listener detach ");
                                p.append(new NodeID(nid).toString());
                                int code = Utilities.NetworkToHostUint16(this.payload, 8);
                                p.append(String.format(" result 0x%04x", code));
                                break block1;
                            }
                            case 3: {
                                p.append("listener is");
                                int count = Utilities.NetworkToHostUint8(this.payload, 2);
                                p.append(String.format(" count %d", this.payload[2] & 0xFF));
                                if (this.payload.length >= 4) {
                                    p.append(String.format(" index %d", this.payload[3] & 0xFF));
                                }
                                if (this.payload.length >= 5 && this.payload[4] != 0) {
                                    p.append(" flags ");
                                    p.append(TractionControlRequestMessage.consistFlagsToDebugString(this.payload[4]));
                                }
                                if (this.payload.length >= 11) {
                                    p.append(" is ");
                                    p.append(new NodeID(Utilities.NetworkToHostUint48(this.payload, 5)).toString());
                                    break block1;
                                }
                                break block34;
                            }
                            default: {
                                return super.toString();
                            }
                        }
                    }
                    case 64: {
                        switch (this.getSubCmd()) {
                            case 1: {
                                p.append("reserve reply");
                                if (this.payload[2] == 0) {
                                    p.append(" OK");
                                    break block1;
                                }
                                p.append(String.format(" error 0x%02x", this.payload[2] & 0xFF));
                                break block1;
                            }
                            case 3: {
                                p.append("heartbeat request");
                                if (this.payload.length >= 3) {
                                    p.append(String.format(" in %d seconds", this.payload[2] & 0xFF));
                                    break block1;
                                }
                                break block34;
                            }
                            default: {
                                return super.toString();
                            }
                        }
                    }
                    default: {
                        return super.toString();
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return super.toString();
            }
        }
        return p.toString();
    }
}

