/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.messages;

import java.util.logging.Logger;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.openlcb.AddressedPayloadMessage;
import org.openlcb.Connection;
import org.openlcb.MessageDecoder;
import org.openlcb.MessageTypeIdentifier;
import org.openlcb.NodeID;
import org.openlcb.Utilities;
import org.openlcb.implementations.throttle.Float16;

@Immutable
@ThreadSafe
public class TractionControlRequestMessage
extends AddressedPayloadMessage {
    private static final Logger logger = Logger.getLogger(TractionControlRequestMessage.class.getName());
    public static final byte CMD_SET_SPEED = 0;
    public static final byte CMD_SET_FN = 1;
    public static final byte CMD_ESTOP = 2;
    public static final byte CMD_GET_SPEED = 16;
    public static final byte CMD_GET_FN = 17;
    public static final byte CMD_CONTROLLER = 32;
    public static final byte SUBCMD_CONTROLLER_ASSIGN = 1;
    public static final byte SUBCMD_CONTROLLER_RELEASE = 2;
    public static final byte SUBCMD_CONTROLLER_QUERY = 3;
    public static final byte SUBCMD_CONTROLLER_CHANGE = 4;
    public static final byte CMD_CONSIST = 48;
    public static final byte SUBCMD_CONSIST_ATTACH = 1;
    public static final byte SUBCMD_CONSIST_DETACH = 2;
    public static final byte SUBCMD_CONSIST_QUERY = 3;
    public static final int CONSIST_FLAG_ALIAS = 1;
    public static final int CONSIST_FLAG_REVERSE = 2;
    public static final int CONSIST_FLAG_FN0 = 4;
    public static final int CONSIST_FLAG_FNN = 8;
    public static final int CONSIST_FLAG_HIDE = 128;
    public static final int CONSIST_FLAG_LISTENERS = 140;
    public static final byte CMD_MGMT = 64;
    public static final byte SUBCMD_MGMT_RESERVE = 1;
    public static final byte SUBCMD_MGMT_RELEASE = 2;
    public static final byte SUBCMD_MGMT_NOOP = 3;
    public static final byte CMD_LISTENER_FORWARD = -128;
    public static final double MPH = 0.44704;
    public static final double KMH = 0.277778;

    public TractionControlRequestMessage(NodeID source, NodeID dest, byte[] payload) {
        super(source, dest, payload);
        this.payload = (byte[])payload.clone();
    }

    public static TractionControlRequestMessage createSetSpeed(NodeID source, NodeID dest, boolean isForward, double speed) {
        if (isForward) {
            if (speed < 0.0) {
                speed = -speed;
            }
        } else if (speed >= 0.0) {
            speed = -speed;
        }
        Float16 sp = new Float16(speed, isForward);
        logger.finest("Traction set speed: isFwd=" + isForward + " speed " + speed + " set speed " + sp.getByte1() + "." + sp.getByte2());
        byte[] payload = new byte[]{0, sp.getByte1(), sp.getByte2()};
        return new TractionControlRequestMessage(source, dest, payload);
    }

    public static TractionControlRequestMessage createSetEstop(NodeID source, NodeID dest) {
        return new TractionControlRequestMessage(source, dest, new byte[]{2});
    }

    public static TractionControlRequestMessage createGetSpeed(NodeID source, NodeID dest) {
        return new TractionControlRequestMessage(source, dest, new byte[]{16});
    }

    public static TractionControlRequestMessage createSetFn(NodeID source, NodeID dest, int fn, int val) {
        byte[] payload = new byte[]{1, (byte)(fn >> 16 & 0xFF), (byte)(fn >> 8 & 0xFF), (byte)(fn & 0xFF), (byte)(val >> 8 & 0xFF), (byte)(val & 0xFF)};
        return new TractionControlRequestMessage(source, dest, payload);
    }

    public static TractionControlRequestMessage createGetFn(NodeID source, NodeID dest, int fn) {
        byte[] payload = new byte[]{17, (byte)(fn >> 16 & 0xFF), (byte)(fn >> 8 & 0xFF), (byte)(fn & 0xFF)};
        return new TractionControlRequestMessage(source, dest, payload);
    }

    public static TractionControlRequestMessage createAssignController(NodeID source, NodeID dest) {
        byte[] payload = new byte[]{32, 1, 0, 1, 2, 3, 4, 5, 6};
        System.arraycopy(source.getContents(), 0, payload, 3, 6);
        return new TractionControlRequestMessage(source, dest, payload);
    }

    public static TractionControlRequestMessage createReleaseController(NodeID source, NodeID dest) {
        byte[] payload = new byte[]{32, 2, 0, 1, 2, 3, 4, 5, 6};
        System.arraycopy(source.getContents(), 0, payload, 3, 6);
        return new TractionControlRequestMessage(source, dest, payload);
    }

    public static TractionControlRequestMessage createQueryController(NodeID source, NodeID dest) {
        byte[] payload = new byte[]{32, 3};
        return new TractionControlRequestMessage(source, dest, payload);
    }

    public static TractionControlRequestMessage createControllerChangeNotify(NodeID source, NodeID dest, NodeID newController) {
        byte[] payload = new byte[]{32, 4, 0, 1, 2, 3, 4, 5, 6};
        System.arraycopy(newController.getContents(), 0, payload, 3, 6);
        return new TractionControlRequestMessage(source, dest, payload);
    }

    public static TractionControlRequestMessage createConsistAttach(NodeID source, NodeID dest, NodeID consistEntry, int flags) {
        byte[] payload = new byte[]{48, 1, (byte)(flags & 0xFF), 1, 2, 3, 4, 5, 6};
        System.arraycopy(consistEntry.getContents(), 0, payload, 3, 6);
        return new TractionControlRequestMessage(source, dest, payload);
    }

    public static TractionControlRequestMessage createConsistDetach(NodeID source, NodeID dest, NodeID consistEntry) {
        byte[] payload = new byte[]{48, 2, 0, 1, 2, 3, 4, 5, 6};
        System.arraycopy(consistEntry.getContents(), 0, payload, 3, 6);
        return new TractionControlRequestMessage(source, dest, payload);
    }

    public static TractionControlRequestMessage createConsistIndexQuery(NodeID source, NodeID dest, int index) {
        byte[] payload = new byte[]{48, 3, (byte)(index & 0xFF)};
        return new TractionControlRequestMessage(source, dest, payload);
    }

    public static TractionControlRequestMessage createConsistLengthQuery(NodeID source, NodeID dest) {
        byte[] payload = new byte[]{48, 3};
        return new TractionControlRequestMessage(source, dest, payload);
    }

    public static TractionControlRequestMessage createReserve(NodeID source, NodeID dest) {
        byte[] payload = new byte[]{64, 1};
        return new TractionControlRequestMessage(source, dest, payload);
    }

    public static TractionControlRequestMessage createRelease(NodeID source, NodeID dest) {
        byte[] payload = new byte[]{64, 2};
        return new TractionControlRequestMessage(source, dest, payload);
    }

    public static TractionControlRequestMessage createNoop(NodeID source, NodeID dest) {
        byte[] payload = new byte[]{64, 3};
        return new TractionControlRequestMessage(source, dest, payload);
    }

    public byte getCmd() throws ArrayIndexOutOfBoundsException {
        int p = this.payload[0] & 0xFF;
        return (byte)(p & 0x7F);
    }

    public boolean isListenerMessage() {
        return (this.payload[0] & 0xFFFFFF80) != 0;
    }

    public byte getSubCmd() throws ArrayIndexOutOfBoundsException {
        return this.payload[1];
    }

    public Float16 getSpeed() throws ArrayIndexOutOfBoundsException {
        return new Float16(this.payload[1] << 8 | this.payload[2] & 0xFF);
    }

    public int getFnNumber() {
        int retval = 0;
        retval = this.payload[1] & 0xFF;
        retval <<= 8;
        retval |= this.payload[2] & 0xFF;
        retval <<= 8;
        return retval |= this.payload[3] & 0xFF;
    }

    public int getFnVal() {
        int retval = 0;
        retval = this.payload[4] & 0xFF;
        retval <<= 8;
        return retval |= this.payload[5] & 0xFF;
    }

    @Override
    public void applyTo(MessageDecoder decoder, Connection sender) {
        decoder.handleTractionControlRequest(this, sender);
    }

    @Override
    public MessageTypeIdentifier getEMTI() {
        return MessageTypeIdentifier.TractionControlRequest;
    }

    public static String speedToDebugString(Float16 sp) {
        StringBuilder p = new StringBuilder();
        if (sp.isPositive()) {
            p.append('F');
        } else {
            p.append('R');
        }
        p.append(" ");
        double dsp = Math.abs(sp.getFloat());
        double mph = dsp / 0.44704;
        p.append(String.format("%.0f mph", mph));
        return p.toString();
    }

    public static String consistFlagsToDebugString(int flags) {
        StringBuilder b = new StringBuilder();
        if ((flags & 1) != 0) {
            b.append("alias,");
        }
        if ((flags & 2) != 0) {
            b.append("reverse,");
        }
        if ((flags & 4) != 0) {
            b.append("link-f0,");
        }
        if ((flags & 8) != 0) {
            b.append("link-f*,");
        }
        if ((flags & 0x80) != 0) {
            b.append("hide,");
        }
        if (b.length() > 0) {
            b.deleteCharAt(b.length() - 1);
        }
        return b.toString();
    }

    @Override
    public String toString() {
        StringBuilder p;
        block35: {
            p = new StringBuilder(this.getSourceNodeID().toString());
            p.append(" - ");
            p.append(this.getDestNodeID());
            p.append(" ");
            p.append(this.getEMTI().toString());
            p.append(" ");
            if (this.isListenerMessage()) {
                p.append("[listener] ");
            }
            try {
                block1 : switch (this.getCmd()) {
                    case 0: {
                        p.append("set speed ");
                        p.append(TractionControlRequestMessage.speedToDebugString(this.getSpeed()));
                        break;
                    }
                    case 16: {
                        p.append("get speed");
                        break;
                    }
                    case 2: {
                        p.append("set estop");
                        break;
                    }
                    case 1: {
                        int fn = Utilities.NetworkToHostUint24(this.payload, 1);
                        int val = Utilities.NetworkToHostUint16(this.payload, 4);
                        p.append(String.format("set fn %d to %d", fn, val));
                        break;
                    }
                    case 17: {
                        int fn = Utilities.NetworkToHostUint24(this.payload, 1);
                        p.append(String.format("get fn %d", fn));
                        break;
                    }
                    case 32: {
                        switch (this.getSubCmd()) {
                            case 1: {
                                long nid = Utilities.NetworkToHostUint48(this.payload, 3);
                                p.append("assign controller ");
                                p.append(new NodeID(nid).toString());
                                int flags = Utilities.NetworkToHostUint8(this.payload, 2);
                                if (flags != 0) {
                                    p.append(String.format(" flags 0x%02x", flags));
                                    break block1;
                                }
                                break block35;
                            }
                            case 2: {
                                long nid = Utilities.NetworkToHostUint48(this.payload, 3);
                                p.append("release controller ");
                                p.append(new NodeID(nid).toString());
                                int flags = Utilities.NetworkToHostUint8(this.payload, 2);
                                if (flags != 0) {
                                    p.append(String.format(" flags 0x%02x", flags));
                                    break block1;
                                }
                                break block35;
                            }
                            case 3: {
                                p.append("query controller");
                                break block1;
                            }
                            case 4: {
                                long nid = Utilities.NetworkToHostUint48(this.payload, 3);
                                p.append("notify controller change to ");
                                p.append(new NodeID(nid).toString());
                                int flags = Utilities.NetworkToHostUint8(this.payload, 2);
                                if (flags != 0) {
                                    p.append(String.format(" flags 0x%02x", flags));
                                    break block1;
                                }
                                break block35;
                            }
                            default: {
                                return super.toString();
                            }
                        }
                    }
                    case 48: {
                        switch (this.getSubCmd()) {
                            case 1: {
                                long nid = Utilities.NetworkToHostUint48(this.payload, 3);
                                int flags = Utilities.NetworkToHostUint8(this.payload, 2);
                                p.append("listener attach ");
                                p.append(new NodeID(nid).toString());
                                if (flags != 0) {
                                    p.append(" flags ");
                                    p.append(TractionControlRequestMessage.consistFlagsToDebugString(flags));
                                    break block1;
                                }
                                break block35;
                            }
                            case 2: {
                                long nid = Utilities.NetworkToHostUint48(this.payload, 3);
                                int flags = Utilities.NetworkToHostUint8(this.payload, 2);
                                p.append("listener detach ");
                                p.append(new NodeID(nid).toString());
                                if (flags != 0) {
                                    p.append(String.format(" flags 0x%02x", flags));
                                    break block1;
                                }
                                break block35;
                            }
                            case 3: {
                                p.append("listener query");
                                if (this.payload.length > 2) {
                                    p.append(String.format(" index %d", this.payload[2] & 0xFF));
                                    break block1;
                                }
                                break block35;
                            }
                            default: {
                                return super.toString();
                            }
                        }
                    }
                    case 64: {
                        switch (this.getSubCmd()) {
                            case 1: {
                                p.append("management reserve");
                                break block1;
                            }
                            case 2: {
                                p.append("management release");
                                break block1;
                            }
                            case 3: {
                                p.append("noop/heartbeat");
                                break block1;
                            }
                        }
                        return super.toString();
                    }
                    default: {
                        return super.toString();
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return super.toString();
            }
        }
        return p.toString();
    }
}

