/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.protocols;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.TimerTask;
import org.openlcb.Connection;
import org.openlcb.ConsumerRangeIdentifiedMessage;
import org.openlcb.DefaultPropertyListenerSupport;
import org.openlcb.EventID;
import org.openlcb.EventMessage;
import org.openlcb.EventState;
import org.openlcb.MessageDecoder;
import org.openlcb.MessageTypeIdentifier;
import org.openlcb.NodeID;
import org.openlcb.OlcbInterface;
import org.openlcb.ProducerConsumerEventReportMessage;
import org.openlcb.ProducerIdentifiedMessage;
import org.openlcb.ProducerRangeIdentifiedMessage;
import org.openlcb.protocols.TimeKeeper;
import org.openlcb.protocols.TimeProtocol;

public class TimeBroadcastGenerator
extends DefaultPropertyListenerSupport
implements TimeProtocol {
    private final Handler messageHandler = new Handler();
    private TimeZone timeZone = TimeZone.getDefault();
    private final OlcbInterface iface;
    private final NodeID clock;
    TimeKeeper timeKeeper;
    TimerTask delayedSyncTask = null;
    private TimerTask midnightTask = null;
    private long midnightScheduledTime = 0L;
    private long fastDayLastAnnounced;
    long RESYNC_DELAY_MSEC = 3000L;

    public TimeBroadcastGenerator(OlcbInterface iface, NodeID clock) {
        this.clock = clock;
        this.timeKeeper = new TimeKeeper();
        this.fastDayLastAnnounced = this.timeKeeper.matchingFastTime;
        this.iface = iface;
        iface.registerMessageListener(this.messageHandler);
        iface.getOutputConnection().registerStartNotification(new Connection.ConnectionListener(){

            @Override
            public void connectionActive(Connection c) {
                TimeBroadcastGenerator.this.sendStartupAction();
            }
        });
    }

    public void setTimeZone(TimeZone tz) {
        this.timeZone = tz;
    }

    public synchronized void dispose() {
        if (this.delayedSyncTask != null) {
            this.delayedSyncTask.cancel();
        }
        this.iface.unRegisterMessageListener(this.messageHandler);
    }

    private void sendStartupAction() {
        int producerSuffix = (this.clock.getContents()[5] & 1) == 0 ? 65535 : 0;
        this.sendClockEvent(producerSuffix, MessageTypeIdentifier.ProducerRangeIdentified);
        int consumerSuffix = 32768;
        this.sendClockEvent(consumerSuffix, MessageTypeIdentifier.ConsumerRangeIdentified);
    }

    private Calendar prepareTimeUpdate() {
        Calendar c = Calendar.getInstance(this.timeZone);
        c.setTimeInMillis(this.getTimeInMsec());
        return c;
    }

    private synchronized void triggerClockSyncIn3Sec() {
        if (this.delayedSyncTask != null) {
            this.delayedSyncTask.cancel();
            this.delayedSyncTask = null;
        }
        this.delayedSyncTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                TimeBroadcastGenerator timeBroadcastGenerator = TimeBroadcastGenerator.this;
                synchronized (timeBroadcastGenerator) {
                    TimeBroadcastGenerator.this.delayedSyncTask = null;
                }
                TimeBroadcastGenerator.this.triggerClockSyncNow();
            }
        };
        this.iface.getTimer().schedule(this.delayedSyncTask, this.RESYNC_DELAY_MSEC);
    }

    private void triggerClockSyncNow() {
        Calendar c = Calendar.getInstance(this.timeZone);
        c.setTimeInMillis(this.getTimeInMsec());
        if (this.isRunning()) {
            this.sendClockEvent(61442, MessageTypeIdentifier.ProducerIdentifiedValid);
        } else {
            this.sendClockEvent(61441, MessageTypeIdentifier.ProducerIdentifiedValid);
        }
        this.sendClockEvent(TimeProtocol.createRate(this.timeKeeper.rate), MessageTypeIdentifier.ProducerIdentifiedValid);
        int year = c.get(1);
        int month = c.get(2) + 1;
        int day = c.get(5);
        int hour = c.get(11);
        int min = c.get(12);
        this.sendClockEvent(TimeProtocol.createYear(year), MessageTypeIdentifier.ProducerIdentifiedValid);
        this.sendClockEvent(TimeProtocol.createMonthDay(month, day), MessageTypeIdentifier.ProducerIdentifiedValid);
        this.sendClockEvent(TimeProtocol.createHourMin(hour, min), MessageTypeIdentifier.ProducerIdentifiedValid);
    }

    @Override
    public double getRate() {
        return this.timeKeeper.rate;
    }

    @Override
    public boolean isRunning() {
        return this.timeKeeper.isRunning;
    }

    @Override
    public long getTimeInMsec() {
        return this.timeKeeper.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRate(double r) {
        double oldRate;
        TimeBroadcastGenerator timeBroadcastGenerator = this;
        synchronized (timeBroadcastGenerator) {
            oldRate = this.timeKeeper.rate;
            this.timeKeeper.setRate(r);
            if (this.timeKeeper.isRunning) {
                this.updateMidnightTask(0L, 0);
            }
        }
        this.firePropertyChange("RateUpdated", oldRate, r);
    }

    private synchronized void updateMidnightTask(long unused, int daysDelta) {
        long desiredTime = 0L;
        long chosenFastMidnight = 0L;
        if (!this.timeKeeper.isRunning || this.timeKeeper.rate == 0.0) {
            desiredTime = 0L;
        } else {
            Calendar c = Calendar.getInstance(this.timeZone);
            c.setTimeInMillis(this.fastDayLastAnnounced);
            if (daysDelta != 0) {
                c.add(5, daysDelta);
                this.fastDayLastAnnounced = c.getTimeInMillis();
            }
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
            if (this.timeKeeper.rate > 0.0) {
                c.add(5, 1);
            }
            chosenFastMidnight = c.getTimeInMillis();
            desiredTime = this.timeKeeper.translateFastToRealTime(chosenFastMidnight);
            --desiredTime;
        }
        if (desiredTime == this.midnightScheduledTime) {
            return;
        }
        if (this.midnightTask != null) {
            this.midnightTask.cancel();
            this.midnightTask = null;
        }
        this.midnightScheduledTime = 0L;
        if (desiredTime == 0L) {
            return;
        }
        this.midnightTask = new TimerTask(){

            @Override
            public void run() {
                TimeBroadcastGenerator.this.announceMidnight(this);
            }
        };
        this.midnightScheduledTime = desiredTime;
        this.iface.getTimer().schedule(this.midnightTask, new Date(this.midnightScheduledTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTime(long newTime) {
        long oldTime;
        TimeBroadcastGenerator timeBroadcastGenerator = this;
        synchronized (timeBroadcastGenerator) {
            oldTime = this.timeKeeper.getTime();
            this.timeKeeper.setTime(newTime);
            if (this.timeKeeper.isRunning) {
                this.fastDayLastAnnounced = newTime;
                this.updateMidnightTask(0L, 0);
            }
        }
        this.firePropertyChange("TimeUpdated", oldTime, newTime);
    }

    private synchronized void announceMidnight(TimerTask self) {
        if (!this.timeKeeper.isRunning || this.midnightTask != self) {
            return;
        }
        this.sendClockEvent(61443);
        this.midnightTask = null;
        int deltaDays = 0;
        deltaDays = this.timeKeeper.rate > 0.0 ? 1 : -1;
        this.updateMidnightTask(0L, deltaDays);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRunning(boolean r) {
        boolean lastRunning;
        TimeBroadcastGenerator timeBroadcastGenerator = this;
        synchronized (timeBroadcastGenerator) {
            lastRunning = this.timeKeeper.isRunning;
            if (r) {
                this.timeKeeper.start();
            } else {
                this.timeKeeper.stop();
            }
            this.updateMidnightTask(0L, 0);
        }
        this.firePropertyChange("RunUpdated", lastRunning, r);
    }

    private void sendClockEvent(int suffix) {
        this.sendClockEvent(suffix, MessageTypeIdentifier.ProducerConsumerEventReport);
    }

    private void sendClockEvent(int suffix, MessageTypeIdentifier mti) {
        EventMessage m = null;
        NodeID nid = this.iface.getNodeId();
        EventID eid = TimeProtocol.createClockEvent(this.clock, suffix);
        switch (mti) {
            case ProducerConsumerEventReport: {
                m = new ProducerConsumerEventReportMessage(nid, eid);
                break;
            }
            case ProducerIdentifiedValid: {
                m = new ProducerIdentifiedMessage(nid, eid, EventState.Valid);
                break;
            }
            case ProducerRangeIdentified: {
                m = new ProducerRangeIdentifiedMessage(nid, eid);
                break;
            }
            case ConsumerRangeIdentified: {
                m = new ConsumerRangeIdentifiedMessage(nid, eid);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported clock event requested.");
            }
        }
        this.iface.getOutputConnection().put(m, this.messageHandler);
    }

    @Override
    public void requestSetRate(double rate) {
        double r = TimeProtocol.decodeRate(TimeProtocol.createRate(rate));
        if (r == 0.0 && rate > 0.0) {
            r = 0.25;
        } else if (r == 0.0 && rate < 0.0) {
            r = -0.25;
        }
        this.updateRate(r);
        int d = TimeProtocol.createRate(r);
        this.sendClockEvent(d);
        this.triggerClockSyncIn3Sec();
    }

    @Override
    public void requestStop() {
        if (this.isRunning()) {
            this.sendClockEvent(61441);
        }
    }

    @Override
    public void requestStart() {
        if (!this.isRunning()) {
            this.sendClockEvent(61442);
        }
    }

    @Override
    public void requestSetTime(long timeMsec) {
        this.updateTime(timeMsec);
        Calendar c = Calendar.getInstance(this.timeZone);
        c.setTimeInMillis(timeMsec);
        this.sendClockEvent(TimeProtocol.createYear(c.get(1)));
        this.sendClockEvent(TimeProtocol.createMonthDay(c.get(2) + 1, c.get(5)));
        this.sendClockEvent(TimeProtocol.createHourMin(c.get(11), c.get(12)));
        this.triggerClockSyncIn3Sec();
    }

    @Override
    public void requestQuery() {
        this.firePropertyChange("TimeUpdated", null, this.getTimeInMsec());
        this.firePropertyChange("RateUpdated", null, this.getRate());
        this.firePropertyChange("RunUpdated", null, this.isRunning());
    }

    private class Handler
    extends MessageDecoder {
        private Handler() {
        }

        @Override
        public void handleProducerConsumerEventReport(ProducerConsumerEventReportMessage msg, Connection sender) {
            int d = TimeProtocol.decodeClock(msg.getEventID(), TimeBroadcastGenerator.this.clock);
            if (d < 0 || (d & 0x8000) == 0) {
                return;
            }
            switch (d) {
                case 61440: {
                    TimeBroadcastGenerator.this.triggerClockSyncNow();
                    break;
                }
                case 61441: {
                    TimeBroadcastGenerator.this.updateRunning(false);
                    TimeBroadcastGenerator.this.triggerClockSyncIn3Sec();
                    break;
                }
                case 61442: {
                    TimeBroadcastGenerator.this.updateRunning(true);
                    TimeBroadcastGenerator.this.triggerClockSyncIn3Sec();
                }
            }
            boolean retransmitReport = true;
            switch (d >> 12 & 7) {
                case 0: 
                case 1: {
                    int hrs = d >> 8 & 0x1F;
                    int min = d & 0xFF;
                    Calendar c = TimeBroadcastGenerator.this.prepareTimeUpdate();
                    c.set(11, hrs);
                    c.set(12, min);
                    c.set(13, 0);
                    c.set(14, 0);
                    TimeBroadcastGenerator.this.updateTime(c.getTimeInMillis());
                    break;
                }
                case 2: {
                    int month = d >> 8 & 0xF;
                    int day = d & 0xFF;
                    Calendar c = TimeBroadcastGenerator.this.prepareTimeUpdate();
                    c.set(2, month - 1);
                    c.set(5, day);
                    TimeBroadcastGenerator.this.updateTime(c.getTimeInMillis());
                    break;
                }
                case 3: {
                    int year = d & 0xFFF;
                    Calendar c = TimeBroadcastGenerator.this.prepareTimeUpdate();
                    c.set(1, year);
                    TimeBroadcastGenerator.this.updateTime(c.getTimeInMillis());
                    break;
                }
                case 4: {
                    double r = TimeProtocol.decodeRate(d);
                    TimeBroadcastGenerator.this.updateRate(r);
                    break;
                }
                default: {
                    retransmitReport = false;
                }
            }
            if (retransmitReport) {
                TimeBroadcastGenerator.this.sendClockEvent(d & 0xFFFF7FFF);
                TimeBroadcastGenerator.this.triggerClockSyncIn3Sec();
            }
        }
    }
}

