/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.protocols;

import org.openlcb.Connection;
import org.openlcb.MessageDecoder;
import org.openlcb.NodeID;
import org.openlcb.OlcbInterface;
import org.openlcb.OptionalIntRejectedMessage;
import org.openlcb.UnknownMtiMessage;

public class UnknownMtiHandler
extends MessageDecoder {
    private final OlcbInterface iface;
    private final NodeID id;

    public UnknownMtiHandler(NodeID id, OlcbInterface iface) {
        this.iface = iface;
        this.id = id;
        iface.registerMessageListener(this);
    }

    @Override
    public void handleUnknownMTI(UnknownMtiMessage msg, Connection sender) {
        if (msg.getDestNodeID() == this.id) {
            int mti = msg.getOriginalMTI();
            int code = 4160;
            OptionalIntRejectedMessage omsg = new OptionalIntRejectedMessage(this.id, msg.getSourceNodeID(), mti, code);
            this.iface.getOutputConnection().put(omsg, this);
        }
    }
}

