/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.swing;

import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFormattedTextField;
import javax.swing.text.MaskFormatter;
import org.openlcb.swing.EventIdTextField;

public class NodeIdTextField
extends JFormattedTextField {
    private static final long serialVersionUID = -2449245636268993230L;
    private static final Logger logger = Logger.getLogger(NodeIdTextField.class.getName());

    public static JFormattedTextField getNodeIdTextField() {
        JFormattedTextField retval = new JFormattedTextField(NodeIdTextField.createFormatter("HH.HH.HH.HH.HH.HH"));
        retval.setValue("00.00.00.00.00.00");
        retval.setToolTipText("NodeID as six-byte dotted-hex string, e.g. 01.02.0A.AB.34.56");
        retval.setDragEnabled(true);
        retval.setTransferHandler(new EventIdTextField.CustomTransferHandler());
        return retval;
    }

    private static MaskFormatter createFormatter(String s) {
        MaskFormatter formatter = null;
        try {
            formatter = new MaskFormatter(s);
        }
        catch (ParseException exc) {
            logger.log(Level.SEVERE, "formatter is bad: {0}", exc.getMessage());
        }
        return formatter;
    }
}

