/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.swing;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.openlcb.MimicNodeStore;
import org.openlcb.NodeID;
import org.openlcb.SimpleNodeIdent;

public class NodeSelector
extends JComboBox<ModelEntry> {
    private final PropertyChangeListener propertyChangeListener;
    MimicNodeStore store;
    private DefaultComboBoxModel<ModelEntry> model = new DefaultComboBoxModel();
    private boolean seenLight = false;
    private int termCount = 2;
    private static final Logger log = Logger.getLogger(NodeSelector.class.getName());

    public NodeSelector(MimicNodeStore store) {
        this(store, 2);
    }

    public NodeSelector(MimicNodeStore store, int termCount) {
        this.store = store;
        this.termCount = termCount;
        this.setModel(this.model);
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("AddNode")) {
                    MimicNodeStore.NodeMemo memo = (MimicNodeStore.NodeMemo)e.getNewValue();
                    NodeSelector.this.newNodeInList(memo);
                } else if (e.getPropertyName().equals("ClearAllNodes")) {
                    NodeSelector.this.clearList();
                }
            }
        };
        store.addPropertyChangeListener(this.propertyChangeListener);
        for (MimicNodeStore.NodeMemo memo : store.getNodeMemos()) {
            this.newNodeInList(memo);
        }
        this.setPrototypeDisplayValue(new ModelEntry("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"));
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if (NodeSelector.this.isDisplayable()) {
                    NodeSelector.this.seenLight = true;
                } else if (NodeSelector.this.seenLight) {
                    log.finest("NodeSelector disposing due to hierarchy changes.");
                    NodeSelector.this.removeHierarchyListener(this);
                    NodeSelector.this.dispose();
                }
            }
        });
    }

    private void updateComboBoxModelEntry(ModelEntry modelEntry) {
        int idx = this.model.getIndexOf(modelEntry);
        if (idx < 0) {
            return;
        }
        ModelEntry last = this.model.getElementAt(idx);
        if (last != modelEntry) {
            modelEntry.dispose();
            return;
        }
        ModelEntry sel = (ModelEntry)this.model.getSelectedItem();
        this.model.removeElementAt(idx);
        this.model.insertElementAt(modelEntry, idx);
        this.model.setSelectedItem(sel);
    }

    private void newNodeInList(MimicNodeStore.NodeMemo memo) {
        int i;
        if (this.model.getIndexOf(memo.getNodeID()) >= 0) {
            return;
        }
        ModelEntry e = new ModelEntry(memo);
        for (i = 0; i < this.model.getSize() && this.model.getElementAt(i).compareTo(e) < 0; ++i) {
        }
        this.model.insertElementAt(e, i);
        if (this.getSelectedItem() == null) {
            this.setSelectedItem(e);
        }
        this.setPrototypeDisplayValue(e);
        this.invalidate();
    }

    private void clearList() {
        for (int i = 0; i < this.model.getSize(); ++i) {
            this.model.getElementAt(i).dispose();
        }
        this.model.removeAllElements();
    }

    public void dispose() {
        this.clearList();
        this.store.removePropertyChangeListener(this.propertyChangeListener);
    }

    public NodeID getSelectedNodeID() {
        ModelEntry me = (ModelEntry)super.getSelectedItem();
        if (me == null) {
            return null;
        }
        return me.getNodeID();
    }

    public void setSelectedNodeID(NodeID nodeID) {
        for (int i = 0; i < this.model.getSize(); ++i) {
            if (!this.model.getElementAt(i).getNodeID().equals(nodeID)) continue;
            super.setSelectedItem(this.model.getElementAt(i));
            break;
        }
    }

    protected class ModelEntry
    implements Comparable<ModelEntry>,
    PropertyChangeListener {
        final MimicNodeStore.NodeMemo nodeMemo;
        String description = "";

        ModelEntry(MimicNodeStore.NodeMemo memo) {
            this.nodeMemo = memo;
            memo.addPropertyChangeListener(this);
            this.updateDescription();
        }

        private ModelEntry(String description) {
            this.nodeMemo = null;
            this.description = description;
        }

        public NodeID getNodeID() {
            return this.nodeMemo.getNodeID();
        }

        private void updateDescription() {
            String newDescription;
            SimpleNodeIdent ident = this.nodeMemo.getSimpleNodeIdent();
            StringBuilder sb = new StringBuilder();
            sb.append(this.nodeMemo.getNodeID().toString());
            int count = 0;
            if (count < NodeSelector.this.termCount) {
                count += this.addToDescription(ident.getUserName(), sb);
            }
            if (count < NodeSelector.this.termCount) {
                count += this.addToDescription(ident.getUserDesc(), sb);
            }
            if (!(count >= NodeSelector.this.termCount || ident.getMfgName().isEmpty() && ident.getModelName().isEmpty())) {
                count += this.addToDescription(ident.getMfgName() + " " + ident.getModelName(), sb);
            }
            if (count < NodeSelector.this.termCount) {
                count += this.addToDescription(ident.getSoftwareVersion(), sb);
            }
            if (!this.description.equals(newDescription = sb.toString())) {
                this.description = newDescription;
                NodeSelector.this.updateComboBoxModelEntry(this);
            }
        }

        private int addToDescription(String s, StringBuilder sb) {
            if (s.isEmpty()) {
                return 0;
            }
            sb.append(" - ");
            sb.append(s);
            return 1;
        }

        private long reorder(long n) {
            return n < 0L ? Long.MAX_VALUE - n : Long.MIN_VALUE + n;
        }

        @Override
        public int compareTo(ModelEntry otherEntry) {
            long l1 = this.reorder(this.getNodeID().toLong());
            long l2 = this.reorder(otherEntry.getNodeID().toLong());
            return Long.compare(l1, l2);
        }

        public String toString() {
            return this.description;
        }

        @SuppressFBWarnings(value={"EQ_CHECK_FOR_OPERAND_NOT_COMPATIBLE_WITH_THIS"}, justification="Purposefully attempting lookup using NodeID argument in model vector.")
        public boolean equals(Object o) {
            if (o instanceof ModelEntry) {
                if (this.nodeMemo == null && ((ModelEntry)o).nodeMemo == null) {
                    return true;
                }
                if (this.nodeMemo == null || ((ModelEntry)o).nodeMemo == null) {
                    return false;
                }
                return this.getNodeID().equals(((ModelEntry)o).getNodeID());
            }
            if (o instanceof NodeID) {
                return this.getNodeID().equals(o);
            }
            return false;
        }

        public int hashCode() {
            return this.getNodeID().hashCode();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("updateSimpleNodeIdent")) {
                this.updateDescription();
            }
        }

        public void dispose() {
            this.nodeMemo.removePropertyChangeListener(this);
        }
    }
}

