/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.openlcb.AbstractConnection;
import org.openlcb.Connection;
import org.openlcb.Message;
import org.openlcb.implementations.SingleProducerNode;

public class ProducerPane
extends JPanel {
    private static final long serialVersionUID = 3746472517189015417L;
    private static final Logger logger = Logger.getLogger(ProducerPane.class.getName());
    String name;
    protected JButton sendButton = new JButton();
    protected SingleProducerNode node;

    public ProducerPane(String name, SingleProducerNode node) {
        this.node = node;
        this.name = name;
        if (name != null) {
            this.sendButton.setText(name);
        } else {
            this.sendButton.setText(node.getEventID().toString());
        }
        this.sendButton.setVisible(true);
        this.sendButton.setToolTipText("Click to fire event");
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.sendButton);
        this.sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProducerPane.this.sendButtonActionPerformed(e);
            }
        });
        node.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("EventID")) {
                    if (ProducerPane.this.name == null) {
                        ProducerPane.this.sendButton.setText(e.getNewValue().toString());
                    }
                    logger.log(Level.FINE, "new {0}", e.getNewValue());
                }
            }
        });
    }

    public synchronized void sendButtonActionPerformed(ActionEvent e) {
        this.node.send();
    }

    public Connection getConnection() {
        return new InputLink();
    }

    class InputLink
    extends AbstractConnection {
        @Override
        public void put(Message msg, Connection sender) {
        }
    }
}

