/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.swing.memconfig;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openlcb.MimicNodeStore;
import org.openlcb.NodeID;
import org.openlcb.Utilities;
import org.openlcb.implementations.MemoryConfigurationService;
import org.openlcb.swing.MemorySpaceSelector;

public class MemConfigReadWritePane
extends JPanel {
    private static final long serialVersionUID = -6666836889862724299L;
    NodeID node;
    MimicNodeStore store;
    MemoryConfigurationService service;
    JTextField readDataField = new JTextField(80);
    JTextField writeDataField = new JTextField(80);
    JTextField configNumberField = new JTextField("40");
    JTextField configAddressField = new JTextField("000000");
    MemorySpaceSelector addrSpace = new MemorySpaceSelector(255);

    public MemConfigReadWritePane(NodeID node, MimicNodeStore store, MemoryConfigurationService service) {
        this.node = node;
        this.store = store;
        this.service = service;
        this.setLayout(new BoxLayout(this, 1));
    }

    void addLine(JComponent j, String name) {
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());
        p.add(new JLabel(name));
        p.add(j);
        this.add(p);
    }

    public void initComponents() {
        this.addLine(this.readDataField, "Read: ");
        this.addLine(this.writeDataField, "Write: ");
        this.addLine(this.configNumberField, "Count: ");
        this.addLine(this.configAddressField, "Address: ");
        this.addLine(this.addrSpace, "Space: ");
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());
        JButton b = new JButton("Read");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemConfigReadWritePane.this.readPerformed();
            }
        });
        p.add(b);
        b = new JButton("Write");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemConfigReadWritePane.this.writePerformed();
            }
        });
        p.add(b);
        this.add(p);
    }

    public void readPerformed() {
        int space = this.addrSpace.getMemorySpace();
        long addr = Integer.parseInt(this.configAddressField.getText(), 16);
        int length = Integer.parseInt(this.configNumberField.getText());
        this.service.requestRead(this.node, space, addr, length, new MemoryConfigurationService.McsReadHandler(){

            @Override
            public void handleFailure(int code) {
                MemConfigReadWritePane.this.readDataField.setText("Failed: 0x" + Integer.toHexString(code));
            }

            @Override
            public void handleReadData(NodeID dest, int space, long address, byte[] data) {
                MemConfigReadWritePane.this.readDataField.setText(Utilities.toHexSpaceString(data));
            }
        });
    }

    public void writePerformed() {
        int space = this.addrSpace.getMemorySpace();
        long addr = Integer.parseInt(this.configAddressField.getText(), 16);
        byte[] content = Utilities.bytesFromHexString(this.writeDataField.getText());
        this.service.requestWrite(this.node, space, addr, content, new MemoryConfigurationService.McsWriteHandler(){

            @Override
            public void handleFailure(int errorCode) {
                MemConfigReadWritePane.this.readDataField.setText("Write failed: 0x" + Integer.toHexString(errorCode));
            }

            @Override
            public void handleSuccess() {
            }
        });
    }
}

