/*
 * Decompiled with CFR 0.152.
 */
package org.openlcb.swing.networktree;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.openlcb.MimicNodeStore;
import org.openlcb.NodeID;
import org.openlcb.ProtocolIdentification;
import org.openlcb.SimpleNodeIdent;

public class NodeTreeRep
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 9205221269108293489L;
    MimicNodeStore.NodeMemo memo;
    MimicNodeStore store;
    DefaultTreeModel treeModel;
    String nodeDescription = "";
    SelectionKeyLoader loader;
    DefaultMutableTreeNode[] simpleInfoNodes = new DefaultMutableTreeNode[InfoNodes.NUM_NODES.ordinal()];
    DefaultMutableTreeNode pipNode;
    DefaultMutableTreeNode openConfigNode = null;

    DefaultMutableTreeNode getThis() {
        return this;
    }

    DefaultTreeModel getTreeModel() {
        return this.treeModel;
    }

    public NodeTreeRep(MimicNodeStore.NodeMemo memo, MimicNodeStore store, DefaultTreeModel treeModel, SelectionKeyLoader loader) {
        super("Node");
        this.memo = memo;
        this.store = store;
        this.treeModel = treeModel;
        this.loader = loader;
    }

    void initConnections() {
        SimpleNodeIdent snii;
        this.memo.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("updateProtocol")) {
                    NodeTreeRep.this.updateProtocolIdent((ProtocolIdentification)e.getNewValue());
                }
                if (e.getPropertyName().equals("updateSimpleNodeIdent")) {
                    NodeTreeRep.this.updateSimpleNodeIdent((SimpleNodeIdent)e.getNewValue());
                }
                if (e.getPropertyName().equals("updateConsumers")) {
                    NodeTreeRep.this.getTreeModel().insertNodeInto(NodeTreeRep.this.newNode("Supported Consumers"), NodeTreeRep.this.getThis(), NodeTreeRep.this.getThis().getChildCount());
                }
                if (e.getPropertyName().equals("updateProducers")) {
                    NodeTreeRep.this.getTreeModel().insertNodeInto(NodeTreeRep.this.newNode("Supported Producers"), NodeTreeRep.this.getThis(), NodeTreeRep.this.getThis().getChildCount());
                }
            }
        });
        ProtocolIdentification pip = this.store.getProtocolIdentification(this.memo.getNodeID());
        if (pip != null) {
            this.updateProtocolIdent(pip);
        }
        if ((snii = this.store.getSimpleNodeIdent(this.memo.getNodeID())) != null) {
            this.updateSimpleNodeIdent(snii);
        }
    }

    DefaultMutableTreeNode newNode(String name, SelectionKey key) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(name);
        node.setUserObject(key);
        return node;
    }

    DefaultMutableTreeNode newNode(String name) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(name);
        node.setUserObject(new SelectionKey(name, this.memo.getNodeID()));
        return node;
    }

    void updateSimpleInfoNode(InfoNodes node, String value) {
        int num = node.ordinal();
        if (value == null || value.trim().length() == 0) {
            return;
        }
        String name = node.name + ": " + value;
        if (this.simpleInfoNodes[num] == null) {
            this.simpleInfoNodes[num] = this.newNode(name);
            this.getTreeModel().insertNodeInto(this.simpleInfoNodes[num], this.getThis(), this.getThis().getChildCount());
        } else {
            this.simpleInfoNodes[num].setUserObject(name);
            this.treeModel.nodeChanged(this.simpleInfoNodes[num]);
        }
    }

    synchronized void updateSimpleNodeIdent(SimpleNodeIdent e) {
        String newDesc;
        this.updateSimpleInfoNode(InfoNodes.MFG, e.getMfgName());
        this.updateSimpleInfoNode(InfoNodes.MODEL, e.getModelName());
        this.updateSimpleInfoNode(InfoNodes.HARDWARE_VERSION, e.getHardwareVersion());
        this.updateSimpleInfoNode(InfoNodes.SOFTWARE_VERSION, e.getSoftwareVersion());
        this.updateSimpleInfoNode(InfoNodes.USER_NAME, e.getUserName());
        this.updateSimpleInfoNode(InfoNodes.USER_DESC, e.getUserDesc());
        StringBuilder b = new StringBuilder();
        String n1 = e.getUserName().trim();
        if (!n1.isEmpty()) {
            b.append(n1);
        } else {
            b.append(e.getMfgName());
        }
        String n2 = e.getUserDesc().trim();
        String n3 = "";
        if (n2.isEmpty() && n1.isEmpty()) {
            n2 = e.getModelName();
            n3 = e.getHardwareVersion();
        }
        if (!n2.isEmpty()) {
            if (b.length() > 0) {
                b.append(" - ");
            }
            b.append(n2);
        }
        if (!n3.isEmpty()) {
            if (b.length() > 0) {
                b.append(" - ");
            }
            b.append(n3);
        }
        if (!this.nodeDescription.equals(newDesc = b.toString())) {
            this.nodeDescription = newDesc;
            this.treeModel.nodeChanged(this);
        }
    }

    synchronized void updateProtocolIdent(ProtocolIdentification pi) {
        if (pi.getValue() != 0L) {
            if (this.pipNode == null) {
                this.pipNode = this.newNode("Supported Protocols");
                this.getTreeModel().insertNodeInto(this.pipNode, this.getThis(), this.getThis().getChildCount());
            }
            this.pipNode.removeAllChildren();
            List<ProtocolIdentification.Protocol> protocols = pi.getProtocols();
            for (ProtocolIdentification.Protocol p : protocols) {
                DefaultMutableTreeNode node = null;
                switch (p) {
                    case ConfigurationDescription: {
                        node = this.newNode(p.getName(), this.loader.cdiKey(p.getName(), this.memo.getNodeID()));
                        if (this.openConfigNode != null) break;
                        this.openConfigNode = this.newNode(null, this.loader.cdiKey("Open Configuration dialog", this.memo.getNodeID()));
                        this.getTreeModel().insertNodeInto(this.openConfigNode, this.getThis(), 0);
                        break;
                    }
                    case ProtocolIdentification: {
                        node = this.newNode(p.getName(), this.loader.pipKey(p.getName(), this.memo.getNodeID()));
                        break;
                    }
                    case Datagram: {
                        node = this.newNode(p.getName(), this.loader.datagramKey(p.getName(), this.memo.getNodeID()));
                        break;
                    }
                    case Configuration: {
                        node = this.newNode(p.getName(), this.loader.configurationKey(p.getName(), this.memo.getNodeID()));
                        break;
                    }
                    case SimpleNodeID: {
                        node = this.newNode(p.getName(), this.loader.sniiKey(p.getName(), this.memo.getNodeID()));
                        break;
                    }
                    default: {
                        node = this.newNode(p.getName());
                    }
                }
                this.getTreeModel().insertNodeInto(node, this.pipNode, this.pipNode.getChildCount());
            }
            this.getTreeModel().nodeStructureChanged(this.pipNode);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.memo.getNodeID().toString());
        if (!this.nodeDescription.isEmpty()) {
            sb.append(" - ");
            sb.append(this.nodeDescription);
        }
        return sb.toString();
    }

    static enum InfoNodes {
        MFG("Mfg"),
        MODEL("Mod"),
        HARDWARE_VERSION("Hardware"),
        SOFTWARE_VERSION("Software"),
        USER_NAME("Name"),
        USER_DESC("Desc"),
        NUM_NODES("");

        public final String name;

        private InfoNodes(String n2) {
            this.name = n2;
        }
    }

    public static class SelectionKeyLoader {
        public SelectionKey pipKey(String name, NodeID node) {
            return new SelectionKey(name, node);
        }

        public SelectionKey sniiKey(String name, NodeID node) {
            return new SelectionKey(name, node);
        }

        public SelectionKey datagramKey(String name, NodeID node) {
            return new SelectionKey(name, node);
        }

        public SelectionKey configurationKey(String name, NodeID node) {
            return new SelectionKey(name, node);
        }

        public SelectionKey cdiKey(String name, NodeID node) {
            return new SelectionKey(name, node);
        }
    }

    public static class SelectionKey {
        protected String name;
        protected NodeID node;

        public SelectionKey(String name, NodeID node) {
            this.name = name;
            this.node = node;
        }

        public void select(DefaultMutableTreeNode rep) {
        }

        public String toString() {
            return this.name;
        }
    }
}

