/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.MatteBorder;

public class CollapsiblePanel
extends JPanel {
    private static final long serialVersionUID = -7507196157581324501L;
    private boolean selected;
    JPanel contentPanel_;
    HeaderPanel headerPanel_;
    private int setWidth_ = Integer.MAX_VALUE;

    public CollapsiblePanel(String text, JPanel panel) {
        super(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.anchor = 23;
        this.selected = true;
        this.headerPanel_ = new HeaderPanel(text == null ? "" : text);
        this.contentPanel_ = panel;
        this.contentPanel_.setBorder(new MatteBorder(0, 20, 0, 0, this.contentPanel_.getBackground()));
        this.add((Component)this.headerPanel_, gbc);
        this.add((Component)this.contentPanel_, gbc);
        this.contentPanel_.setVisible(this.selected);
    }

    public JPanel getHeader() {
        return this.headerPanel_;
    }

    public void toggleSelection() {
        this.selected = !this.selected;
        this.contentPanel_.setVisible(this.selected);
        this.validate();
        JFrame top = (JFrame)this.getTopLevelAncestor();
        if (top != null) {
            top.pack();
        }
        this.headerPanel_.repaint();
    }

    public void setExpanded(boolean isExpanded) {
        if (this.selected != isExpanded) {
            this.toggleSelection();
        }
    }

    public void setMaximumWidth(int w) {
        this.setWidth_ = w;
        this.invalidate();
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension d = super.getPreferredSize();
        d.width = this.setWidth_;
        return d;
    }

    private class HeaderPanel
    extends JPanel
    implements MouseListener,
    FocusListener,
    KeyListener {
        private static final long serialVersionUID = 3553276313551309624L;
        String text_;
        Font font;
        BufferedImage open;
        BufferedImage closed;
        final int OFFSET = 30;
        final int PAD = 5;

        public HeaderPanel(String text) {
            this.addMouseListener(this);
            this.addKeyListener(this);
            this.text_ = text;
            this.getAccessibleContext().setAccessibleName(text);
            this.font = UIManager.getFont("Label.font").deriveFont(1);
            this.setFocusable(true);
            this.addFocusListener(this);
            this.setPreferredSize(new Dimension(200, 24));
            this.setMinimumSize(new Dimension(0, 24));
            try {
                this.closed = ImageIO.read(this.getClass().getResourceAsStream("/toolbarButtonGraphics/navigation/Forward24.gif"));
                this.open = ImageIO.read(this.getClass().getResourceAsStream("/toolbarButtonGraphics/navigation/Down24.gif"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int h = this.getHeight();
            if (CollapsiblePanel.this.selected) {
                g2.drawImage(this.open, 5, 0, h, h, this);
            } else {
                g2.drawImage(this.closed, 5, 0, h, h, this);
            }
            g2.setFont(this.font);
            FontRenderContext frc = g2.getFontRenderContext();
            LineMetrics lm = this.font.getLineMetrics(this.text_, frc);
            float height = lm.getAscent() + lm.getDescent();
            float x = 30.0f;
            float y = ((float)h + height) / 2.0f - lm.getDescent();
            g2.drawString(this.text_, x, y);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.requestFocus();
            CollapsiblePanel.this.toggleSelection();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.setBorder(BorderFactory.createDashedBorder(Color.BLACK));
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.setBorder(BorderFactory.createEmptyBorder());
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            int c = keyEvent.getKeyCode();
            if (c == 32 || c == 10) {
                CollapsiblePanel.this.toggleSelection();
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }
    }
}

