/*
 * Decompiled with CFR 0.152.
 */
package util.com.toedter.calendar;

import java.awt.FlowLayout;
import java.awt.Font;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerNumberModel;

public final class JHourMinuteChooser
extends JPanel {
    private Date currentTime;
    private static final Logger LOGGER = Logger.getLogger(JHourMinuteChooser.class.getName());
    private JSpinner hourSpin;
    private JSpinner meridianSpin;
    private JSpinner minuteSpin;

    public JHourMinuteChooser(int hour, int minute) {
        this.setName("JHourMinuteChooser");
        this.initComponents();
        this.currentTime = new Date();
        this.currentTime.setHours(hour);
        this.currentTime.setMinutes(minute);
        this.updateCurrentTimeInGUI();
    }

    public JHourMinuteChooser() {
        this.setName("JHourMinuteChooser");
        this.initComponents();
        this.setCurrentTime();
    }

    @Override
    public void setEnabled(boolean enable) {
        this.hourSpin.setEnabled(enable);
        this.minuteSpin.setEnabled(enable);
        this.meridianSpin.setEnabled(enable);
    }

    public void setCurrentTime() {
        this.currentTime = new Date();
        this.updateCurrentTimeInGUI();
    }

    public void setTimeFromString(String toBeParsed) {
        if (toBeParsed.matches("\\d{1,2}\\s*\\:\\s*\\d{2}\\s+[AP]M")) {
            String[] splitted = toBeParsed.split("\\:");
            this.currentTime = new Date();
            int hour = Integer.parseInt(splitted[0]);
            if ("PM".equals(splitted[2])) {
                hour += 12;
            }
            this.currentTime.setHours(hour);
            int minutes = Integer.parseInt(splitted[1]);
            this.currentTime.setMinutes(minutes);
        }
        this.updateCurrentTimeInGUI();
    }

    private void updateCurrentTimeInGUI() {
        LOGGER.finest(this.currentTime.toString());
        if (this.currentTime.getHours() >= 0 && this.currentTime.getHours() < 12) {
            if (this.currentTime.getHours() == 0) {
                this.hourSpin.setValue(12);
            } else {
                this.hourSpin.setValue(this.currentTime.getHours());
            }
            this.meridianSpin.setValue("AM");
        } else if (this.currentTime.getHours() >= 12 && this.currentTime.getHours() <= 23) {
            if (this.currentTime.getHours() == 12) {
                this.hourSpin.setValue(12);
            } else {
                this.hourSpin.setValue(this.currentTime.getHours() - 12);
            }
            this.meridianSpin.setValue("PM");
        }
        this.minuteSpin.setValue(JHourMinuteChooser.numberFormat(this.currentTime.getMinutes(), "##"));
    }

    public static String numberFormat(long src, String fmt) {
        DecimalFormat df = new DecimalFormat(fmt.replaceAll("#", "0"));
        return df.format(src);
    }

    public String getHour() {
        return JHourMinuteChooser.numberFormat(Integer.parseInt(this.hourSpin.getValue().toString().trim()), "##");
    }

    public String getMinute() {
        return JHourMinuteChooser.numberFormat(Integer.parseInt(this.minuteSpin.getValue().toString().trim()), "##");
    }

    public String getMeridian() {
        return this.meridianSpin.getValue().toString();
    }

    public String getTime() {
        return JHourMinuteChooser.numberFormat(Integer.parseInt(this.hourSpin.getValue().toString().trim()), "##") + ":" + JHourMinuteChooser.numberFormat(Integer.parseInt(this.minuteSpin.getValue().toString().trim()), "##") + " " + this.meridianSpin.getValue().toString();
    }

    private void initComponents() {
        this.hourSpin = new JSpinner();
        this.minuteSpin = new JSpinner();
        this.meridianSpin = new JSpinner();
        this.setLayout(new FlowLayout(0, 3, 0));
        this.hourSpin.setFont(new Font("Tahoma", 1, 11));
        this.hourSpin.setModel(new SpinnerNumberModel(1, 1, 12, 1));
        this.add(this.hourSpin);
        this.minuteSpin.setFont(new Font("Tahoma", 1, 11));
        this.minuteSpin.setModel(new SpinnerListModel(new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59"}));
        this.add(this.minuteSpin);
        this.meridianSpin.setFont(new Font("Tahoma", 1, 11));
        this.meridianSpin.setModel(new SpinnerListModel(new String[]{"AM", "PM"}));
        this.add(this.meridianSpin);
    }

    public Date getCurrentTime() {
        return new Date(this.currentTime.getTime());
    }
}

