/*
 * Decompiled with CFR 0.152.
 */
package jtermios.linux;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import jtermios.JTermios;
import jtermios.Pollfd;
import jtermios.Termios;
import jtermios.TimeVal;

public class JTermiosImpl
implements JTermios.JTermiosInterface {
    private static String DEVICE_DIR_PATH = "/dev/";
    static C_lib_DirectMapping m_ClibDM;
    static C_lib m_Clib;
    static NonDirectCLib m_ClibND;
    private static final int TIOCGSERIAL = 21534;
    private static final int TIOCSSERIAL = 21535;
    private static final int ASYNC_SPD_MASK = 4144;
    private static final int ASYNC_SPD_CUST = 48;
    private static final int[] m_BaudRates;

    public JTermiosImpl() {
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "instantiating %s\n", this.getClass().getCanonicalName());
        JTermios.FIONREAD = 21531;
        JTermios.O_RDWR = 2;
        JTermios.O_NONBLOCK = 2048;
        JTermios.O_NOCTTY = 256;
        JTermios.O_NDELAY = 2048;
        JTermios.F_GETFL = 3;
        JTermios.F_SETFL = 4;
        JTermios.EAGAIN = 11;
        JTermios.EACCES = 13;
        JTermios.EEXIST = 17;
        JTermios.EINTR = 4;
        JTermios.EINVAL = 22;
        JTermios.EIO = 5;
        JTermios.EISDIR = 21;
        JTermios.ELOOP = 40;
        JTermios.EMFILE = 24;
        JTermios.ENAMETOOLONG = 36;
        JTermios.ENFILE = 23;
        JTermios.ENOENT = 2;
        JTermios.ENOSR = 63;
        JTermios.ENOSPC = 28;
        JTermios.ENOTDIR = 20;
        JTermios.ENXIO = 6;
        JTermios.EOVERFLOW = 75;
        JTermios.EROFS = 30;
        JTermios.ENOTSUP = 95;
        JTermios.TIOCM_RNG = 128;
        JTermios.TIOCM_CAR = 64;
        JTermios.IGNBRK = 1;
        JTermios.BRKINT = 2;
        JTermios.IGNPAR = 4;
        JTermios.PARMRK = 8;
        JTermios.INLCR = 64;
        JTermios.IGNCR = 128;
        JTermios.ICRNL = 256;
        JTermios.ECHONL = 64;
        JTermios.IEXTEN = 32768;
        JTermios.CLOCAL = 2048;
        JTermios.OPOST = 1;
        JTermios.VSTART = 8;
        JTermios.TCSANOW = 0;
        JTermios.VSTOP = 9;
        JTermios.VMIN = 6;
        JTermios.VTIME = 5;
        JTermios.VEOF = 4;
        JTermios.TIOCMGET = 21525;
        JTermios.TIOCM_CTS = 32;
        JTermios.TIOCM_DSR = 256;
        JTermios.TIOCM_RI = 128;
        JTermios.TIOCM_CD = 64;
        JTermios.TIOCM_DTR = 2;
        JTermios.TIOCM_RTS = 4;
        JTermios.ICANON = 2;
        JTermios.ECHO = 8;
        JTermios.ECHOE = 16;
        JTermios.ISIG = 1;
        JTermios.TIOCMSET = 21528;
        JTermios.IXON = 1024;
        JTermios.IXOFF = 4096;
        JTermios.IXANY = 2048;
        JTermios.CRTSCTS = Integer.MIN_VALUE;
        JTermios.TCSADRAIN = 1;
        JTermios.INPCK = 16;
        JTermios.ISTRIP = 32;
        JTermios.CSIZE = 48;
        JTermios.TCIFLUSH = 0;
        JTermios.TCOFLUSH = 1;
        JTermios.TCIOFLUSH = 2;
        JTermios.CS5 = 0;
        JTermios.CS6 = 16;
        JTermios.CS7 = 32;
        JTermios.CS8 = 48;
        JTermios.CSTOPB = 64;
        JTermios.CREAD = 128;
        JTermios.PARENB = 256;
        JTermios.PARODD = 512;
        JTermios.B0 = 0;
        JTermios.B50 = 1;
        JTermios.B75 = 2;
        JTermios.B110 = 3;
        JTermios.B134 = 4;
        JTermios.B150 = 5;
        JTermios.B200 = 6;
        JTermios.B300 = 7;
        JTermios.B600 = 8;
        JTermios.B1200 = 9;
        JTermios.B1800 = 10;
        JTermios.B2400 = 11;
        JTermios.B4800 = 12;
        JTermios.B9600 = 13;
        JTermios.B19200 = 14;
        JTermios.B38400 = 15;
        JTermios.B57600 = 4097;
        JTermios.B115200 = 4098;
        JTermios.B230400 = 4099;
        JTermios.POLLIN = 1;
        JTermios.POLLPRI = (short)2;
        JTermios.POLLOUT = (short)4;
        JTermios.POLLERR = (short)8;
        JTermios.POLLNVAL = (short)32;
    }

    @Override
    public int errno() {
        return Native.getLastError();
    }

    @Override
    public void cfmakeraw(Termios termios2) {
        termios termios3 = new termios(termios2);
        m_Clib.cfmakeraw(termios3);
        termios3.update(termios2);
    }

    @Override
    public int fcntl(int n, int n2, int n3) {
        return m_Clib.fcntl(n, n2, n3);
    }

    @Override
    public int tcdrain(int n) {
        return m_Clib.tcdrain(n);
    }

    @Override
    public int cfgetispeed(Termios termios2) {
        return m_Clib.cfgetispeed(new termios(termios2));
    }

    @Override
    public int cfgetospeed(Termios termios2) {
        return m_Clib.cfgetospeed(new termios(termios2));
    }

    @Override
    public int cfsetispeed(Termios termios2, int n) {
        termios termios3 = new termios(termios2);
        int n2 = m_Clib.cfsetispeed(termios3, n);
        termios3.update(termios2);
        return n2;
    }

    @Override
    public int cfsetospeed(Termios termios2, int n) {
        termios termios3 = new termios(termios2);
        int n2 = m_Clib.cfsetospeed(termios3, n);
        termios3.update(termios2);
        return n2;
    }

    @Override
    public int open(String object, int n) {
        if (object != null && !((String)object).startsWith("/")) {
            object = DEVICE_DIR_PATH + (String)object;
        }
        return m_Clib.open((String)object, n);
    }

    @Override
    public int read(int n, byte[] byArray, int n2) {
        return m_Clib.read(n, byArray, new JTermios.JTermiosInterface.NativeSize(n2)).intValue();
    }

    @Override
    public int write(int n, byte[] byArray, int n2) {
        return m_Clib.write(n, byArray, new JTermios.JTermiosInterface.NativeSize(n2)).intValue();
    }

    @Override
    public int close(int n) {
        return m_Clib.close(n);
    }

    @Override
    public int tcflush(int n, int n2) {
        return m_Clib.tcflush(n, n2);
    }

    @Override
    public int tcgetattr(int n, Termios termios2) {
        termios termios3 = new termios();
        int n2 = m_Clib.tcgetattr(n, termios3);
        termios3.update(termios2);
        return n2;
    }

    @Override
    public void perror(String string) {
        m_Clib.perror(string);
    }

    @Override
    public int tcsendbreak(int n, int n2) {
        return m_Clib.tcsendbreak(n, n2 / 250);
    }

    @Override
    public int tcsetattr(int n, int n2, Termios termios2) {
        return m_Clib.tcsetattr(n, n2, new termios(termios2));
    }

    @Override
    public int select(int n, JTermios.FDSet fDSet, JTermios.FDSet fDSet2, JTermios.FDSet fDSet3, TimeVal timeVal) {
        timeval timeval2 = null;
        if (timeVal != null) {
            timeval2 = new timeval(timeVal);
        }
        return m_ClibND.select(n, (fd_set)fDSet, (fd_set)fDSet2, (fd_set)fDSet3, timeval2);
    }

    @Override
    public int poll(Pollfd[] pollfdArray, int n, int n2) {
        int n3;
        if (n <= 0 || n > pollfdArray.length) {
            throw new IllegalArgumentException("nfds " + n + " must be <= fds.length " + pollfdArray.length);
        }
        pollfd.ByReference byReference = new pollfd.ByReference();
        pollfd[] pollfdArray2 = (pollfd[])byReference.toArray(n);
        for (n3 = 0; n3 < n; ++n3) {
            pollfdArray2[n3].fd = pollfdArray[n3].fd;
            pollfdArray2[n3].events = pollfdArray[n3].events;
        }
        n3 = m_ClibND.poll(byReference, n, n2);
        for (int i = 0; i < n; ++i) {
            pollfdArray[i].revents = pollfdArray2[i].revents;
        }
        return n3;
    }

    @Override
    public boolean canPoll() {
        return true;
    }

    @Override
    public JTermios.FDSet newFDSet() {
        return new fd_set();
    }

    @Override
    public int ioctl(int n, int n2, int ... nArray) {
        return m_Clib.ioctl(n, n2, nArray);
    }

    private int ioctl(int n, int n2, serial_struct serial_struct2) {
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> ioctl(%d,%d,%s)\n", new Object[]{n, n2, serial_struct2});
        int n3 = m_Clib.ioctl(n, n2, serial_struct2);
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(3, "< tcsetattr(%d,%d,%s) => %d\n", new Object[]{n, n2, serial_struct2, n3});
        return n3;
    }

    @Override
    public String getPortNamePattern() {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string;
            object = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("/proc/tty/drivers"), "US-ASCII"));
            while ((string = ((BufferedReader)object).readLine()) != null) {
                String[] stringArray = string.split(" +");
                if (stringArray.length != 5 || !"serial".equals(stringArray[4]) || !((String)stringArray[1]).startsWith("/dev/")) continue;
                arrayList.add(((String)stringArray[1]).substring(5));
            }
            ((BufferedReader)object).close();
        }
        catch (IOException iOException) {
            JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "failed to read /proc/tty/drivers\n", new Object[0]);
            arrayList.add("ttyS");
            arrayList.add("ttyUSB");
            arrayList.add("ttyACM");
        }
        object = new StringBuilder();
        ((StringBuilder)object).append('^');
        boolean bl = true;
        for (String string : arrayList) {
            if (bl) {
                bl = false;
            } else {
                ((StringBuilder)object).append('|');
            }
            ((StringBuilder)object).append("(");
            ((StringBuilder)object).append(string);
            ((StringBuilder)object).append(".+)");
        }
        return ((StringBuilder)object).toString();
    }

    @Override
    public List<String> getPortList() {
        File file = new File(DEVICE_DIR_PATH);
        if (!file.isDirectory()) {
            JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "device directory %s does not exist\n", DEVICE_DIR_PATH);
            return null;
        }
        String[] stringArray = file.list();
        LinkedList<String> linkedList = new LinkedList<String>();
        Pattern pattern = JTermios.getPortNamePattern(this);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (!pattern.matcher(string).matches()) continue;
                linkedList.add(string);
            }
        }
        return linkedList;
    }

    @Override
    public void shutDown() {
    }

    @Override
    public int setspeed(int n, Termios termios2, int n2) {
        int n3 = n2;
        for (int i = 0; i < m_BaudRates.length; i += 2) {
            if (m_BaudRates[i] != n2) continue;
            serial_struct serial_struct2 = new serial_struct();
            int n4 = this.ioctl(n, 21534, serial_struct2);
            if (n4 == 0) {
                serial_struct2.flags &= 0xFFFFEFCF;
                n4 = this.ioctl(n, 21535, serial_struct2);
            }
            if ((n4 = JTermios.cfsetispeed(termios2, n3 = m_BaudRates[i + 1])) != 0) {
                return n4;
            }
            n4 = JTermios.cfsetospeed(termios2, n3);
            if (n4 != 0) {
                return n4;
            }
            n4 = JTermios.tcsetattr(n, JTermios.TCSANOW, termios2);
            if (n4 != 0) {
                return n4;
            }
            return 0;
        }
        serial_struct serial_struct3 = new serial_struct();
        int n5 = this.ioctl(n, 21534, serial_struct3);
        if (n5 != 0) {
            return n5;
        }
        serial_struct3.flags = serial_struct3.flags & 0xFFFFEFCF | 0x30;
        if (n2 == 0) {
            JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "unable to set custom baudrate %d \n", n2);
            return -1;
        }
        serial_struct3.custom_divisor = (serial_struct3.baud_base + n2 / 2) / n2;
        if (serial_struct3.custom_divisor == 0) {
            JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "unable to set custom baudrate %d (possible division by zero)\n", n2);
            return -1;
        }
        int n6 = serial_struct3.baud_base / serial_struct3.custom_divisor;
        if (n6 < n2 * 98 / 100 || n6 > n2 * 102 / 100) {
            JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "best available baudrate %d not close enough to requested %d \n", n6, n2);
            return -1;
        }
        n5 = this.ioctl(n, 21535, serial_struct3);
        if (n5 != 0) {
            return n5;
        }
        n5 = JTermios.cfsetispeed(termios2, JTermios.B38400);
        if (n5 != 0) {
            return n5;
        }
        n5 = JTermios.cfsetospeed(termios2, JTermios.B38400);
        if (n5 != 0) {
            return n5;
        }
        n5 = JTermios.tcsetattr(n, JTermios.TCSANOW, termios2);
        if (n5 != 0) {
            return n5;
        }
        return 0;
    }

    @Override
    public int pipe(int[] nArray) {
        return m_Clib.pipe(nArray);
    }

    static {
        m_ClibND = (NonDirectCLib)Native.loadLibrary((String)Platform.C_LIBRARY_NAME, NonDirectCLib.class);
        Native.register(C_lib_DirectMapping.class, (NativeLibrary)NativeLibrary.getInstance((String)Platform.C_LIBRARY_NAME));
        m_ClibDM = new C_lib_DirectMapping();
        m_Clib = m_ClibDM;
        m_BaudRates = new int[]{50, 1, 75, 2, 110, 3, 134, 4, 150, 5, 200, 6, 300, 7, 600, 8, 1200, 9, 1800, 10, 2400, 11, 4800, 12, 9600, 13, 19200, 14, 38400, 15, 57600, 4097, 115200, 4098, 230400, 4099, 460800, 4100, 500000, 4101, 576000, 4102, 921600, 4103, 1000000, 4104, 1152000, 4105, 1500000, 4106, 2000000, 4107, 2500000, 4108, 3000000, 4109, 3500000, 4110, 4000000, 4111};
    }

    public static class termios
    extends Structure {
        public int c_iflag;
        public int c_oflag;
        public int c_cflag;
        public int c_lflag;
        public byte c_line;
        public byte[] c_cc = new byte[32];
        public int c_ispeed;
        public int c_ospeed;

        protected List getFieldOrder() {
            return Arrays.asList("c_iflag", "c_oflag", "c_cflag", "c_lflag", "c_line", "c_cc", "c_ispeed", "c_ospeed");
        }

        public termios() {
        }

        public termios(Termios termios2) {
            this.c_iflag = termios2.c_iflag;
            this.c_oflag = termios2.c_oflag;
            this.c_cflag = termios2.c_cflag;
            this.c_lflag = termios2.c_lflag;
            System.arraycopy(termios2.c_cc, 0, this.c_cc, 0, termios2.c_cc.length);
            this.c_ispeed = termios2.c_ispeed;
            this.c_ospeed = termios2.c_ospeed;
        }

        public void update(Termios termios2) {
            termios2.c_iflag = this.c_iflag;
            termios2.c_oflag = this.c_oflag;
            termios2.c_cflag = this.c_cflag;
            termios2.c_lflag = this.c_lflag;
            System.arraycopy(this.c_cc, 0, termios2.c_cc, 0, termios2.c_cc.length);
            termios2.c_ispeed = this.c_ispeed;
            termios2.c_ospeed = this.c_ospeed;
        }
    }

    public static class serial_struct
    extends Structure {
        public int type;
        public int line;
        public int port;
        public int irq;
        public int flags;
        public int xmit_fifo_size;
        public int custom_divisor;
        public int baud_base;
        public short close_delay;
        public short io_type;
        public int hub6;
        public short closing_wait;
        public short closing_wait2;
        public Pointer iomem_base;
        public short iomem_reg_shift;
        public int port_high;
        public NativeLong iomap_base;

        protected List getFieldOrder() {
            return Arrays.asList("type", "line", "port", "irq", "flags", "xmit_fifo_size", "custom_divisor", "baud_base", "close_delay", "io_type", "hub6", "closing_wait", "closing_wait2", "iomem_base", "iomem_reg_shift", "port_high", "iomap_base");
        }
    }

    public static class fd_set
    extends Structure
    implements JTermios.FDSet {
        private static final int NFBBITS = NativeLong.SIZE * 8;
        private static final int fd_count = 1024;
        public NativeLong[] fd_array = new NativeLong[(1024 + NFBBITS - 1) / NFBBITS];

        public fd_set() {
            for (int i = 0; i < this.fd_array.length; ++i) {
                this.fd_array[i] = new NativeLong();
            }
        }

        protected List getFieldOrder() {
            return Arrays.asList("fd_array");
        }

        @Override
        public void FD_SET(int n) {
            this.fd_array[n / NFBBITS].setValue(this.fd_array[n / NFBBITS].longValue() | 1L << n % NFBBITS);
        }

        @Override
        public boolean FD_ISSET(int n) {
            return (this.fd_array[n / NFBBITS].longValue() & 1L << n % NFBBITS) != 0L;
        }

        @Override
        public void FD_ZERO() {
            for (NativeLong nativeLong : this.fd_array) {
                nativeLong.setValue(0L);
            }
        }

        @Override
        public void FD_CLR(int n) {
            this.fd_array[n / NFBBITS].setValue(this.fd_array[n / NFBBITS].longValue() & (1L << n % NFBBITS ^ 0xFFFFFFFFFFFFFFFFL));
        }
    }

    public static class pollfd
    extends Structure {
        public int fd;
        public short events;
        public short revents;

        protected List getFieldOrder() {
            return Arrays.asList("fd", "events", "revents");
        }

        public pollfd() {
        }

        public pollfd(Pollfd pollfd2) {
            this.fd = pollfd2.fd;
            this.events = pollfd2.events;
            this.revents = pollfd2.revents;
        }

        public static class ByReference
        extends pollfd
        implements Structure.ByReference {
        }
    }

    public static class timeval
    extends Structure {
        public NativeLong tv_sec;
        public NativeLong tv_usec;

        protected List getFieldOrder() {
            return Arrays.asList("tv_sec", "tv_usec");
        }

        public timeval(TimeVal timeVal) {
            this.tv_sec = new NativeLong(timeVal.tv_sec);
            this.tv_usec = new NativeLong(timeVal.tv_usec);
        }
    }

    public static interface NonDirectCLib
    extends Library {
        public int select(int var1, fd_set var2, fd_set var3, fd_set var4, timeval var5);

        public int poll(pollfd.ByReference var1, int var2, int var3);
    }

    public static interface C_lib
    extends Library {
        public int pipe(int[] var1);

        public int tcdrain(int var1);

        public void cfmakeraw(termios var1);

        public int fcntl(int var1, int var2, int var3);

        public int ioctl(int var1, int var2, int[] var3);

        public int ioctl(int var1, int var2, serial_struct var3);

        public int open(String var1, int var2);

        public int close(int var1);

        public int tcgetattr(int var1, termios var2);

        public int tcsetattr(int var1, int var2, termios var3);

        public int cfsetispeed(termios var1, int var2);

        public int cfsetospeed(termios var1, int var2);

        public int cfgetispeed(termios var1);

        public int cfgetospeed(termios var1);

        public JTermios.JTermiosInterface.NativeSize write(int var1, byte[] var2, JTermios.JTermiosInterface.NativeSize var3);

        public JTermios.JTermiosInterface.NativeSize read(int var1, byte[] var2, JTermios.JTermiosInterface.NativeSize var3);

        public int tcflush(int var1, int var2);

        public void perror(String var1);

        public int tcsendbreak(int var1, int var2);
    }

    public static class C_lib_DirectMapping
    implements C_lib {
        @Override
        public native int pipe(int[] var1);

        @Override
        public native int tcdrain(int var1);

        @Override
        public native void cfmakeraw(termios var1);

        @Override
        public native int fcntl(int var1, int var2, int var3);

        @Override
        public native int ioctl(int var1, int var2, int[] var3);

        @Override
        public native int ioctl(int var1, int var2, serial_struct var3);

        @Override
        public native int open(String var1, int var2);

        @Override
        public native int close(int var1);

        @Override
        public native int tcgetattr(int var1, termios var2);

        @Override
        public native int tcsetattr(int var1, int var2, termios var3);

        @Override
        public native int cfsetispeed(termios var1, int var2);

        @Override
        public native int cfsetospeed(termios var1, int var2);

        @Override
        public native int cfgetispeed(termios var1);

        @Override
        public native int cfgetospeed(termios var1);

        @Override
        public native JTermios.JTermiosInterface.NativeSize write(int var1, byte[] var2, JTermios.JTermiosInterface.NativeSize var3);

        @Override
        public native JTermios.JTermiosInterface.NativeSize read(int var1, byte[] var2, JTermios.JTermiosInterface.NativeSize var3);

        @Override
        public native int tcflush(int var1, int var2);

        @Override
        public native void perror(String var1);

        @Override
        public native int tcsendbreak(int var1, int var2);
    }
}

