/*
 * Decompiled with CFR 0.152.
 */
package jtermios.macosx;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import com.sun.jna.Structure;
import com.sun.jna.ptr.NativeLongByReference;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import jtermios.JTermios;
import jtermios.Pollfd;
import jtermios.Termios;
import jtermios.TimeVal;

public class JTermiosImpl
implements JTermios.JTermiosInterface {
    private static int IOSSIOSPEED = -2147199998;
    private static String DEVICE_DIR_PATH = "/dev/";
    static C_lib_DirectMapping m_ClibDM;
    static C_lib m_Clib;

    public JTermiosImpl() {
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "instantiating %s\n", this.getClass().getCanonicalName());
    }

    @Override
    public int errno() {
        return Native.getLastError();
    }

    @Override
    public void cfmakeraw(Termios termios2) {
        termios termios3 = new termios(termios2);
        m_Clib.cfmakeraw(termios3);
        termios3.update(termios2);
    }

    @Override
    public int fcntl(int n, int n2, int n3) {
        return m_Clib.fcntl(n, n2, n3);
    }

    @Override
    public int tcdrain(int n) {
        return m_Clib.tcdrain(n);
    }

    @Override
    public int cfgetispeed(Termios termios2) {
        return m_Clib.cfgetispeed(new termios(termios2)).intValue();
    }

    @Override
    public int cfgetospeed(Termios termios2) {
        return m_Clib.cfgetospeed(new termios(termios2)).intValue();
    }

    @Override
    public int cfsetispeed(Termios termios2, int n) {
        termios termios3 = new termios(termios2);
        int n2 = m_Clib.cfsetispeed(termios3, new NativeLong((long)n));
        termios3.update(termios2);
        return n2;
    }

    @Override
    public int cfsetospeed(Termios termios2, int n) {
        termios termios3 = new termios(termios2);
        int n2 = m_Clib.cfsetospeed(termios3, new NativeLong((long)n));
        termios3.update(termios2);
        return n2;
    }

    @Override
    public int open(String object, int n) {
        if (object != null && !((String)object).startsWith("/")) {
            object = DEVICE_DIR_PATH + (String)object;
        }
        return m_Clib.open((String)object, n);
    }

    @Override
    public int read(int n, byte[] byArray, int n2) {
        return m_Clib.read(n, byArray, new JTermios.JTermiosInterface.NativeSize(n2)).intValue();
    }

    @Override
    public int write(int n, byte[] byArray, int n2) {
        return m_Clib.write(n, byArray, new JTermios.JTermiosInterface.NativeSize(n2)).intValue();
    }

    @Override
    public int close(int n) {
        return m_Clib.close(n);
    }

    @Override
    public int tcflush(int n, int n2) {
        return m_Clib.tcflush(n, n2);
    }

    @Override
    public int tcgetattr(int n, Termios termios2) {
        termios termios3 = new termios();
        int n2 = m_Clib.tcgetattr(n, termios3);
        termios3.update(termios2);
        return n2;
    }

    @Override
    public void perror(String string) {
        m_Clib.perror(string);
    }

    @Override
    public int tcsendbreak(int n, int n2) {
        return m_Clib.tcsendbreak(n, n2 / 250);
    }

    @Override
    public int tcsetattr(int n, int n2, Termios termios2) {
        return m_Clib.tcsetattr(n, n2, new termios(termios2));
    }

    @Override
    public int select(int n, JTermios.FDSet fDSet, JTermios.FDSet fDSet2, JTermios.FDSet fDSet3, TimeVal timeVal) {
        timeval timeval2 = null;
        if (timeVal != null) {
            timeval2 = new timeval(timeVal);
        }
        return m_Clib.select(n, (fd_set)fDSet, (fd_set)fDSet2, (fd_set)fDSet3, timeval2);
    }

    @Override
    public int poll(Pollfd[] pollfdArray, int n, int n2) {
        throw new UnsupportedOperationException("Poll not supported");
    }

    @Override
    public boolean canPoll() {
        return false;
    }

    @Override
    public JTermios.FDSet newFDSet() {
        return new fd_set();
    }

    @Override
    public int ioctl(int n, int n2, int ... nArray) {
        System.out.println(" ");
        NativeLong nativeLong = new NativeLong((long)nArray[0]);
        NativeLongByReference nativeLongByReference = new NativeLongByReference(nativeLong);
        int n3 = m_Clib.ioctl(n, new NativeLong(0xFFFFFFFFL & (long)n2), nativeLongByReference);
        nArray[0] = nativeLong.intValue();
        return n3;
    }

    @Override
    public List<String> getPortList() {
        File file = new File(DEVICE_DIR_PATH);
        if (!file.isDirectory()) {
            JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "device directory %s does not exist\n", DEVICE_DIR_PATH);
            return null;
        }
        String[] stringArray = file.list();
        LinkedList<String> linkedList = new LinkedList<String>();
        Pattern pattern = JTermios.getPortNamePattern(this);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (!pattern.matcher(string).matches()) continue;
                linkedList.add(string);
            }
        }
        return linkedList;
    }

    @Override
    public String getPortNamePattern() {
        return "^(tty\\.|cu\\.).*";
    }

    @Override
    public void shutDown() {
    }

    @Override
    public int setspeed(int n, Termios termios2, int n2) {
        int n3 = this.cfsetispeed(termios2, n2);
        if (n3 == 0) {
            n3 = this.cfsetospeed(termios2, n2);
        }
        if (n3 == 0) {
            n3 = this.tcsetattr(n, JTermios.TCSANOW, termios2);
        }
        if (n3 != 0 && this.cfsetispeed(termios2, JTermios.B9600) == 0 && this.cfsetospeed(termios2, JTermios.B9600) == 0 && this.tcsetattr(n, JTermios.TCSANOW, termios2) == 0) {
            n3 = this.ioctl(n, IOSSIOSPEED, n2);
        }
        return n3;
    }

    @Override
    public int pipe(int[] nArray) {
        return m_Clib.pipe(nArray);
    }

    static {
        Native.register(C_lib_DirectMapping.class, (NativeLibrary)NativeLibrary.getInstance((String)Platform.C_LIBRARY_NAME));
        m_ClibDM = new C_lib_DirectMapping();
        m_Clib = m_ClibDM;
    }

    public static class termios
    extends Structure {
        public NativeLong c_iflag;
        public NativeLong c_oflag;
        public NativeLong c_cflag;
        public NativeLong c_lflag;
        public byte[] c_cc = new byte[20];
        public NativeLong c_ispeed;
        public NativeLong c_ospeed;

        protected List getFieldOrder() {
            return Arrays.asList("c_iflag", "c_oflag", "c_cflag", "c_lflag", "c_cc", "c_ispeed", "c_ospeed");
        }

        public termios() {
        }

        public termios(Termios termios2) {
            this.c_iflag.setValue((long)termios2.c_iflag);
            this.c_oflag.setValue((long)termios2.c_oflag);
            this.c_cflag.setValue((long)termios2.c_cflag);
            this.c_lflag.setValue((long)termios2.c_lflag);
            System.arraycopy(termios2.c_cc, 0, this.c_cc, 0, Math.min(termios2.c_cc.length, this.c_cc.length));
            this.c_ispeed.setValue((long)termios2.c_ispeed);
            this.c_ospeed.setValue((long)termios2.c_ospeed);
        }

        public void update(Termios termios2) {
            termios2.c_iflag = this.c_iflag.intValue();
            termios2.c_oflag = this.c_oflag.intValue();
            termios2.c_cflag = this.c_cflag.intValue();
            termios2.c_lflag = this.c_lflag.intValue();
            System.arraycopy(this.c_cc, 0, termios2.c_cc, 0, Math.min(termios2.c_cc.length, this.c_cc.length));
            termios2.c_ispeed = this.c_ispeed.intValue();
            termios2.c_ospeed = this.c_ospeed.intValue();
        }
    }

    public static class fd_set
    extends Structure
    implements JTermios.FDSet {
        private static final int NFBBITS = 32;
        private static final int fd_count = 1024;
        public int[] fd_array = new int[32];

        protected List getFieldOrder() {
            return Arrays.asList("fd_array");
        }

        @Override
        public void FD_SET(int n) {
            int n2 = n / 32;
            this.fd_array[n2] = this.fd_array[n2] | 1 << n % 32;
        }

        @Override
        public boolean FD_ISSET(int n) {
            return (this.fd_array[n / 32] & 1 << n % 32) != 0;
        }

        @Override
        public void FD_ZERO() {
            Arrays.fill(this.fd_array, 0);
        }

        @Override
        public void FD_CLR(int n) {
            int n2 = n / 32;
            this.fd_array[n2] = this.fd_array[n2] & ~(1 << n % 32);
        }
    }

    public static class pollfd
    extends Structure {
        public int fd;
        public short events;
        public short revents;

        protected List getFieldOrder() {
            return Arrays.asList("fd", "events", "revents");
        }

        public pollfd() {
        }

        public pollfd(Pollfd pollfd2) {
            this.fd = pollfd2.fd;
            this.events = pollfd2.events;
            this.revents = pollfd2.revents;
        }

        public static class ByReference
        extends pollfd
        implements Structure.ByReference {
        }
    }

    public static class timeval
    extends Structure {
        public NativeLong tv_sec;
        public NativeLong tv_usec;

        protected List getFieldOrder() {
            return Arrays.asList("tv_sec", "tv_usec");
        }

        public timeval(TimeVal timeVal) {
            this.tv_sec = new NativeLong(timeVal.tv_sec);
            this.tv_usec = new NativeLong(timeVal.tv_usec);
        }
    }

    public static interface C_lib
    extends Library {
        public int pipe(int[] var1);

        public int tcdrain(int var1);

        public void cfmakeraw(termios var1);

        public int fcntl(int var1, int var2, int var3);

        public int ioctl(int var1, NativeLong var2, NativeLongByReference var3);

        public int open(String var1, int var2);

        public int close(int var1);

        public int tcgetattr(int var1, termios var2);

        public int tcsetattr(int var1, int var2, termios var3);

        public int cfsetispeed(termios var1, NativeLong var2);

        public int cfsetospeed(termios var1, NativeLong var2);

        public NativeLong cfgetispeed(termios var1);

        public NativeLong cfgetospeed(termios var1);

        public JTermios.JTermiosInterface.NativeSize write(int var1, byte[] var2, JTermios.JTermiosInterface.NativeSize var3);

        public JTermios.JTermiosInterface.NativeSize read(int var1, byte[] var2, JTermios.JTermiosInterface.NativeSize var3);

        public int tcflush(int var1, int var2);

        public void perror(String var1);

        public int tcsendbreak(int var1, int var2);

        public int select(int var1, fd_set var2, fd_set var3, fd_set var4, timeval var5);
    }

    public static class C_lib_DirectMapping
    implements C_lib {
        @Override
        public native int pipe(int[] var1);

        @Override
        public native int tcdrain(int var1);

        @Override
        public native void cfmakeraw(termios var1);

        @Override
        public native int fcntl(int var1, int var2, int var3);

        public native int ioctl(int var1, NativeLong var2);

        public native int ioctl(int var1, NativeLong var2, int var3);

        @Override
        public native int ioctl(int var1, NativeLong var2, NativeLongByReference var3);

        @Override
        public native int open(String var1, int var2);

        @Override
        public native int close(int var1);

        @Override
        public native int tcgetattr(int var1, termios var2);

        @Override
        public native int tcsetattr(int var1, int var2, termios var3);

        @Override
        public native int cfsetispeed(termios var1, NativeLong var2);

        @Override
        public native int cfsetospeed(termios var1, NativeLong var2);

        @Override
        public native NativeLong cfgetispeed(termios var1);

        @Override
        public native NativeLong cfgetospeed(termios var1);

        @Override
        public native JTermios.JTermiosInterface.NativeSize write(int var1, byte[] var2, JTermios.JTermiosInterface.NativeSize var3);

        @Override
        public native JTermios.JTermiosInterface.NativeSize read(int var1, byte[] var2, JTermios.JTermiosInterface.NativeSize var3);

        @Override
        public native int tcflush(int var1, int var2);

        @Override
        public native void perror(String var1);

        @Override
        public native int tcsendbreak(int var1, int var2);

        @Override
        public native int select(int var1, fd_set var2, fd_set var3, fd_set var4, timeval var5);
    }
}

