/*
 * Decompiled with CFR 0.152.
 */
package jtermios.testsuite;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import purejavacomm.CommPortIdentifier;
import purejavacomm.SerialPort;

public class TwoPortSerialTest {
    public static void main(String[] args) throws Exception {
        if (args.length != 6 || !args[0].equalsIgnoreCase("S") && !args[0].equalsIgnoreCase("R")) {
            System.err.printf("usage: %s <S|R> <port> <baudrate> <databits> <stopbits> <parity>%n", TwoPortSerialTest.class.getName());
            System.exit(1);
            return;
        }
        if (args[0].equalsIgnoreCase("s")) {
            TwoPortSerialTest.runSender(Arrays.copyOfRange(args, 1, 6));
        } else {
            TwoPortSerialTest.runReceiver(Arrays.copyOfRange(args, 1, 6));
        }
    }

    public static void runSender(String[] args) throws Exception {
        int baudRate = Integer.valueOf(args[1]);
        int dataBits = Integer.valueOf(args[2]);
        int stopBits = 1;
        if (args[3].equals("1")) {
            stopBits = 1;
        } else if (args[3].equals("1.5") || args[3].equals("2")) {
            stopBits = 2;
        } else {
            System.err.println("Invalid stop bits");
            System.exit(1);
            return;
        }
        int parity = 0;
        if (args[4].equalsIgnoreCase("e")) {
            parity = 2;
        } else if (args[4].equalsIgnoreCase("o")) {
            parity = 1;
        } else if (args[4].equalsIgnoreCase("n")) {
            parity = 0;
        } else if (args[4].equalsIgnoreCase("m")) {
            parity = 3;
        } else if (args[4].equalsIgnoreCase("s")) {
            parity = 4;
        } else {
            System.err.println("Invalid parity");
            System.exit(1);
            return;
        }
        int requiredExtraBits = 0;
        if (stopBits != 1) {
            ++requiredExtraBits;
        }
        if (parity != 0) {
            ++requiredExtraBits;
        }
        if (dataBits + requiredExtraBits > 8) {
            System.err.printf("This test can only run with up to %d data bits%n", 8 - requiredExtraBits);
            System.exit(1);
            return;
        }
        SerialPort p = (SerialPort)CommPortIdentifier.getPortIdentifier(args[0]).open(TwoPortSerialTest.class.getName(), 0);
        p.setSerialPortParams(baudRate, dataBits, stopBits, parity);
        OutputStream out = p.getOutputStream();
        int N = 1 << dataBits;
        for (int n = 0; n < N; ++n) {
            out.write(n);
            Thread.sleep(1L);
        }
    }

    public static void runReceiver(String[] args) throws Exception {
        int baudRate = Integer.valueOf(args[1]);
        int dataBits = Integer.valueOf(args[2]);
        int stopBits = 1;
        if (args[3].equals("1")) {
            stopBits = 1;
        } else if (args[3].equals("1.5") || args[3].equals("2")) {
            stopBits = 2;
        } else {
            System.err.println("Invalid stop bits");
            System.exit(1);
            return;
        }
        int parity = 0;
        if (args[4].equalsIgnoreCase("e")) {
            parity = 2;
        } else if (args[4].equalsIgnoreCase("o")) {
            parity = 1;
        } else if (args[4].equalsIgnoreCase("n")) {
            parity = 0;
        } else if (args[4].equalsIgnoreCase("m")) {
            parity = 3;
        } else if (args[4].equalsIgnoreCase("s")) {
            parity = 4;
        } else {
            System.err.println("Invalid parity");
            System.exit(1);
            return;
        }
        int requiredExtraBits = 1;
        if (stopBits != 1) {
            ++requiredExtraBits;
        }
        if (parity != 0) {
            ++requiredExtraBits;
        }
        if (dataBits + requiredExtraBits > 8) {
            System.err.printf("This test can only run with up to %d data bits%n", 8 - requiredExtraBits);
            System.exit(1);
            return;
        }
        SerialPort p = (SerialPort)CommPortIdentifier.getPortIdentifier(args[0]).open(TwoPortSerialTest.class.getName(), 0);
        p.setSerialPortParams(baudRate, dataBits + requiredExtraBits, 1, 0);
        p.enableReceiveTimeout(10000);
        InputStream in = p.getInputStream();
        while (in.available() != 0) {
            in.read();
        }
        System.out.println("Waiting for A...");
        int N = 1 << dataBits;
        boolean failed = false;
        for (int n = 0; n < N; ++n) {
            int v = in.read();
            if (v == -1) {
                System.out.printf("Timeout on value %d%n", n);
                failed = true;
                break;
            }
            if ((v & N - 1) != n) {
                System.out.printf("Invalid data byte %02X for value %d%n", v, n);
                failed = true;
            }
            int par = v >> dataBits & 1;
            switch (parity) {
                case 0: {
                    break;
                }
                case 2: {
                    if (par == Integer.bitCount(v & N - 1) % 2) break;
                    System.out.printf("Invalid even parity in byte %02X for value %d%n", v, n);
                    failed = true;
                    break;
                }
                case 1: {
                    if (par != Integer.bitCount(v & N - 1) % 2) break;
                    System.out.printf("Invalid odd parity in byte %02X for value %d%n", v, n);
                    failed = true;
                    break;
                }
                case 3: {
                    if (par == 1) break;
                    System.out.printf("Invalid mark parity in byte %02X for value %d%n", v, n);
                    failed = true;
                    break;
                }
                case 4: {
                    if (par == 0) break;
                    System.out.printf("Invalid space parity in byte %02X for value %d%n", v, n);
                    failed = true;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            int stop = v >> dataBits + (parity != 0 ? 1 : 0);
            if (stopBits != 1) {
                if ((stop &= 3) == 3) continue;
                System.out.printf("Invalid stop bits %X for value %d%n", stop, n);
                failed = true;
                continue;
            }
            if ((stop &= 1) == 1) continue;
            System.out.printf("Invalid stop bit %d for value %d%n", stop, n);
            failed = true;
        }
        System.out.println(failed ? "FAIL" : "SUCCESS");
        System.exit(failed ? 2 : 1);
    }
}

