/*
 * Decompiled with CFR 0.152.
 */
package jtermios.windows;

import com.sun.jna.FromNativeContext;
import com.sun.jna.IntegerType;
import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIOptions;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import jtermios.JTermios;

public class WinAPI {
    private static Windows_kernel32_lib m_K32lib;
    private static Windows_kernel32_lib_Direct m_K32libDM;
    private static WaitMultiple m_K32libWM;
    private static final ThreadLocal<int[]> LastError;
    public static HANDLE INVALID_HANDLE_VALUE;
    public static HANDLE NULL;
    public static final int ERROR_INSUFFICIENT_BUFFER = 122;
    public static final int MAXDWORD = -1;
    public static final int STATUS_WAIT_0 = 0;
    public static final int STATUS_ABANDONED_WAIT_0 = 128;
    public static final int WAIT_ABANDONED = 128;
    public static final int WAIT_ABANDONED_0 = 128;
    public static final int WAIT_OBJECT_0 = 0;
    public static final int WAIT_FAILED = -1;
    public static final int INFINITE = -1;
    public static final int WAIT_TIMEOUT = 258;
    public static final int GENERIC_READ = Integer.MIN_VALUE;
    public static final int GENERIC_WRITE = 0x40000000;
    public static final int GENERIC_EXECUTE = 0x20000000;
    public static final int GENERIC_ALL = 0x10000000;
    public static final int CREATE_NEW = 1;
    public static final int CREATE_ALWAYS = 2;
    public static final int OPEN_EXISTING = 3;
    public static final int OPEN_ALWAYS = 4;
    public static final int TRUNCATE_EXISTING = 5;
    public static final int PURGE_TXABORT = 1;
    public static final int PURGE_RXABORT = 2;
    public static final int PURGE_TXCLEAR = 4;
    public static final int PURGE_RXCLEAR = 8;
    public static final int MS_CTS_ON = 16;
    public static final int MS_DSR_ON = 32;
    public static final int MS_RING_ON = 64;
    public static final int MS_RLSD_ON = 128;
    public static final int SETXOFF = 1;
    public static final int SETXON = 2;
    public static final int SETRTS = 3;
    public static final int CLRRTS = 4;
    public static final int SETDTR = 5;
    public static final int CLRDTR = 6;
    public static final int RESETDEV = 7;
    public static final int SETBREAK = 8;
    public static final int CLRBREAK = 9;
    public static final int FILE_ATTRIBUTE_NORMAL = 128;
    public static final int FILE_FLAG_WRITE_THROUGH = Integer.MIN_VALUE;
    public static final int FILE_FLAG_OVERLAPPED = 0x40000000;
    public static final int FILE_FLAG_NO_BUFFERING = 0x20000000;
    public static final int FILE_FLAG_RANDOM_ACCESS = 0x10000000;
    public static final int FILE_FLAG_SEQUENTIAL_SCAN = 0x8000000;
    public static final int FILE_FLAG_DELETE_ON_CLOSE = 0x4000000;
    public static final int FILE_FLAG_BACKUP_SEMANTICS = 0x2000000;
    public static final int FILE_FLAG_POSIX_SEMANTICS = 0x1000000;
    public static final int FILE_FLAG_OPEN_REPARSE_POINT = 0x200000;
    public static final int FILE_FLAG_OPEN_NO_RECALL = 0x100000;
    public static final int FILE_FLAG_FIRST_PIPE_INSTANCE = 524288;
    public static final int ERROR_OPERATION_ABORTED = 995;
    public static final int ERROR_IO_INCOMPLETE = 996;
    public static final int ERROR_IO_PENDING = 997;
    public static final int ERROR_INVALID_PARAMETER = 87;
    public static final int ERROR_BROKEN_PIPE = 109;
    public static final int ERROR_MORE_DATA = 234;
    public static final int ERROR_FILE_NOT_FOUND = 2;
    public static final byte NOPARITY = 0;
    public static final byte ODDPARITY = 1;
    public static final byte EVENPARITY = 2;
    public static final byte MARKPARITY = 3;
    public static final byte SPACEPARITY = 4;
    public static final byte ONESTOPBIT = 0;
    public static final byte ONE5STOPBITS = 1;
    public static final byte TWOSTOPBITS = 2;
    public static final int CBR_110 = 110;
    public static final int CBR_300 = 300;
    public static final int CBR_600 = 600;
    public static final int CBR_1200 = 1200;
    public static final int CBR_2400 = 2400;
    public static final int CBR_4800 = 4800;
    public static final int CBR_9600 = 9600;
    public static final int CBR_14400 = 14400;
    public static final int CBR_19200 = 19200;
    public static final int CBR_38400 = 38400;
    public static final int CBR_56000 = 56000;
    public static final int CBR_57600 = 57600;
    public static final int CBR_115200 = 115200;
    public static final int CBR_128000 = 128000;
    public static final int CBR_256000 = 256000;
    public static final int CE_RXOVER = 1;
    public static final int CE_OVERRUN = 2;
    public static final int CE_RXPARITY = 4;
    public static final int CE_FRAME = 8;
    public static final int CE_BREAK = 16;
    public static final int CE_TXFULL = 256;
    public static final int CE_PTO = 512;
    public static final int CE_IOE = 1024;
    public static final int CE_DNS = 2048;
    public static final int CE_OOP = 4096;
    public static final int CE_MODE = 32768;
    public static final int IE_BADID = -1;
    public static final int IE_OPEN = -2;
    public static final int IE_NOPEN = -3;
    public static final int IE_MEMORY = -4;
    public static final int IE_DEFAULT = -5;
    public static final int IE_HARDWARE = -10;
    public static final int IE_BYTESIZE = -11;
    public static final int IE_BAUDRATE = -12;
    public static final int EV_RXCHAR = 1;
    public static final int EV_RXFLAG = 2;
    public static final int EV_TXEMPTY = 4;
    public static final int EV_CTS = 8;
    public static final int EV_DSR = 16;
    public static final int EV_RLSD = 32;
    public static final int EV_BREAK = 64;
    public static final int EV_ERR = 128;
    public static final int EV_RING = 256;
    public static final int EV_PERR = 512;
    public static final int EV_RX80FULL = 1024;
    public static final int EV_EVENT1 = 2048;
    public static final int EV_EVENT2 = 4096;
    public static final int FORMAT_MESSAGE_ALLOCATE_BUFFER = 256;
    public static final int FORMAT_MESSAGE_IGNORE_INSERTS = 512;
    public static final int FORMAT_MESSAGE_FROM_STRING = 1024;
    public static final int FORMAT_MESSAGE_FROM_HMODULE = 2048;
    public static final int FORMAT_MESSAGE_FROM_SYSTEM = 4096;
    public static final int FORMAT_MESSAGE_ARGUMENT_ARRAY = 8192;
    public static final int FORMAT_MESSAGE_MAX_WIDTH_MASK = 255;
    public static final int LANG_NEUTRAL = 0;
    public static final int SUBLANG_DEFAULT = 1;

    public static int MAKELANGID(int n, int n2) {
        return n2 << 10 | n;
    }

    public static HANDLE CreateFile(String string, int n, int n2, SECURITY_ATTRIBUTES sECURITY_ATTRIBUTES, int n3, int n4, Pointer pointer) {
        HANDLE hANDLE;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> CreateFileA(%s, 0x%08X, 0x%08X, %s, 0x%08X, 0x%08X,%s)\n", new Object[]{string, n, n2, sECURITY_ATTRIBUTES, n3, n4, pointer});
        try {
            hANDLE = m_K32lib.CreateFile(string, n, n2, sECURITY_ATTRIBUTES, n3, n4, pointer);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException lastErrorException) {
            hANDLE = INVALID_HANDLE_VALUE;
            WinAPI.LastError.get()[0] = lastErrorException.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< CreateFileA(%s, 0x%08X, 0x%08X, %s, 0x%08X, 0x%08X,%s) => %s\n", new Object[]{string, n, n2, sECURITY_ATTRIBUTES, n3, n4, pointer, hANDLE});
        return hANDLE;
    }

    public static boolean WriteFile(HANDLE hANDLE, byte[] byArray, int n, int[] nArray) {
        boolean bl;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> WriteFile(%s, %s, %d, [%d])\n", new Object[]{hANDLE, JTermios.JTermiosLogging.log(byArray, n), n, nArray[0]});
        try {
            bl = m_K32lib.WriteFile(hANDLE, byArray, n, nArray, null);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException lastErrorException) {
            bl = false;
            WinAPI.LastError.get()[0] = lastErrorException.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< WriteFile(%s, %s, %d, [%d]) => %s\n", new Object[]{hANDLE, JTermios.JTermiosLogging.log(byArray, n), n, nArray[0], bl});
        return bl;
    }

    public static boolean WriteFile(HANDLE hANDLE, Pointer pointer, int n, int[] nArray, OVERLAPPED oVERLAPPED) {
        boolean bl;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> WriteFile(%s, %s, %d, [%d], %s)\n", new Object[]{hANDLE, JTermios.JTermiosLogging.log(pointer.getByteArray(0L, n), 5), n, nArray[0], JTermios.JTermiosLogging.ref(oVERLAPPED)});
        try {
            bl = m_K32lib.WriteFile(hANDLE, pointer, n, nArray, oVERLAPPED.getPointer());
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException lastErrorException) {
            bl = false;
            WinAPI.LastError.get()[0] = lastErrorException.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< WriteFile(%s, %s, %d, [%d], %s) => %s\n", new Object[]{hANDLE, JTermios.JTermiosLogging.log(pointer.getByteArray(0L, n), 5), n, nArray[0], JTermios.JTermiosLogging.ref(oVERLAPPED), bl});
        return bl;
    }

    public static boolean ReadFile(HANDLE hANDLE, byte[] byArray, int n, int[] nArray) {
        boolean bl;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> ReadFile(%s, %s, %d, [%d])\n", new Object[]{hANDLE, JTermios.JTermiosLogging.log(byArray, n), n, nArray[0]});
        try {
            bl = m_K32lib.ReadFile(hANDLE, byArray, n, nArray, null);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException lastErrorException) {
            bl = false;
            WinAPI.LastError.get()[0] = lastErrorException.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< ReadFile(%s, %s, %d, [%d]) => %s\n", new Object[]{hANDLE, JTermios.JTermiosLogging.log(byArray, n), n, nArray[0], bl});
        return bl;
    }

    public static boolean ReadFile(HANDLE hANDLE, Pointer pointer, int n, int[] nArray, OVERLAPPED oVERLAPPED) {
        boolean bl;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> ReadFile(%s, %s, %d, [%d], %s)\n", new Object[]{hANDLE, JTermios.JTermiosLogging.log(pointer.getByteArray(0L, n), 5), n, nArray[0], JTermios.JTermiosLogging.ref(oVERLAPPED)});
        try {
            bl = m_K32lib.ReadFile(hANDLE, pointer, n, nArray, oVERLAPPED.getPointer());
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException lastErrorException) {
            bl = false;
            WinAPI.LastError.get()[0] = lastErrorException.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< ReadFile(%s, %s, %d, [%d], %s) => %s\n", new Object[]{hANDLE, JTermios.JTermiosLogging.log(pointer.getByteArray(0L, n), 5), n, nArray[0], JTermios.JTermiosLogging.ref(oVERLAPPED), bl});
        return bl;
    }

    public static boolean FlushFileBuffers(HANDLE hANDLE) {
        boolean bl;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> FlushFileBuffers(%s)\n", new Object[]{hANDLE});
        try {
            bl = m_K32lib.FlushFileBuffers(hANDLE);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException lastErrorException) {
            bl = false;
            WinAPI.LastError.get()[0] = lastErrorException.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< FlushFileBuffers(%s) => %s\n", new Object[]{hANDLE, bl});
        return bl;
    }

    public static boolean PurgeComm(HANDLE hANDLE, int n) {
        boolean bl;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> PurgeComm(%s,0x%08X)\n", new Object[]{hANDLE, n});
        try {
            bl = m_K32lib.PurgeComm(hANDLE, n);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException lastErrorException) {
            bl = false;
            WinAPI.LastError.get()[0] = lastErrorException.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< PurgeComm(%s,0x%08X) => %s\n", new Object[]{hANDLE, n, bl});
        return bl;
    }

    public static boolean CancelIo(HANDLE hANDLE) {
        boolean bl;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> CancelIo(%s)\n", new Object[]{hANDLE});
        try {
            bl = m_K32lib.CancelIo(hANDLE);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException lastErrorException) {
            bl = false;
            WinAPI.LastError.get()[0] = lastErrorException.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< CancelIo(%s) => %s\n", new Object[]{hANDLE, bl});
        return bl;
    }

    public static boolean CloseHandle(HANDLE hANDLE) {
        boolean bl;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> CloseHandle(%s)\n", new Object[]{hANDLE});
        try {
            bl = m_K32lib.CloseHandle(hANDLE);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException lastErrorException) {
            bl = false;
            WinAPI.LastError.get()[0] = lastErrorException.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< CloseHandle(%s) => %s\n", new Object[]{hANDLE, bl});
        return bl;
    }

    public static boolean ClearCommError(HANDLE hANDLE, int[] nArray, COMSTAT cOMSTAT) {
        boolean bl;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> ClearCommError(%s, [%d], %s)\n", new Object[]{hANDLE, nArray[0], cOMSTAT});
        try {
            bl = m_K32lib.ClearCommError(hANDLE, nArray, cOMSTAT);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException lastErrorException) {
            bl = false;
            WinAPI.LastError.get()[0] = lastErrorException.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< ClearCommError(%s, [%d], %s) => %s\n", new Object[]{hANDLE, nArray[0], cOMSTAT, bl});
        return bl;
    }

    public static boolean SetCommMask(HANDLE hANDLE, int n) {
        boolean bl;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> SetCommMask(%s, 0x%08X)\n", new Object[]{hANDLE, n});
        try {
            bl = m_K32lib.SetCommMask(hANDLE, n);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException lastErrorException) {
            bl = false;
            WinAPI.LastError.get()[0] = lastErrorException.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< SetCommMask(%s, 0x%08X) => %s\n", new Object[]{hANDLE, n, bl});
        return bl;
    }

    public static boolean GetCommMask(HANDLE hANDLE, int[] nArray) {
        boolean bl;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> GetCommMask(%s, [0x%08X])\n", new Object[]{hANDLE, nArray[0]});
        try {
            bl = m_K32lib.GetCommMask(hANDLE, nArray);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException lastErrorException) {
            bl = false;
            WinAPI.LastError.get()[0] = lastErrorException.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< GetCommMask(%s, [0x%08X]) => %s\n", new Object[]{hANDLE, nArray[0], bl});
        return bl;
    }

    public static boolean GetCommState(HANDLE hANDLE, DCB dCB) {
        boolean bl;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> GetCommState(%s, %s)\n", new Object[]{hANDLE, dCB});
        try {
            bl = m_K32lib.GetCommState(hANDLE, dCB);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException lastErrorException) {
            bl = false;
            WinAPI.LastError.get()[0] = lastErrorException.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< GetCommState(%s, %s) => %s\n", new Object[]{hANDLE, dCB, bl});
        return bl;
    }

    public static boolean SetCommState(HANDLE hANDLE, DCB dCB) {
        boolean bl;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> SetCommState(%s, %s)\n", new Object[]{hANDLE, dCB});
        try {
            bl = m_K32lib.SetCommState(hANDLE, dCB);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException lastErrorException) {
            bl = false;
            WinAPI.LastError.get()[0] = lastErrorException.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< SetCommState(%s, %s) => %s\n", new Object[]{hANDLE, dCB, bl});
        return bl;
    }

    public static boolean SetCommTimeouts(HANDLE hANDLE, COMMTIMEOUTS cOMMTIMEOUTS) {
        boolean bl;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> SetCommTimeouts(%s, %s)\n", new Object[]{hANDLE, cOMMTIMEOUTS});
        try {
            bl = m_K32lib.SetCommTimeouts(hANDLE, cOMMTIMEOUTS);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException lastErrorException) {
            bl = false;
            WinAPI.LastError.get()[0] = lastErrorException.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< SetCommTimeouts(%s, %s) => %s\n", new Object[]{hANDLE, cOMMTIMEOUTS, bl});
        return bl;
    }

    public static boolean SetupComm(HANDLE hANDLE, int n, int n2) {
        boolean bl;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> SetCommTimeouts(%s, %d, %d)\n", new Object[]{hANDLE, n, n2});
        try {
            bl = m_K32lib.SetupComm(hANDLE, n, n2);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException lastErrorException) {
            bl = false;
            WinAPI.LastError.get()[0] = lastErrorException.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< SetCommTimeouts(%s, %d, %d) => %s\n", new Object[]{hANDLE, n, n2, bl});
        return bl;
    }

    public static boolean SetCommBreak(HANDLE hANDLE) {
        boolean bl;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> SetCommBreak(%s)\n", new Object[]{hANDLE});
        try {
            bl = m_K32lib.SetCommBreak(hANDLE);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException lastErrorException) {
            bl = false;
            WinAPI.LastError.get()[0] = lastErrorException.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< SetCommBreak(%s) => %s\n", new Object[]{hANDLE, bl});
        return bl;
    }

    public static boolean ClearCommBreak(HANDLE hANDLE) {
        boolean bl;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> ClearCommBreak(%s)\n", new Object[]{hANDLE});
        try {
            bl = m_K32lib.ClearCommBreak(hANDLE);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException lastErrorException) {
            bl = false;
            WinAPI.LastError.get()[0] = lastErrorException.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< ClearCommBreak(%s) => %s\n", new Object[]{hANDLE, bl});
        return bl;
    }

    public static boolean GetCommModemStatus(HANDLE hANDLE, int[] nArray) {
        boolean bl;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> GetCommModemStatus(%s,0x%08X)\n", new Object[]{hANDLE, nArray[0]});
        try {
            bl = m_K32lib.GetCommModemStatus(hANDLE, nArray);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException lastErrorException) {
            bl = false;
            WinAPI.LastError.get()[0] = lastErrorException.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< GetCommModemStatus(%s,0x%08X) => %s\n", new Object[]{hANDLE, nArray[0], bl});
        return bl;
    }

    public static boolean EscapeCommFunction(HANDLE hANDLE, int n) {
        boolean bl;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> EscapeCommFunction(%s,0x%08X)\n", new Object[]{hANDLE, n});
        try {
            bl = m_K32lib.EscapeCommFunction(hANDLE, n);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException lastErrorException) {
            bl = false;
            WinAPI.LastError.get()[0] = lastErrorException.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< EscapeCommFunction(%s,0x%08X) => %s\n", new Object[]{hANDLE, n, bl});
        return bl;
    }

    public static HANDLE CreateEvent(SECURITY_ATTRIBUTES sECURITY_ATTRIBUTES, boolean bl, boolean bl2, String string) {
        HANDLE hANDLE;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> CreateEventA(%s, %s, %s, %s)\n", JTermios.JTermiosLogging.ref(sECURITY_ATTRIBUTES), bl, bl2, string);
        try {
            hANDLE = m_K32lib.CreateEvent(sECURITY_ATTRIBUTES, bl, bl2, string);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException lastErrorException) {
            hANDLE = INVALID_HANDLE_VALUE;
            WinAPI.LastError.get()[0] = lastErrorException.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< CreateEventA(%s, %s, %s, %s) => %s\n", new Object[]{JTermios.JTermiosLogging.ref(sECURITY_ATTRIBUTES), bl, bl2, string, hANDLE});
        return hANDLE;
    }

    public static boolean SetEvent(HANDLE hANDLE) {
        boolean bl;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> SetEvent(%s)\n", new Object[]{hANDLE});
        try {
            bl = m_K32lib.SetEvent(hANDLE);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException lastErrorException) {
            bl = false;
            WinAPI.LastError.get()[0] = lastErrorException.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< SetEvent(%s) => %s\n", new Object[]{hANDLE, bl});
        return bl;
    }

    public static boolean ResetEvent(HANDLE hANDLE) {
        boolean bl;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> ResetEvent(%s)\n", new Object[]{hANDLE});
        try {
            bl = m_K32lib.ResetEvent(hANDLE);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException lastErrorException) {
            bl = false;
            WinAPI.LastError.get()[0] = lastErrorException.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< ResetEvent(%s) => %s\n", new Object[]{hANDLE, bl});
        return bl;
    }

    public static boolean WaitCommEvent(HANDLE hANDLE, IntByReference intByReference, OVERLAPPED oVERLAPPED) {
        boolean bl;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> WaitCommEvent(%s, [%d], %s)\n", new Object[]{hANDLE, intByReference.getValue(), JTermios.JTermiosLogging.ref(oVERLAPPED)});
        try {
            bl = m_K32lib.WaitCommEvent(hANDLE, intByReference, oVERLAPPED.getPointer());
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException lastErrorException) {
            bl = false;
            WinAPI.LastError.get()[0] = lastErrorException.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< WaitCommEvent(%s, [%d], %s) => %s\n", new Object[]{hANDLE, intByReference.getValue(), JTermios.JTermiosLogging.ref(oVERLAPPED), bl});
        return bl;
    }

    public static boolean WaitCommEvent(HANDLE hANDLE, int[] nArray) {
        boolean bl;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> WaitCommEvent(%s, [%d], %s) => %s\n", new Object[]{hANDLE, nArray[0], null});
        IntByReference intByReference = new IntByReference(nArray[0]);
        try {
            bl = m_K32lib.WaitCommEvent(hANDLE, intByReference, null);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException lastErrorException) {
            bl = false;
            WinAPI.LastError.get()[0] = lastErrorException.getErrorCode();
        }
        nArray[0] = intByReference.getValue();
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< WaitCommEvent(%s, [%d], %s) => %s\n", new Object[]{hANDLE, nArray[0], null, bl});
        return bl;
    }

    public static int WaitForSingleObject(HANDLE hANDLE, int n) {
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> WaitForSingleObject(%s, %d)\n", new Object[]{hANDLE, n});
        int n2 = m_K32lib.WaitForSingleObject(hANDLE, n);
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< WaitForSingleObject(%s, %d) => %s\n", new Object[]{hANDLE, n, n2});
        return n2;
    }

    public static int WaitForMultipleObjects(int n, HANDLE[] hANDLEArray, boolean bl, int n2) {
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> WaitForMultipleObjects(%d, %s, %s, %d)\n", n, JTermios.JTermiosLogging.log((Object[])hANDLEArray, 3), bl, n2);
        int n3 = m_K32libWM.WaitForMultipleObjects(n, hANDLEArray, bl, n2);
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< WaitForMultipleObjects(%d, %s, %s, %d) => %s\n", n, JTermios.JTermiosLogging.log((Object[])hANDLEArray, 3), bl, n2, n3);
        return n3;
    }

    public static boolean GetOverlappedResult(HANDLE hANDLE, OVERLAPPED oVERLAPPED, int[] nArray, boolean bl) {
        boolean bl2;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> GetOverlappedResult(%s, %s, [%d], %s)\n", new Object[]{hANDLE, JTermios.JTermiosLogging.ref(oVERLAPPED), nArray[0], bl});
        try {
            bl2 = m_K32lib.GetOverlappedResult(hANDLE, oVERLAPPED.getPointer(), nArray, bl);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException lastErrorException) {
            bl2 = false;
            WinAPI.LastError.get()[0] = lastErrorException.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< GetOverlappedResult(%s, %s, [%d], %s) => %s\n", new Object[]{hANDLE, JTermios.JTermiosLogging.ref(oVERLAPPED), nArray[0], bl, bl2});
        return bl2;
    }

    public static int GetLastError() {
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> GetLastError()\n", new Object[0]);
        int n = LastError.get()[0];
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< GetLastError() => %d\n", n);
        return n;
    }

    public static int FormatMessageW(int n, Pointer pointer, int n2, int n3, Pointer pointer2, int n4, Pointer pointer3) {
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> FormatMessageW(%08x, %08x, %d, %d, %s, %d, %s)\n", n, pointer, n2, n3, pointer2, n4, pointer3);
        int n5 = m_K32lib.FormatMessageW(n, pointer, n2, n3, pointer2, n4, pointer3);
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< FormatMessageW(%08x, %08x, %d, %d, %s, %d, %s) => %d\n", n, pointer, n2, n3, pointer2, n4, pointer3, n5);
        return n5;
    }

    public static int QueryDosDevice(String string, byte[] byArray, int n) {
        int n2;
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> QueryDosDeviceA(%s, %s, %d)\n", string, byArray, n);
        try {
            n2 = m_K32lib.QueryDosDevice(string, byArray, n);
            WinAPI.LastError.get()[0] = 0;
        }
        catch (LastErrorException lastErrorException) {
            n2 = 0;
            WinAPI.LastError.get()[0] = lastErrorException.getErrorCode();
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(4, "< QueryDosDeviceA(%s, %s, %d) => %d\n", string, byArray, n, n2);
        return n2;
    }

    static {
        m_K32libWM = (WaitMultiple)Native.loadLibrary((String)"kernel32", WaitMultiple.class, (Map)W32APIOptions.ASCII_OPTIONS);
        Native.register(Windows_kernel32_lib_Direct.class, (NativeLibrary)NativeLibrary.getInstance((String)"kernel32", (Map)W32APIOptions.ASCII_OPTIONS));
        m_K32libDM = new Windows_kernel32_lib_Direct();
        m_K32lib = m_K32libDM;
        LastError = new ThreadLocal<int[]>(){

            @Override
            protected int[] initialValue() {
                return new int[1];
            }
        };
        INVALID_HANDLE_VALUE = new HANDLE(Pointer.createConstant((long)(Native.POINTER_SIZE == 8 ? -1L : 0xFFFFFFFFL)));
        NULL = new HANDLE(Pointer.createConstant((int)0));
    }

    public static class COMSTAT
    extends Structure {
        public int fFlags;
        public static final int fCtsHold = 1;
        public static final int fDsrHold = 2;
        public static final int fRlsdHold = 4;
        public static final int fXoffHold = 8;
        public static final int fXoffSent = 16;
        public static final int fEof = 32;
        public static final int fTxim = 64;
        public static final int fReserved = -128;
        public int cbInQue;
        public int cbOutQue;

        protected List getFieldOrder() {
            return Arrays.asList("fFlags", "cbInQue", "cbOutQue");
        }

        public String toString() {
            return String.format("[fFlags %04X cbInQue %d cbInQue %d]", this.fFlags, this.cbInQue, this.cbOutQue);
        }
    }

    public static class COMMTIMEOUTS
    extends Structure {
        public int ReadIntervalTimeout;
        public int ReadTotalTimeoutMultiplier;
        public int ReadTotalTimeoutConstant;
        public int WriteTotalTimeoutMultiplier;
        public int WriteTotalTimeoutConstant;

        protected List getFieldOrder() {
            return Arrays.asList("ReadIntervalTimeout", "ReadTotalTimeoutMultiplier", "ReadTotalTimeoutConstant", "WriteTotalTimeoutMultiplier", "WriteTotalTimeoutConstant");
        }

        public String toString() {
            return String.format("[ReadIntervalTimeout %d ReadTotalTimeoutMultiplier %d ReadTotalTimeoutConstant %d WriteTotalTimeoutMultiplier %d WriteTotalTimeoutConstant %d]", this.ReadIntervalTimeout, this.ReadTotalTimeoutMultiplier, this.ReadTotalTimeoutConstant, this.WriteTotalTimeoutMultiplier, this.WriteTotalTimeoutConstant);
        }
    }

    public static class DCB
    extends Structure {
        public int DCBlength;
        public int BaudRate;
        public int fFlags;
        public static final int fBinary = 1;
        public static final int fParity = 2;
        public static final int fOutxCtsFlow = 4;
        public static final int fOutxDsrFlow = 8;
        public static final int fDtrControl = 48;
        public static final int fDsrSensitivity = 64;
        public static final int fTXContinueOnXoff = 128;
        public static final int fOutX = 256;
        public static final int fInX = 512;
        public static final int fErrorChar = 1024;
        public static final int fNull = 2048;
        public static final int fRtsControl = 12288;
        public static final int fAbortOnError = 16384;
        public static final int fDummy2 = Short.MIN_VALUE;
        public short wReserved;
        public short XonLim;
        public short XoffLim;
        public byte ByteSize;
        public byte Parity;
        public byte StopBits;
        public byte XonChar;
        public byte XoffChar;
        public byte ErrorChar;
        public byte EofChar;
        public byte EvtChar;
        public short wReserved1;

        protected List getFieldOrder() {
            return Arrays.asList("DCBlength", "BaudRate", "fFlags", "wReserved", "XonLim", "XoffLim", "ByteSize", "Parity", "StopBits", "XonChar", "XoffChar", "ErrorChar", "EofChar", "EvtChar", "wReserved1");
        }

        public String toString() {
            return String.format("[BaudRate %d fFlags %04X wReserved %d XonLim %d XoffLim %d ByteSize %d Parity %d StopBits %d XonChar %02X XoffChar %02X ErrorChar %02X EofChar %02X EvtChar %02X wReserved1 %d]", this.BaudRate, this.fFlags, this.wReserved, this.XonLim, this.XoffLim, this.ByteSize, this.Parity, this.StopBits, this.XonChar, this.XoffChar, this.ErrorChar, this.EofChar, this.EvtChar, this.wReserved1);
        }
    }

    public static class SECURITY_ATTRIBUTES
    extends Structure {
        public int nLength;
        public Pointer lpSecurityDescriptor;
        public boolean bInheritHandle;

        protected List getFieldOrder() {
            return Arrays.asList("nLength", "lpSecurityDescriptor", "bInheritHandle");
        }
    }

    public static class OVERLAPPED
    extends Structure {
        public ULONG_PTR Internal;
        public ULONG_PTR InternalHigh;
        public int Offset;
        public int OffsetHigh;
        public HANDLE hEvent;

        protected List getFieldOrder() {
            return Arrays.asList("Internal", "InternalHigh", "Offset", "OffsetHigh", "hEvent");
        }

        public OVERLAPPED() {
            this.setAutoSynch(false);
        }

        public String toString() {
            return String.format("[Offset %d OffsetHigh %d hEvent %s]", this.Offset, this.OffsetHigh, this.hEvent.toString());
        }
    }

    public static class ULONG_PTR
    extends IntegerType {
        public ULONG_PTR() {
            this(0L);
        }

        public ULONG_PTR(long l) {
            super(Native.POINTER_SIZE, l);
        }
    }

    public static interface Windows_kernel32_lib
    extends StdCallLibrary {
        public HANDLE CreateFile(String var1, int var2, int var3, SECURITY_ATTRIBUTES var4, int var5, int var6, Pointer var7);

        public boolean WriteFile(HANDLE var1, byte[] var2, int var3, int[] var4, Pointer var5);

        public boolean WriteFile(HANDLE var1, Pointer var2, int var3, int[] var4, Pointer var5);

        public boolean ReadFile(HANDLE var1, byte[] var2, int var3, int[] var4, Pointer var5);

        public boolean ReadFile(HANDLE var1, Pointer var2, int var3, int[] var4, Pointer var5);

        public boolean FlushFileBuffers(HANDLE var1);

        public boolean PurgeComm(HANDLE var1, int var2);

        public boolean CancelIo(HANDLE var1);

        public boolean CloseHandle(HANDLE var1);

        public boolean ClearCommError(HANDLE var1, int[] var2, COMSTAT var3);

        public boolean SetCommMask(HANDLE var1, int var2);

        public boolean GetCommMask(HANDLE var1, int[] var2);

        public boolean GetCommState(HANDLE var1, DCB var2);

        public boolean SetCommState(HANDLE var1, DCB var2);

        public boolean SetCommTimeouts(HANDLE var1, COMMTIMEOUTS var2);

        public boolean SetupComm(HANDLE var1, int var2, int var3);

        public boolean SetCommBreak(HANDLE var1);

        public boolean ClearCommBreak(HANDLE var1);

        public boolean GetCommModemStatus(HANDLE var1, int[] var2);

        public boolean EscapeCommFunction(HANDLE var1, int var2);

        public HANDLE CreateEvent(SECURITY_ATTRIBUTES var1, boolean var2, boolean var3, String var4);

        public boolean ResetEvent(HANDLE var1);

        public boolean SetEvent(HANDLE var1);

        public boolean WaitCommEvent(HANDLE var1, IntByReference var2, Pointer var3);

        public int WaitForSingleObject(HANDLE var1, int var2);

        public boolean GetOverlappedResult(HANDLE var1, Pointer var2, int[] var3, boolean var4);

        public int FormatMessageW(int var1, Pointer var2, int var3, int var4, Pointer var5, int var6, Pointer var7);

        public int QueryDosDevice(String var1, byte[] var2, int var3);
    }

    public static interface WaitMultiple
    extends StdCallLibrary {
        public int WaitForMultipleObjects(int var1, HANDLE[] var2, boolean var3, int var4);
    }

    public static class Windows_kernel32_lib_Direct
    implements Windows_kernel32_lib {
        @Override
        public native HANDLE CreateFile(String var1, int var2, int var3, SECURITY_ATTRIBUTES var4, int var5, int var6, Pointer var7) throws LastErrorException;

        @Override
        public native boolean WriteFile(HANDLE var1, byte[] var2, int var3, int[] var4, Pointer var5) throws LastErrorException;

        @Override
        public native boolean WriteFile(HANDLE var1, Pointer var2, int var3, int[] var4, Pointer var5) throws LastErrorException;

        @Override
        public native boolean ReadFile(HANDLE var1, byte[] var2, int var3, int[] var4, Pointer var5) throws LastErrorException;

        @Override
        public native boolean ReadFile(HANDLE var1, Pointer var2, int var3, int[] var4, Pointer var5) throws LastErrorException;

        @Override
        public native boolean FlushFileBuffers(HANDLE var1) throws LastErrorException;

        @Override
        public native boolean PurgeComm(HANDLE var1, int var2) throws LastErrorException;

        @Override
        public native boolean CancelIo(HANDLE var1) throws LastErrorException;

        @Override
        public native boolean CloseHandle(HANDLE var1) throws LastErrorException;

        @Override
        public native boolean ClearCommError(HANDLE var1, int[] var2, COMSTAT var3) throws LastErrorException;

        @Override
        public native boolean SetCommMask(HANDLE var1, int var2) throws LastErrorException;

        @Override
        public native boolean GetCommMask(HANDLE var1, int[] var2) throws LastErrorException;

        @Override
        public native boolean GetCommState(HANDLE var1, DCB var2) throws LastErrorException;

        @Override
        public native boolean SetCommState(HANDLE var1, DCB var2) throws LastErrorException;

        @Override
        public native boolean SetCommTimeouts(HANDLE var1, COMMTIMEOUTS var2) throws LastErrorException;

        @Override
        public native boolean SetupComm(HANDLE var1, int var2, int var3) throws LastErrorException;

        @Override
        public native boolean SetCommBreak(HANDLE var1) throws LastErrorException;

        @Override
        public native boolean ClearCommBreak(HANDLE var1) throws LastErrorException;

        @Override
        public native boolean GetCommModemStatus(HANDLE var1, int[] var2) throws LastErrorException;

        @Override
        public native boolean EscapeCommFunction(HANDLE var1, int var2) throws LastErrorException;

        @Override
        public native HANDLE CreateEvent(SECURITY_ATTRIBUTES var1, boolean var2, boolean var3, String var4) throws LastErrorException;

        @Override
        public native boolean ResetEvent(HANDLE var1) throws LastErrorException;

        @Override
        public native boolean SetEvent(HANDLE var1) throws LastErrorException;

        @Override
        public native boolean WaitCommEvent(HANDLE var1, IntByReference var2, Pointer var3) throws LastErrorException;

        @Override
        public native int WaitForSingleObject(HANDLE var1, int var2);

        @Override
        public native boolean GetOverlappedResult(HANDLE var1, Pointer var2, int[] var3, boolean var4) throws LastErrorException;

        @Override
        public native int FormatMessageW(int var1, Pointer var2, int var3, int var4, Pointer var5, int var6, Pointer var7);

        @Override
        public native int QueryDosDevice(String var1, byte[] var2, int var3) throws LastErrorException;
    }

    public static class HANDLE
    extends PointerType {
        private boolean immutable;

        public HANDLE() {
        }

        public HANDLE(Pointer pointer) {
            this.setPointer(pointer);
            this.immutable = true;
        }

        public Object fromNative(Object object, FromNativeContext fromNativeContext) {
            Object object2 = super.fromNative(object, fromNativeContext);
            if (NULL.equals(object2)) {
                return NULL;
            }
            if (INVALID_HANDLE_VALUE.equals(object2)) {
                return INVALID_HANDLE_VALUE;
            }
            return object2;
        }

        public void setPointer(Pointer pointer) {
            if (this.immutable) {
                throw new UnsupportedOperationException("immutable");
            }
            super.setPointer(pointer);
        }
    }
}

