/*
 * Decompiled with CFR 0.152.
 */
package purejavacomm;

import java.io.FileDescriptor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jtermios.JTermios;
import jtermios.Termios;
import purejavacomm.CommDriver;
import purejavacomm.CommPort;
import purejavacomm.CommPortOwnershipListener;
import purejavacomm.NoSuchPortException;
import purejavacomm.PortInUseException;
import purejavacomm.PureJavaSerialPort;
import purejavacomm.UnsupportedCommOperationException;

public class CommPortIdentifier {
    public static final int PORT_SERIAL = 1;
    public static final int PORT_PARALLEL = 2;
    private static volatile Object m_Mutex = new Object();
    private volatile String m_PortName;
    private volatile int m_PortType;
    private volatile CommDriver m_Driver;
    private static volatile Hashtable<String, CommPortIdentifier> m_PortIdentifiers = new Hashtable();
    private static volatile Hashtable<CommPort, CommPortIdentifier> m_OpenPorts = new Hashtable();
    private static volatile Hashtable<CommPortIdentifier, String> m_Owners = new Hashtable();
    private volatile Hashtable<CommPortIdentifier, List<CommPortOwnershipListener>> m_OwnerShipListeners = new Hashtable();

    public boolean equals(Object object) {
        return object instanceof CommPortIdentifier && this.m_PortName.equals(((CommPortIdentifier)object).m_PortName);
    }

    public int hashCode() {
        return this.m_PortName.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPortName(String string, int n, CommDriver commDriver) {
        Object object = m_Mutex;
        synchronized (object) {
            m_PortIdentifiers.put(string, new CommPortIdentifier(string, n, commDriver));
        }
    }

    private CommPortIdentifier(String string, int n, CommDriver commDriver) {
        this.m_PortName = string;
        this.m_PortType = n;
        this.m_Driver = commDriver;
    }

    public static CommPortIdentifier getPortIdentifier(String string) throws NoSuchPortException {
        Object object = m_Mutex;
        synchronized (object) {
            Object object2;
            boolean bl = false;
            for (CommPortIdentifier commPortIdentifier : m_OpenPorts.values()) {
                if (!commPortIdentifier.getName().equals(string)) continue;
                return commPortIdentifier;
            }
            if (bl) {
                object2 = CommPortIdentifier.getPortIdentifiers();
                while (object2.hasMoreElements()) {
                    CommPortIdentifier commPortIdentifier;
                    commPortIdentifier = (CommPortIdentifier)object2.nextElement();
                    if (!commPortIdentifier.getName().equals(string)) continue;
                    return commPortIdentifier;
                }
            } else {
                object2 = m_PortIdentifiers.get(string);
                if (object2 != null) {
                    return object2;
                }
                int n = JTermios.open(string, JTermios.O_RDWR | JTermios.O_NOCTTY | JTermios.O_NONBLOCK);
                if (n != -1) {
                    if (JTermios.tcgetattr(n, new Termios()) != -1 || JTermios.errno() != JTermios.ENOTTY) {
                        JTermios.close(n);
                        return new CommPortIdentifier(string, 1, null);
                    }
                    JTermios.close(n);
                } else if (JTermios.errno() != JTermios.ENOENT) {
                    return new CommPortIdentifier(string, 1, null);
                }
            }
            throw new NoSuchPortException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommPortIdentifier getPortIdentifier(CommPort commPort) throws NoSuchPortException {
        Object object = m_Mutex;
        synchronized (object) {
            CommPortIdentifier commPortIdentifier = m_OpenPorts.get(commPort);
            if (commPortIdentifier == null) {
                throw new NoSuchPortException();
            }
            return commPortIdentifier;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommPort open(String string, int n) throws PortInUseException {
        Object object = m_Mutex;
        synchronized (object) {
            long l = System.currentTimeMillis();
            String string2 = m_Owners.get(this);
            if (string2 != null) {
                this.fireOwnershipEvent(3);
                try {
                    while (System.currentTimeMillis() - l < (long)n) {
                        m_Mutex.wait(5L);
                        if (this.isCurrentlyOwned()) continue;
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.isCurrentlyOwned()) {
                throw new PortInUseException(this.getCurrentOwner());
            }
            CommPortIdentifier commPortIdentifier = m_PortIdentifiers.get(this.m_PortName);
            CommPort commPort = commPortIdentifier != null ? commPortIdentifier.m_Driver.getCommPort(this.m_PortName, commPortIdentifier.m_PortType) : new PureJavaSerialPort(this.m_PortName, n);
            m_OpenPorts.put(commPort, this);
            m_Owners.put(this, string);
            this.fireOwnershipEvent(1);
            return commPort;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void close(CommPort commPort) {
        Object object = m_Mutex;
        synchronized (object) {
            CommPortIdentifier commPortIdentifier = m_OpenPorts.remove(commPort);
            if (commPortIdentifier != null) {
                commPortIdentifier.fireOwnershipEvent(2);
                m_Owners.remove(commPortIdentifier);
            }
        }
    }

    public CommPort open(FileDescriptor fileDescriptor) throws UnsupportedCommOperationException {
        throw new UnsupportedCommOperationException("open from file descriptor not supported");
    }

    public String getName() {
        return this.m_PortName;
    }

    public int getPortType() {
        return this.m_PortType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enumeration<CommPortIdentifier> getPortIdentifiers() {
        Object object = m_Mutex;
        synchronized (object) {
            return new Enumeration(){
                List<CommPortIdentifier> m_PortIDs = new LinkedList<CommPortIdentifier>();
                Iterator<CommPortIdentifier> m_Iterator;
                {
                    for (CommPortIdentifier object : m_PortIdentifiers.values()) {
                        this.m_PortIDs.add(object);
                    }
                    List<String> list = JTermios.getPortList();
                    if (list != null) {
                        for (String string : list) {
                            this.m_PortIDs.add(new CommPortIdentifier(string, 1, null));
                        }
                    }
                    this.m_Iterator = this.m_PortIDs.iterator();
                }

                @Override
                public boolean hasMoreElements() {
                    return this.m_Iterator != null ? this.m_Iterator.hasNext() : false;
                }

                public Object nextElement() {
                    return this.m_Iterator.next();
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentOwner() {
        Object object = m_Mutex;
        synchronized (object) {
            return m_Owners.get(this);
        }
    }

    public boolean isCurrentlyOwned() {
        return this.getCurrentOwner() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPortOwnershipListener(CommPortOwnershipListener commPortOwnershipListener) {
        Object object = m_Mutex;
        synchronized (object) {
            List<CommPortOwnershipListener> list = this.m_OwnerShipListeners.get(this);
            if (list == null) {
                list = new LinkedList<CommPortOwnershipListener>();
                this.m_OwnerShipListeners.put(this, list);
            }
            list.add(commPortOwnershipListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePortOwnershipListener(CommPortOwnershipListener commPortOwnershipListener) {
        Object object = m_Mutex;
        synchronized (object) {
            List<CommPortOwnershipListener> list = this.m_OwnerShipListeners.get(this);
            if (list == null) {
                return;
            }
            list.remove(commPortOwnershipListener);
            if (list.isEmpty()) {
                this.m_OwnerShipListeners.remove(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireOwnershipEvent(int n) {
        Object object = m_Mutex;
        synchronized (object) {
            List<CommPortOwnershipListener> list = this.m_OwnerShipListeners.get(this);
            if (list == null) {
                return;
            }
            for (CommPortOwnershipListener commPortOwnershipListener : list) {
                commPortOwnershipListener.ownershipChange(n);
            }
        }
    }
}

