/*
 * Decompiled with CFR 0.152.
 */
package purejavacomm;

import com.sun.jna.Native;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;
import jtermios.JTermios;
import jtermios.Pollfd;
import jtermios.Termios;
import jtermios.TimeVal;
import purejavacomm.PortInUseException;
import purejavacomm.PureJavaIllegalStateException;
import purejavacomm.SerialPort;
import purejavacomm.SerialPortEvent;
import purejavacomm.SerialPortEventListener;
import purejavacomm.UnsupportedCommOperationException;

public class PureJavaSerialPort
extends SerialPort {
    final boolean USE_POLL;
    final boolean RAW_READ_MODE;
    private Thread m_Thread;
    private volatile SerialPortEventListener m_EventListener;
    private volatile OutputStream m_OutputStream;
    private volatile InputStream m_InputStream;
    private volatile int m_FD = -1;
    private volatile boolean m_HaveNudgePipe = false;
    private volatile int m_PipeWrFD = 0;
    private volatile int m_PipeRdFD = 0;
    private byte[] m_NudgeData = new byte[]{0};
    private volatile int m_BaudRate;
    private volatile int m_DataBits;
    private volatile int m_FlowControlMode;
    private volatile int m_Parity;
    private volatile int m_StopBits;
    private volatile Object m_ThresholdTimeoutLock = new Object();
    private volatile boolean m_TimeoutThresholdChanged = true;
    private volatile boolean m_ReceiveTimeoutEnabled;
    private volatile int m_ReceiveTimeoutValue;
    private volatile int m_ReceiveTimeoutVTIME;
    private volatile boolean m_ReceiveThresholdEnabled;
    private volatile int m_ReceiveThresholdValue;
    private volatile boolean m_PollingReadMode;
    private volatile boolean m_NotifyOnDataAvailable;
    private volatile boolean m_DataAvailableNotified;
    private volatile boolean m_NotifyOnOutputEmpty;
    private volatile boolean m_OutputEmptyNotified;
    private volatile boolean m_NotifyOnRI;
    private volatile boolean m_NotifyOnCTS;
    private volatile boolean m_NotifyOnDSR;
    private volatile boolean m_NotifyOnCD;
    private volatile boolean m_NotifyOnOverrunError;
    private volatile boolean m_NotifyOnParityError;
    private volatile boolean m_NotifyOnFramingError;
    private volatile boolean m_NotifyOnBreakInterrupt;
    private volatile boolean m_ThreadRunning;
    private volatile boolean m_ThreadStarted;
    private int[] m_ioctl = new int[]{0};
    private int m_ControlLineStates;
    private Termios m_Termios = new Termios();
    private int m_MinVTIME;

    private void sendDataEvents(boolean bl, boolean bl2) {
        if (bl && this.m_NotifyOnDataAvailable && !this.m_DataAvailableNotified) {
            this.m_DataAvailableNotified = true;
            this.m_EventListener.serialEvent(new SerialPortEvent(this, 1, false, true));
        }
        if (bl2 && this.m_NotifyOnOutputEmpty && !this.m_OutputEmptyNotified) {
            this.m_OutputEmptyNotified = true;
            this.m_EventListener.serialEvent(new SerialPortEvent(this, 2, false, true));
        }
    }

    private synchronized void sendNonDataEvents() {
        int n;
        if (JTermios.ioctl(this.m_FD, JTermios.TIOCMGET, this.m_ioctl) < 0) {
            return;
        }
        int n2 = this.m_ControlLineStates;
        this.m_ControlLineStates = this.m_ioctl[0];
        int n3 = this.m_ControlLineStates;
        int n4 = n2 ^ n3;
        if (n4 == 0) {
            return;
        }
        if (this.m_NotifyOnCTS && ((n = JTermios.TIOCM_CTS) & n4) != 0) {
            this.m_EventListener.serialEvent(new SerialPortEvent(this, 3, (n2 & n) != 0, (n3 & n) != 0));
        }
        if (this.m_NotifyOnDSR && ((n = JTermios.TIOCM_DSR) & n4) != 0) {
            this.m_EventListener.serialEvent(new SerialPortEvent(this, 4, (n2 & n) != 0, (n3 & n) != 0));
        }
        if (this.m_NotifyOnRI && ((n = JTermios.TIOCM_RI) & n4) != 0) {
            this.m_EventListener.serialEvent(new SerialPortEvent(this, 5, (n2 & n) != 0, (n3 & n) != 0));
        }
        if (this.m_NotifyOnCD && ((n = JTermios.TIOCM_CD) & n4) != 0) {
            this.m_EventListener.serialEvent(new SerialPortEvent(this, 6, (n2 & n) != 0, (n3 & n) != 0));
        }
    }

    @Override
    public synchronized void addEventListener(SerialPortEventListener serialPortEventListener) throws TooManyListenersException {
        this.checkState();
        if (serialPortEventListener == null) {
            throw new IllegalArgumentException("eventListener cannot be null");
        }
        if (this.m_EventListener != null) {
            throw new TooManyListenersException();
        }
        this.m_EventListener = serialPortEventListener;
        if (!this.m_ThreadStarted) {
            this.m_ThreadStarted = true;
            this.m_Thread.start();
        }
    }

    @Override
    public synchronized int getBaudRate() {
        this.checkState();
        return this.m_BaudRate;
    }

    @Override
    public synchronized int getDataBits() {
        this.checkState();
        return this.m_DataBits;
    }

    @Override
    public synchronized int getFlowControlMode() {
        this.checkState();
        return this.m_FlowControlMode;
    }

    @Override
    public synchronized int getParity() {
        this.checkState();
        return this.m_Parity;
    }

    @Override
    public synchronized int getStopBits() {
        this.checkState();
        return this.m_StopBits;
    }

    @Override
    public synchronized boolean isCD() {
        this.checkState();
        return this.getControlLineState(JTermios.TIOCM_CD);
    }

    @Override
    public synchronized boolean isCTS() {
        this.checkState();
        return this.getControlLineState(JTermios.TIOCM_CTS);
    }

    @Override
    public synchronized boolean isDSR() {
        this.checkState();
        return this.getControlLineState(JTermios.TIOCM_DSR);
    }

    @Override
    public synchronized boolean isDTR() {
        this.checkState();
        return this.getControlLineState(JTermios.TIOCM_DTR);
    }

    @Override
    public synchronized boolean isRI() {
        this.checkState();
        return this.getControlLineState(JTermios.TIOCM_RI);
    }

    @Override
    public synchronized boolean isRTS() {
        this.checkState();
        return this.getControlLineState(JTermios.TIOCM_RTS);
    }

    @Override
    public synchronized void notifyOnBreakInterrupt(boolean bl) {
        this.checkState();
        this.m_NotifyOnBreakInterrupt = bl;
    }

    @Override
    public synchronized void notifyOnCTS(boolean bl) {
        this.checkState();
        if (bl) {
            this.updateControlLineState(JTermios.TIOCM_CTS);
        }
        this.m_NotifyOnCTS = bl;
        this.nudgePipe();
    }

    @Override
    public synchronized void notifyOnCarrierDetect(boolean bl) {
        this.checkState();
        if (bl) {
            this.updateControlLineState(JTermios.TIOCM_CD);
        }
        this.m_NotifyOnCD = bl;
        this.nudgePipe();
    }

    @Override
    public synchronized void notifyOnDSR(boolean bl) {
        this.checkState();
        if (bl) {
            this.updateControlLineState(JTermios.TIOCM_DSR);
        }
        this.m_NotifyOnDSR = bl;
        this.nudgePipe();
    }

    @Override
    public synchronized void notifyOnDataAvailable(boolean bl) {
        this.checkState();
        this.m_NotifyOnDataAvailable = bl;
        this.nudgePipe();
    }

    @Override
    public synchronized void notifyOnFramingError(boolean bl) {
        this.checkState();
        this.m_NotifyOnFramingError = bl;
    }

    @Override
    public synchronized void notifyOnOutputEmpty(boolean bl) {
        this.checkState();
        this.m_NotifyOnOutputEmpty = bl;
        this.nudgePipe();
    }

    @Override
    public synchronized void notifyOnOverrunError(boolean bl) {
        this.checkState();
        this.m_NotifyOnOverrunError = bl;
    }

    @Override
    public synchronized void notifyOnParityError(boolean bl) {
        this.checkState();
        this.m_NotifyOnParityError = bl;
    }

    @Override
    public synchronized void notifyOnRingIndicator(boolean bl) {
        this.checkState();
        if (bl) {
            this.updateControlLineState(JTermios.TIOCM_RI);
        }
        this.m_NotifyOnRI = bl;
        this.nudgePipe();
    }

    @Override
    public synchronized void removeEventListener() {
        this.checkState();
        this.m_EventListener = null;
    }

    @Override
    public synchronized void sendBreak(int n) {
        this.checkState();
        JTermios.tcsendbreak(this.m_FD, n);
    }

    @Override
    public synchronized void setDTR(boolean bl) {
        this.checkState();
        this.setControlLineState(JTermios.TIOCM_DTR, bl);
    }

    @Override
    public synchronized void setRTS(boolean bl) {
        this.checkState();
        this.setControlLineState(JTermios.TIOCM_RTS, bl);
    }

    @Override
    public synchronized void disableReceiveFraming() {
        this.checkState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void disableReceiveThreshold() {
        this.checkState();
        Object object = this.m_ThresholdTimeoutLock;
        synchronized (object) {
            this.m_ReceiveThresholdEnabled = false;
            this.thresholdOrTimeoutChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void disableReceiveTimeout() {
        this.checkState();
        Object object = this.m_ThresholdTimeoutLock;
        synchronized (object) {
            this.m_ReceiveTimeoutEnabled = false;
            this.thresholdOrTimeoutChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void enableReceiveThreshold(int n) throws UnsupportedCommOperationException {
        this.checkState();
        if (n < 0) {
            throw new IllegalArgumentException("threshold" + n + " < 0 ");
        }
        if (this.RAW_READ_MODE && n > 255) {
            throw new IllegalArgumentException("threshold" + n + " > 255 in raw read mode");
        }
        Object object = this.m_ThresholdTimeoutLock;
        synchronized (object) {
            this.m_ReceiveThresholdEnabled = true;
            this.m_ReceiveThresholdValue = n;
            this.thresholdOrTimeoutChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void enableReceiveTimeout(int n) throws UnsupportedCommOperationException {
        if (n < 0) {
            throw new IllegalArgumentException("threshold" + n + " < 0 ");
        }
        if (n > 25500) {
            throw new UnsupportedCommOperationException("threshold" + n + " > 25500 ");
        }
        this.checkState();
        Object object = this.m_ThresholdTimeoutLock;
        synchronized (object) {
            this.m_ReceiveTimeoutEnabled = true;
            this.m_ReceiveTimeoutValue = n;
            this.thresholdOrTimeoutChanged();
        }
    }

    @Override
    public synchronized void enableReceiveFraming(int n) throws UnsupportedCommOperationException {
        this.checkState();
        throw new UnsupportedCommOperationException("receive framing not supported/implemented");
    }

    private void thresholdOrTimeoutChanged() {
        this.m_PollingReadMode = this.m_ReceiveTimeoutEnabled && this.m_ReceiveTimeoutValue == 0 || this.m_ReceiveThresholdEnabled && this.m_ReceiveThresholdValue == 0;
        this.m_ReceiveTimeoutVTIME = (this.m_ReceiveTimeoutValue + 99) / 100;
        this.m_TimeoutThresholdChanged = true;
    }

    @Override
    public synchronized int getInputBufferSize() {
        this.checkState();
        return 0;
    }

    @Override
    public synchronized int getOutputBufferSize() {
        this.checkState();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setFlowControlMode(int n) throws UnsupportedCommOperationException {
        this.checkState();
        Termios termios2 = this.m_Termios;
        synchronized (termios2) {
            this.m_Termios.c_iflag &= ~JTermios.IXANY;
            this.m_Termios.c_cflag = (n & 3) != 0 ? (this.m_Termios.c_cflag |= JTermios.CRTSCTS) : (this.m_Termios.c_cflag &= ~JTermios.CRTSCTS);
            this.m_Termios.c_iflag = (n & 4) != 0 ? (this.m_Termios.c_iflag |= JTermios.IXOFF) : (this.m_Termios.c_iflag &= ~JTermios.IXOFF);
            this.m_Termios.c_iflag = (n & 8) != 0 ? (this.m_Termios.c_iflag |= JTermios.IXON) : (this.m_Termios.c_iflag &= ~JTermios.IXON);
            this.checkReturnCode(JTermios.tcsetattr(this.m_FD, JTermios.TCSANOW, this.m_Termios));
            this.m_FlowControlMode = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setSerialPortParams(int n, int n2, int n3, int n4) throws UnsupportedCommOperationException {
        this.checkState();
        Termios termios2 = this.m_Termios;
        synchronized (termios2) {
            Termios termios3 = new Termios();
            termios3.set(this.m_Termios);
            try {
                int n5;
                int n6;
                this.checkReturnCode(JTermios.setspeed(this.m_FD, this.m_Termios, n));
                switch (n2) {
                    case 5: {
                        n6 = JTermios.CS5;
                        break;
                    }
                    case 6: {
                        n6 = JTermios.CS6;
                        break;
                    }
                    case 7: {
                        n6 = JTermios.CS7;
                        break;
                    }
                    case 8: {
                        n6 = JTermios.CS8;
                        break;
                    }
                    default: {
                        throw new UnsupportedCommOperationException("dataBits = " + n2);
                    }
                }
                switch (n3) {
                    case 1: {
                        n5 = 1;
                        break;
                    }
                    case 3: {
                        n5 = 2;
                        break;
                    }
                    case 2: {
                        n5 = 2;
                        break;
                    }
                    default: {
                        throw new UnsupportedCommOperationException("stopBits = " + n3);
                    }
                }
                int n7 = this.m_Termios.c_iflag & ~(JTermios.INPCK | JTermios.ISTRIP);
                int n8 = this.m_Termios.c_cflag & ~(JTermios.PARENB | JTermios.CMSPAR | JTermios.PARODD);
                switch (n4) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        n8 |= JTermios.PARENB;
                        break;
                    }
                    case 1: {
                        n8 |= JTermios.PARENB;
                        n8 |= JTermios.PARODD;
                        break;
                    }
                    case 3: {
                        n8 |= JTermios.PARENB;
                        n8 |= JTermios.CMSPAR;
                        n8 |= JTermios.PARODD;
                        break;
                    }
                    case 4: {
                        n8 |= JTermios.PARENB;
                        n8 |= JTermios.CMSPAR;
                        break;
                    }
                    default: {
                        throw new UnsupportedCommOperationException("parity = " + n4);
                    }
                }
                n8 &= ~JTermios.CSIZE;
                n8 |= n6;
                n8 = n5 == 2 ? (n8 |= JTermios.CSTOPB) : (n8 &= ~JTermios.CSTOPB);
                this.m_Termios.c_cflag = n8;
                this.m_Termios.c_iflag = n7;
                if (JTermios.tcsetattr(this.m_FD, JTermios.TCSANOW, this.m_Termios) != 0) {
                    throw new UnsupportedCommOperationException("tcsetattr failed");
                }
                this.m_BaudRate = n;
                this.m_Parity = n4;
                this.m_DataBits = n2;
                this.m_StopBits = n3;
            }
            catch (UnsupportedCommOperationException unsupportedCommOperationException) {
                this.m_Termios.set(termios3);
                this.checkReturnCode(JTermios.tcsetattr(this.m_FD, JTermios.TCSANOW, this.m_Termios));
                throw unsupportedCommOperationException;
            }
            catch (IllegalStateException illegalStateException) {
                this.m_Termios.set(termios3);
                this.checkReturnCode(JTermios.tcsetattr(this.m_FD, JTermios.TCSANOW, this.m_Termios));
                if (illegalStateException instanceof PureJavaIllegalStateException) {
                    throw illegalStateException;
                }
                throw new PureJavaIllegalStateException(illegalStateException);
            }
        }
    }

    public int getNativeFileDescriptor() {
        return this.m_FD;
    }

    @Override
    public synchronized OutputStream getOutputStream() throws IOException {
        this.checkState();
        if (this.m_OutputStream == null) {
            this.m_OutputStream = new OutputStream(){
                private byte[] im_Buffer = new byte[2048];

                @Override
                public final void write(int n) throws IOException {
                    PureJavaSerialPort.this.checkState();
                    byte[] byArray = new byte[]{(byte)n};
                    this.write(byArray, 0, 1);
                }

                @Override
                public final void write(byte[] byArray, int n, int n2) throws IOException {
                    if (byArray == null) {
                        throw new IllegalArgumentException();
                    }
                    if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
                        throw new IndexOutOfBoundsException("buffer.lengt " + byArray.length + " offset " + n + " length " + n2);
                    }
                    PureJavaSerialPort.this.checkState();
                    while (n2 > 0) {
                        int n3 = byArray.length - n;
                        if (n3 > this.im_Buffer.length) {
                            n3 = this.im_Buffer.length;
                        }
                        if (n3 > n2) {
                            n3 = n2;
                        }
                        if (n > 0) {
                            System.arraycopy(byArray, n, this.im_Buffer, 0, n3);
                            n3 = JTermios.write(PureJavaSerialPort.this.m_FD, this.im_Buffer, n3);
                        } else {
                            n3 = JTermios.write(PureJavaSerialPort.this.m_FD, byArray, n3);
                        }
                        if (n3 < 0) {
                            PureJavaSerialPort.this.close();
                            throw new IOException();
                        }
                        n2 -= n3;
                        n += n3;
                    }
                    PureJavaSerialPort.this.m_OutputEmptyNotified = false;
                }

                @Override
                public final void write(byte[] byArray) throws IOException {
                    this.write(byArray, 0, byArray.length);
                }

                @Override
                public void close() throws IOException {
                    super.close();
                }

                @Override
                public final void flush() throws IOException {
                    PureJavaSerialPort.this.checkState();
                    if (JTermios.tcdrain(PureJavaSerialPort.this.m_FD) < 0) {
                        this.close();
                        throw new IOException();
                    }
                }
            };
        }
        return this.m_OutputStream;
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        this.checkState();
        if (this.m_InputStream == null) {
            this.m_InputStream = new InputStream(){
                private int[] im_Available = new int[]{0};
                private byte[] im_Buffer = new byte[2048];
                private int im_VTIME = -1;
                private int im_VMIN = -1;
                private final Pollfd[] im_ReadPollFD = new Pollfd[]{new Pollfd(), new Pollfd()};
                private byte[] im_Nudge;
                private JTermios.FDSet im_ReadFDSet = JTermios.newFDSet();
                private TimeVal im_ReadTimeVal = new TimeVal();
                private int im_PollFDn;
                private boolean im_ReceiveTimeoutEnabled;
                private int im_ReceiveTimeoutValue;
                private boolean im_ReceiveThresholdEnabled;
                private int im_ReceiveThresholdValue;
                private boolean im_PollingReadMode;
                private int im_ReceiveTimeoutVTIME;
                {
                    this.im_ReadPollFD[0].fd = PureJavaSerialPort.this.m_FD;
                    this.im_ReadPollFD[0].events = JTermios.POLLIN;
                    this.im_ReadPollFD[1].fd = PureJavaSerialPort.this.m_PipeRdFD;
                    this.im_ReadPollFD[1].events = JTermios.POLLIN;
                    this.im_PollFDn = PureJavaSerialPort.this.m_HaveNudgePipe ? 2 : 1;
                    this.im_Nudge = new byte[1];
                }

                @Override
                public final int available() throws IOException {
                    if (PureJavaSerialPort.this.m_FD < 0) {
                        return 0;
                    }
                    PureJavaSerialPort.this.checkState();
                    if (JTermios.ioctl(PureJavaSerialPort.this.m_FD, JTermios.FIONREAD, this.im_Available) < 0) {
                        PureJavaSerialPort.this.close();
                        System.out.println(Native.getLastError());
                        throw new IOException();
                    }
                    return this.im_Available[0];
                }

                @Override
                public final int read() throws IOException {
                    byte[] byArray = new byte[]{0};
                    int n = this.read(byArray, 0, 1);
                    return n > 0 ? byArray[0] & 0xFF : -1;
                }

                @Override
                public void close() throws IOException {
                    super.close();
                }

                private void throwStreamClosedException() throws IOException {
                    throw new IOException("Stream Closed");
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public final int read(byte[] byArray, int n, int n2) throws IOException {
                    if (byArray == null) {
                        throw new IllegalArgumentException("buffer null");
                    }
                    if (n2 == 0) {
                        return 0;
                    }
                    if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
                        throw new IndexOutOfBoundsException("buffer.length " + byArray.length + " offset " + n + " length " + n2);
                    }
                    if (PureJavaSerialPort.this.m_FD < 0) {
                        this.throwStreamClosedException();
                    }
                    if (PureJavaSerialPort.this.RAW_READ_MODE) {
                        int n3;
                        if (PureJavaSerialPort.this.m_TimeoutThresholdChanged) {
                            Object object = PureJavaSerialPort.this.m_ThresholdTimeoutLock;
                            synchronized (object) {
                                int n4 = PureJavaSerialPort.this.m_ReceiveTimeoutEnabled ? PureJavaSerialPort.this.m_ReceiveTimeoutVTIME : 0;
                                int n5 = PureJavaSerialPort.this.m_ReceiveThresholdEnabled ? PureJavaSerialPort.this.m_ReceiveThresholdValue : 1;
                                Termios termios2 = PureJavaSerialPort.this.m_Termios;
                                synchronized (termios2) {
                                    PureJavaSerialPort.this.m_Termios.c_cc[JTermios.VTIME] = (byte)n4;
                                    PureJavaSerialPort.this.m_Termios.c_cc[JTermios.VMIN] = (byte)n5;
                                    PureJavaSerialPort.this.checkReturnCode(JTermios.tcsetattr(PureJavaSerialPort.this.m_FD, JTermios.TCSANOW, PureJavaSerialPort.this.m_Termios));
                                }
                                PureJavaSerialPort.this.m_TimeoutThresholdChanged = false;
                            }
                        }
                        if (n > 0) {
                            n3 = n2 < this.im_Buffer.length ? JTermios.read(PureJavaSerialPort.this.m_FD, this.im_Buffer, n2) : JTermios.read(PureJavaSerialPort.this.m_FD, this.im_Buffer, this.im_Buffer.length);
                            if (n3 > 0) {
                                System.arraycopy(this.im_Buffer, 0, byArray, n, n3);
                            }
                        } else {
                            n3 = JTermios.read(PureJavaSerialPort.this.m_FD, byArray, n2);
                        }
                        PureJavaSerialPort.this.m_DataAvailableNotified = false;
                        return n3;
                    }
                    if (PureJavaSerialPort.this.m_TimeoutThresholdChanged) {
                        Object object = PureJavaSerialPort.this.m_ThresholdTimeoutLock;
                        synchronized (object) {
                            this.im_ReceiveTimeoutEnabled = PureJavaSerialPort.this.m_ReceiveTimeoutEnabled;
                            this.im_ReceiveTimeoutValue = PureJavaSerialPort.this.m_ReceiveTimeoutValue;
                            this.im_ReceiveThresholdEnabled = PureJavaSerialPort.this.m_ReceiveThresholdEnabled;
                            this.im_ReceiveThresholdValue = PureJavaSerialPort.this.m_ReceiveThresholdValue;
                            this.im_PollingReadMode = PureJavaSerialPort.this.m_PollingReadMode;
                            this.im_ReceiveTimeoutVTIME = PureJavaSerialPort.this.m_ReceiveTimeoutVTIME;
                            PureJavaSerialPort.this.m_TimeoutThresholdChanged = false;
                        }
                    }
                    int n6 = n2;
                    int n7 = 0;
                    while (true) {
                        int n8;
                        int n9;
                        int n10;
                        int n11;
                        if (this.im_PollingReadMode) {
                            n11 = 0;
                            n10 = 0;
                            n9 = 0;
                        } else {
                            n11 = this.im_ReceiveThresholdEnabled ? this.im_ReceiveThresholdValue : 1;
                            if (n11 > n6) {
                                n11 = n6;
                            }
                            n10 = n11 <= 255 ? n11 : 255;
                            n9 = this.im_ReceiveTimeoutEnabled ? this.im_ReceiveTimeoutVTIME : 0;
                        }
                        if (n10 != this.im_VMIN || n9 != this.im_VTIME) {
                            this.im_VMIN = n10;
                            this.im_VTIME = n9;
                            Termios termios3 = PureJavaSerialPort.this.m_Termios;
                            synchronized (termios3) {
                                PureJavaSerialPort.this.m_Termios.c_cc[JTermios.VTIME] = (byte)this.im_VTIME;
                                PureJavaSerialPort.this.m_Termios.c_cc[JTermios.VMIN] = (byte)this.im_VMIN;
                                PureJavaSerialPort.this.checkReturnCode(JTermios.tcsetattr(PureJavaSerialPort.this.m_FD, JTermios.TCSANOW, PureJavaSerialPort.this.m_Termios));
                            }
                        }
                        boolean bl = false;
                        boolean bl2 = false;
                        if (!this.im_PollingReadMode) {
                            int n12;
                            int n13;
                            int n14 = n13 = this.im_ReceiveTimeoutEnabled ? this.im_ReceiveTimeoutValue : Integer.MAX_VALUE;
                            if (PureJavaSerialPort.this.USE_POLL) {
                                n8 = JTermios.poll(this.im_ReadPollFD, this.im_PollFDn, n13);
                                if (n8 < 0 || PureJavaSerialPort.this.m_FD < 0) {
                                    this.throwStreamClosedException();
                                }
                                if ((this.im_ReadPollFD[1].revents & JTermios.POLLIN) != 0) {
                                    JTermios.read(PureJavaSerialPort.this.m_PipeRdFD, this.im_Nudge, 1);
                                }
                                if (((n12 = (int)this.im_ReadPollFD[0].revents) & JTermios.POLLNVAL) != 0) {
                                    this.throwStreamClosedException();
                                }
                                bl = (n12 & JTermios.POLLIN) != 0;
                            } else {
                                JTermios.FD_ZERO(this.im_ReadFDSet);
                                JTermios.FD_SET(PureJavaSerialPort.this.m_FD, this.im_ReadFDSet);
                                n12 = PureJavaSerialPort.this.m_FD;
                                if (PureJavaSerialPort.this.m_HaveNudgePipe) {
                                    JTermios.FD_SET(PureJavaSerialPort.this.m_PipeRdFD, this.im_ReadFDSet);
                                    if (PureJavaSerialPort.this.m_PipeRdFD > n12) {
                                        n12 = PureJavaSerialPort.this.m_PipeRdFD;
                                    }
                                }
                                if (n13 >= 1000) {
                                    int n15 = n13 / 1000;
                                    this.im_ReadTimeVal.tv_sec = n15;
                                    this.im_ReadTimeVal.tv_usec = (n13 - n15 * 1000) * 1000;
                                } else {
                                    this.im_ReadTimeVal.tv_sec = 0L;
                                    this.im_ReadTimeVal.tv_usec = n13 * 1000;
                                }
                                n8 = JTermios.select(n12 + 1, this.im_ReadFDSet, null, null, this.im_ReadTimeVal);
                                if (PureJavaSerialPort.this.m_FD < 0) {
                                    this.throwStreamClosedException();
                                }
                                if (n8 < 0) {
                                    throw new IOException(String.format("select() < 0 , errno()=%d", JTermios.errno()));
                                }
                                bl = JTermios.FD_ISSET(PureJavaSerialPort.this.m_FD, this.im_ReadFDSet);
                            }
                            if (n8 == 0 && PureJavaSerialPort.this.m_ReceiveTimeoutEnabled) {
                                bl2 = true;
                            }
                        }
                        if (bl2) break;
                        n8 = 0;
                        if (bl || this.im_PollingReadMode) {
                            if (n > 0) {
                                n8 = n6 < this.im_Buffer.length ? JTermios.read(PureJavaSerialPort.this.m_FD, this.im_Buffer, n6) : JTermios.read(PureJavaSerialPort.this.m_FD, this.im_Buffer, this.im_Buffer.length);
                                if (n8 > 0) {
                                    System.arraycopy(this.im_Buffer, 0, byArray, n, n8);
                                }
                            } else {
                                n8 = JTermios.read(PureJavaSerialPort.this.m_FD, byArray, n6);
                            }
                            if (n8 == 0) {
                                bl2 = true;
                            }
                        }
                        if (n8 < 0) {
                            throw new IOException(String.format("read() < 0 , errno()=%d", JTermios.errno()));
                        }
                        if ((n7 += n8) >= n11 || bl2) break;
                        n += n8;
                        n6 -= n8;
                    }
                    PureJavaSerialPort.this.m_DataAvailableNotified = false;
                    return n7;
                }
            };
        }
        return this.m_InputStream;
    }

    @Override
    public synchronized int getReceiveFramingByte() {
        this.checkState();
        return 0;
    }

    @Override
    public synchronized int getReceiveThreshold() {
        this.checkState();
        return this.m_ReceiveThresholdValue;
    }

    @Override
    public synchronized int getReceiveTimeout() {
        this.checkState();
        return this.m_ReceiveTimeoutValue;
    }

    @Override
    public synchronized boolean isReceiveFramingEnabled() {
        this.checkState();
        return false;
    }

    @Override
    public synchronized boolean isReceiveThresholdEnabled() {
        this.checkState();
        return this.m_ReceiveThresholdEnabled;
    }

    @Override
    public synchronized boolean isReceiveTimeoutEnabled() {
        this.checkState();
        return this.m_ReceiveTimeoutEnabled;
    }

    @Override
    public synchronized void setInputBufferSize(int n) {
        this.checkState();
    }

    @Override
    public synchronized void setOutputBufferSize(int n) {
        this.checkState();
    }

    private void nudgePipe() {
        if (this.m_HaveNudgePipe) {
            JTermios.write(this.m_PipeWrFD, this.m_NudgeData, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        int n = this.m_FD;
        if (n != -1) {
            int n2;
            this.m_FD = -1;
            try {
                if (this.m_InputStream != null) {
                    this.m_InputStream.close();
                }
            }
            catch (IOException iOException) {
                JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "m_InputStream.close threw an IOException %s\n", iOException.getMessage());
            }
            finally {
                this.m_InputStream = null;
            }
            try {
                if (this.m_OutputStream != null) {
                    this.m_OutputStream.close();
                }
            }
            catch (IOException iOException) {
                JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "m_OutputStream.close threw an IOException %s\n", iOException.getMessage());
            }
            finally {
                this.m_OutputStream = null;
            }
            this.nudgePipe();
            int n3 = JTermios.fcntl(n, JTermios.F_GETFL, 0);
            int n4 = JTermios.fcntl(n, JTermios.F_SETFL, n3 |= JTermios.O_NONBLOCK);
            if (n4 != 0) {
                boolean bl = JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "fcntl(%d,%d,%d) returned %d\n", n, JTermios.F_SETFL, n3, n4);
            }
            if (this.m_Thread != null) {
                this.m_Thread.interrupt();
            }
            if ((n2 = JTermios.close(n)) < 0) {
                boolean bl = JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "JTermios.close returned %d, errno %d\n", n2, JTermios.errno());
            }
            if (this.m_HaveNudgePipe) {
                n2 = JTermios.close(this.m_PipeRdFD);
                if (n2 < 0) {
                    boolean bl = JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "JTermios.close returned %d, errno %d\n", n2, JTermios.errno());
                }
                if ((n2 = JTermios.close(this.m_PipeWrFD)) < 0) {
                    JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "JTermios.close returned %d, errno %d\n", n2, JTermios.errno());
                }
            }
            long l = System.currentTimeMillis();
            while (this.m_ThreadRunning) {
                try {
                    Thread.sleep(5L);
                    if (System.currentTimeMillis() - l <= 2000L) continue;
                    break;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    break;
                }
            }
            super.close();
        }
    }

    PureJavaSerialPort(String string, int n) throws PortInUseException {
        Object object;
        boolean bl = false;
        if (JTermios.canPoll()) {
            String string2 = "purejavacomm.use_poll";
            String string3 = "purejavacomm.usepoll";
            if (System.getProperty(string2) != null) {
                bl = Boolean.getBoolean(string2);
                JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "use of '%s' is deprecated, use '%s' instead\n", string2, string3);
            } else {
                bl = System.getProperty(string3) != null ? Boolean.getBoolean(string3) : true;
            }
        }
        this.USE_POLL = bl;
        this.RAW_READ_MODE = Boolean.getBoolean("purejavacomm.rawreadmode");
        this.name = string;
        int n2 = (n + 5) / 10;
        while ((this.m_FD = JTermios.open(string, JTermios.O_RDWR | JTermios.O_NOCTTY | JTermios.O_NONBLOCK)) < 0) {
            int n3 = JTermios.errno();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                Thread.currentThread().interrupt();
            }
            if (n2-- >= 0) continue;
            throw new PortInUseException("Unknown Application", n3);
        }
        this.m_MinVTIME = Integer.getInteger("purejavacomm.minvtime", 100);
        int n4 = JTermios.fcntl(this.m_FD, JTermios.F_GETFL, 0);
        if (n4 < 0) {
            this.checkReturnCode(n4);
        }
        this.checkReturnCode(JTermios.fcntl(this.m_FD, JTermios.F_SETFL, n4 &= ~JTermios.O_NONBLOCK));
        this.m_BaudRate = 9600;
        this.m_DataBits = 8;
        this.m_FlowControlMode = 0;
        this.m_Parity = 0;
        this.m_StopBits = 1;
        this.checkReturnCode(JTermios.tcgetattr(this.m_FD, this.m_Termios));
        JTermios.cfmakeraw(this.m_FD, this.m_Termios);
        this.m_Termios.c_cflag |= JTermios.CLOCAL | JTermios.CREAD;
        this.m_Termios.c_lflag &= ~(JTermios.ICANON | JTermios.ECHO | JTermios.ECHOE | JTermios.ISIG);
        this.m_Termios.c_oflag &= ~JTermios.OPOST;
        this.m_Termios.c_cc[JTermios.VSTART] = (byte)JTermios.DC1;
        this.m_Termios.c_cc[JTermios.VSTOP] = (byte)JTermios.DC3;
        this.m_Termios.c_cc[JTermios.VMIN] = 0;
        this.m_Termios.c_cc[JTermios.VTIME] = 0;
        this.checkReturnCode(JTermios.tcsetattr(this.m_FD, JTermios.TCSANOW, this.m_Termios));
        try {
            this.setSerialPortParams(this.m_BaudRate, this.m_DataBits, this.m_StopBits, this.m_Parity);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            unsupportedCommOperationException.printStackTrace();
        }
        try {
            this.setFlowControlMode(0);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            unsupportedCommOperationException.printStackTrace();
        }
        int n5 = JTermios.ioctl(this.m_FD, JTermios.TIOCMGET, this.m_ioctl);
        if (n5 == 0) {
            this.m_ControlLineStates = this.m_ioctl[0];
        } else {
            JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "ioctl(TIOCMGET) returned %d, errno %d\n", n5, JTermios.errno());
        }
        String string4 = "purejavacomm.usenudgepipe";
        if ((System.getProperty(string4) == null || Boolean.getBoolean(string4)) && JTermios.pipe(object = new int[2]) == 0) {
            this.m_HaveNudgePipe = true;
            this.m_PipeRdFD = object[0];
            this.m_PipeWrFD = object[1];
            this.checkReturnCode(JTermios.fcntl(this.m_PipeRdFD, JTermios.F_SETFL, JTermios.fcntl(this.m_PipeRdFD, JTermios.F_GETFL, 0) | JTermios.O_NONBLOCK));
        }
        object = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    int n;
                    PureJavaSerialPort.this.m_ThreadRunning = true;
                    int n2 = Integer.getInteger("purejavacomm.pollperiod", 10);
                    TimeVal timeVal = null;
                    JTermios.FDSet fDSet = null;
                    JTermios.FDSet fDSet2 = null;
                    Pollfd[] pollfdArray = null;
                    byte[] byArray = null;
                    if (PureJavaSerialPort.this.USE_POLL) {
                        pollfdArray = new Pollfd[]{new Pollfd(), new Pollfd()};
                        byArray = new byte[1];
                        pollfdArray[0].fd = PureJavaSerialPort.this.m_FD;
                        pollfdArray[1].fd = PureJavaSerialPort.this.m_PipeRdFD;
                    } else {
                        fDSet = JTermios.newFDSet();
                        fDSet2 = JTermios.newFDSet();
                        timeVal = new TimeVal();
                        n = n2 * 1000;
                        timeVal.tv_sec = n / 1000000;
                        timeVal.tv_usec = (long)n - timeVal.tv_sec * 1000000L;
                    }
                    while (PureJavaSerialPort.this.m_FD >= 0) {
                        boolean bl;
                        n = PureJavaSerialPort.this.m_NotifyOnDataAvailable && !PureJavaSerialPort.this.m_DataAvailableNotified ? 1 : 0;
                        boolean bl2 = PureJavaSerialPort.this.m_NotifyOnOutputEmpty && !PureJavaSerialPort.this.m_OutputEmptyNotified;
                        int n3 = 0;
                        boolean bl3 = bl = PureJavaSerialPort.this.m_NotifyOnCTS || PureJavaSerialPort.this.m_NotifyOnDSR || PureJavaSerialPort.this.m_NotifyOnRI || PureJavaSerialPort.this.m_NotifyOnCD;
                        if (n != 0 || bl2 || !bl && PureJavaSerialPort.this.m_HaveNudgePipe) {
                            if (PureJavaSerialPort.this.USE_POLL) {
                                short s = 0;
                                if (n != 0) {
                                    s = (short)(s | JTermios.POLLIN);
                                }
                                if (bl2) {
                                    s = (short)(s | JTermios.POLLOUT);
                                }
                                pollfdArray[0].events = s;
                                pollfdArray[1].events = JTermios.POLLIN;
                                n3 = PureJavaSerialPort.this.m_HaveNudgePipe ? JTermios.poll(pollfdArray, 2, n2) : JTermios.poll(pollfdArray, 1, n2);
                                short s2 = pollfdArray[1].revents;
                                if ((s2 & JTermios.POLLNVAL) != 0) {
                                    JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "poll() returned POLLNVAL, errno %d\n", JTermios.errno());
                                    break;
                                }
                                if ((s2 & JTermios.POLLIN) != 0) {
                                    JTermios.read(PureJavaSerialPort.this.m_PipeRdFD, byArray, 1);
                                }
                                if (((s2 = pollfdArray[0].revents) & JTermios.POLLNVAL) != 0) {
                                    JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "poll() returned POLLNVAL, errno %d\n", JTermios.errno());
                                    break;
                                }
                                n = n != 0 && (s2 & JTermios.POLLIN) != 0 ? 1 : 0;
                                bl2 = bl2 && (s2 & JTermios.POLLOUT) != 0;
                            } else {
                                JTermios.FD_ZERO(fDSet);
                                JTermios.FD_ZERO(fDSet2);
                                if (n != 0) {
                                    JTermios.FD_SET(PureJavaSerialPort.this.m_FD, fDSet);
                                }
                                if (bl2) {
                                    JTermios.FD_SET(PureJavaSerialPort.this.m_FD, fDSet2);
                                }
                                if (PureJavaSerialPort.this.m_HaveNudgePipe) {
                                    JTermios.FD_SET(PureJavaSerialPort.this.m_PipeRdFD, fDSet);
                                }
                                n3 = JTermios.select(PureJavaSerialPort.this.m_FD + 1, fDSet, fDSet2, null, PureJavaSerialPort.this.m_HaveNudgePipe ? null : timeVal);
                                n = n != 0 && JTermios.FD_ISSET(PureJavaSerialPort.this.m_FD, fDSet) ? 1 : 0;
                                boolean bl4 = bl2 = bl2 && JTermios.FD_ISSET(PureJavaSerialPort.this.m_FD, fDSet2);
                            }
                            if (PureJavaSerialPort.this.m_FD < 0) {
                                break;
                            }
                            if (n3 < 0) {
                                JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "select() or poll() returned %d, errno %d\n", n3, JTermios.errno());
                                PureJavaSerialPort.this.close();
                                break;
                            }
                        } else {
                            Thread.sleep(n2);
                        }
                        if (PureJavaSerialPort.this.m_EventListener == null) continue;
                        if (n != 0 || bl2) {
                            PureJavaSerialPort.this.sendDataEvents(n != 0, bl2);
                        }
                        if (!bl) continue;
                        PureJavaSerialPort.this.sendNonDataEvents();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    PureJavaSerialPort.this.m_ThreadRunning = false;
                }
            }
        };
        this.m_Thread = new Thread((Runnable)object, this.getName());
        this.m_Thread.setDaemon(true);
    }

    private synchronized void updateControlLineState(int n) {
        this.checkState();
        if (JTermios.ioctl(this.m_FD, JTermios.TIOCMGET, this.m_ioctl) == -1) {
            throw new PureJavaIllegalStateException("ioctl(m_FD, TIOCMGET, m_ioctl) == -1");
        }
        this.m_ControlLineStates = (this.m_ioctl[0] & n) + (this.m_ControlLineStates & ~n);
    }

    private synchronized boolean getControlLineState(int n) {
        this.checkState();
        if (JTermios.ioctl(this.m_FD, JTermios.TIOCMGET, this.m_ioctl) == -1) {
            throw new PureJavaIllegalStateException("ioctl(m_FD, TIOCMGET, m_ioctl) == -1");
        }
        return (this.m_ioctl[0] & n) != 0;
    }

    private synchronized void setControlLineState(int n, boolean bl) {
        this.checkState();
        if (JTermios.ioctl(this.m_FD, JTermios.TIOCMGET, this.m_ioctl) == -1) {
            throw new PureJavaIllegalStateException("ioctl(m_FD, TIOCMGET, m_ioctl) == -1");
        }
        this.m_ioctl[0] = bl ? this.m_ioctl[0] | n : this.m_ioctl[0] & ~n;
        if (JTermios.ioctl(this.m_FD, JTermios.TIOCMSET, this.m_ioctl) == -1) {
            throw new PureJavaIllegalStateException("ioctl(m_FD, TIOCMSET, m_ioctl) == -1");
        }
    }

    private void failWithIllegalStateException() {
        throw new PureJavaIllegalStateException("File descriptor is " + this.m_FD + " < 0, maybe closed by previous error condition");
    }

    private void checkState() {
        if (this.m_FD < 0) {
            this.failWithIllegalStateException();
        }
    }

    private void checkReturnCode(int n) {
        if (n != 0) {
            String string = String.format("JTermios call returned %d at %s", n, JTermios.JTermiosLogging.lineno(1));
            JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "%s\n", string);
            try {
                this.close();
            }
            catch (Exception exception) {
                StackTraceElement stackTraceElement = exception.getStackTrace()[0];
                String string2 = String.format("close threw %s at class %s line% d", exception.getClass().getName(), stackTraceElement.getClassName(), stackTraceElement.getLineNumber());
                JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "%s\n", string2);
            }
            throw new PureJavaIllegalStateException(string);
        }
    }

    public boolean isInternalThreadRunning() {
        return this.m_ThreadRunning;
    }
}

