/*
 * Decompiled with CFR 0.152.
 */
package purejavacomm.testsuite;

import purejavacomm.SerialPortEvent;
import purejavacomm.SerialPortEventListener;
import purejavacomm.testsuite.TestBase;

public class Test1
extends TestBase {
    static void run() throws Exception {
        try {
            Test1.begin("Test1 - control lines ");
            Test1.openPort();
            m_Port.setRTS(false);
            m_Port.setDTR(false);
            Test1.sleep();
            m_Port.notifyOnCTS(true);
            m_Port.notifyOnRingIndicator(true);
            m_Port.notifyOnCarrierDetect(true);
            m_Port.notifyOnDSR(true);
            final int[] nArray = new int[11];
            m_Port.addEventListener(new SerialPortEventListener(){

                @Override
                public void serialEvent(SerialPortEvent serialPortEvent) {
                    try {
                        if (serialPortEvent.getEventType() == 3) {
                            nArray[3] = nArray[3] + 1;
                        }
                        if (serialPortEvent.getEventType() == 5) {
                            nArray[5] = nArray[5] + 1;
                        }
                        if (serialPortEvent.getEventType() == 6) {
                            nArray[6] = nArray[6] + 1;
                        }
                        if (serialPortEvent.getEventType() == 4) {
                            nArray[4] = nArray[4] + 1;
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
            int n = 128;
            for (int i = 0; i < n; ++i) {
                m_Port.setRTS((i & 1) != 0);
                m_Port.setDTR((i & 2) != 0);
                Test1.sleep();
            }
            if (nArray[3] != n - 1) {
                Test1.fail("CTS loopback failed, expected %d toggles, got %d", n - 1, nArray[3]);
            }
            if (nArray[4] != n / 2 - 1) {
                Test1.fail("DSR loopback failed, expected %d toggles, got %d", n / 2 - 1, nArray[4]);
            }
            if (nArray[5] != n - 1) {
                Test1.fail("RI loopback failed, expected %d toggles, got %d", n - 1, nArray[5]);
            }
            if (nArray[6] != n / 2 - 1) {
                Test1.fail("CTS loopback failed, expected %d toggles, got %d", n / 2 - 1, nArray[6]);
            }
            Test1.finishedOK();
        }
        finally {
            Test1.closePort();
        }
    }
}

