/*
 * Decompiled with CFR 0.152.
 */
package purejavacomm.testsuite;

import java.util.Random;
import purejavacomm.SerialPortEvent;
import purejavacomm.SerialPortEventListener;
import purejavacomm.testsuite.TestBase;

public class Test2
extends TestBase {
    private static boolean m_Done;
    private static volatile Random rnd;
    private static volatile byte[] m_ReceiveBuffer;
    private static volatile int m_BytesReceived;
    private static volatile int m_TotalReceived;
    private static volatile long m_T0;
    private static volatile long m_T1;
    private static volatile int m_TxCount;
    private static volatile int m_RxCount;
    private static volatile int m_ErrorCount;
    private static int N;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void run(int n) throws Exception {
        try {
            m_Done = false;
            rnd = new Random();
            m_BytesReceived = 0;
            m_TotalReceived = 0;
            m_TxCount = 0;
            m_RxCount = 0;
            m_ErrorCount = 0;
            Test2.begin("Test2 - tx/rx with event listener");
            Test2.openPort();
            m_Port.notifyOnDataAvailable(true);
            m_Port.notifyOnOutputEmpty(true);
            m_Port.setFlowControlMode(12);
            m_Port.setSerialPortParams(n, 8, 1, 0);
            boolean[] blArray = new boolean[]{false};
            m_T0 = System.currentTimeMillis();
            m_Port.addEventListener(new SerialPortEventListener(){

                @Override
                public void serialEvent(SerialPortEvent serialPortEvent) {
                    try {
                        byte[] byArray;
                        if (serialPortEvent.getEventType() == 1) {
                            byArray = new byte[TestBase.m_In.available()];
                            int n = TestBase.m_In.read(byArray);
                            if (!m_Done) {
                                m_TotalReceived += n;
                                Test2.processBuffer(byArray, n);
                                if (m_RxCount >= N) {
                                    m_Done = true;
                                }
                            }
                        }
                        if (serialPortEvent.getEventType() == 2 && m_TxCount < N) {
                            byArray = Test2.generateRandomMessage();
                            TestBase.m_Out.write(byArray, 0, byArray.length);
                            ++m_TxCount;
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
            while (!m_Done) {
                try {
                    Test2.sleep(100);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            m_T1 = System.currentTimeMillis();
            if (m_ErrorCount > 0) {
                Test2.fail("checksum sum failure in %d out %d messages", m_ErrorCount, N);
            }
            int n2 = m_Port.getDataBits() + 2;
            double d = (double)(m_TotalReceived * n2) * 1000.0 / (double)(m_T1 - m_T0);
            int n3 = m_Port.getBaudRate();
            Test2.finishedOK("average speed %1.0f b/sec at baud rate %d", d, n3);
        }
        finally {
            Test2.closePort();
        }
    }

    private static byte[] generateRandomMessage() {
        int n = 4 + (rnd.nextInt() & 0x3F);
        byte[] byArray = new byte[n + 2];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            byte by;
            byArray[i] = by = (byte)(32 + (rnd.nextInt() & 0x3F));
            n2 += by;
        }
        byArray[i++] = (byte)(32 + (n2 & 0x3F));
        byArray[i++] = 10;
        return byArray;
    }

    private static void processBuffer(byte[] byArray, int n) {
        for (int i = 0; i < n; ++i) {
            int n2;
            byte by = byArray[i];
            if (n > byArray.length) {
                ++m_ErrorCount;
                return;
            }
            Test2.m_ReceiveBuffer[Test2.m_BytesReceived++] = by;
            if (by != 10) continue;
            int n3 = 0;
            for (n2 = 0; n2 < m_BytesReceived - 2; ++n2) {
                n3 += m_ReceiveBuffer[n2];
            }
            byte by2 = (byte)(32 + (n3 & 0x3F));
            if (by2 != m_ReceiveBuffer[n2] && m_RxCount > 0) {
                System.out.println("check sum failure");
                ++m_ErrorCount;
            }
            ++m_RxCount;
            m_BytesReceived = 0;
        }
    }

    static {
        rnd = new Random();
        m_ReceiveBuffer = new byte[10000];
        m_BytesReceived = 0;
        m_TxCount = 0;
        m_RxCount = 0;
        m_ErrorCount = 0;
        N = 1000;
    }
}

