/*
 * Decompiled with CFR 0.152.
 */
package purejavacomm.testsuite;

import purejavacomm.testsuite.TestBase;

public class Test4
extends TestBase {
    private static Exception m_Exception = null;
    private static Thread m_Receiver;
    private static Thread m_Transmitter;

    static void run() throws Exception {
        try {
            Test4.begin("Test4 - indefinite blocking");
            Test4.openPort();
            m_Receiver = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        TestBase.sync(2);
                        long l = System.currentTimeMillis();
                        byte[] byArray = new byte[]{0};
                        int n = TestBase.m_In.read(byArray);
                        long l2 = System.currentTimeMillis() - l;
                        if (n != 1) {
                            TestBase.fail("read did not block, read returned %d", n);
                        }
                        if (byArray[0] != 73) {
                            TestBase.fail("read did not get looped back '73' got '%d'", byArray[0]);
                        }
                        if (l2 < 10000L) {
                            TestBase.fail("read did not block for 10000 msec, received loopback in %d msec", l2);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Exception exception) {
                        if (m_Exception == null) {
                            m_Exception = exception;
                        }
                        m_Receiver.interrupt();
                        m_Transmitter.interrupt();
                    }
                }
            });
            m_Transmitter = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        TestBase.sync(2);
                        TestBase.sleep(10000);
                        TestBase.m_Out.write(73);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if (m_Exception == null) {
                            m_Exception = exception;
                        }
                        m_Receiver.interrupt();
                        m_Transmitter.interrupt();
                    }
                }
            });
            m_Receiver.start();
            m_Transmitter.start();
            while (m_Receiver.isAlive() || m_Transmitter.isAlive()) {
                Test4.sleep(100);
            }
            if (m_Exception != null) {
                throw m_Exception;
            }
            Test4.finishedOK();
        }
        finally {
            Test4.closePort();
        }
    }
}

