/*
 * Decompiled with CFR 0.152.
 */
package purejavacomm.testsuite;

import purejavacomm.testsuite.TestBase;

public class Test6
extends TestBase {
    private static Exception m_Exception = null;
    private static Thread m_Receiver;
    private static Thread m_Transmitter;

    static void run() throws Exception {
        try {
            Test6.begin("Test6 - threshold + timeout");
            Test6.openPort();
            m_Port.setSerialPortParams(230400, 8, 1, 0);
            m_Receiver = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        TestBase.sync(2);
                        TestBase.m_Port.enableReceiveThreshold(4);
                        TestBase.m_Port.enableReceiveTimeout(10000);
                        byte[] byArray = new byte[4];
                        for (int i = 0; i < 1000; ++i) {
                            long l = System.currentTimeMillis();
                            int n = TestBase.m_In.read(byArray);
                            long l2 = System.currentTimeMillis() - l;
                            if (n != 4) {
                                TestBase.fail("read did not get 4 bytes as expected, got %d ", n);
                            }
                            if (l2 < 1000L) continue;
                            TestBase.fail("read timed out though we got 4 bytes " + l2, new Object[0]);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Exception exception) {
                        if (m_Exception == null) {
                            m_Exception = exception;
                        }
                        m_Receiver.interrupt();
                        m_Transmitter.interrupt();
                    }
                }
            });
            m_Transmitter = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        TestBase.sync(2);
                        for (int i = 0; i < 1000; ++i) {
                            TestBase.m_Out.write(new byte[4]);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if (m_Exception == null) {
                            m_Exception = exception;
                        }
                        m_Receiver.interrupt();
                        m_Transmitter.interrupt();
                    }
                }
            });
            m_Transmitter.start();
            Test6.sleep(100);
            m_Receiver.start();
            while (m_Receiver.isAlive() || m_Transmitter.isAlive()) {
                Test6.sleep(100);
            }
            if (m_Exception != null) {
                throw m_Exception;
            }
            Test6.finishedOK();
        }
        finally {
            Test6.closePort();
        }
    }
}

