/*
 * Decompiled with CFR 0.152.
 */
package purejavacomm.testsuite;

import purejavacomm.UnsupportedCommOperationException;
import purejavacomm.testsuite.TestBase;

public class Test8
extends TestBase {
    private static final int[] LIMITED_PARITY = new int[]{0, 1, 2};
    private static final int[] LIMITED_STOPBITS = new int[]{1};
    private static final int[] LIMITED_DATABITS = new int[]{8};
    private static final int[] LIMITED_DATAMASK = new int[]{255};
    private static final int[] FULL_PARITY = new int[]{0, 1, 2, 3, 4};
    private static final int[] FULL_STOPBITS = new int[]{1, 3, 2};
    private static final int[] FULL_DATABITS = new int[]{8, 7, 6, 5};
    private static final int[] FULL_DATAMASK = new int[]{255, 127, 63, 31};

    static void run() throws Exception {
        Test8.run(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void run(boolean bl) throws Exception {
        try {
            int[] nArray;
            int[] nArray2;
            int[] nArray3;
            int[] nArray4;
            Test8.begin("Test8 - parity etc");
            Test8.openPort();
            if (bl) {
                nArray4 = FULL_PARITY;
                nArray3 = FULL_STOPBITS;
                nArray2 = FULL_DATABITS;
                nArray = FULL_DATAMASK;
            } else {
                nArray4 = LIMITED_PARITY;
                nArray3 = LIMITED_STOPBITS;
                nArray2 = LIMITED_DATABITS;
                nArray = LIMITED_DATAMASK;
            }
            System.out.println();
            int n = 0;
            for (int i = 0; i < nArray4.length; ++i) {
                for (int j = 0; j < nArray3.length; ++j) {
                    for (int k = 0; k < nArray2.length; ++k) {
                        m_Port.enableReceiveTimeout(10000);
                        m_Port.enableReceiveThreshold(256);
                        try {
                            String string = "?";
                            switch (nArray2[k]) {
                                case 5: {
                                    string = "5";
                                    break;
                                }
                                case 6: {
                                    string = "6";
                                    break;
                                }
                                case 7: {
                                    string = "7";
                                    break;
                                }
                                case 8: {
                                    string = "8";
                                }
                            }
                            String string2 = "?";
                            switch (nArray3[j]) {
                                case 1: {
                                    string2 = "1";
                                    break;
                                }
                                case 3: {
                                    string2 = "1.5";
                                    break;
                                }
                                case 2: {
                                    string2 = "2";
                                }
                            }
                            String string3 = "?";
                            switch (nArray4[i]) {
                                case 2: {
                                    string3 = "E";
                                    break;
                                }
                                case 1: {
                                    string3 = "O";
                                    break;
                                }
                                case 3: {
                                    string3 = "M";
                                    break;
                                }
                                case 4: {
                                    string3 = "S";
                                    break;
                                }
                                case 0: {
                                    string3 = "N";
                                }
                            }
                            Test8.begin("Test8." + ++n + " databits=" + string + " stopbits=" + string2 + " parity=" + string3);
                            m_Port.setSerialPortParams(19200, nArray2[k], nArray3[j], nArray4[i]);
                            Test8.sleep(100);
                            byte[] byArray = new byte[256];
                            byte[] byArray2 = new byte[256];
                            for (int i2 = 0; i2 < 256; ++i2) {
                                byArray[i2] = (byte)i2;
                            }
                            m_Out = m_Port.getOutputStream();
                            m_In = m_Port.getInputStream();
                            long l = System.currentTimeMillis();
                            m_Out.write(byArray);
                            int n2 = 0;
                            while ((n2 += m_In.read(byArray2, n2, 256 - n2)) < 256) {
                            }
                            if (n2 != byArray.length) {
                                Test8.fail("was expecting %d characters got %d", byArray.length, n2);
                            }
                            for (int i3 = 0; i3 < 256; ++i3) {
                                int n3;
                                if (i3 <= nArray[k]) {
                                    if (byArray2[i3] == byArray[i3]) continue;
                                    Test8.fail("failed: transmit '0x%02X' != receive'0x%02X'", byArray[i3], byArray2[i3]);
                                    continue;
                                }
                                if (nArray2[k] < 7 || byArray2[i3] == (n3 = byArray[i3] & nArray[k])) continue;
                                Test8.fail("failed: transmit (excessive) '0x%02X' != receive'0x%02X'%n", n3, byArray2[i3]);
                            }
                            if (n2 < 256) {
                                Test8.fail("did not receive all 256 chars, got %d", n2);
                            }
                            Test8.finishedOK();
                            continue;
                        }
                        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
                            Test8.finishedOK(" NOT SUPPORTED " + unsupportedCommOperationException.getMessage(), new Object[0]);
                        }
                    }
                }
            }
        }
        finally {
            Test8.closePort();
        }
    }
}

