/*
 * Decompiled with CFR 0.152.
 */
package purejavacomm.testsuite;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import purejavacomm.CommPortIdentifier;
import purejavacomm.NoSuchPortException;
import purejavacomm.SerialPort;

public class TestBase {
    public static final String APPLICATION_NAME = "PureJavaCommTestSuite";
    protected static volatile String m_TestPortName;
    protected static volatile SerialPort m_Port;
    private static volatile long m_T0;
    protected static volatile OutputStream m_Out;
    protected static volatile InputStream m_In;
    protected static volatile int[] m_SyncSema4;
    protected static int m_Tab;
    protected static int m_Progress;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void sync(int n) throws InterruptedException {
        int[] nArray = m_SyncSema4;
        synchronized (m_SyncSema4) {
            m_SyncSema4[0] = m_SyncSema4[0] + 1;
            if (m_SyncSema4[0] < n) {
                m_SyncSema4.wait();
            } else {
                TestBase.m_SyncSema4[0] = 0;
                m_SyncSema4.notifyAll();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected static void openPort() throws Exception {
        try {
            CommPortIdentifier commPortIdentifier = CommPortIdentifier.getPortIdentifier(m_TestPortName);
            m_Port = (SerialPort)commPortIdentifier.open(APPLICATION_NAME, 1000);
            m_Out = m_Port.getOutputStream();
            m_In = m_Port.getInputStream();
            TestBase.drain(m_In);
        }
        catch (NoSuchPortException noSuchPortException) {
            TestBase.fail("could no open port '%s'\n", m_TestPortName);
        }
    }

    protected static void closePort() {
        if (m_Port != null) {
            try {
                m_Out.flush();
                m_Port.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                m_Port = null;
            }
        }
    }

    protected static void drain(InputStream inputStream) throws Exception {
        int n;
        TestBase.sleep(100);
        while ((n = inputStream.available()) > 0) {
            for (int i = 0; i < n; ++i) {
                inputStream.read();
            }
            TestBase.sleep(100);
        }
    }

    static void begin(String string) {
        System.out.printf("%-46s", string);
        m_Tab = 46;
        m_T0 = System.currentTimeMillis();
        m_Progress = 0;
    }

    protected static void sleep() throws InterruptedException {
        TestBase.sleep(40);
    }

    protected static void sleep(int n) throws InterruptedException {
        int n2 = 1000;
        while (n > 0) {
            Thread.sleep(n > n2 ? (long)n2 : (long)n);
            n -= n2;
            while ((System.currentTimeMillis() - m_T0) / (long)n2 > (long)m_Progress) {
                System.out.print(".");
                --m_Tab;
                ++m_Progress;
            }
        }
    }

    static void fail(String string, Object ... objectArray) throws TestFailedException {
        System.out.println(" FAILED");
        System.out.println("------------------------------------------------------------");
        System.out.printf(string, objectArray);
        System.out.println();
        System.out.println("------------------------------------------------------------");
        throw new TestFailedException();
    }

    static void finishedOK() {
        TestBase.finishedOK("", new Object[0]);
    }

    static void finishedOK(String string, Object ... objectArray) {
        for (int i = 0; i < m_Tab; ++i) {
            System.out.print(".");
        }
        System.out.printf(" OK " + string, objectArray);
        System.out.println();
    }

    public static void init(String[] stringArray) {
        m_TestPortName = "cu.usbserial-FTOXM3NX";
        if (stringArray.length > 0) {
            m_TestPortName = stringArray[0];
        }
    }

    public static String getPortName() {
        return m_TestPortName;
    }

    static {
        m_SyncSema4 = new int[]{0};
    }

    static class TestFailedException
    extends Exception {
        TestFailedException() {
        }
    }
}

