/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf;

import com.github.weisj.darklaf.DarkLaf;
import com.github.weisj.darklaf.LafManager;
import com.github.weisj.darklaf.LafTransition;
import com.github.weisj.darklaf.theme.Theme;
import com.github.weisj.darklaf.theme.event.ThemeChangeEvent;
import com.github.weisj.darklaf.theme.event.ThemeChangeListener;
import com.github.weisj.darklaf.theme.event.ThemeEvent;
import com.github.weisj.darklaf.theme.event.ThemeEventListener;
import com.github.weisj.darklaf.theme.event.ThemeEventSupport;
import com.github.weisj.darklaf.util.LogUtil;
import java.awt.Window;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

final class LafInstaller {
    private static final Logger LOGGER = LogUtil.getLogger(LafManager.class);
    private static final AtomicBoolean isInstalling = new AtomicBoolean(false);
    private static final ThemeEventSupport<ThemeChangeEvent, ThemeChangeListener> eventSupport = new ThemeEventSupport();

    LafInstaller() {
    }

    void install(Theme theme) {
        if (!isInstalling.compareAndSet(false, true)) {
            throw new IllegalStateException("Can't install Laf while installation is in progress");
        }
        try {
            LOGGER.fine(() -> "Installing theme " + theme);
            LafTransition transition = LafTransition.showSnapshot();
            UIManager.setLookAndFeel((LookAndFeel)((Object)new DarkLaf(theme, false, true)));
            this.updateLaf();
            SwingUtilities.invokeLater(transition::runTransition);
            this.notifyThemeInstalled(theme);
        }
        catch (UnsupportedLookAndFeelException e) {
            LOGGER.log(Level.SEVERE, "Could not install LaF", e);
        }
        finally {
            isInstalling.set(false);
        }
    }

    void updateLaf() {
        for (Window w : Window.getWindows()) {
            this.updateLafRecursively(w);
        }
    }

    private void updateLafRecursively(Window window) {
        for (Window childWindow : window.getOwnedWindows()) {
            this.updateLafRecursively(childWindow);
        }
        SwingUtilities.updateComponentTreeUI(window);
    }

    void notifyThemeInstalled(Theme newTheme) {
        eventSupport.dispatchEvent((ThemeEvent)new ThemeChangeEvent(null, newTheme), ThemeChangeListener::themeInstalled);
    }

    void addThemeChangeListener(ThemeChangeListener listener) {
        eventSupport.addListener((ThemeEventListener)listener);
    }

    void removeThemeChangeListener(ThemeChangeListener listener) {
        eventSupport.removeListener((ThemeEventListener)listener);
    }

    void notifyThemeChanged(Theme oldTheme, Theme newTheme) {
        if (oldTheme != newTheme) {
            eventSupport.dispatchEvent((ThemeEvent)new ThemeChangeEvent(oldTheme, newTheme), ThemeChangeListener::themeChanged);
            LOGGER.fine(() -> "Setting theme to " + newTheme);
        }
    }
}

