/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf;

import com.github.weisj.darklaf.graphics.Animator;
import com.github.weisj.darklaf.graphics.DefaultInterpolator;
import com.github.weisj.darklaf.util.ImageUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import com.github.weisj.darklaf.util.graphics.ImagePainter;
import com.github.weisj.darklaf.util.graphics.ScaledImage;
import com.github.weisj.darklaf.util.value.SharedNonNull;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.ImageObserver;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;

class LafTransition {
    private static final String ANIMATED_LAF_CHANGE = "darklaf.animatedLafChange";

    private LafTransition() {
    }

    static LafTransition showSnapshot() {
        return PropertyUtil.getSystemFlag((String)ANIMATED_LAF_CHANGE) ? new AnimatedLafTransition() : new LafTransition();
    }

    void runTransition() {
    }

    static final class AnimatedLafTransition
    extends LafTransition {
        private final Animator animator;
        private final Map<JLayeredPane, Component> uiSnapshots;
        private final SharedNonNull<Float> sharedAlpha = new SharedNonNull((Object)Float.valueOf(1.0f));

        private AnimatedLafTransition() {
            this.animator = new TransitionAnimator();
            this.uiSnapshots = new LinkedHashMap<JLayeredPane, Component>();
            Window[] windows = Window.getWindows();
            if (windows.length == 0) {
                this.animator.setEnabled(false);
                return;
            }
            for (Window window : windows) {
                RootPaneContainer rootPaneContainer;
                JRootPane rootPane;
                if (!(window instanceof RootPaneContainer) || !window.isShowing() || (rootPane = (rootPaneContainer = (RootPaneContainer)((Object)window)).getRootPane()).getWidth() == 0 || rootPane.getHeight() == 0) continue;
                ScaledImage img = ImageUtil.scaledImageFromComponent((Component)rootPaneContainer.getRootPane());
                JLayeredPane layeredPane = rootPaneContainer.getLayeredPane();
                ImageLayer imageLayer = new ImageLayer(layeredPane, (Image)img, this.sharedAlpha);
                imageLayer.setSize(layeredPane.getSize());
                layeredPane.add((Component)imageLayer, JLayeredPane.DRAG_LAYER);
                this.uiSnapshots.put(layeredPane, imageLayer);
            }
            this.doPaint();
        }

        @Override
        void runTransition() {
            this.animator.play();
        }

        private void disposeSnapshots() {
            for (Map.Entry<JLayeredPane, Component> entry : this.uiSnapshots.entrySet()) {
                entry.getKey().remove(entry.getValue());
                entry.getKey().revalidate();
                entry.getKey().repaint();
            }
            this.uiSnapshots.clear();
        }

        private void doPaint() {
            for (Map.Entry<JLayeredPane, Component> entry : this.uiSnapshots.entrySet()) {
                if (!entry.getKey().isShowing()) continue;
                entry.getValue().revalidate();
                entry.getValue().repaint();
            }
        }

        private class TransitionAnimator
        extends Animator {
            public TransitionAnimator() {
                super(160L, DefaultInterpolator.EASE_IN_SINE);
            }

            @Override
            public void paintAnimationFrame(float fraction) {
                AnimatedLafTransition.this.sharedAlpha.set((Object)Float.valueOf(1.0f - fraction));
                AnimatedLafTransition.this.doPaint();
            }

            @Override
            public void play() {
                AnimatedLafTransition.this.doPaint();
                super.play();
            }

            @Override
            protected void onAnimationFinished() {
                AnimatedLafTransition.this.disposeSnapshots();
            }
        }
    }

    private static class ImageLayer
    extends JComponent {
        private final JLayeredPane layeredPane;
        private final SharedNonNull<Float> sharedAlpha;
        private final Image image;

        private ImageLayer(JLayeredPane layeredPane, Image image, SharedNonNull<Float> sharedAlpha) {
            this.layeredPane = layeredPane;
            this.image = image;
            this.sharedAlpha = sharedAlpha;
        }

        @Override
        public void updateUI() {
        }

        @Override
        public void paint(Graphics g) {
            Graphics gg = g.create();
            ((Graphics2D)gg).setComposite(AlphaComposite.getInstance(3, ((Float)this.sharedAlpha.get()).floatValue()));
            ImagePainter.drawImage((Graphics)gg, (Image)this.image, (int)0, (int)0, (ImageObserver)this);
        }

        @Override
        public Rectangle getBounds() {
            return this.layeredPane.getBounds();
        }
    }
}

