/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components;

import com.github.weisj.darklaf.DarkLaf;
import com.github.weisj.darklaf.LafManager;
import com.github.weisj.darklaf.iconset.IconSet;
import com.github.weisj.darklaf.properties.PropertyLoader;
import com.github.weisj.darklaf.properties.icons.CustomThemedIcon;
import com.github.weisj.darklaf.properties.icons.IconLoader;
import com.github.weisj.darklaf.properties.icons.IconResolver;
import com.github.weisj.darklaf.properties.icons.StateIcon;
import com.github.weisj.darklaf.task.AccentColorAdjustmentTask;
import com.github.weisj.darklaf.task.ForegroundColorGenerationTask;
import com.github.weisj.darklaf.theme.Theme;
import com.github.weisj.darklaf.ui.togglebutton.radiobutton.DarkRadioButtonUI;
import com.github.weisj.darklaf.ui.util.DarkUIUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;

public class ColoredRadioButton
extends JRadioButton {
    public static final Color DEFAULT_COLOR = new Color(0){

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }
    };
    private Color color;
    private Color focusColor;

    public ColoredRadioButton(String text, Color color) {
        super(text, null, false);
        this.setColors(color, color);
    }

    public ColoredRadioButton(String text, boolean selected, Color color) {
        super(text, null, selected);
        this.setColors(color, color);
    }

    public ColoredRadioButton(String text, Color color, Color focusColor) {
        super(text, null, false);
        this.setColors(color, focusColor);
    }

    public ColoredRadioButton(String text, boolean selected, Color color, Color focusColor) {
        super(text, null, selected);
        this.setColors(color, focusColor);
    }

    public void setColors(Color color, Color focusColor) {
        this.color = color;
        this.focusColor = focusColor != null ? focusColor : color;
        this.updateColorUI();
    }

    public void setColor(Color color) {
        this.color = color;
        this.updateColorUI();
    }

    public void setFocusColor(Color color) {
        this.focusColor = color;
        this.updateColorUI();
    }

    private void updateColorUI() {
        ColoredRadioButtonUI ui = DarkUIUtil.getUIOfType(this.getUI(), ColoredRadioButtonUI.class);
        if (ui != null) {
            ui.setColors(this.color, this.focusColor);
        }
        this.repaint();
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    protected void setUI(ComponentUI newUI) {
        if (!(newUI instanceof ColoredRadioButtonUI)) {
            throw new IllegalArgumentException("UI must be of type ColoredRadioButtonUI");
        }
        super.setUI(newUI);
    }

    @Override
    public void updateUI() {
        this.setUI(new ColoredRadioButtonUI(this.color, this.focusColor));
    }

    protected static class ColoredRadioButtonUI
    extends DarkRadioButtonUI {
        private static final String[] PROPERTIES = new String[]{"Icons.RadioButton.activeFillColor", "Icons.RadioButton.activeBorderColor", "Icons.RadioButtonDisabled.inactiveFillColor", "Icons.RadioButtonDisabled.inactiveBorderColor", "Icons.RadioButtonFocused.activeFillColor", "Icons.RadioButtonFocused.focusBorderColor", "Icons.RadioButtonFocused.glowFocus", "Icons.RadioButtonFocused.glowOpacity", "Icons.RadioButtonSelected.selectedFillColor", "Icons.RadioButtonSelected.selectedBorderColor", "Icons.RadioButtonSelected.selectionSelectedColor", "Icons.RadioButtonSelectedDisabled.inactiveFillColor", "Icons.RadioButtonSelectedDisabled.inactiveBorderColor", "Icons.RadioButtonSelectedDisabled.selectionDisabledColor", "Icons.RadioButtonSelectedFocused.selectedFillColor", "Icons.RadioButtonSelectedFocused.focusSelectedBorderColor", "Icons.RadioButtonSelectedFocused.selectionFocusSelectedColor", "Icons.RadioButtonSelectedFocused.glowFocus", "Icons.RadioButtonSelectedFocused.glowOpacity"};
        private static final String[] COLOR_PROPERTIES = new String[]{"Icons.RadioButton.activeFillColor", "Icons.RadioButton.activeBorderColor", "Icons.RadioButtonFocused.activeFillColor", "Icons.RadioButtonFocused.focusBorderColor", "Icons.RadioButtonSelected.selectedFillColor", "Icons.RadioButtonSelected.selectedBorderColor", "Icons.RadioButtonSelectedFocused.selectedFillColor", "Icons.RadioButtonSelectedFocused.focusSelectedBorderColor"};
        private static final String[] FOCUS_COLOR_PROPERTIES = new String[]{"Icons.RadioButtonFocused.glowFocus", "Icons.RadioButtonSelectedFocused.glowFocus"};
        private static final String[] FOREGROUND_PROPERTIES = new String[]{"Icons.RadioButtonSelected.selectionSelectedColor", "Icons.RadioButtonSelectedFocused.selectionFocusSelectedColor"};
        private static final double MIN_FG_CONTRAST = 0.6;
        private final Properties propertyMap = new Properties();
        private StateIcon stateIcon;
        private Icon[] iconStates;
        private Color iconColor;
        private Color focusIconColor;
        private Color patchedColor;
        private Color patchedFocusColor;
        private boolean patched;
        private static final AccentColorAdjustmentTask adjustment = new AccentColorAdjustmentTask();

        public ColoredRadioButtonUI(Color iconColor, Color focusIconColor) {
            this.iconColor = iconColor;
            this.focusIconColor = focusIconColor;
        }

        @Override
        protected void installIcons() {
            super.installIcons();
            this.patchColors(this.iconColor, this.focusIconColor);
        }

        public void setColors(Color color, Color focusColor) {
            this.iconColor = color;
            this.focusIconColor = focusColor != null ? focusColor : color;
        }

        @Override
        public void update(Graphics g, JComponent c) {
            if (!Objects.equals(this.patchedColor, this.iconColor) || Objects.equals(this.patchedFocusColor, this.focusIconColor)) {
                this.patchColors(this.iconColor, this.focusIconColor);
            }
            super.update(g, c);
        }

        private void patchColors(Color color, Color focusColor) {
            if (color == null || this.patched && Objects.equals(this.patchedColor, color) && Objects.equals(this.patchedFocusColor, focusColor)) {
                return;
            }
            this.patchedColor = color;
            this.patchedFocusColor = focusColor;
            IconResolver iconResolver = DarkUIUtil.iconResolver();
            Theme theme = LafManager.getInstalledTheme();
            Properties props = new Properties();
            UIDefaults defaults = UIManager.getLookAndFeelDefaults();
            theme.loadDefaults(props, defaults, iconResolver);
            Color accentCol = DEFAULT_COLOR.equals(color) ? (Color)props.get("widgetFillDefault") : color;
            Color focusCol = DEFAULT_COLOR.equals(focusColor) ? accentCol : focusColor;
            adjustment.applyColors(theme, props, accentCol, null);
            PropertyLoader.putProperties((Properties)PropertyLoader.loadProperties(DarkLaf.class, (String)"radioButton", (String)"ui/"), (Properties)props, (UIDefaults)defaults, (IconResolver)iconResolver);
            PropertyLoader.putProperties((Properties)PropertyLoader.loadProperties(IconSet.class, (String)"radioButton", (String)""), (Properties)props, (UIDefaults)defaults, (IconResolver)iconResolver);
            this.propertyMap.clear();
            for (String prop : PROPERTIES) {
                this.propertyMap.put(prop, props.get(prop));
            }
            for (String prop : COLOR_PROPERTIES) {
                this.propertyMap.put(prop, accentCol);
            }
            if (!DEFAULT_COLOR.equals(focusColor)) {
                for (String prop : FOCUS_COLOR_PROPERTIES) {
                    this.propertyMap.put(prop, focusCol);
                }
            }
            for (String prop : FOREGROUND_PROPERTIES) {
                ColorUIResource fg = ForegroundColorGenerationTask.makeAdjustedForeground((Color)props.get(prop), accentCol, ForegroundColorGenerationTask.Bias.BACKGROUND, 0.6);
                this.propertyMap.put(prop, fg);
            }
            if (this.stateIcon == null) {
                IconLoader iconLoader = DarkUIUtil.radioButtonLoader();
                this.iconStates = new Icon[]{this.load(iconLoader, "control/radio.svg"), this.load(iconLoader, "control/radioDisabled.svg"), this.load(iconLoader, "control/radioFocused.svg"), this.load(iconLoader, "control/radioSelected.svg"), this.load(iconLoader, "control/radioSelectedDisabled.svg"), this.load(iconLoader, "control/radioSelectedFocused.svg")};
                this.stateIcon = new StateIcon(this.iconStates);
            } else {
                for (Icon iconState : this.iconStates) {
                    ((CustomThemedIcon)iconState).invalidate();
                }
            }
            this.patched = true;
        }

        private Icon load(IconLoader loader, String name) {
            return loader.loadSVGIcon(name, -1, -1, true, (Map)this.propertyMap);
        }

        @Override
        protected Icon getStateIcon(AbstractButton b) {
            return this.patched ? this.stateIcon : super.getStateIcon(b);
        }
    }
}

